/***************************************************************************
 *   Copyright (C) 2005 by Dominic Rath                                    *
 *   Dominic.Rath@gmx.de                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CFI_H
#define CFI_H

#define CFI_STATUS_POLL_MASK_DQ5_DQ6_DQ7 0xE0 /* DQ5..DQ7 */
#define CFI_STATUS_POLL_MASK_DQ6_DQ7     0xC0 /* DQ6..DQ7 */

struct cfi_flash_bank
{
	struct working_area *write_algorithm;

	int x16_as_x8;
	int jedec_probe;
	int not_cfi;
	int probed;

	uint16_t manufacturer;
	uint16_t device_id;

	uint8_t qry[3];

	/* identification string */
	uint16_t pri_id;
	uint16_t pri_addr;
	uint16_t alt_id;
	uint16_t alt_addr;

	/* device-system interface */
	uint8_t vcc_min;
	uint8_t vcc_max;
	uint8_t vpp_min;
	uint8_t vpp_max;
	uint8_t word_write_timeout_typ;
	uint8_t buf_write_timeout_typ;
	uint8_t block_erase_timeout_typ;
	uint8_t chip_erase_timeout_typ;
	uint8_t word_write_timeout_max;
	uint8_t buf_write_timeout_max;
	uint8_t block_erase_timeout_max;
	uint8_t chip_erase_timeout_max;

	uint8_t status_poll_mask;

	/* flash geometry */
	uint32_t dev_size;
	uint16_t interface_desc;
	uint16_t max_buf_write_size;
	uint8_t num_erase_regions;
	uint32_t *erase_region_info;

	void *pri_ext;
	void *alt_ext;

	/* calculated timeouts */
	unsigned word_write_timeout;
	unsigned buf_write_timeout;
	unsigned block_erase_timeout;
	unsigned chip_erase_timeout;
};

/* Intel primary extended query table
 * as defined for the Advanced+ Boot Block Flash Memory (C3)
 * and used by the linux kernel cfi driver (as of 2.6.14)
 */
struct cfi_intel_pri_ext
{
	uint8_t pri[3];
	uint8_t major_version;
	uint8_t minor_version;
	uint32_t feature_support;
	uint8_t suspend_cmd_support;
	uint16_t blk_status_reg_mask;
	uint8_t vcc_optimal;
	uint8_t vpp_optimal;
	uint8_t num_protection_fields;
	uint16_t prot_reg_addr;
	uint8_t fact_prot_reg_size;
	uint8_t user_prot_reg_size;
	uint8_t extra[0];
};

/* Spansion primary extended query table as defined for and used by
 * the linux kernel cfi driver (as of 2.6.15)
 */
struct cfi_spansion_pri_ext
{
	uint8_t  pri[3];
	uint8_t  major_version;
	uint8_t  minor_version;
	uint8_t  SiliconRevision; /* bits 1-0: Address Sensitive Unlock */
	uint8_t  EraseSuspend;
	uint8_t  BlkProt;
	uint8_t  TmpBlkUnprotect;
	uint8_t  BlkProtUnprot;
	uint8_t  SimultaneousOps;
	uint8_t  BurstMode;
	uint8_t  PageMode;
	uint8_t  VppMin;
	uint8_t  VppMax;
	uint8_t  TopBottom;
	int _reversed_geometry;
	uint32_t _unlock1;
	uint32_t _unlock2;
};

/* Atmel primary extended query table as defined for and used by
 * the linux kernel cfi driver (as of 2.6.20+)
 */
struct cfi_atmel_pri_ext
{
	uint8_t pri[3];
	uint8_t major_version;
	uint8_t minor_version;
	uint8_t features;
	uint8_t bottom_boot;
	uint8_t burst_mode;
	uint8_t page_mode;
};

enum {
	CFI_UNLOCK_555_2AA,
	CFI_UNLOCK_5555_2AAA,
};

struct cfi_unlock_addresses
{
	uint32_t unlock1;
	uint32_t unlock2;
};

struct cfi_fixup
{
	uint16_t mfr;
	uint16_t id;
	void (*fixup)(struct flash_bank *bank, void *param);
	void *param;
};

#define CFI_MFR_AMD		0x0001
#define CFI_MFR_FUJITSU	0x0004
#define CFI_MFR_ATMEL	0x001F
#define CFI_MFR_ST		0x0020	/* STMicroelectronics */
#define CFI_MFR_AMIC	0x0037
#define CFI_MFR_SST		0x00BF
#define CFI_MFR_MX		0x00C2

#define CFI_MFR_ANY		0xffff
#define CFI_ID_ANY		0xffff

#endif /* CFI_H */
