import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/** used to generate .tcl files from */
public class Stylizer
{
	// Global value so it can be ref'd by the tree-adapter
	static Document document;
	public static void main(String argv[])
	{
		if (argv.length != 3)
		{
			System.err.println("Usage: java Stylizer stylesheet xmlfile outputdir");
			System.exit(1);
		}
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		try
		{
			System.err.println("Starting conversion...");
			
			File stylesheet = new File(argv[0]);
			File datafile = new File(argv[1]);
			DocumentBuilder builder = factory.newDocumentBuilder();
			document = builder.parse(datafile);
			
			NodeList list = XPathAPI.selectNodeList(document, "website/language/page");

			for (int i=0; i<list.getLength(); i++)
			{
				Node node=list.item(i);
				
				// Use a Transformer for output
				TransformerFactory tFactory = TransformerFactory.newInstance();
				StreamSource stylesource = new StreamSource(stylesheet);
				Transformer transformer = tFactory.newTransformer(stylesource);
				
				Node fileName = XPathAPI.selectSingleNode(node, "outfile/text()");
				
				System.err.println("Converting " + fileName.getNodeValue());
				DOMSource source = new DOMSource(document);
				
				OutputStream output=new FileOutputStream(new File(argv[2], fileName.getNodeValue()));
				
				
				try
				{
					StreamResult result = new StreamResult(output);
					
					transformer.setParameter("pagetogenerate", fileName.getNodeValue());
					transformer.transform(source, result);
				} 
				finally
				{
					output.close();
				}
			}
		} catch (TransformerConfigurationException tce)
		{
			// Error generated by the parser
			System.out.println("\n** Transformer Factory error");
			System.out.println("   " + tce.getMessage());
			// Use the contained exception, if any
			Throwable x = tce;
			if (tce.getException() != null)
				x = tce.getException();
			x.printStackTrace();
		} catch (TransformerException te)
		{
			// Error generated by the parser
			System.out.println("\n** Transformation error");
			System.out.println("   " + te.getMessage());
			// Use the contained exception, if any
			Throwable x = te;
			if (te.getException() != null)
				x = te.getException();
			x.printStackTrace();
		} catch (SAXException sxe)
		{
			// Error generated by this application
			// (or a parser-initialization error)
			Exception x = sxe;
			if (sxe.getException() != null)
				x = sxe.getException();
			x.printStackTrace();
		} catch (ParserConfigurationException pce)
		{
			// Parser with specified options can't be built
			pce.printStackTrace();
		} catch (IOException ioe)
		{
			// I/O error
			ioe.printStackTrace();
		}
	} // main
}
