// $Id: KeyCodeSetting.hh 11587 2010-07-13 21:55:48Z mthuurne $

#ifndef KEYCODESETTING_HH
#define KEYCODESETTING_HH

#include "SettingPolicy.hh"
#include "SettingImpl.hh"
#include "Keys.hh"

namespace openmsx {

class KeyCodeSettingPolicy : public SettingPolicy<Keys::KeyCode>
{
protected:
	explicit KeyCodeSettingPolicy();
	std::string toString(Keys::KeyCode key) const;
	Keys::KeyCode fromString(const std::string& str) const;
	std::string getTypeString() const;
};

class KeyCodeSetting : public SettingImpl<KeyCodeSettingPolicy>
{
public:
	KeyCodeSetting(CommandController& commandController,
	               const std::string& name, const std::string& description,
	               Keys::KeyCode initialValue);
	KeyCodeSetting(CommandController& commandController,
	               const char* name, const char* description,
	               Keys::KeyCode initialValue);
};

} // namespace openmsx

#endif
