// $Id: DeviceFactory.hh 10182 2009-07-05 14:13:27Z mthuurne $

#ifndef DEVICEFACTORY_HH
#define DEVICEFACTORY_HH

#include <memory>

namespace openmsx {

class MSXDevice;
class MSXMotherBoard;
class MSXCPUInterface;
class HardwareConfig;
class XMLElement;
class DummyDevice;
class MSXDeviceSwitch;
class MSXMapperIO;
class VDPIODelay;

class DeviceFactory
{
public:
	static std::auto_ptr<MSXDevice> create(
		MSXMotherBoard& motherBoard, const HardwareConfig& hwConf,
		const XMLElement& conf);
	static std::auto_ptr<DummyDevice> createDummyDevice(
		MSXMotherBoard& motherBoard);
	static std::auto_ptr<MSXDeviceSwitch> createDeviceSwitch(
		MSXMotherBoard& motherBoard);
	static std::auto_ptr<MSXMapperIO> createMapperIO(
		MSXMotherBoard& motherBoard);
	static std::auto_ptr<VDPIODelay> createVDPIODelay(
		MSXMotherBoard& motherBoard, MSXCPUInterface& cpuInterface);
};

} // namespace openmsx

#endif
