// $Id: CompressedFileAdapter.hh 8205 2008-09-08 07:49:38Z m9710797 $

#ifndef COMPRESSEDFILEADAPTER_HH
#define COMPRESSEDFILEADAPTER_HH

#include "FileBase.hh"
#include <vector>
#include <memory>

namespace openmsx {

class CompressedFileAdapter : public FileBase
{
public:
	virtual void read(void* buffer, unsigned num);
	virtual void write(const void* buffer, unsigned num);
	virtual unsigned getSize();
	virtual void seek(unsigned pos);
	virtual unsigned getPos();
	virtual void truncate(unsigned size);
	virtual void flush();
	virtual const std::string getURL() const;
	virtual const std::string getOriginalName();
	virtual bool isReadOnly() const;
	virtual time_t getModificationDate();

protected:
	explicit CompressedFileAdapter(std::auto_ptr<FileBase> file);
	virtual ~CompressedFileAdapter();
	virtual void decompress(FileBase& file) = 0;

	// filled in by subclass
	std::vector<byte> buf;
	std::string originalName;

private:
	void fillBuffer();

	std::auto_ptr<FileBase> file;
	time_t cachedModificationDate;
	std::string cachedURL;
	unsigned pos;
};

} // namespace openmsx

#endif
