// $Id: VLM5030.hh 8352 2008-11-12 18:39:08Z m9710797 $

#ifndef VLM5030_HH
#define VLM5030_HH

#include "EmuTime.hh"
#include "openmsx.hh"
#include <string>
#include <memory>

namespace openmsx {

class MSXMotherBoard;
class XMLElement;
class VLM5030Impl;

class VLM5030
{
public:
	VLM5030(MSXMotherBoard& motherBoard, const std::string& name,
	        const std::string& desc, const XMLElement& config);
	~VLM5030();
	void reset();

	/** latch control data */
	void writeData(byte data);

	/** set RST / VCU / ST pins */
	void writeControl(byte data, EmuTime::param time);

	/** get BSY pin level */
	bool getBSY(EmuTime::param time);

	template<typename Archive>
	void serialize(Archive& ar, unsigned version);

private:
	const std::auto_ptr<VLM5030Impl> pimple;
};

} // namespace openmsx

#endif
