// $Id: ReadDir.cc,v 1.4 2006/05/28 19:19:29 m9710797 Exp $

#include "ReadDir.hh"

namespace openmsx {

ReadDir::ReadDir(const std::string& directory)
{
	dir = opendir(directory.empty() ? "." : directory.c_str());
}

ReadDir::~ReadDir()
{
	if (dir) {
		closedir(dir);
	}
}

struct dirent* ReadDir::getEntry()
{
	if (!dir) {
		return NULL;
	}
	return readdir(dir);
}

} // namespace openmsx
