/*
 * Copyright (C) 2000, 2001, Amnon Barak (amnon@cs.huji.ac.il)
 *
 * Permission to use this software is hereby granted under the terms of the
 * GNU General Public License, as published by the Free Software Foundation.
 *
 * THIS  SOFTWARE  IS  PROVIDED IN ITS  "AS IS"  CONDITION, WITH NO WARRANTY
 * WHATSOEVER. NO LIABILITY OF ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING
 * FROM THE USE OF THIS SOFTWARE WILL BE ACCEPTED.
 */
/*
 * Author(s): Amnon Shiloh.
 */
#ifndef _MOS_ROUTINES_H
#define _MOS_ROUTINES_H
#ifdef CONFIG_MOSIX

#include <linux/stddef.h>

/*
 * a collection of routines in mos/?*.c that are neither:
 * 1) used by the rest of the kernel	 --> include/linux/mosix.h
 * 2) in the communication package	 --> include/mos/comm.h
 * 3) part of the DEPUTY/REMOTE protocol --> include/mos/protocol.h
 * 4) related to prequests		 --> include/mos/request.h
 * 5) related to DFSA			 --> include/mos/dfsa.h
 */

struct task_struct;
struct mosixnet;

/* task management: */

extern int remote_need_while_asleep(struct task_struct *);
extern int other_needs_while_asleep(void);
extern void remote_run_while_asleep(void);
extern void deputy_run_while_asleep(void);
extern int remote_pre_usermode_actions(void);
extern int local_pre_usermode_actions(void);
extern void per_task_ack_mosix_state(void);
extern char *desc_mostask(struct mosix_task *);
extern void mosix_do_add_to_whereto(struct task_struct *, int);
extern void common_daemon_setup(char *, int);
extern void neutralize_my_load(int);
extern void wait_for_mosix_configuration(int *);
extern int obtain_mm(void);
extern void sync_caps(void);

/* load balancing: */

extern void mosix_load_init(void);
extern void load_balance(void);
extern void mosix_clear_statistics(void);
struct sonstats;
extern void consider(int, struct sonstats *);
extern int send_local_aload(int);
extern int send_with_miginfo(int, void *, int);
extern void mosix_local_syscall(void);
extern void release_migrations(int);
extern void changed_my_mind_and_staying(void);
extern int balance_commit_mig(int, int);
extern void info_someone_came_in(void);
extern void end_coming_in(int);
extern void add_statistics_to_ancesstor(struct task_struct *, struct task_struct *);
extern void info_update_costs(void);
extern void info_update_mfscosts(void);
extern void load_balance(void);
extern void memory_balance(void);
extern void age_balancing(void);
extern void unchoose_me(void);

/* memory: */

extern void init_mdp(void);
extern void compute_freemem(void);
extern int export_mem(void);
extern int memory_badly_required(void);
extern int memory_relief_quality(struct task_struct *, int);
extern void memory_balance(void);

/* information dissemination: */

extern void init_mosconfig(void);
extern int mosix_info_daemon(void *); 
extern void info_init(void);
extern void info_startup(void);
extern void info_reconfig(void);
struct mosix_info;
struct loadinfo;
extern int balance_get_load(int, struct loadinfo *);
extern int balance_get_infos(int, int, struct mosix_info *, int);
extern int balance_get_info(int, struct mosix_info *);
extern void mosinfo_update_gateways(void);
extern void this_machine_is_favourite(int);
extern int mosix_mem_daemon(void *); 

/* migration: */

struct mig_request_h;
extern int mosix_mig_daemon(void *);
extern int passto(int, int);
extern int mosix_do_send_back_home(struct task_struct *);
extern int mosix_do_go_home(int);
extern void follow_whereto(void);
extern int mig_migrate(int);
extern void mig_set_lock(int);
extern int count_migrating_pages(void);
extern void kickstart(void);
extern int run_over_dirty_pages(int (*func)(unsigned long, int), int);
extern void deputy_startup(void);
extern int mig_send_request(int, int);
extern int mig_recv_request(struct mig_request_h **);
extern int mig_do_send(void);
extern int mig_do_receive(void);

/* deputy: */

extern void deputy_main_loop(void);
extern void undeputy(struct task_struct *);
extern void deputy_async_requests(void);
extern void mosix_clear_all_held_files(struct task_struct *);
extern int fork_mosix_remote_files(struct task_struct *);
extern void coordinate(int, int);
extern long call_with_regs(void *, struct pt_regs *, struct pt_regs *);
extern int task_maps_ip(struct task_struct *, struct inode *);
extern void deputy_communication_failed(void);
extern void deputy_die_on_communication(void) ATTRIB_NORET;

/* remote: */

extern int remote_wait(int, void **, int *);
extern void wait_for_permission_to_continue(void);
extern int remote_request(int, void *, int, void *, int, int, void **, int);
extern long remote_standard_system_call(int, struct pt_regs *);
extern struct file *get_remote_file(int, struct file *, struct dentry *, unsigned long long, off_t, nopage_t);
extern void remote_disappear(void) __attribute__((noreturn));

/* data cache: */

struct syscall_h;
struct syscall_ret_h;
extern int copy_from_cache(char *, unsigned long, int, int *);
extern int copy_to_cache(unsigned long, char *, int, int *);
extern int zero_cache(char *, int, int *);
extern int strlen_cache(char *, int *);
extern int all_in_cache(unsigned long, unsigned int, int);
extern int any_in_cache(unsigned long, unsigned int);
extern int alloc_ucache(void);
extern void free_ucache(void);
extern void flush_ucache(void);
extern void flush_read_cache(void);
extern int ucache_ok(unsigned long, unsigned long, int);
extern int remote_unpack_read_cache_data(struct syscall_ret_h *);
extern void set_read_region(unsigned long, unsigned int);
extern void set_write_region(unsigned long, unsigned int);
extern char *construct_ucache_envelope(int *, int *, struct syscall_h *, char **);
extern int open_ucache_envelope(struct syscall_h *);
extern char *deputy_pack_read_cache_data(int *, struct syscall_ret_h *, char **);

/* configuration: */

extern int count_mosix_nodes(void); 
extern int nth_node(int);
extern int mos_to_ascii(int, char *, int);
extern int mos_to_net(int, void *);
extern int mymos_to_net(void *);
extern int mosix_config_get_table(struct mosixnet **, int, int);
extern int mosix_config_set_table(struct mosixnet *, int, int);
extern int mosix_config_get_pe(void);
extern int mosix_config_set_pe(int);
extern int mosix_config_get_tentative_pe(void);
extern int mosix_config_get_limit(void);
extern int count_mosix_nodes(void);
extern int config_get_status(int);
extern int config_set_status(int);
extern int i_am_in_a_wrong_place(void);
extern void done_checking_conf(void);
#ifdef CONFIG_MOSIX_FS
extern int scan_mosix_nodes(int, int *, int *);
#endif /* CONFIG_MOSIX_FS */

/* statistics decay: */

extern int decay_inherit(int);
extern int decay_exec(int);
extern int decay_execonce(int);
extern int decay_set(int, int, int);
extern int decay_get(int);
extern void decay_clear(void);
extern void deputy_update_remote_decay(void);
extern void do_decay(void);
extern void inc_decays(void);
extern now_t time_now(void);
#define	time_since(_when_)	(time_now() - (_when_))

/* MOSIX administration: */

extern int admin_get_mode(int);
extern int admin_set_mode(int, int);
extern int expel(int);
extern int bring(void);
extern void proc_update_costs(void);
extern int my_mosix_status(void);
extern void set_my_cpuspeed(void);

/* debugging: */

#ifdef CONFIG_MOSIX_DEBUG
extern void init_mosix_log(struct task_struct *);
extern void clear_mosix_log(struct task_struct *);
#else
#define	init_mosix_log(m)	do {} while(0)
#define	clear_mosix_log(m)	do {} while(0)
#endif /* CONFIG_MOSIX_DEBUG */

/* macros: */

#define	MOSIX_TO_TASK(m) ((struct task_struct *)(((char *)m)-offsetof(struct task_struct,mosix)))

#ifdef CONFIG_MOSIX_DFSA
#define	URGENT_REMOTE_CONDITIONS(p)	((p)->mosix.whereto || \
					process_told((p), DREQ_DFSASYNC))
#else
#define	URGENT_REMOTE_CONDITIONS(m)	((p)->mosix.whereto)
#endif /* CONFIG_MOSIX_DFSA */
#endif /* CONFIG_MOSIX */

#if MILLION % HZ
#define ticks_to_ms(ticks)	(((int64_t)(ticks)) * MILLION / HZ)
#define	ms_to_ticks(ms)		((ms) * HZ / MILLION)
#else
#define ticks_to_ms(ticks)	(((int64_t)(ticks)) * (MILLION / HZ))
#define	ms_to_ticks(ms)		((ms) / (MILLION/HZ))
#endif

#endif
