/*
 * Copyright (C) 2000, 2001, Amnon Barak (amnon@cs.huji.ac.il)
 *
 * Permission to use this software is hereby granted under the terms of the
 * GNU General Public License, as published by the Free Software Foundation.
 *
 * THIS  SOFTWARE  IS  PROVIDED IN ITS  "AS IS"  CONDITION, WITH NO WARRANTY
 * WHATSOEVER. NO LIABILITY OF ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING
 * FROM THE USE OF THIS SOFTWARE WILL BE ACCEPTED.
 */
/*
 * Author(s): Amnon Shiloh.
 */

/* all manners of independent variables and definitions required by the
 * MOSIX package and possibly also by the MOSIX module itself:
 */

#ifndef _MOS_DEFS_H
#define _MOS_DEFS_H

extern int mosix_running;
extern int active_cpus;

extern spinlock_t whereto_lock;

extern struct task_struct *mig_proc;
extern int mig_daemon_active;
extern struct task_struct *info_proc;
extern int info_daemon_active;

extern int slow_alpha, fast_alpha;	/* units over DECAY_QUOTIENT */
extern int decay_interval;	/* in seconds */
extern int mosadmin_gateways;	/* number of network segments (gateways) */
extern int mosadmin_mode_stay;	/* no automatic migration out */
extern int mosadmin_mode_lstay;	/* same just for local processes */
extern int mosadmin_mode_block;	/* do not accept guests */
extern int mosadmin_mode_quiet;	/* stop the load-chat (obsolete) */
extern int mosadmin_mode_nomfs;	/* disallow MFS access to this node */
extern char bootexpel, expel_progress;
extern int latest_free_mem;

extern struct task_struct *chosen_for_balance;
extern struct task_struct *chosen_for_mdp;

#define	STD_SPD		10000	  /* speed units of a standard processor */
extern int cpuspeed;		  /* this node's relative processor speed */
extern int standard_speed;	  /* if sysadmin changes standard-processor */
extern int PE;			/* MOSIX number for this processor */
extern int NPE;			/* number of configured MOSIX nodes */
extern int MAXPE;		/* maximum MOSIX number in the cluster */

#ifdef CONFIG_MOSIX_TOPOLOGY
#if CONFIG_MOSIX_MAXTOPOLOGY > 10
#warning MAXIMUM TOPOLOGY too big -- truncated to 10
#define	MAX_MOSIX_TOPOLOGY	10
#elif CONFIG_MOSIX_MAXTOPOLOGY < 2
#warning MAXIMUM TOPOLOGY < 2 -- so why use it at all?
#define	MAX_MOSIX_TOPOLOGY	1
#else
#define	MAX_MOSIX_TOPOLOGY	CONFIG_MOSIX_MAXTOPOLOGY
#endif /* CONFIG_MOSIX_MAXTOPOLOGY */
#else
#define	MAX_MOSIX_TOPOLOGY	1
#endif /* CONFIG_MOSIX_TOPOLOGY */

extern struct mosix_cost
{
	int PAGE_D, PAGE_R;
	int SYSCALL_D, SYSCALL_R;
	int COPYOUT_BASE_D, COPYOUT_PER_KB_D;
	int COPYOUT_BASE_R, COPYOUT_PER_KB_R;
	int COPYIN_BASE_D, COPYIN_PER_KB_D;
	int COPYIN_BASE_R, COPYIN_PER_KB_R;
	int MIGRATION_BASIC, MIGRATION_PER_PAGE;
#ifdef CONFIG_MOSIX_TOPOLOGY
	int first, last;
#endif /* CONFIG_MOSIX_TOPOLOGY */
} mosix_cost[MAX_MOSIX_TOPOLOGY];

extern struct mfs_cost
{
	int MFS_CONN_S, MFS_CONN_C;
	int MFS_INKB_S, MFS_INKB_C;
	int MFS_OUTKB_S, MFS_OUTKB_C;
#ifdef CONFIG_MOSIX_TOPOLOGY
	int first, last;
#endif /* CONFIG_MOSIX_TOPOLOGY */
} mfs_cost[MAX_MOSIX_TOPOLOGY];

extern struct opcost deputy_here[MAX_MOSIX_TOPOLOGY];

#ifdef CONFIG_MOSIX_FS
#define	MAX_MFS_STATNODES	10

struct mfs_stats
{
	int nnodes;
	unsigned short hint;
	unsigned short nodes[MAX_MFS_STATNODES];
	int64_t conns[MAX_MFS_STATNODES];
	int64_t inbytes[MAX_MFS_STATNODES];
	int64_t outbytes[MAX_MFS_STATNODES];
};
#else
#define	MAX_MFS_STATNODES	0
#endif /* CONFIG_MOSIX_FS */

/* node-disconnection timeout: */
#ifdef CONFIG_MOSIX_UDB
#define	MOSIX_CONNECTION_KEEPALIVE_INTERVAL	60
#define	MOSIX_CONNECTION_KEEPALIVE_MAXTRIES	10
#define	MOSIX_CONNECTION_KEEPALIVE_TOTAL	600
#else
#define	MOSIX_CONNECTION_KEEPALIVE_INTERVAL	30
#define	MOSIX_CONNECTION_KEEPALIVE_MAXTRIES	6
#define	MOSIX_CONNECTION_KEEPALIVE_TOTAL	180
#endif /* CONFIG_MOSIX_UDB */

/* default slow decay brings process-statistics down to 10% in 3 minutes */
/* default fast decay brings process-statistics down to 10% in 1 minute */

#define	DEFAULT_DECAY_INTERVAL	2		/* seconds */
#define	DEFAULT_SLOW_ALPHA	(DECAY_QUOTIENT * 975 / 1000)
#define	DEFAULT_FAST_ALPHA	(DECAY_QUOTIENT * 926 / 1000)

#define	MF	100		/* MOSIX frequency */

#define	MILLION		1000000
#define	DMILLION	1000000.0

#endif
