#!/bin/sh -
#
# 
# chkconfig: 2345 95 5
# description: openMosix is an extension of the operating system,
#	       supporting scalable and transparent cluster computing.
#
# openmosix		Script to stop/start openMosix
#

#Don't delete the following line. Needed for RedHat compatibility !!!
#daemon openmosix

# Read the openmosix variables to make decisions
. /etc/default/openmosix

stop_openmosix() {
    if [ -f /proc/mosix/admin/mospe ]; then
        mosctl expel
        mosctl bring
        echo 0 > /proc/mosix/admin/mospe
    else
        echo Error: this is not OPENMOSIX!
        exit 0
    fi
}

start_openmosix() {
        OVERHEADS=/etc/overheads
	MFSCOSTS=/etc/mfscosts

	if [ -s $OVERHEADS -a -f /proc/mosix/admin/overheads ]
	then
		 /bin/grep -v '^#' $OVERHEADS > /proc/mosix/admin/overheads
	fi
	if [ -s $MFSCOSTS -a -f /proc/mosix/admin/mfscosts ]
	then
		 /bin/grep -v '^#' $MFSCOSTS > /proc/mosix/admin/mfscosts
	fi
	a1=
	[ -s /etc/mospe ] && a1="-p `cat /etc/mospe`"
	a2=
	[ -s /etc/mosgates ] && a2="-g `cat /etc/mosgates`"
	/sbin/setpe -W $a1 $a2 -f /etc/openmosix.map
#	touch /var/lock/subsys/openmosix

        if [ $? = 1 ]; then
            exit 0;
        fi

	cat /proc/mosix/admin/speed > /proc/mosix/admin/sspeed

        if [ $MIGRATE == "yes" ]; then
            /usr/bin/mosctl -lstay
            /usr/bin/mosctl -stay
        else
            /usr/bin/mosctl lstay
        fi

        if [ $BLOCK == "yes" ]; then
            /usr/bin/mosctl block
        else
            /usr/bin/mosctl -block
        fi

        if [ $MFS == "yes" ]; then
            /usr/bin/mosctl mfs
        else
            /usr/bin/mosctl nomfs
        fi
}

alarm() {
	t=$2
	while :
	do
		case "$t" in 0) break ;; esac
		sleep 1
		t=$(($t-1))
	done
	kill -1 $1
	exit 0
}

# See how we were called.
case "$1" in
  start)
	echo "Initializing OPENMOSIX..."
	if [ ! -f /etc/openmosix.map ]
	then
		echo You have no OPENMOSIX configuration - please edit yours now:
		echo -n "Editor to use [q to quit] - [editor] :- "
		trap 'echo Timed-Out ; exit 1' 1
		alarm $$ 120 &
		killer=$!
		read editor
		kill $killer
		trap ''
		case "$editor" in [qQ]) exit ;;
			"") editor=/usr/bin/editor
			    [ -f $editor ] || editor=/bin/vi
				;;
		esac
		echo "# OPENMOSIX CONFIGURATION" > /etc/openmosix.map
		echo "# ===================" >> /etc/openmosix.map
		echo "#" >> /etc/openmosix.map
		echo "# Each line should contain 3 fields, mapping IP addresses to OPENMOSIX node-numbers:" >> /etc/openmosix.map
		echo "# 1) first OPENMOSIX node-number in range." >> /etc/openmosix.map
		echo "# 2) IP address of the above node (or node-name from /etc/hosts)." >> /etc/openmosix.map
		echo "# 3) number of nodes in this range." >> /etc/openmosix.map
		echo "#" >> /etc/openmosix.map
		echo "# OPENMOSIX-#  IP  number-of-nodes" >> /etc/openmosix.map
		echo "# ============================" >> /etc/openmosix.map
		$editor /etc/openmosix.map
		echo
		while :
		do
			echo "If this node's standard IP address is not part of the table that"
			echo "you just edited, because OPENOSIX uses a different or separate network,"
			echo "you need to type this node's OPENMOSIX-number now."
			echo
			/bin/echo -n "Otherwise please press only <Enter> :- "
			read me
			case "$me" in "") /bin/rm -f /etc/mospe ; break ;;
				[1-9] | [1-9][0-9] | [1-9][0-9][0-9] | \
				[1-9][0-9][0-9][0-9] | \
				[1-6][0-9][0-9][0-9][0-9])
					echo $me > /etc/mospe ; break ;;
				*) echo Improper OPENMOSIX number - please try again: ;;
			esac
		done
	fi
	start_openmosix ;;
  stop)
	echo "Stopping OPENMOSIX..."
	stop_openmosix ;;
  status)
	/sbin/setpe -r ;;
  restart|reload)
	echo "Restarting OPENMOSIX..."
	stop_openmosix
	start_openmosix ;;
  *)
	# do not advertise unreasonable commands that there is no reason
	# to use with this device
	echo "Usage: openmosix {start|stop|status|restart|reload}"
	exit 1
esac

exit 0
