/*
   Copyright (C) 1994-2001 Digitool, Inc
   This file is part of Opensourced MCL.

   Opensourced MCL is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   Opensourced MCL is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/



/*   Lambda-list processing, destructuring-bind. */


	include(lisp.s)
	_beginfile

	.globl ksignalerr
/* Provide default (NIL) values for &optional arguments; imm0 is 
   the (fixnum) upper limit on the total of required and &optional 
   arguments.  nargs is preserved, all arguments wind up on the 
   vstack. */
_spentry(default_optional_args)
	__(cmplw cr7,nargs,imm0)
	__(vpush_argregs())
	__(mr imm1,nargs)
	__(bgelr cr7)
1:	
	__(addi imm1,imm1,fixnum_one)
	__(cmpw cr0,imm1,imm0)
	__(vpush(rnil))
	__(bne cr0,1b)
	__(blr)

/* Indicate whether &optional arguments were actually supplied.  nargs 
   contains the actual arg count (minus the number of required args); 
   imm0 contains the number of &optional args in the lambda list. 
   Note that nargs may be > imm0 if &rest/&key is involved. */
_spentry(opt_supplied_p)
	__(li imm1,0)
1:
	/* (vpush (< imm1 nargs)) */
	__(xor imm2,imm1,nargs)
	__(srawi imm2,imm2,31)
	__(or imm2,imm2,imm1)
	__(addi imm1,imm1,fixnumone)
	__(cmpw cr0,imm1,imm0)
	__(subf imm2,nargs,imm2)
	__(srwi imm2,imm2,31)
	__(insrwi imm2,imm2,1,27)
	__(add imm2,rnil,imm2)
	__(vpush(imm2))
	__(bne cr0,1b)
	__(blr)



/* If nargs is <= imm0, vpush a nil.  Otherwise, cons a list of length 
   (- nargs imm0) and vpush it. 
   Use this entry point to heap-cons a simple &rest arg. */
_spentry(heap_rest_arg)
	__(li imm0,0)

/* And this entry point when the argument registers haven't yet been 
   vpushed (as is typically the case when required/&rest but no &optional/&key.) */
_spentry(req_heap_rest_arg)
	__(vpush_argregs( ))

_spentry(heap_cons_rest_arg)
	__(sub imm1,nargs,imm0)
	__(cmpwi cr0,imm1,0)
	__(mr arg_z,rnil)
	__(ble cr0,2f)
	__(add imm1,imm1,imm1)
	__(stwux rzero,freeptr,imm1)
	__(la arg_y,-cons.size+fulltag_cons(freeptr))
	__(mr initptr,freeptr)
1:	
	__(subi imm1,imm1,8)
	__(cmpwi cr0,imm1,0)
	__(vpop( arg_x))
	__(rplacd(arg_y,arg_z))
	__(rplaca(arg_y,arg_x))
	__(mr arg_z,arg_y)
	__(la arg_y,-cons.size(arg_y))
	__(bne cr0,1b)
2:	
	__(vpush(arg_z))
	__(blr)

/* As in the heap-consed cases, only stack-cons the &rest arg */
_spentry(stack_rest_arg)
	__(li imm0,0)

_spentry(req_stack_rest_arg)
	__(vpush_argregs())

_spentry(stack_cons_rest_arg)
	__(sub imm1,nargs,imm0)
	__(cmpwi cr0,imm1,0)
	__(cmpwi cr1,imm1,(4096-8)/2)
	__(mr arg_z,rnil)
	__(ble cr0,2f)		/* always temp-push something. */
	__(bge cr1,3f)
	__(add imm1,imm1,imm1)
	__(neg imm2,imm1)
	__(subi imm2,imm2,8)
	__(mr initptr,tsp)		/* uninterruptable */
	__(stwux tsp,tsp,imm2)
	__(sub initptr,tsp,imm2)
	__(la arg_y,-cons.size+fulltag_cons(initptr))
0:
	__(cmpwi cr0,imm1,8)	/* last time through ? */
	__(subi imm1,imm1,8)
	__(vpop(arg_x))
	__(rplacd(arg_y,arg_z))
	__(rplaca(arg_y,arg_x))
	__(mr arg_z,arg_y)
	__(la arg_y,-cons.size(arg_y))
	__(bne cr0,0b)
	__(stw rzero,4(tsp))
	__(mr initptr,freeptr)
	__(vpush(arg_z))
	__(blr)
2:
	__(stwu tsp,-8(tsp))
	__(stw rzero,4(tsp))
	__(vpush(arg_z))
	__(blr)
3:
	__(stwu tsp,-8(tsp))
	__(stw rzero,4(tsp))
	__(b heap_cons_rest_arg)

/* Treat the last (- nargs imm0) values on the vstack as keyword/value 
   pairs.  There'll be imm3 keyword arguments.  Imm2 contains flags 
   that indicate whether &allow-other-keys was specified and whether 
   or not to leave the keyword/value pairs on the vstack for an &rest 
   argument.  Temp3 contains a vector of keyword specifiers which we 
   must (in general) match. 
   If the number of arguments is greater than imm0, the difference must 
   be even. 
   Note that the caller hasn't yet saved its caller's context and that 
   the temp registers used to pass closure_data (temp0) and next_method_context 
   (temp1) may still have "live" values in them, as does nfn (temp2). */

define([keyword_flags],[imm2])
define([keyword_vector],[temp3])
define([keyword_count],[imm3])

_spentry(simple_keywords)
	__(li imm0,0)

_spentry(keyword_args)
	__(vpush_argregs())

define([varptr],[save0])
define([valptr],[save1])
define([limit],[save2])

_spentry(keyword_bind)
	/* Before we can really do anything, we have to */
	/* save the caller's context.  To do so, we need to know */
	/* how many args have actually been pushed.  Ordinarily, that'd */
	/* be "nargs", but we may have pushed more args than we received */
	/* if we had to default any &optionals. */
	/* So, the number of args pushed so far is the larger of nargs */
	/* and the (canonical) total of required/&optional args received. */
	__(cmpw cr0,nargs,imm0)
	__(add arg_z,vsp,nargs)
	__(bge+ cr0,1f)
	__(add arg_z,vsp,imm0)
1:
	__(create_lisp_frame())
	__(stw loc_pc,lisp_frame.savelr(sp))
	__(stw arg_z,lisp_frame.savevsp(sp))
	__(stw fn,lisp_frame.savefn(sp))
	__(mr fn,nfn)
	/* If there are key/value pairs to consider, we slide them down */
	/* the vstack to make room for the value/supplied-p pairs. */
	/* The first step in that operation involves pushing imm3 pairs */
	/* of NILs. */
	/* If there aren't any such pairs, the first step is the last */
	/* step. */
	__(cmpwi cr0,imm3,0)
	__(li arg_z,0)
	__(sub imm1,nargs,imm0)
	__(mr imm4,vsp)	/* in case odd keywords error */
	__(cmpwi cr1,imm1,0)
	__(b 3f)
2:
	__(addi arg_z,arg_z,fixnum_one)
	__(cmplw cr0,arg_z,imm3)
	__(vpush(rnil))
	__(vpush(rnil))
3:
	__(bne cr0,2b)
	__(andi. arg_z,imm1,fixnum_one)
	__(blelr cr1)	/* no keyword/value pairs to consider. */
	__(bne cr0,odd_keywords)
	/* We have key/value pairs.  Move them to the top of the vstack, */
	/* then set the value/supplied-p vars to NIL. */
	/* Have to use some save regs to do this. */
	__(vpush(limit))
	__(vpush(valptr))
	__(vpush(varptr))
	/* recompute ptr to user args in case stack overflowed */
	__(add imm4,vsp,imm3)
	__(add imm4,imm4,imm3)
	__(addi imm4,imm4,12)
	/* error if odd number of keyword/value args */
	__(mr varptr,imm4)
	__(la limit,12(vsp))
	__(mr valptr,limit)
	__(mr arg_z,imm1)
4:
	__(subi arg_z,arg_z,2<<fixnumshift)
	__(cmplwi cr0,arg_z,0)
	__(lwz arg_x,0(varptr))
	__(lwz arg_y,4(varptr))
	__(stw rnil,0(varptr))
	__(stw rnil,4(varptr))
	__(la varptr,8(varptr))
	__(stw arg_x,0(valptr))
	__(stw arg_y,4(valptr))
	__(la valptr,8(valptr))
	__(bne cr0,4b)


/* Now, iterate through each supplied keyword/value pair.  If 
   it's :allow-other-keys and the corresponding value is non-nil, 
   note that other keys will be allowed. 
   Find its position in the function's keywords vector.  If that's 
   nil, note that an unknown keyword was encountered. 
   Otherwise, if the keyword arg hasn't already had a value supplied, 
   supply it. 
   When done, complain if any unknown keywords were found and that 
   situation was unexpected. */
	__(mr imm4,valptr)
5:
	__(lwzu arg_z,-4(valptr))
	__(lwzu arg_y,-4(valptr))
	__(cmpw cr1,arg_y,rnil)
	__(la arg_x,nrs.kallowotherkeys(rnil))
	__(cmpw cr0,arg_x,arg_z)
	__(cmpw cr7,valptr,limit)
	__(beq cr1,6f)
	__(bne cr0,6f)
	__(ori keyword_flags,keyword_flags,fixnum_one)
6:
	__(cmpwi cr1,imm3,0)
	__(li imm1,misc_data_offset)
	__(li imm0,0)
	__(b 8f)
7:
	__(addi imm0,imm0,fixnum_one)
	__(cmpw cr1,imm0,imm3)
	__(lwzx arg_x,keyword_vector,imm1)
	__(cmpw cr0,arg_x,arg_z)
	__(addi imm1,imm1,fixnum_one)
	__(bne cr0,8f)
	__(add imm0,imm0,imm0)
	__(sub imm0,varptr,imm0)
	__(lwz arg_x,0(imm0))
	__(cmpw cr0,arg_x,rnil)
	__(la arg_z,t_offset(rnil))
	__(bne cr0,9f)
	__(stw arg_y,4(imm0))
	__(stw arg_z,0(imm0))
	__(b 9f)
8:
	__(bne cr1,7b)
	/* Unknown keyword. */
	__(ori keyword_flags,keyword_flags,2<<fixnumshift)
9:
	__(bne cr7,5b)
	__(vpop(varptr))
	__(vpop(valptr))
	__(vpop(limit))
	/* All keyword/value pairs have been processed. */
	/* If we saw an unknown keyword and didn't expect to, error. */
	/* Unless bit 2 is set in the fixnum in keyword_flags, discard the */
	/* keyword/value pairs from the vstack. */
	__(andi. imm0,keyword_flags,(fixnum_one)|(2<<fixnumshift))
	__(cmpwi cr0,imm0,2<<fixnumshift)
	__(beq- cr0,badkeys)
	__(andi. imm2,keyword_flags,4<<fixnumshift)
	__(bnelr cr0)
	__(mr vsp,imm4)
	__(blr)

/* Signal an error.  We saved context on entry, so this thing doesn't 
   have to. 
   The "unknown keywords" error could be continuable (ignore them.) 
   It might be hard to then cons an &rest arg. 
   In the general case, it's hard to recover the set of args that were 
   actually supplied to us ... */
	/* For now, just cons a list out of the keyword/value pairs */
	/* that were actually provided, and signal an "invalid keywords" */
	/* error with that list as an operand. */
odd_keywords:
	__(mr vsp,imm4)
	__(mr nargs,imm1)
	__(b 1f)
badkeys:
	__(sub nargs,imm4,vsp)
1:
	.globl _SPconslist
	__(bl _SPconslist)
	__(li arg_y,XBADKEYS)
	__(set_nargs(2))
	__(b ksignalerr)



/* Destructuring-bind, macro-bind. 
   */
define([whole_reg],[temp1])
define([arg_reg],[temp3])
define([keyvect_reg],[temp2])
define([mask_req_start],[24])
define([mask_req_width],[8])
define([mask_opt_start],[16])
define([mask_opt_width],[8])
define([mask_key_start],[8])
define([mask_key_width],[8])
define([mask_initopt],[7])
define([mask_keyp],[6]) /*  note that keyp can be true even when 0 keys. */
define([mask_aok],[5])
define([mask_restp],[4])
/* OK to use arg_x, arg_y for whatever (tagged) purpose; 
   likewise immX regs. 
   arg_z preserved, nothing else in particular defined on exit. 
   nargs contains req count (0-255) in PPC bits mask_req_start/mask_req_width, 
                  opt count (0-255) in PPC bits mask_opt_start/mask_opt_width, 
                  key count (0-255) in PPC bits mask_key_start/mask_key_width, 
                  opt-supplied-p flag in PPC bit mask_initopt, 
                  keyp flag in PPC bit mask_keyp, 
                  &allow-other-keys flag in PPC bit mask_aok, 
   		   &rest flag in PPC bit mask_restp. 
   When mask_keyp bit is set, keyvect contains vector of keyword symbols, 
	length key count. */

_spentry(macro_bind)
	__(mr whole_reg,arg_reg)
	__(extract_lisptag(imm0,arg_reg))
	__(cmpwi cr0,imm0,tag_list)
	__(bne- cr0,1f)
	__(_cdr(arg_reg,arg_reg))
	__(b destbind1)
1:
	__(li arg_y,XCALLNOMATCH)
	__(mr arg_z,whole_reg)
	__(set_nargs(2))
	__(b ksignalerr)

_spentry(destructuring_bind_inner)
	__(mr whole_reg,arg_z)
	__(b destbind1)

_spentry(destructuring_bind)
	__(mr whole_reg,arg_reg)
	/* b destbind1 */

destbind1:
	/* Extract required arg count. */
	 /* A bug in gas: can't handle shift count of "32" (= 0 */
	ifelse(eval(mask_req_width+mask_req_start),eval(32),[
	__(clrlwi. imm0,nargs,mask_req_start)
	],[
	__(extrwi. imm0,nargs,mask_req_width,mask_req_start)
	])
	__(extrwi imm1,nargs,mask_opt_width,mask_opt_start)
	__(rlwinm imm2,nargs,0,mask_initopt,mask_initopt)
	__(rlwinm imm4,nargs,0,mask_keyp,mask_keyp)
	__(cmpwi cr4,imm4,0)
	__(rlwinm imm4,nargs,0,mask_restp,mask_restp)
	__(cmpwi cr5,imm4,0)
	__(cmpwi cr1,imm1,0)
	__(cmpwi cr2,imm2,0)
	/* Save entry vsp in case of error. */
	__(mr imm4,vsp)
	__(beq cr0,2f)
1:
	__(cmpw cr7,arg_reg,rnil)
	__(extract_lisptag(imm3,arg_reg))
	__(cmpwi cr3,imm3,tag_list)
	__(subi imm0,imm0,1)
	__(cmpwi cr0,imm0,0)
	__(beq cr7,toofew)
	__(bne cr3,badlist)
	__(lwz arg_x,cons.car(arg_reg))
	__(lwz arg_reg,cons.cdr(arg_reg))
	__(vpush(arg_x))
	__(bne cr0,1b)
2:
	__(beq cr1,rest_keys)
	__(bne cr2,opt_supp)
	/* 'simple' &optionals:	 no supplied-p, default to nil. */
simple_opt_loop:
	__(cmpw cr0,arg_reg,rnil)
	__(extract_lisptag(imm3,arg_reg))
	__(cmpwi cr3,imm3,tag_list)
	__(subi imm1,imm1,1)
	__(cmpwi cr1,imm1,0)
	__(beq cr0,default_simple_opt)
	__(bne cr3,badlist)
	__(lwz arg_x,cons.car(arg_reg))
	__(lwz arg_reg,cons.cdr(arg_reg))
	__(vpush(arg_x))
	__(bne cr1,simple_opt_loop)
	__(b rest_keys)
default_simple_opt_loop:
	__(subi imm1,imm1,1)
	__(cmpwi cr1,imm1,0)
default_simple_opt:
	__(vpush(rnil))
	__(bne cr1,default_simple_opt_loop)
	__(b rest_keys)
	/* Provide supplied-p vars for the &optionals. */
opt_supp:
	__(la arg_y,t_offset(rnil))
opt_supp_loop:
	__(cmpw cr0,arg_reg,rnil)
	__(extract_lisptag(imm3,arg_reg))
	__(cmpwi cr3,imm3,tag_list)
	__(subi imm1,imm1,1)
	__(cmpwi cr1,imm1,0)
	__(beq cr0,default_hard_opt)
	__(bne cr3,badlist)
	__(lwz arg_x,cons.car(arg_reg))
	__(lwz arg_reg,cons.cdr(arg_reg))
	__(vpush(arg_x))
	__(vpush(arg_y))
	__(bne cr1,opt_supp_loop)
	__(b rest_keys)
default_hard_opt_loop:
	__(subi imm1,imm1,1)
	__(cmpwi cr1,imm1,0)
default_hard_opt:
	__(vpush(rnil))
	__(vpush(rnil))
	__(bne cr1,default_hard_opt_loop)
rest_keys:
	__(cmpw cr0,arg_reg,rnil)
	__(bne cr5,have_rest)
	__(bne cr4,have_keys)
	__(bne cr0,toomany)
	__(blr)
have_rest:
	__(vpush(arg_reg))
	__(beqlr cr4)
have_keys:
	/* Ensure that arg_reg contains a proper,even-length list. */
	/* Insist that its length is <= 512 (as a cheap circularity check.) */
	__(li imm0,256)
	__(mr arg_x,arg_reg)
count_keys_loop:
	__(extract_lisptag(imm3,arg_x))
	__(cmpwi cr3,imm3,tag_list)
	__(cmpw cr0,arg_x,rnil)
	__(subi imm0,imm0,1)
	__(cmpwi cr4,imm0,0)
	__(bne cr3,badlist)
	__(beq cr0,counted_keys)
	__(lwz arg_x,cons.cdr(arg_x))
	__(extract_lisptag(imm3,arg_x))
	__(cmpwi cr3,imm3,tag_list)
	__(blt cr4,toomany)
	__(cmpw cr0,arg_x,rnil)
	__(bne cr3,badlist)
	__(beq cr0,db_badkeys)
	__(lwz arg_x,cons.cdr(arg_x))
	__(b count_keys_loop)
counted_keys:
	/* 
	  We've got a proper, even-length list of key/value pairs in
	arg_reg. For each keyword var in the lambda-list, push a pair
	of NILs on the vstack. */
	__(extrwi. imm0,nargs,mask_key_width,mask_key_start )
	__(mr imm2,imm0) 	/* save number of keys */
	__(b push_pair_test)
push_pair_loop:
	__(cmpwi cr0,imm0,1)
	__(subi imm0,imm0,1)
	__(vpush(rnil))
	__(vpush(rnil))
push_pair_test:
	__(bne cr0,push_pair_loop)
	__(slwi imm2,imm2,3)		/* pairs -> bytes */
	__(add imm2,vsp,imm2)		/* imm2 points below pairs */
	__(li imm0,0)			/* count unknown keywords so far */
	__(extrwi imm1,nargs,1,mask_aok) /* unknown keywords allowed */
	__(extrwi nargs,nargs,mask_key_width,mask_key_start)
	/* Now, for each keyword/value pair in the list */
	/*  a) if the keyword is found in the keyword vector, set the */
	/*     corresponding entry on the vstack to the value and the */
	/*     associated supplied-p var to T. */
	/*  b) Regardless of whether or not the keyword is found, */
	/*     if the keyword is :ALLOW-OTHER-KEYS and the value is non-nil, */
	/*     set imm1 to a non-zero value to indicate that unknown keywords */
	/*     are acceptable. */
	/*  c) If the keyword is not found (and isn't :ALLOW-OTHER-KEYS), increment */
	/*     the count of unknown keywords in imm0. */
	/* At the end of the list, signal an error if any unknown keywords were seen */
	/* but not allowed.  Otherwise, return. */

match_keys_loop:
	__(cmpw cr0,arg_reg,rnil)
	__(li imm0,0)
	__(li imm3,misc_data_offset)
	__(beq cr0,matched_keys)
	__(lwz arg_x,cons.car(arg_reg))
	__(la arg_y,nrs.kallowotherkeys(rnil))
	__(cmpw cr3,arg_x,arg_y)	/* :ALLOW-OTHER-KEYS ? */
	__(lwz arg_reg,cons.cdr(arg_reg))
	__(lwz arg_y,cons.car(arg_reg))
	__(cmpw cr0,arg_y,rnil)
	__(cmpw cr4,imm0,nargs)
	__(lwz arg_reg,cons.cdr(arg_reg))
	__(bne cr3,match_test)
	__(beq cr0,match_test)
	__(ori imm1,imm1,1)
	__(b match_test)
match_loop:
	__(lwzx temp0,keyvect_reg,imm3)
	__(cmpw cr0,arg_x,temp0)
	__(addi imm0,imm0,1)
	__(cmpw cr4,imm0,nargs)
	__(addi imm3,imm3,4)
	__(bne cr0,match_test)
	/* Got a hit.  Unless this keyword's been seen already, set it. */
	__(slwi imm0,imm0,3)
	__(subf imm0,imm0,imm2)
	__(lwz temp0,0(imm0))
	__(cmpw cr0,temp0,rnil)
	__(la temp0,t_offset(rnil))
	__(bne cr0,match_keys_loop)	/* already saw this */
	__(stw arg_y,4(imm0))
	__(stw temp0,0(imm0))
	__(b match_keys_loop)
match_test:
	__(bne cr4,match_loop)
	__(oris imm1,imm1,0x8000)
	__(b match_keys_loop)
matched_keys:
	__(cmpwi cr1,imm1,0)
	__(add imm1,imm1,imm1)
	__(cmpwi cr0,imm1,0)
	__(bgelr cr1)
	__(bnelr cr0)
	/* Some unrecognized keywords.  Complain generically about */
	/* invalid keywords. */
db_badkeys:
	__(li arg_y,XBADKEYS)
	__(b destructure_error)
toomany:
	__(li arg_y,XCALLTOOMANY)
	__(b destructure_error)
toofew:
	__(li arg_y,XCALLTOOFEW)
	__(b destructure_error)
badlist:
	__(li arg_y,XCALLNOMATCH)
	/* b destructure_error */
destructure_error:
	__(mr vsp,imm4)		/* undo everything done to the stack */
	__(mr arg_z,whole_reg)
	__(set_nargs(2))
	__(b ksignalerr)

/* Everything up to the last arg has been vpushed, nargs is set to 
   the (boxed) count of things already pushed. 
   On exit, arg_x, arg_y, arg_z, and nargs are set as per a normal 
   function call (this may require vpopping a few things.) 
   ppc2-invoke-fn assumes that temp1 is preserved here. */
_spentry(spreadargz)
	__(extract_lisptag(imm1,arg_z))
	__(cmpwi cr1,imm1,tag_list)
	__(cmpw cr0,arg_z,rnil)
	__(li imm0,0)
	__(mr arg_y,arg_z)		/*  save in case of error */
	__(beq cr0,2f)
1:
	__(bne- cr1,3f)
	__(_car(arg_x,arg_z))
	__(_cdr(arg_z,arg_z))
	__(cmpw cr0,arg_z,rnil)
	__(extract_lisptag(imm1,arg_z))
	__(cmpwi cr1,imm1,tag_list)
	__(vpush(arg_x))
	__(addi imm0,imm0,fixnum_one)
	__(bne cr0,1b)
2:
	__(add. nargs,nargs,imm0)
	__(cmpwi cr2,nargs,2<<fixnumshift)
	__(beqlr- cr0)
	__(vpop(arg_z))
	__(bltlr cr2)
	__(vpop(arg_y))
	__(beqlr cr2)
	__(vpop(arg_x))
	__(blr)
/*  Discard whatever's been vpushed already, complain. */
3:	
	__(add vsp,vsp,imm0)
	__(mr arg_z,arg_y)		/* recover original arg_z */
	__(li arg_y,XNOSPREAD)
	__(set_nargs(2))
	__(b ksignalerr)

/* "spread" the lexpr in arg_z. 
   ppc2-invoke-fn assumes that temp1 is preserved here. */
_spentry(spread_lexprz)
	__(lwz imm0,0(arg_z))
	__(cmpwi cr3,imm0,3<<fixnumshift)
	__(cmpwi cr4,imm0,2<<fixnumshift)
	__(add imm1,arg_z,imm0)
	__(cmpwi cr0,imm0,0)
	__(add nargs,nargs,imm0)
	__(cmpwi cr1,nargs,0)
	__(cmpwi cr2,nargs,2<<fixnumshift)
	__(la imm1,4(imm1))
	__(bge cr3,9f)
	__(beq cr4,2f)
	__(bne cr0,1f)
	/* lexpr count was 0; vpop the arg regs that */
	/* were vpushed by the caller */
	__(beqlr cr1)
	__(vpop(arg_z))
	__(bltlr cr2)
	__(vpop(arg_y))
	__(beqlr cr2)
	__(vpop(arg_x))
	__(blr)

	/* vpush args from the lexpr until we have only */
	/* three left, then assign them to arg_x, arg_y, */
	/* and arg_z. */
8:
	__(cmpwi cr3,imm0,4<<fixnumshift)
	__(subi imm0,imm0,fixnumone)
	__(lwzu arg_z,-4(imm1))
	__(vpush(arg_z))
9:
	__(bne cr3,8b)
	__(lwz arg_x,-4(imm1))
	__(lwz arg_y,-8(imm1))
	__(lwz arg_z,-12(imm1))
	__(blr)

	/* lexpr count is two: set arg_y, arg_z from the */
	/* lexpr, maybe vpop arg_x */
2:	
	__(lwz arg_y,-4(imm1))
	__(lwz arg_z,-8(imm1))
	__(beqlr cr2)		/* return if (new) nargs = 2 */
	__(vpop(arg_x))
	__(blr)

	/* lexpr count is one: set arg_z from the lexpr, */
	/* maybe vpop arg_y, arg_x */
1:	
	__(lwz arg_z,-4(imm1))
	__(bltlr cr2)		/* return if (new) nargs < 2 */
	__(vpop(arg_y))
	__(beqlr cr2)		/* return if (new) nargs = 2 */
	__(vpop(arg_x))
	__(blr)

	_endfile

