/*
   Copyright (C) 1994-2001 Digitool, Inc
   This file is part of Opensourced MCL.

   Opensourced MCL is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   Opensourced MCL is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

	include(lisp.s)

/* Frame needs room for backlink, lr, 18 GPRs, FPSCR, 18 FPRs, 12 VRs, the
	VSCR, and VRSAVE, and must be aligned on a 16-byte boundary */

define([QT_BACKLINK],[0])
ifdef([EABI],[
  define([QT_SAVElr],[4])
  define([QT_first_nvr],[r14])
  define([QT_SAVEr14],[8])
  define([QT_SAVEnvrs],[QT_SAVEr14])
])

ifdef([POWEROPENABI],[
  define([QT_SAVElr],[8])
  define([QT_first_nvr],[r13])
  define([QT_SAVEr13],[(68)])
  define([QT_SAVEnvrs],[(QT_SAVEr13)])
  define([QT_SAVEr14],[(QT_SAVEr13+4)])
])

define([QT_SAVEfpscr],[QT_SAVEr14 + ((32-14)*4)])
define([QT_SAVEf14],[QT_SAVEfpscr+8])
define([QT_SAVEpad],[QT_SAVEf14+((32-14)*8)])
define([QT_SAVEv20],[QT_SAVEpad+8])
define([QT_SAVEvtemp],[QT_SAVEv20+((32-20)*16)])
define([QT_SAVEvrsave],[QT_SAVEvtemp+8])
define([QT_FRAMESIZE],[QT_SAVEvtemp+16])

ifelse(eval(QT_SAVEv20 & 0xf),eval(0),[],[
	errprint([Fix QT frame alignment.])
	m4exit(1)])
	
ifelse(eval(QT_FRAMESIZE  & 0xf),eval(0),[],[
	errprint([Fix QT frame size alignment.])
	m4exit(1)])
	 	
/*
	In general, a frame looks like:
+---------+
| backptr |	back link to previous frame
+---------+
| save lr |	slot for CALLEE to save lr in
+---------+
| save r14|	user function param 'pu'
+---------+
| save r15|	user function param 'pt'
+---------+
| save r16|	user function 'userf'
+---------+
| save r17|	'only'
+---------+
    ...
+---------+
| save r31|
+---------+
| fpscr   |	64 bits
|	  |
+---------+
| save f14|
|	  |
+---------+
   ...
+---------+
| save f31|
|	  |
+---------+
|  pad    |      64 bits
|         |
+---------+
| save v20|	128 bits
|         |
+---------+
   ...
+---------+
| save v31|
|         |
+---------+
| vrtemp  |  xxxx, xxxx, vrsave, vscr
|         |
+---------+
		When 'qt_start' runs, there should be a backlink
		and save_lr slot underneath the top frame.
*/

	_beginfile
	.globl C(altivec_present)
_exportfn(C(qt_block))
	__(andi. r0,sp,8)
	__(mflr r0)
	__(stw r0,(QT_SAVElr)(sp))
	__(bne 1f)
	__(stwu sp,-(QT_FRAMESIZE)(sp))
	__(b 2f)
1:
	__(stwu sp,-(QT_FRAMESIZE+8)(sp))
2:	
	__(stmw QT_first_nvr,(QT_SAVEnvrs)(sp))
	__(lis r15,HA(C(altivec_present)))
	__(lwz r15,LO(C(altivec_present))(r15))
	__(cmpwi r15,0)
	__(la r14,QT_SAVEfpscr-8(sp))
	__(mffs f0)
	__(stfdu f0,8(r14))
	__(stfdu f14,8(r14))
	__(stfdu f15,8(r14))
	__(stfdu f16,8(r14))
	__(stfdu f17,8(r14))
	__(stfdu f18,8(r14))
	__(stfdu f19,8(r14))
	__(stfdu f20,8(r14))
	__(stfdu f21,8(r14))
	__(stfdu f22,8(r14))
	__(stfdu f23,8(r14))
	__(stfdu f24,8(r14))
	__(stfdu f25,8(r14))
	__(stfdu f26,8(r14))
	__(stfdu f27,8(r14))
	__(stfdu f28,8(r14))
	__(stfdu f29,8(r14))
	__(stfdu f30,8(r14))
	__(stfdu f31,8(r14))
	__(beq 3f			/* branch if no Altivec */)
	__(la r14,8(r14))
	__(STVX(20,0,14))
	__(la r14,16(r14))
	__(STVX(21,0,14))
	__(la r14,16(r14))
	__(STVX(22,0,14))
	__(la r14,16(r14))
	__(STVX(23,0,14))
	__(la r14,16(r14))
	__(STVX(24,0,14))
	__(la r14,16(r14))
	__(STVX(25,0,14))
	__(la r14,16(r14))
	__(STVX(26,0,14))
	__(la r14,16(r14))
	__(STVX(27,0,14))
	__(la r14,16(r14))
	__(STVX(28,0,14))
	__(la r14,16(r14))
	__(STVX(29,0,14))
	__(la r14,16(r14))
	__(STVX(30,0,14))
	__(la r14,16(r14))
	__(STVX(31,0,14))
	__(la r14,16(r14))
	__(MFVSCR(31))
	__(STVX(31,0,14))
	__(mfspr r14,256)		/* VRSAVE */
	__(stw r14,(QT_SAVEvrsave)(sp))
3:
	__(mtctr r3)
	__(mr r3,sp)
	__(mr sp,r6)
	__(bctrl)
	__(lis r15,HA(C(altivec_present)))
	__(lwz r15,LO(C(altivec_present))(r15))
	__(cmpwi r15,0)
	__(la r14,QT_SAVEfpscr-8(sp))
	__(lfdu f0,8(r14))
	__(mtfsf 0xff,f0)
	__(lfdu f14,8(r14))
	__(lfdu f15,8(r14))
	__(lfdu f16,8(r14))
	__(lfdu f17,8(r14))
	__(lfdu f18,8(r14))
	__(lfdu f19,8(r14))
	__(lfdu f20,8(r14))
	__(lfdu f21,8(r14))
	__(lfdu f22,8(r14))
	__(lfdu f23,8(r14))
	__(lfdu f24,8(r14))
	__(lfdu f25,8(r14))
	__(lfdu f26,8(r14))
	__(lfdu f27,8(r14))
	__(lfdu f28,8(r14))
	__(lfdu f29,8(r14))
	__(lfdu f30,8(r14))
	__(lfdu f31,8(r14))
	__(beq 4f)
	__(la r14,8(r14))
	__(LVX(20,0,14))
	__(la r14,16(r14))
	__(LVX(21,0,14))
	__(la r14,16(r14))
	__(LVX(22,0,14))
	__(la r14,16(r14))
	__(LVX(23,0,14))
	__(la r14,16(r14))
	__(LVX(24,0,14))
	__(la r14,16(r14))
	__(LVX(25,0,14))
	__(la r14,16(r14))
	__(LVX(26,0,14))
	__(la r14,16(r14))
	__(LVX(27,0,14))
	__(la r14,16(r14))
	__(LVX(28,0,14))
	__(la r14,16(r14))
	__(LVX(29,0,14))
	__(la r14,16(r14))
	__(LVX(30,0,14))
	__(la r14,16(r14))
	__(LVX(31,0,14))
	__(la r14,16(r14))
	__(LVX(0,0,14))
	__(MTVSCR(0))
	__(lwz r14,(QT_SAVEvrsave)(sp))
	__(mtspr 256,r14)
4:	
	__(lmw QT_first_nvr,(QT_SAVEnvrs)(sp))
	__(lwz sp,(QT_BACKLINK)(sp))
	__(lwz r0,(QT_SAVElr)(sp))
	__(mtlr r0)
	__(blr)
_endfn

_exportfn(C(qt_start))
	.globl C(qt_error)
	__(mtctr r17)		/* Ready to call 'only' */
	__(mr r3,r14)		/* Load up user function pu. */
	__(mr r4,r15)		/* ... user function pt */
	__(mr r5,r16)		/* ... user function userf */
	__(bctrl)		/* Call only(pu,pt,userf) */
	__(b C(qt_error))	/* should never get here */
_endfn
	_endfile
