/*
   Copyright (C) 1994-2001 Digitool, Inc
   This file is part of Opensourced MCL.

   Opensourced MCL is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   Opensourced MCL is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

/* 
   A simple server loop for vxppccl.
*/



#include <stdio.h>
#include <setjmp.h>
#include "sockets.h"

#define LISP_PORT 1717


int default_lisp_port = LISP_PORT;


jmp_buf vxppccl_exit;

#ifdef TESTING
extern
server_test_loop(void);
#else
extern
vxppcclMain(void);
#endif
vxppccl()
{
  int sock, sock1;
  int old_in, old_out, old_err;

  old_in = ioTaskStdGet(0, 0);
  old_out = ioTaskStdGet(0, 1);
  old_err = ioTaskStdGet(0, 2);

  sock = open_server_socket(default_lisp_port);

  do {
    sock1 = accept_client_socket(sock);
    if (sock1 < 0) {
      close(sock);
      sock = -1;
      break;
    }
    if (setjmp(vxppccl_exit) == 0) {
      ioTaskStdSet(0, 0, sock1);
      ioTaskStdSet(0, 1, sock1);
      ioTaskStdSet(0, 2, sock1);
      fprintf(stderr, "Connected; starting vxppccl ... \n");
      fflush(stderr);
#ifdef TESTING
      server_test_loop();
#else
      vxppcclMain();
#endif
    }
    close(sock1);
  } while (0);
  ioTaskStdSet(0, 0, old_in);
  ioTaskStdSet(0, 1, old_out);
  ioTaskStdSet(0, 2, old_err);
  close(sock);
  return 0;
}

#ifdef TESTING
server_test_loop()
{
  char buf[512];
  fd_set infds;


  while(1) {
    fprintf(stdout, "type something: ");
    fflush(stdout);
    FD_ZERO(&infds);
    FD_SET(0, &infds);
    select(1, &infds, NULL, NULL, NULL);
    fgets(buf, 80, stdin);
    fprintf(stdout, "input was %s\n", buf);
  }
}
#endif
