/*
   Copyright (C) 1994-2001 Digitool, Inc
   This file is part of Opensourced MCL.

   Opensourced MCL is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   Opensourced MCL is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "lisp-exceptions.h"
#include "lisp_globals.h"
#include "area.h"
#include <ctype.h>
#include <stdio.h>
#include <stddef.h>
#include <string.h>
#include <stdarg.h>
#include <errno.h>
#include <stdio.h>

int
readc()
{
  int c;
  while ((c = getchar()) == '\n');
  return c;
}

void
show_lisp_register(ExceptionInformationPowerPC *xp, char *label, int r)
{
  extern char *print_lisp_object(LispObj);

  LispObj val = xpGPR(xp, r);

  fprintf(stderr, "r%02d (%s) = %s\n", r, label, print_lisp_object(val));
}

void
debug_lisp_registers(ExceptionInformationPowerPC *xp)
{
  int xpnil = (int) xpGPR(xp, rnil);

  fprintf(stderr, "rnil = 0x%08X ", xpnil);
  if (xpnil != lisp_nil) {
    fprintf(stderr, "(INVALID)\n");
  } else {
    fprintf(stderr, "\nnargs = %d\n", xpGPR(xp, nargs) >> 2);
    show_lisp_register(xp, "fn", fn);
    show_lisp_register(xp, "arg_z", arg_z);
    show_lisp_register(xp, "arg_y", arg_y);
    show_lisp_register(xp, "arg_x", arg_x);
    show_lisp_register(xp, "temp0", temp0);
    show_lisp_register(xp, "temp1/next_method_context", temp1);
    show_lisp_register(xp, "temp2/nfn", temp2);
    show_lisp_register(xp, "temp3/fname", temp3);
    show_lisp_register(xp, "save0", save0);
    show_lisp_register(xp, "save1", save1);
    show_lisp_register(xp, "save2", save2);
    show_lisp_register(xp, "save3", save3);
    show_lisp_register(xp, "save4", save4);
    show_lisp_register(xp, "save5", save5);
    show_lisp_register(xp, "save6", save6);
    show_lisp_register(xp, "save7", save7);
  }
}
    
void
debug_show_registers(ExceptionInformationPowerPC *xp)
{
  int a, b, c, d, i;

  for (a = 0, b = 8, c = 16, d = 24; a < 8; a++, b++, c++, d++) {
    fprintf(stderr,"r%02d = 0x%08X  r%02d = 0x%08X  r%02d = 0x%08X  r%02d = 0x%08X\n",
	    a, xpGPR(xp, a),
	    b, xpGPR(xp, b),
	    c, xpGPR(xp, c),
	    d, xpGPR(xp, d));
  }
  fprintf(stderr, "\n PC = 0x%08X   LR = 0x%08X  CTR = 0x%08X  CCR = 0x%08X\n",
	  xp->regs->nip, xp->regs->link, xp->regs->ctr, xp->regs->ccr);
  fprintf(stderr, "XER = 0x%08X  MSR = 0x%08X  DAR = 0x%08X  DSISR = 0x%08X\n",
	  xp->regs->xer, xp->regs->msr, xp->regs->dar, xp->regs->dsisr);
}

void
debug_show_fpu(ExceptionInformationPowerPC *xp)
{
  double *dp, d;
  int *np, n, i;

  np = ((int *)(xp->regs))+PT_FPR0;
  dp = ((double *)np);
  
  for (i = 0; i < 32; i++) {
    fprintf(stderr, "f%02d : 0x%08X%08X (%f)\n", i,  *np++, *np++, *dp++);
  }
  fprintf(stderr, "FPSCR = %08X\n", np[1]);

}

void
debug_backtrace(ExceptionInformationPowerPC *xp)
{
  extern LispObj current_stack_pointer();
  extern void plbt_sp(LispObj);
  extern void plbt(ExceptionInformationPowerPC *);

  if (xp) {
    plbt(xp);
  } else {
    plbt_sp(current_stack_pointer());
  }
}

void
Debugger(ExceptionInformationPowerPC *xp, char *message)
{
  fprintf(stderr, "%s\n", message);
  if (lisp_global(BATCH_FLAG)) {
    lisp_exit(-1);
  }
  while (1) {
    fprintf(stderr,"\n(R)egisters, (L)isp registers (F)loating-point, (B)acktrace (K)ill, e(X)it ?");
    switch(readc()) {
    case 'R': case 'r':
      if (xp) {
	debug_show_registers(xp);
      }
      break;
    case 'L': case 'l':
      if (xp) {
	debug_lisp_registers(xp);
      }
      break;
    case 'F': case 'f':
      if (xp) {
	debug_show_fpu(xp);
      }
      break;
    case 'B': case 'b':
      debug_backtrace(xp);
      break;
    case 'K': case 'k':
      lisp_exit(-1);
    case 'X': case 'x':
      return;
    }
  }
}

