;;;-*-Mode: LISP; Package: CCL -*-
;;;
;;;   Copyright (C) 1994-2001 Digitool, Inc
;;;   This file is part of Opensourced MCL.
;;;
;;;   Opensourced MCL is free software; you can redistribute it and/or
;;;   modify it under the terms of the GNU Lesser General Public
;;;   License as published by the Free Software Foundation; either
;;;   version 2.1 of the License, or (at your option) any later version.
;;;
;;;   Opensourced MCL is distributed in the hope that it will be useful,
;;;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;;   Lesser General Public License for more details.
;;;
;;;   You should have received a copy of the GNU Lesser General Public
;;;   License along with this library; if not, write to the Free Software
;;;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;;;


(in-package "CCL")

;;; mcl-compat.lisp - (some) backwards-compatibility with traditional MCL
;;;  (CLtL2/ANSI, etc.)

;;;  Gratuitous name changes, for the most part:

(deftype base-character () 'base-char)
(deftype extended-character () 'extended-char)

(defmacro define-setf-method (access-fn lambda-list &body body)
  `(define-setf-expander ,access-fn ,lambda-list ,@body))

(defun get-setf-method (form &optional environment)
  (get-setf-expansion-aux form environment nil))

(defun get-setf-method-multiple-value (form &optional environment)
  "Like Get-Setf-Method, but may return multiple new-value variables."
  (get-setf-expansion-aux form environment t))

;;; Traditional MCL I/O primitives:

(defun tyi (stream)
  (let* ((ch (stream-read-char stream)))
    (unless (eq ch :eof) ch)))

(defun untyi (ch &optional stream)
  (stream-unread-char (designated-input-stream stream) ch))

(defun tyo (ch &optional stream)
  (stream-write-char (real-print-stream stream) ch))
