;;;-*-Mode: LISP; Package: CCL -*-
;;;
;;;   Copyright (C) 1994-2001 Digitool, Inc
;;;   This file is part of Opensourced MCL.
;;;
;;;   Opensourced MCL is free software; you can redistribute it and/or
;;;   modify it under the terms of the GNU Lesser General Public
;;;   License as published by the Free Software Foundation; either
;;;   version 2.1 of the License, or (at your option) any later version.
;;;
;;;   Opensourced MCL is distributed in the hope that it will be useful,
;;;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;;   Lesser General Public License for more details.
;;;
;;;   You should have received a copy of the GNU Lesser General Public
;;;   License along with this library; if not, write to the Free Software
;;;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;;;

(in-package "CCL")

(eval-when (:compile-toplevel :execute)
  (require "SOLARIS-RECORDS"))

(defcallback 
 %err-disp 
  (:address xp :unsigned-fullword fn-reg :unsigned-fullword pc-or-index :signed-fullword errnum :unsigned-fullword rb :signed-fullword continuable)
  (let ((fn (unless (eql fn-reg 0) (sparc-xp-gpr-lisp xp fn-reg)))
        (err-fn (if (eql continuable 0) '%err-disp-internal '%kernel-restart-internal)))
    (if (eql errnum sparc::error-stack-overflow)
      (handle-stack-overflow xp fn rb)
      (with-xp-stack-frames (xp fn frame-ptr)   ; execute body with dummy stack frame(s)
        (with-error-reentry-detection
          (let* ((rb-value (sparc-xp-gpr-lisp xp rb))
                 (res
                  (cond ((< errnum 0)
                         (%err-disp-internal errnum nil frame-ptr))
                        ((logtest errnum arch::error-type-error)
                         (funcall err-fn 
                                  #.(car (rassoc 'type-error *kernel-simple-error-classes*))
                                  (list rb-value (logand errnum 63))
                                  frame-ptr))
                        ((eql errnum arch::error-udf)
                         (funcall err-fn $xfunbnd (list rb-value) frame-ptr))
                        ((eql errnum arch::error-throw-tag-missing)
                         (%err-disp-internal $xnoctag (list rb-value) frame-ptr))
                        ((eql errnum arch::error-cant-call)
                         (funcall err-fn $xnotfun (list rb-value) frame-ptr))
                        ((eql errnum arch::error-udf-call)
                         (return-from %err-disp
                           (handle-udf-call xp frame-ptr)))
                        ((eql errnum arch::error-alloc-failed)
                         (%error (make-condition 
                                  'simple-storage-condition
                                  :format-control (%rsc-string $xmemfull))
                                 nil frame-ptr))
                        ((eql errnum arch::error-memory-full)
                         (%error (make-condition 
                                  'simple-storage-condition
                                  :format-control (%rsc-string $xnomem))
                                 nil frame-ptr))
                        ((or (eql errnum arch::error-fpu-exception-double) 
                             (eql errnum arch::error-fpu-exception-single))
                         (let* ((code-vector (and fn fn (uvref fn 0)))
                                (instr (if code-vector 
                                         (uvref code-vector pc-or-index)
                                         (%get-long (%int-to-ptr pc-or-index)))))
                           (let* ((minor (ldb (byte 5 1) instr))
                                  (fra (ldb (byte 5 16) instr))
                                  (frb (ldb (byte 5 11) instr))
                                  (frc (ldb (byte 5 6) instr)))
                             (declare (fixnum minor fra frb frc))
                             (if (= minor 12)   ; FRSP
                               (%err-disp-internal $xcoerce (list (xp-double-float xp frc) 'short-float) frame-ptr)
                               (flet ((coerce-to-op-type (double-arg)
                                        (if (eql errnum arch::error-fpu-exception-double)
                                          double-arg
                                          (handler-case (coerce double-arg 'short-float)
                                            (error (c) (declare (ignore c)) double-arg)))))
                                 (multiple-value-bind (status control) (xp-fpscr-info xp)
                                   (%error (make-condition (fp-condition-from-fpscr status control)
                                                           :operation (fp-minor-opcode-operation minor)
                                                           :operands (list (coerce-to-op-type 
                                                                            (xp-double-float xp fra))
                                                                           (if (= minor 25)
                                                                             (coerce-to-op-type 
                                                                              (xp-double-float xp frc))
                                                                             (coerce-to-op-type 
                                                                              (xp-double-float xp frb)))))
                                           nil
                                           frame-ptr)))))))
                        ((eql errnum arch::error-excised-function-call)
                         (%error "~s: code has been excised." (list (sparc-xp-gpr-lisp xp sparc::%nfn)) frame-ptr))
                        ((eql errnum arch::error-too-many-values)
                         (%err-disp-internal $xtoomanyvalues (list rb-value) frame-ptr))
			((or (eql errnum arch::error-cant-take-car)
			     (eql errnum arch::error-cant-take-cdr))
			 (%err-disp-internal
			  (if (eql errnum arch::error-cant-take-car)
			      $xnocar
			      $xnocdr)
			  (list rb-value) frame-ptr))
			(t (%error "Unknown error #~d with arg: ~d" (list errnum rb-value) frame-ptr))
			)))
            (setf (sparc-xp-gpr-lisp xp rb) res)        ; munge register for continuation
            ))))))

(defun handle-udf-call (xp frame-ptr)
  (let* ((args (sparc-xp-argument-list xp))
	 (values (multiple-value-list
		     (%kernel-restart-internal
		      $xudfcall
		      (list (sparc-xp-gpr-lisp xp sparc::%fname) args)
		      frame-ptr)))
	 (stack-argcnt (max 0 (- (length args) 3)))
	 (vsp (%i+ (sparc-xp-gpr-lisp xp sparc::%vsp) stack-argcnt))
	 (f #'(lambda (values) (apply #'values values))))
    (setf (sparc-xp-gpr-lisp xp sparc::%vsp) vsp
	  (sparc-xp-gpr-lisp xp sparc::%nargs) 1
	  (sparc-xp-gpr-lisp xp sparc::%arg_z) values
	  (sparc-xp-gpr-lisp xp sparc::%nfn) f)
    ;;; This is pretty funky.  Wish there was a better way.
    (without-interrupts
     (let*  ((entry (%misc-address-fixnum (uvref f 0))))
       (with-macptrs ((p (%inc-ptr xp #.(get-field-offset :ucontext.uc-mcontext.gregs))))
	 (%set-object p (ash (- reg-pc 0) 2) entry)
	 (%set-object p (ash (- reg-npc 0) 2) (1+ entry)))))))

    
	      
(defsparclapfunction %misc-address-fixnum ((misc-object %arg_z))
  (check-nargs 1)
  (retl)
    (add misc-object arch::misc-data-offset %arg_z))
