;;;-*-Mode: LISP; Package: CCL -*-
;;;
;;;   Copyright (C) 1994-2001 Digitool, Inc
;;;   This file is part of Opensourced MCL.
;;;
;;;   Opensourced MCL is free software; you can redistribute it and/or
;;;   modify it under the terms of the GNU Lesser General Public
;;;   License as published by the Free Software Foundation; either
;;;   version 2.1 of the License, or (at your option) any later version.
;;;
;;;   Opensourced MCL is distributed in the hope that it will be useful,
;;;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;;   Lesser General Public License for more details.
;;;
;;;   You should have received a copy of the GNU Lesser General Public
;;;   License along with this library; if not, write to the Free Software
;;;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;;;



; L1-utils.lisp


#+allow-in-package
(in-package "CCL")

;The following forms (up thru defn of %DEFUN) must come before any DEFUN's.
;Any (non-kernel) functions must be defined before they're used! 
;In fact, ALL functions must be defined before they're used!  How about that ?



(setq %lisp-system-fixups% nil)

(setq *lfun-names* (make-hash-table :test 'eq :weak t))



(setq *warn-if-redefine-kernel* nil)

(setq *warn-if-redefine* nil)
(setq *record-source-file* t)

; Kluge for record-source-file bootstrapping

; Set T by l1-boot.lisp
(setq *level-1-loaded* nil)

(%fhave 'full-pathname (qlfun bootstrapping-full-pathname (name) name))

(%fhave '%source-files (qlfun bootstrapping-%source-files (name)
                         (get name 'bootstrapping-source-files)))
(%fhave '%set-source-files (qlfun bootstrapping-%set-source-files (name value)
                             (put name 'bootstrapping-source-files value)))





; real one is  in setf.lisp
(%fhave '%setf-method (qlfun bootstripping-setf-fsname (spec)
                                   spec nil))

; this new thing breaks for case of a function being defined in non-file place
; use some euphemism for that such as t or "{No file}"
; something is broken (probably) here calling assq with garbage

(defun source-file-or-files (symbol type setf-p method)
  (let ((source-files-info (%source-files symbol))    
        assoc-pair files)
    (cond ((null (consp source-files-info))
           (values source-files-info
                   nil
                   (if (and source-files-info (eq type 'function)(not setf-p)) source-files-info)))
          (t (setq assoc-pair (assq type (if setf-p
                                           (cdr (assq 'setf source-files-info))
                                           source-files-info)))
             (if (neq type 'method)
               (setq files assoc-pair)
               (setq files
                     (do* ((lst (cdr assoc-pair) (cdr lst))
                           (clst (car lst)(car lst)))
                          ((null lst) nil)
                       (when (consp clst)
                         (when (or (eq method (car clst))  ; method is a place holder for q's and s's 
                                   (and (methods-congruent-p method (car clst))
                                        ; below avoids clutter
                                        (rplaca clst method)))
                           (return clst))))))
             (values source-files-info assoc-pair files)))))

; warn if defining in no file iff previously defined in a file (i.e. dont
; warn every time something gets redefined in the listener)
; fix to not to bitch if file is anywhere in list
; name is function-name or (method-name (class-names)) or ((setf method-name) (class-names))
; store('method (method file  file) (method file file) ...)
; if type is 'method we expect name to be an actual method
; Remember to smash old methods with newer methods to avoid clutter - done

(defun physical-pathname-p (file)(declare (ignore file)) nil) ; redefined later


;(%defvar *enqueued-window-title* nil)

(defun booted-probe-file (file)
  (declare (ignore file))
  nil)

(queue-fixup
 (defun booted-probe-file (file)
   (probe-file file)))

(defun record-source-file (name def-type
                                &optional (file-name *loading-file-source-file*))  
  (let (symbol setf-p method old-file)
    (flet ((same-file (x y)
             (or (eq x y)
		 ;; funny because equal not defined before us
                 (and x
		      y
		      (or (equal x y)
			  (equal
			   (or (booted-probe-file x) (full-pathname x))
			   (or (booted-probe-file y) (full-pathname y))))))))
      (when (and *record-source-file* ) ;file-name)
        (when (and file-name (physical-pathname-p file-name))
	  (setq file-name (namestring (back-translate-pathname file-name)))
	  (cond ((equalp file-name *last-back-translated-name*)
		 (setq file-name *last-back-translated-name*))
		(t (setq *last-back-translated-name* file-name))))
        (when (eq t def-type) (report-bad-arg def-type '(not (eql t))))
        (cond ((eq def-type 'method)
               (setq method name symbol (%method-name name) name nil))
              ((consp name)
               (cond ((neq (car name) 'setf)
                      (warn "record-source-file hates ~s" name))
                     (t (setq symbol name))))
              ((symbolp name) (setq symbol name)))
        (cond ((and (consp symbol)(eq (car symbol) 'setf))
               (let ((tem (%setf-method (cadr symbol))))
                 (if tem 
                   (setq symbol tem)
                   (progn (setq symbol (cadr symbol))
                          (setq setf-p t))))))
					; assoc-pair is e.g. (function file1 ...) or (class . file)
					; or (method (method-object  file1 ...) ...) or (method (method-object . file) ...)
        (when (symbolp symbol)		; avoid boot problems - you thought          
          (multiple-value-bind (source-files-info assoc-pair files)
	      (source-file-or-files symbol def-type setf-p method)                                             
            (setq old-file 
                  (cond ((consp files)
                         (if (consp (cdr files)) (cadr files) (cdr files)))
                        (t files)))
            (unless
		(if (or (not (consp files))(not (consp (cdr files))))
		  (same-file old-file file-name)
		  (do ((lst (cdr files)(cdr lst)))
		      ((null (consp lst)) nil) 
		    (when (same-file file-name (car lst))
		      (rplaca lst (cadr files))
		      (rplaca (cdr files) file-name)
		      (return t))))
              (when (and *warn-if-redefine*
                         (neq def-type 'method)	; This should be more specific
                         (cond ((eq def-type 'function)
                                (and (fboundp name) old-file))
                               (t old-file)))
                (warn " ~S ~S previously defined in: ~A
         is now being redefined in: ~A~%"
                      def-type
                      name
                      (or old-file "{Not Recorded}")
                      (or file-name "{No file}")))
              (if (consp files)
                (%rplacd files (cons file-name 
                                     (if (consp (cdr files))(cdr files)(list (cdr files)))))
                
                (if assoc-pair
                  (%rplacd assoc-pair (cons (if (eq def-type 'method)
                                              `(,method . , file-name)
                                              file-name)
                                            (if (consp (%cdr assoc-pair))
                                              (%cdr assoc-pair)
                                              (list (%cdr assoc-pair)))))
		  (%set-source-files
		   symbol
		   (cond ((and (eq def-type 'function)
			       (null setf-p)
			       (not (consp  source-files-info)))
			  (if (null old-file)
			    file-name
			    `((function ,file-name ,old-file))))
			 (t
			  (when (and source-files-info
				     (not (consp source-files-info)))
			    (setq source-files-info `((function . , source-files-info))))
			  (let ((thing (if (neq def-type 'method) 
					 `(,def-type . ,file-name)
					 `(,def-type (,method . ,file-name)))))
			    (cons (if setf-p `(setf ,thing) thing) source-files-info))))))))
	    ))))))

(record-source-file 'record-source-file 'function)

(defun inherit-from-p (ob parent)
  (memq (if (symbolp parent) (find-class parent nil) parent)
        (%inited-class-cpl (class-of ob))))

; returns new plist with value spliced in or key, value consed on.
(defun setprop (plist key value &aux loc)
 (if (setq loc (pl-search plist key))
  (progn (%rplaca (%cdr loc) value) plist)
  (cons key (cons value plist))))

(defun getf-test (place indicator test &optional default)
  (loop
    (when (null place)
      (return default))
    (when (funcall test indicator (car place))
      (return (cadr place)))
    (setq place (cddr place))))

(defun setprop-test (plist indicator test value)
  (let ((tail plist))
    (loop
      (when (null tail)
        (return (cons indicator (cons value plist))))
      (when (funcall test indicator (car tail))
        (setf (cadr tail) value)
        (return plist))
      (setq tail (cddr tail)))))

(defun plistp (p &aux len)
  (and (listp p)
       (setq len (list-length p))
       (not (%ilogbitp 0 len))))  ; (evenp p)

(defun %imax (i1 i2)
 (if (%i> i1 i2) i1 i2))

(defun %imin (i1 i2)
  (if (%i< i1 i2) i1 i2))

(defun nremove (elt list)
  (let* ((handle (cons nil list))
         (splice handle))
    (declare (dynamic-extent handle))
    (loop
      (if (eq elt (car (%cdr splice)))
        (unless (setf (%cdr splice) (%cddr splice)) (return))
        (unless (cdr (setq splice (%cdr splice)))
          (return))))
    (%cdr handle)))


;|#


(eval-when (:compile-toplevel :execute)
  (defmacro need-use-eql-macro (key)
    `(let* ((typecode (typecode ,key)))
       (declare (fixnum typecode))
       (or (= typecode arch::subtag-macptr)
           (and (>= typecode arch::min-numeric-subtag)
                (<= typecode arch::max-numeric-subtag)))))
  (require "NUMBER-MACROS")
)






(defun loading-file-source-file ()
  *loading-file-source-file*)

(setq *save-local-symbols* t)

(%fhave 'require-type (nfunction bootstrapping-require-type
                                 (lambda (thing type)
                                   (declare (ignore type))
                                   thing)))
(%fhave '%require-type 
        (nfunction bootstrapping-%require-type
                   (lambda (thing predicate)
                     (declare (ignore predicate))
                     thing)))

(setf (type-predicate 'macptr) 'macptrp)

(defun null-or-handlep (arg)
  (and (macptrp arg)
       (or (%null-ptr-p arg)
           (handlep arg))))

(defun require-null-or-handlep (arg)
  (if (null-or-handlep arg)
    arg
    (require-type arg '(satisfies null-or-handlep))))


(%fhave 'set-macro-function #'%macro-have)   ; redefined in sysutils.

; Define special forms.
(dolist (sym '(block catch compiler-let declare eval-when
               flet function go if labels let let* macrolet
               multiple-value-call multiple-value-prog1
               progn progv quote return-from setq tagbody
               the throw unwind-protect locally load-time-value
	       symbol-macrolet 
; These are implementation-specific special forms :
	       nfunction without-interrupts
               macro-bind debind 
	       %vreflet ppc-lap-function sparc-lap-function fbind))
  (%macro-have sym sym))



(locally (declare (special *fred-special-indent-alist*))
   (setq *fred-special-indent-alist* nil))
  
(defun %macro (named-fn &optional doc &aux body-pos arglist)
  ; "doc" is either a string or a list of the form :
  ; (doc-string-or-nil . (body-pos-or-nil . arglist-or-nil))
  (if (listp doc)
    (setq body-pos (cadr doc)
          arglist (cddr doc)
          doc (car doc)))
  (let* ((name (function-name named-fn)))
    (record-source-file name 'function)
    (set-macro-function name named-fn)
    (when (and doc *save-doc-strings*)
      (setf (documentation name 'function) doc))
    (when body-pos
      (setf (assq name *fred-special-indent-alist*) body-pos))
    (when arglist
      (record-arglist name arglist))
    (when *fasload-print* (format t "~&~S~%" name))
    name))

#+ignore                                ; moved to "ccl:level-0;l0-symbol.lisp"
(defun boundp (sym)
  (not (eq (%sym-value sym) (%unbound-marker)))) ; undefinedp


(defun %defvar (var &optional doc)
  "Returns boundp"
  (%proclaim-special var)
  (record-source-file var 'variable)
  (cond ((not (boundp var))
         (when (and doc *save-doc-strings*)
           (setf (documentation var 'variable) doc))
         (when *fasload-print* (format t "~&~S~%" var))
         nil)
        (t t)))

(defun %defparameter (var value &optional doc)
  (%proclaim-special var)
  (record-source-file var 'variable)
  (when (and doc *save-doc-strings*)
    (setf (documentation var 'variable) doc))
  (when *fasload-print* (format t "~&~S~%" var))
  (set var value)
  var)

(defun %defglobal (var value &optional doc)
  (%symbol-bits var (logior (ash 1 $sym_vbit_global) (the fixnum (%symbol-bits var))))
  (%defparameter var value doc))

;Needed early for member etc.
(defun identity (x) x)

(%fhave 'find-unencapsulated-definition #'identity)

(defun coerce-to-function (arg)
  (if (functionp arg)
    arg
    (if (symbolp arg)
      (%function arg)
      (report-bad-arg arg 'function))))

; takes arguments in arg_x, arg_y, arg_z, returns "multiple values" 
; Test(-not) arguments are NOT validated beyond what is done
; here.
; if both :test and :test-not supplied, signal error.
; if test provided as #'eq or 'eq, return first value 'eq.
; if test defaulted, provided as 'eql, or provided as #'eql, return first value 'eql.
; if test-not provided as 'eql or provided as #'eql, return second value 'eql.
; if key provided as either 'identity or #'identity, return third value nil.
(defun %key-conflict (test-fn test-not-fn key)
  (let* ((eqfn #'eq)
         (eqlfn #'eql)
         (idfn #'identity))
    (if (or (eq key 'identity) (eq key idfn))
      (setq key nil))
    (if test-fn
      (if test-not-fn
        (%err-disp $xkeyconflict ':test test-fn ':test-not test-not-fn)
        (if (eq test-fn eqfn)
          (values 'eq nil key)
          (if (eq test-fn eqlfn)
            (values 'eql nil key)
            (values test-fn nil key))))
      (if test-not-fn
        (if (eq test-not-fn eqfn)
          (values nil 'eq key)
          (if (eq test-not-fn eqlfn)
            (values nil 'eql key)
            (values nil test-not-fn key)))
        (values 'eql nil key)))))




;;; Assoc.

; (asseql item list) <=> (assoc item list :test #'eql :key #'identity)

(defun asseql (item list)
  (when (not (listp list))(setq list (%kernel-restart $xwrongtype list 'list)))
  (locally (declare (list list))
    (if (need-use-eql-macro item)
      (dolist (pair list)
        (if (and pair (eql item (%car pair)))
          (return pair)))
      (dolist (pair list)        
        (when (and pair (eq item (%car pair)))
          (return pair))))))

; (assoc-test item list test-fn) 
;   <=> 
;     (assoc item list :test test-fn :key #'identity)
; test-fn may not be FUNCTIONP, so we coerce it here.
(defun assoc-test (item list test-fn)
  (dolist (pair list)
    (if (and pair (funcall test-fn item (car pair)))
      (return pair))))



; (assoc-test-not item list test-not-fn) 
;   <=> 
;     (assoc item list :test-not test-not-fn :key #'identity)
; test-not-fn may not be FUNCTIONP, so we coerce it here.
(defun assoc-test-not (item list test-not-fn)
  (dolist (pair list)
    (if (and pair (not (funcall test-not-fn item (car pair))))
      (return pair))))

(defun assoc (item list &key test test-not key)
  (multiple-value-bind (test test-not key) (%key-conflict test test-not key)
    (if (null key)
      (if (eq test 'eq)
        (assq item list)
        (if (eq test 'eql)
          (asseql item list)
          (if test
            (assoc-test item list test)
            (assoc-test-not item list test-not))))
      (if test
        (dolist (pair list)
          (when pair
            (if (funcall test item (funcall key (car pair)))
              (return pair))))
        (dolist (pair list)
          (when pair
            (unless (funcall test-not item (funcall key (car pair)))
              (return pair))))))))


;;;; Member.

; (memeql item list) <=> (member item list :test #'eql :key #'identity)

;nil or error - supposed to error if not proper list?
(defun memeql (item list)
  (when (not (listp list))(setq list (%kernel-restart $xwrongtype list 'list)))
  (if (need-use-eql-macro item)
    (do* ((l list (cdr l)))
         ((null l))
      (when (eql (%car l) item) (return l)))
    (do* ((tail list (cdr tail)))
         ((null tail))
      (if (eq item (%car tail))
        (return tail)))))

; (member-test item list test-fn) 
;   <=> 
;     (member item list :test test-fn :key #'identity)
(defun member-test (item list test-fn)
  (if (or (eq test-fn 'eq)(eq test-fn  #'eq)
          (and (or (eq test-fn 'eql)(eq test-fn  #'eql))
               (not (need-use-eql-macro item))))
    (do* ((l list (cdr l)))
         ((null l))
      (when (eq item (car l))(return l)))
    (if (or (eq test-fn 'eql)(eq test-fn  #'eql))
      (do* ((l list (cdr l)))
           ((null l))
        (when (eql item (car l))(return l)))    
      (do* ((l list (cdr l)))
           ((null l))
        (when (funcall test-fn item (car l)) (return l))))))


; (member-test-not item list test-not-fn) 
;   <=> 
;     (member item list :test-not test-not-fn :key #'identity)
(defun member-test-not (item list test-not-fn)
  (do* ((l list (cdr l)))
       ((null l))
    (unless (funcall test-not-fn item (car l)) (return l))))

(defun member (item list &key test test-not key)
  (multiple-value-bind (test test-not key) (%key-conflict test test-not key)
    (if (null key)
      (if (eq test 'eq)
        (memq item list)
        (if (eq test 'eql)
          (memeql item list)
          (if test
            (member-test item list test)
            (member-test-not item list test-not))))
      (if test
        (do* ((l list (cdr l)))
             ((null l))
          (if (funcall test item (funcall key (car l)))
              (return l)))
        (do* ((l list (cdr l)))
             ((null l))
          (unless (funcall test-not item (funcall key (car l)))
              (return l)))))))

(defun adjoin (item list &key test test-not key)
  (if (and (not test)(not test-not)(not key))
    (if (not (memeql item list))(cons item list) list)
    (multiple-value-bind (test test-not key) (%key-conflict test test-not key)
      (if
        (if (null key)
          (if (eq test 'eq)
            (memq item list)
            (if (eq test 'eql)
              (memeql item list)
              (if test
                (member-test item list test)
                (member-test-not item list test-not))))
          (if test
            (member (funcall key item) list :test test :key key)
            (member (funcall key item) list :test-not test-not :key key)))
        list
        (cons item list)))))

(defun adjoin-eq (elt list)
  (if (memq elt list)
    list
    (cons elt list)))

(defun adjoin-eql (elt list)
  (if (memeql elt list)
    list
    (cons elt list)))

(defun union-eq (list1 list2)
  (let ((res list2))
    (dolist (elt list1)
      (unless (memq elt res)
        (push elt res)))
    res))

(defun union-eql (list1 list2)
  (let ((res list2))
    (dolist (elt list1)
      (unless (memeql elt res)
        (push elt res)))
    res))

; Fix this someday.  Fix EQUALP, while you're at it ...
(defun similar-as-constants-p (x y)
  (or (eq x y)                          ; Redefinition of constants to themselves.
      (if (and (stringp x) (stringp y)) ;The most obvious case where equalp & s-a-c-p need to differ...
        (string= x y)
        (equalp x y))))

(defun define-constant (var value)
  (block nil
    (if (constant-symbol-p var)
      (if (similar-as-constants-p (%sym-value var) value)
        (return)
        ;This should really be a cell error, allow options other than redefining (such
        ; as don't redefine and continue)...
        (cerror "Redefine ~S anyway"
                "Constant ~S is already defined with a different value"
                var)))
    (%symbol-bits var 
                  (%ilogior (%ilsl $sym_bit_special 1) (%ilsl $sym_bit_const 1)
                            (%symbol-bits var)))
    (%set-sym-value var value))
  var)

(defun %defconstant (var value &optional doc)
  (%proclaim-special var)
  (record-source-file var 'constant)
  (define-constant var value)
  (when (and doc *save-doc-strings*)
    (setf (documentation var 'variable) doc))
  (when *fasload-print* (format t "~&~S~%" var))
  var)

(defparameter *nx1-compiler-special-forms* ())
(defparameter *nx-proclaimed-types* ())
(defparameter *nx-proclaimed-ftypes* nil)

(defun compiler-special-form-p (sym)
  (or (eq sym 'quote)
      (if (memq sym *nx1-compiler-special-forms*) t)))

(defun evaluator-special-form-p (sym)
  (declare (ignore sym))
 '(get sym 'special-in-evaluator)
 nil)

(defparameter *nx-known-declarations* ())
(defparameter *nx-proclaimed-inline* ())
(defparameter *nx-proclaimed-ignore* ())
(defparameter *nx-globally-inline* ())



(defconstant *cl-types* '(
array
atom
base-char
bignum
bit
bit-vector 
character
#|
lisp:common
|#
compiled-function 
complex 
cons                    
double-float
extended-char
fixnum
float
function
hash-table
integer
keyword
list 
long-float
nil 
null
number  
package
pathname 
random-state  
ratio
rational
readtable
real
sequence 
short-float
signed-byte 
simple-array
simple-bit-vector
simple-string 
simple-base-string
simple-extended-string 
simple-vector 
single-float
standard-char
stream  
string
#|
lisp:string-char
|#
symbol
t
unsigned-byte 
vector
))

(defun proclaim (spec)
  (case (car spec)
    (special (apply #'proclaim-special (%cdr spec)))
    (notspecial (apply #'proclaim-notspecial (%cdr spec)))
    (optimize (%proclaim-optimize (%cdr spec)))
    (inline (apply #'proclaim-inline t (%cdr spec)))
    (notinline (apply #'proclaim-inline nil (%cdr spec)))
    (declaration (apply #'proclaim-declaration (%cdr spec)))
    (ignore (apply #'proclaim-ignore t (%cdr spec)))
    (unignore (apply #'proclaim-ignore nil (%cdr spec)))
    (type (apply #'proclaim-type (%cdr spec)))
    (ftype (apply #'proclaim-ftype (%cdr spec)))
    ;(function (proclaim-ftype (cons 'function (cddr spec)) (cadr spec)))
    (t (unless (memq (%car spec) *nx-known-declarations*) ;not really right...
         (if (memq (%car spec) *cl-types*)
           (apply #'proclaim-type spec)
           (warn "Unknown declaration specifier(s) in ~S" spec))))))

(defun proclaim-type (type &rest vars)
  (declare (dynamic-extent vars))
  (dolist (var vars)
    (if (symbolp var)
      (let ((spec (assq var *nx-proclaimed-types*)))
        (if spec
          (rplacd spec type)
          (push (cons var type) *nx-proclaimed-types*)))
      (warn "Invalid type declaration for ~S" var))))

#| redefined from nfcomp
(defun proclaim-ftype (type &rest names)
  (declare (ignore type names))
  ;remember to accept (setf name)'s when implement this.
  nil)
|#

(defun proclaim-ftype (ftype &rest names)
  (declare (dynamic-extent names))
  (unless *nx-proclaimed-ftypes*
    (setq *nx-proclaimed-ftypes* (make-hash-table :test #'eq)))
  (dolist (name names)
    (setf (gethash (ensure-valid-function-name name) *nx-proclaimed-ftypes*) ftype)))

(defun proclaimed-ftype (name)
  (when *nx-proclaimed-ftypes*
    (gethash (ensure-valid-function-name name) *nx-proclaimed-ftypes*)))

(defun proclaim-special (&rest vars)
  (declare (dynamic-extent vars))
  (dolist (sym vars) (%proclaim-special sym)))

(defun proclaim-notspecial (&rest vars)
  (declare (dynamic-extent vars))
  (dolist (sym vars) (%proclaim-notspecial sym)))

(defun proclaim-inline (t-or-nil &rest names)
  (declare (dynamic-extent names))
  ;This is just to make it more likely to detect forgetting about the first arg...
  (unless (or (eq nil t-or-nil) (eq t t-or-nil)) (report-bad-arg t-or-nil '(member t nil)))
  (dolist (name names)
    (setq name (ensure-valid-function-name name))
    (if (listp *nx-proclaimed-inline*)
      (setq *nx-proclaimed-inline*
          (alist-adjoin name
                        (or t-or-nil (if (compiler-special-form-p name) t))
                        *nx-proclaimed-inline*))      
      (setf (gethash name *nx-proclaimed-inline*)
            (or t-or-nil (if (compiler-special-form-p name) t))))))

(defun proclaim-declaration (&rest syms)
  (declare (dynamic-extent syms))
  (dolist (sym syms)
    (setq *nx-known-declarations* 
          (adjoin sym *nx-known-declarations* :test 'eq))))

(defun proclaim-ignore (t-or-nil &rest syms)
  (declare (dynamic-extent syms))
  ;This is just to make it more likely to detect forgetting about the first arg...
  (unless (or (eq nil t-or-nil) (eq t t-or-nil)) (report-bad-arg t-or-nil '(member t nil)))
  (dolist (sym syms)
    (setq *nx-proclaimed-ignore*
          (alist-adjoin sym t-or-nil *nx-proclaimed-ignore*))))

(queue-fixup
 (when (listp *nx-proclaimed-inline*)
  (let ((table (make-hash-table :size 100 :test #'eq)))
    (dolist (x *nx-proclaimed-inline*)
      (let ((name (car x)) (value (cdr x)))
        (when (symbolp name)
          (setf (gethash name table) value))))
    (setq *nx-proclaimed-inline* table))))

(defun proclaimed-special-p (sym)
  (%ilogbitp $sym_vbit_special (%symbol-bits sym)))

(defun proclaimed-inline-p (sym)
  (if (listp *nx-proclaimed-inline*)
    (%cdr (assq sym *nx-proclaimed-inline*))
    (gethash sym *nx-proclaimed-inline*)))

(defun proclaimed-notinline-p (sym)
  (if (listp *nx-proclaimed-inline*)
    (and (setq sym (assq sym *nx-proclaimed-inline*))
         (null (%cdr sym)))
    (null (gethash sym *nx-proclaimed-inline* t))))



(defun self-evaluating-p (form)
;   (or (numberp form)
;       (characterp form)
;       (null form)
;       (eq form t)
;       (keywordp form)
;       (arrayp form) ; making the following redundant
;       ;(stringp form)
;       ;(bit-vector-p form)
;       )
  (and (atom form)
       (or (not (non-nil-symbol-p form))
           (eq form t)
           (keywordp form)))
  )

(defun constantp (form)
   (or (self-evaluating-p form)
       (quoted-form-p form)
       (constant-symbol-p form)))

(defun eval-constant (form)
  (if (quoted-form-p form) (%cadr form)
      (if (constant-symbol-p form) (symbol-value form)
          (if (self-evaluating-p form) form
              (report-bad-arg form '(satsifies constantp))))))

; SETQ'd above before we could DEFVAR.
(defvar *fred-special-indent-alist*)
; avoid hanging onto beezillions of pathnames
(defvar *last-back-translated-name* nil)
(defvar *lfun-names*)

(defvar %lambda-lists% (make-hash-table :test #'eq :weak t))
(defparameter *save-arglist-info* t)


(defun record-arglist (name args)
  "Used by defmacro & defgeneric"
  (when (or *save-arglist-info* *save-local-symbols*)
    (setf (gethash name %lambda-lists%) args)))


;Support the simple case of defsetf.
(%fhave 'store-setf-method
        (qlfun bootstrapping-store-setf-method (name fn &optional doc)
          (declare (ignore doc))
          (put name 'bootstrapping-setf-method (require-type fn 'symbol))))
(%fhave '%setf-method
        (qlfun bootstrapping-%setf-method (name)
          (get name 'bootstrapping-setf-method)))

(%fhave 'function-spec-p #'symbolp)     ; redefined later


;;; Lisp Development System/Application Module Loading

(defvar *lds* t
  "True to load all Lisp Development System modules")
(defvar *app-optional-modules* nil
  "Optional modules to load into application and keys to control contents")
(defvar *app-modules* nil
  "Custom modules to load into application")

#| *app-modules* keys:
:unbind-macros
:unintern-macros
:unbind-constants
:unintern-constants
:clear-vars
|#

; (lds <lds-form>)
; (lds <lds-form> <else-form> ...)
; (lds <lds-form> :module <module(s)>)
; (lds <lds-form> :module <module(s)> <else-form> ...)

(defmacro lds (form &rest base-forms &aux modules)
  (when (eq (first base-forms) :module)
    (setq modules (second base-forms)
          base-forms (cddr base-forms)))
  `(if ,(if (null modules)
          '*lds*
          `(or *lds* (,(if (listp modules) 'intersection 'memq)
                      ',modules *app-modules*)))
     ,form
     ,@(if base-forms `((progn ,@base-forms)))))

(defun lds-key-aux (test keys forms)
  `(,test (,(if (listp keys) 'intersection 'memq)
           ',keys *app-modules*)
          ,@forms))

(defmacro lds-key (keys &rest forms)
  (lds-key-aux 'when keys forms))

(defmacro lds-not-key (keys &rest forms)
  (lds-key-aux 'unless keys forms))

#| tests
(lds (print "included"))
(lds (print "included")
     (print "other") (print "another"))
(lds (print "included") :module :eval)
(lds (print "included") :module :eval
     (print "other") (print "another"))
(lds (print "included") :module (:eval :compiler))
(lds (print "included") :module (:eval :compiler)
     (print "other") (print "another"))

(setq *lds* nil)
(setq *lds* t)
(setq *app-modules* nil)
(setq *app-modules* '(:eval))
(setq *app-modules* '(:compiler))

(lds-key :uno (foo))
(lds-key :uno (foo)(bar))
(lds-key (:uno :dos) (foo))
(lds-key (:uno :dos) (foo) (bar))
(lds-not-key :uno (foo))
(lds-not-key :uno (foo) (bar))
(lds-not-key (:uno :dos) (foo))
(lds-not-key (:uno :dos) (foo) (bar))
|#


; defmacro uses (setf (assq ...) ...) for &body forms.
(defun adjoin-assq (indicator alist value)
  (let ((cell (assq indicator alist)))
    (if cell 
      (setf (cdr cell) value)
      (push (cons indicator value) alist)))
  alist)

(defmacro setf-assq (indicator place value)
  (let ((res (gensym)))
    `(let (,res)
       (setf ,place (adjoin-assq ,indicator ,place (setq ,res ,value)))
       ,res)))

(defsetf assq setf-assq)
(defsetf %typed-miscref %typed-miscset)

(defun quoted-form-p (form)
   (and (consp form)
        (eq (%car form) 'quote)
        (consp (%cdr form))
        (null (%cdr (%cdr form)))))

(defun lambda-expression-p (form)
  (and (consp form)
       (eq (%car form) 'lambda)
       (consp (%cdr form))
       (listp (%cadr form))))

;;;;;FUNCTION BINDING Functions

; A symbol's entrypoint contains:
;  1) something tagged as $t_lfun if the symbol is
;     not fbound as a macro or special form;
;  2) a cons, otherwise, where the cdr is a fixnum
;     whose value happens to be the same bit-pattern
;     as a "jsr_subprim $sp-apply-macro" instruction.
;     The car of this cons is either:
;     a) a function -> macro-function;
;     b) a symbol: special form not redefined as a macro.
;     c) a cons whose car is a function -> macro function defined
;        on a special form.


(defun macro-function (form &optional env)
  (setq form (require-type form 'symbol))
  (when env
    ; A definition-environment isn't a lexical environment, but it can
    ; be an ancestor of one.
    (unless (istruct-typep env 'lexical-environment)
        (report-bad-arg env 'lexical-environment))
      (let ((cell nil))
        (tagbody
          top
          (if (setq cell (%cdr (assq form (lexenv.functions env))))
            (return-from macro-function 
              (if (eq (car cell) 'macro) (%cdr cell))))
          (unless (listp (setq env (lexenv.parent-env env)))
            (go top)))))
      ; Not found in env, look in function cell.
  (%global-macro-function form))

(defun symbol-function (name)
  "Returns the definition of name, even if it is a macro or a special form.
   Errors if name doesn't have a definition."
  (or (fboundp name) ;Our fboundp returns the binding
      (prog1 (%err-disp $xfunbnd name))))

(%fhave 'fdefinition #'symbol-function)


(defun kernel-function-p (f)
  (declare (ignore f))
  nil)

(defun %make-function (name fn env)
  (let ((compile-it *compile-definitions*))
    (when (and compile-it (neq compile-it t))
      (setq compile-it (funcall compile-it env)))
    (if (not compile-it)
      ; bad things will probably occur if env contains unmunched function bindings
      ; but enclose says the behavior in that case is "undefined"
      (make-evaluated-function name fn env)
      (compile-user-function fn name env))))
    
;;;;;;;;; VALUE BINDING Functions

(defun gensym (&optional string-or-integer)
  "Behaves just like Common Lisp. Imagine that."
  (let ((prefix "G")
        (counter nil))
    (if (integerp string-or-integer)
      (setq counter string-or-integer) ; & emit-style-warning
      (if (stringp string-or-integer)
        (setq prefix (ensure-simple-string string-or-integer))
        (if string-or-integer ;not string or index or NIL
          (report-bad-arg string-or-integer '(or string integer (eql nil))))))
    (unless counter
      (setq *gensym-counter* (1+ (setq counter *gensym-counter*))))
    (make-symbol (%str-cat prefix (%integer-to-string counter)))))

(defun make-keyword (name)
  (if (and (symbolp name) (eq (symbol-package name) *keyword-package*))
    name
    (values (intern (string name) *keyword-package*))))




; destructive, removes first match only
(defun remove-from-alist (thing alist)
 (let ((start alist))
  (if (eq thing (%caar alist))
   (%cdr alist)
   (let* ((prev start)
          (this (%cdr prev))
          (next (%cdr this)))
    (while this
     (if (eq thing (%caar this))
      (progn
       (%rplacd prev next)
       (return-from remove-from-alist start))
      (setq prev this
            this next
            next (%cdr next))))
    start))))

;destructive
(defun add-to-alist (thing val alist &aux (pair (assq thing alist)))
  (if pair
    (progn (%rplacd pair thing) alist)
    (cons (cons thing val) alist)))

;non-destructive...
(defun alist-adjoin (thing val alist &aux (pair (assq thing alist)))
  (if (and pair (eq (%cdr pair) val))
    alist
    (cons (cons thing val) alist)))

(defun %str-assoc (str alist)
  (assoc str alist :test #'string-equal))

(defvar *pathname-escape-character* #\\
  "Not CL.  A Coral addition for compatibility between CL spec and the shell.")


(defun caar (x)
 (car (car x)))

(defun cadr (x)
 (car (cdr x)))

(defun cdar (x)
 (cdr (car x)))

(defun cddr (x)
 (cdr (cdr x)))

(defun caaar (x)
 (car (car (car x))))

(defun caadr (x)
 (car (car (cdr x))))

(defun cadar (x)
 (car (cdr (car x))))

(defun caddr (x)
 (car (cdr (cdr x))))

(defun cdaar (x)
 (cdr (car (car x))))

(defun cdadr (x)
 (cdr (car (cdr x))))

(defun cddar (x)
 (cdr (cdr (car x))))

(defun cdddr (x)
 (cdr (cdr (cdr x))))

(defun cadddr (x)
 (car (cdr (cdr (cdr x)))))

(%fhave 'type-of #'%type-of)









(defun pointerp (thing &optional errorp)
  (if (macptrp thing)
    t
    (if errorp (error "~S is not a pointer" thing) nil)))

(defun zone-pointerp (thing)
  (pointerp thing))

(defun handlep (p)
  (declare (ignore p))
  nil)

(defun %get-ostype (pointer &optional (offset 0))
  (values (make-keyword (%str-from-ptr (%inc-ptr pointer offset) 4))))


     
(defun %put-ostype (pointer str &optional (offset 0))
  (%put-ostype pointer str offset))     ; gets compiled inline

(defun %set-ostype (pointer offset &optional (str (prog1 offset
                                                   (setq offset 0))))
  (%put-ostype pointer str offset)
  str)

(defsetf %get-ostype %set-ostype)






(defun %ostype-ptr (str)
  (%stack-block ((type 4))
    (%put-ostype type str)
    (%get-ptr type)))

(defun ostype-p (x)
  (or (integerp x)
      (and (stringp x)
           (eql 4 (length x))
           (or (eq 'base-char (array-element-type x))
               (dotimes (i 4 t)
                 (unless (< (the fixnum (char-code (char x i))) 256)
                   (return nil)))))
      (and (symbolp x)
           (ostype-p (symbol-name x)))))





;Add an item to a dialog items list handle.  HUH ?
(defun %rsc-string (n)
  (or (cdr (assq n *error-format-strings*))
  (%str-cat "Error #" (%integer-to-string n))))

(defun string-arg (arg)
 (or (string-argp arg) (error "~S is not a string" arg)))

(defun string-argp (arg)
 (if (symbolp arg) (symbol-name arg)
   (if (stringp arg) (ensure-simple-string arg)
     nil)))

(defun symbol-arg (arg)
  (unless (symbolp arg)
    (report-bad-arg arg 'symbol))
  arg)




; start and end are character positions
; maxsize is a byte count.
(defun %put-string-segment-contents (p str start end &optional maxsize script)
  (declare (ignore script))
  (multiple-value-setq (str start end)(string-start-end str start end))
  (flet ((err () (error "String too big to fit in record")))
    (let ((size (- end start)))
      (if (and maxsize (%i> size maxsize))
        (err)
            (cond
             ((simple-base-string-p str)
              (%copy-ivector-to-ptr str start p 0 size)
              size)
             (t (let (;(table (get-char-byte-table script))
                  (j 0))
              (when (not maxsize)(setq  maxsize most-positive-fixnum))
              (dotimes (i size)                
                (let ((c (%scharcode str i)))                  
                  ;(cerror "b" "foo ~s ~s ~S" i j C)
                  (if (and #|table|# (%i> c #xff) #|(eq (svref table (%ilsr 8 c)) 1)|#)
                    (progn 
                      (when  (%i>= j (%i- maxsize 1))(err))
                      (%put-word p c j)
                      (setq j (%i+ j 2)))
                    (progn
                      (when (%i>= j maxsize)(err))
                      (%put-byte p c j)
                      (setq j (%i+ j 1))))))
              j)))))))

(defun %set-string (pointer offset &optional (string (prog1 offset (setq offset 0))))
  (%put-string pointer string offset)
  string)

(defun %put-cstring (ptr str &optional (offset 0))
  (do* ((len (length str))
	(i 0 (1+ i)))
       ((= i len) (setf (%get-byte ptr offset) 0))
    (setf (%get-byte ptr offset) (char-code (schar str i)))
    (incf offset)))

(defun %get-double-float (macptr &optional (offset 0) (res (%copy-float 0.0d0)))
  (unless (macptrp macptr)
    (setq macptr (require-type macptr 'macptr)))
  (unless (typep res 'double-float)
    (setq res (require-type res 'double-float)))
  (%copy-ptr-to-ivector macptr offset res (* 4 arch::double-float.value-cell) 8)
  res)



(defun %set-double-float (macptr offset &optional (value nil value-p))
  (unless value-p
    (setq value offset
          offset 0))
  (unless (macptrp macptr)
    (setq macptr (require-type macptr 'macptr)))
  (unless (typep value 'double-float)
    (setq value (require-type value 'double-float)))
  (%copy-ivector-to-ptr value (* 4 arch::double-float.value-cell) macptr offset 8)
  value)



(defun %put-double-float (macptr value &optional (offset 0))
  (%set-double-float macptr offset value))


  
(defun %get-single-float (macptr &optional (offset 0) (res (%make-sfloat)))
  (unless (macptrp macptr)
    (setq macptr (require-type macptr 'macptr)))
  (unless (fixnump offset)
    (setq offset (require-type offset 'fixnum)))
  (unless (typep res 'short-float)
    (setq res (require-type res 'short-float)))
  (locally (declare (fixnum offset)) 
    (with-macptrs ((single (%inc-ptr macptr offset)))
      (%ref-ieee-single-float single res))))



(defun %set-single-float (macptr offset &optional (value nil value-p))
  (unless value-p
    (setq value offset
          offset 0))
  (unless (macptrp macptr)
    (setq macptr (require-type macptr 'macptr)))
  (unless (fixnump offset)
    (setq offset (require-type offset 'fixnum)))
  (locally (declare (fixnum offset))
    (cond ((typep value 'short-float)
           (with-macptrs ((single (%inc-ptr macptr offset)))
             (%set-ieee-single-float value single)))
          ((typep value 'double-float)
           (with-macptrs ((single (%inc-ptr macptr offset)))
             (%set-ieee-single-float-from-double value single)))
          (t (return-from %set-single-float
               (%set-single-float
                macptr offset (require-type value 'short-float))))))
  value)



(defun %put-single-float (macptr value &optional (offset 0))
  (%set-single-float macptr offset value))


  
; Single float is sign, 8 bits of exponent, 23 bits of mantissa
; Double float is sign, 11 bits of exponent, 52 bits of mantissa
#|
(defun %single-float-ptr->double-float-ptr (single double)
  (let* ((hi (%get-word single))
         (low (%get-word single 2))
         (negative (logbitp 16 hi))
         (expt (logand #xff (the fixnum (ash hi -7))))
         (normalized-expt (- expt #x7f))
         (double-expt (+ normalized-expt #x3ff))
         (double-expt-with-sign
          (if negative 
            (the fixnum (+ (ash 1 11) double-expt))
            double-expt))
         (mantissa (+ low (the fixnum (logand hi #x7f))))
         (word0 (+ (the fixnum (ash double-expt-with-sign 4))
                   (the fixnum (ash mantissa -19))))
         (word1 (logand (the fixnum (ash mantissa -3)) #xffff))
         (word2 (ash (the fixnum (logand mantissa 7)) 13)))
    (declare (fixnum hi low expt normalized-expt double-expt
                     double-expt-with-sign mantissa word0 word1 word2))
    (setf (%get-word double) word0
          (%get-word double 2) word1
          (%get-word double 4) word2
          (%get-word double 6) 0)
    double))
|#

; Copy a single float pointed at by the macptr in single
; to a double float pointed at by the macptr in double
#+ppc-target
(defppclapfunction %single-float-ptr->double-float-ptr ((single arg_y) (double arg_z))
  (check-nargs 2)
  (lwz imm0 arch::macptr.address single)
  (lfs fp0 0 imm0)
  (lwz imm0 arch::macptr.address double)
  (stfd fp0 0 imm0)
  (blr))

#+sparc-target
(defsparclapfunction %single-float-ptr->double-float-ptr ((single %arg_y) (double %arg_z))
  (check-nargs 2)
  (ld (single arch::macptr.address) %imm0)
  (ldf (%imm0) %f2)
  (fstod %f2 %f4)
  (ld (double arch::macptr.address) %imm0)
  (retl)
    (stdf %f4 (%imm0)))


; Copy a double float pointed at by the macptr in double
; to a single float pointed at by the macptr in single.
#+ppc-target
(defppclapfunction %double-float-ptr->single-float-ptr ((double arg_y) (single arg_z))
  (check-nargs 2)
  (lwz imm0 arch::macptr.address double)
  (lfd fp0 0 imm0)
  (lwz imm0 arch::macptr.address single)
  (stfs fp0 0 imm0)
  (blr))

#+sparc-target
(defsparclapfunction %double-float-ptr->single-float-ptr ((double %arg_y) (single %arg_z))
  (check-nargs 2)
  (ld (double arch::macptr.address) %imm0)
  (lddf (%imm0) %f4)
  (fdtos %f4 %f2)
  (fcmpd %f2 %fp-zero)			; for exception
  (ld (double arch::macptr.address) %imm0)
  (retl)
   (stf %f2 (%imm0)))


; Copy an IEEE-single (aka "short") float from a macptr to a lisp short float
#+ppc-target
(defppclapfunction %ref-ieee-single-float ((macptr arg_y) (dest arg_z))
  (check-nargs 2)
  (lwz imm0 arch::macptr.address macptr)
  (lfs fp1 0 imm0)
  (put-single-float fp1 dest)
  (blr))

#+sparc-target
(defsparclapfunction %ref-ieee-single-float ((macptr %arg_y) (dest %arg_z))
  (check-nargs 2)
  (ld (macptr arch::macptr.address) %imm0)
  (ldf (%imm0) %f2)
  (retl)
   (put-single-float %f2 dest))

#+ppc-target
(defppclapfunction %set-ieee-single-float ((src arg_y) (macptr arg_z))
  (check-nargs 2)
  (lwz imm0 arch::macptr.address macptr)
  (get-single-float fp1 src)
  (stfs fp1 0 imm0)
  (blr))

#+sparc-target
(defsparclapfunction %set-ieee-single-float ((src %arg_y) (macptr %arg_z))
  (check-nargs 2)
  (ld (macptr arch::macptr.address) %imm0)
  (get-single-float src %f2)
  (retl)
    (stf %f2 (%imm0)))

#+ppc-target
(defppclapfunction %set-ieee-single-float-from-double ((src arg_y) (macptr arg_z))
  (check-nargs 2)
  (lwz imm0 arch::macptr.address macptr)
  (get-double-float fp1 src)
  (stfs fp1 0 imm0)
  (blr))

#+sparc-target
(defsparclapfunction %set-ieee-single-float-from-double ((src %arg_y) (macptr %arg_z))
  (check-nargs 2)
  (ld (macptr arch::macptr.address) %imm0)
  (get-double-float src %f4)
  (fdtos %f4 %f2)
  (fcmps %f2 %fp-zero)
  (retl)
    (stf %f2 (%imm0)))



;Returns a simple string and adjusted start and end, such that
; 0<= start <= end <= (length simple-string).
(defun get-sstring (str &optional (start 0) (end (length (require-type str 'string))))
  (multiple-value-bind (sstr offset) (array-data-and-offset (string str))
    (setq start (+ start offset) end (+ end offset))
    (when (< (length sstr) end)(setq end (length sstr)))
    (when (< end start) (setq start end))
    (values sstr start end)))

;e.g. (bad-named-arg :key key 'function)
(defun bad-named-arg (name arg &optional (type nil type-p))
  (if type-p
    (%err-disp $err-bad-named-arg-2 name arg type)
    (%err-disp $err-bad-named-arg name arg)))

(defun verify-arg-count (call min &optional max)
  "If call contains less than MIN number of args, or more than MAX
   number of args, error. Otherwise, return call.
   If Max is NIL, the maximum args for the fn are infinity."
 (or (verify-call-count (car call) (%cdr call) min max) call))

(defun verify-call-count (sym args min &optional max &aux argcount)
  (if (%i< (setq argcount  (list-length args)) min)
    (%err-disp $xtoofew (cons sym args))
    (if (if max (%i> argcount max))
      (%err-disp $xtoomany (cons sym args)))))

(defun getf (place key &optional (default ()))
  (let ((p (pl-search place key))) (if p (%cadr p) default)))

(defun remprop (symbol key)
  (do* ((prev nil plist)
        (plist (symbol-plist symbol) tail)
        (tail (cddr plist) (cddr tail)))
       ((null plist))
    (when (eq (car plist) key)
      (if prev
        (rplacd (cdr prev) tail)
        (setf (symbol-plist symbol) tail))
      (return t))))



; If this returns non-nil, safe to do %rplaca of %cdr to update.
(defun pl-search (plist key)
  (unless (plistp plist)
    (report-bad-arg plist '(satisfies plistp)))
  (%pl-search plist key))




(defun point-string (point)
  (%str-cat "#@("
            (%integer-to-string (point-h point))
            " "
            (%integer-to-string (point-v point))
            ")"))


(defun position (item sequence &rest ignored-keys)
  (declare (ignore ignored-keys)
           (dynamic-extent ignored-keys))
  (xposition item sequence))

(defun xposition (item sequence)
  (if (listp sequence)
    (do* ((list sequence (%cdr list))
          (count 0 (1+ count)))
         ((endp list) nil)
      (when (eql (car list) item) (return count)))
    (dotimes (i (length sequence))
      (declare (fixnum i))
      (when (eql (aref sequence i) item) (return i)))))

(defun position-positional-test-key (item sequence test key)
  (declare (ignore test key))
  (xposition item sequence))

(defun delete (item list &rest ignored-keys)
  (declare (ignore ignored-keys)
           (dynamic-extent ignored-keys)
           (inline delete))
  (if list
      (if (eq item (car list))
          (delete item (%cdr list))
          (%rplacd list (delete item (%cdr list))))))

(defun rassoc (item alist &key (test #'eql test-p) test-not (key #'identity))
  (declare (list alist))
  "Returns the cons in alist whose cdr is equal (by a given test or EQL) to
   the Item."
  (if (or test-p (not test-not))
    (progn
      (if test-not (error "Cannot specify both :TEST and :TEST-NOT."))
      (dolist (pair alist)
        (if (atom pair)
          (if pair (error "Invalid alist containing ~S: ~S" pair alist))
          (when (funcall test item (funcall key (cdr pair))) (return pair)))))
    (progn
      (unless test-not (error "Must specify at least one of :TEST or :TEST-NOT"))
      (dolist (pair alist)
        (if (atom pair)
          (if pair (error "Invalid alist containing ~S: ~S" pair alist))
          (unless (funcall test-not item (funcall key (cdr pair))) (return pair)))))))

(defun *%saved-method-var%* ()
  (declare (special %saved-method-var%))
  %saved-method-var%)

(defun set-*%saved-method-var%* (new-value)
  (declare (special %saved-method-var%))
  (setq %saved-method-var% new-value))

(defsetf *%saved-method-var%* set-*%saved-method-var%*)

(defun beep (&optional (times 1) idlecount)
  (dotimes (i times) (declare (fixnum i)) (princ #.(string #\bell)))
  (when idlecount (dotimes (i idlecount) (declare (fixnum i)))))



(defun true (&rest p) (declare (ignore p)) t)
(defun false (&rest p) (declare (ignore p)) nil)

(setf (symbol-function 'clear-type-cache) #'false)      ; bootstrapping

(defun make-array-1 (dims element-type element-type-p
                          displaced-to
                          displaced-index-offset
                          adjustable
                          fill-pointer
                          initial-element initial-element-p
                          initial-contents initial-contents-p
                          size)
  (let ((subtype (element-type-subtype element-type)))
    (when (and element-type (null subtype))
      (error "Unknown element-type ~S" element-type))
    (when (null size)
      (cond ((listp dims)
             (setq size 1)
             (dolist (dim dims)
               (when (< dim 0)
                 (report-bad-arg dim '(integer 0 *)))
               (setq size (* size dim))))
            (t (setq size dims)))) ; no need to check vs. array-dimension-limit
    (cond
     (displaced-to
      (when (or initial-element-p initial-contents-p)
        (error "Cannot specify initial values for displaced arrays"))
      (when (and element-type-p
                 (neq (array-element-subtype displaced-to) subtype))
        (error "The ~S array ~S is not of ~S ~S"
               :displaced-to displaced-to :element-type element-type))
      (%make-displaced-array dims displaced-to
                             fill-pointer adjustable displaced-index-offset))
     (t
      (when displaced-index-offset
        (error "Cannot specify ~S for non-displaced-array" :displaced-index-offset))
      (when (null subtype)
        (error "Cannot make an array of empty type ~S" element-type))
      (make-uarray-1 subtype dims adjustable fill-pointer 
                     initial-element initial-element-p
                     initial-contents initial-contents-p
                     nil size)))))

(defun make-uarray-1 (subtype dims adjustable fill-pointer
                              initial-element initial-element-p
                              initial-contents initial-contents-p
                              temporary 
                              size)
  (when (null size)(setq size (if (listp dims)(apply #'* dims) dims)))
  (let ((vector (if temporary
                  (%make-temp-uvector size subtype)
		  (%alloc-misc size subtype))))  ; may not get here in that case
    (if initial-element-p
      (dotimes (i (uvsize vector)) (declare (fixnum i))(uvset vector i initial-element))
      (if initial-contents-p
        (if (null dims) (uvset vector 0 initial-contents)
            (init-uvector-contents vector 0 dims initial-contents))))
    (if (and (null fill-pointer)
             (not adjustable)
             dims
             (or (atom dims) (null (%cdr dims))))
      vector
      (let ((array (%make-displaced-array dims vector 
                                          fill-pointer adjustable nil)))
        (when (and (null fill-pointer) (not adjustable))
          (%set-simple-array-p array))
        array))))

(defun init-uvector-contents (vect offset dims contents
                              &aux (len (length contents)))
  "Returns final offset. Assumes dims not ()."
  (unless (eq len (if (atom dims) dims (%car dims)))
    (error "~S doesn't match array dimensions of ~S ."  contents vect))
  (cond ((or (atom dims) (null (%cdr dims)))
         (if (listp contents)
           (let ((contents-tail contents))
             (dotimes (i len)
               (declare (fixnum i))
               (uvset vect offset (pop contents-tail))
               (setq offset (%i+ offset 1))))
           (dotimes (i len)
             (declare (fixnum i))
             (uvset vect offset (elt contents i))
             (setq offset (%i+ offset 1)))))
        (t (setq dims (%cdr dims))
           (if (listp contents)
             (let ((contents-tail contents))
               (dotimes (i len)
                 (declare (fixnum i))
                 (setq offset
                       (init-uvector-contents vect offset dims (pop contents-tail)))))
             (dotimes (i len)
               (declare (fixnum i))
               (setq offset
                     (init-uvector-contents vect offset dims (elt contents i)))))))
  offset)

(defun %get-signed-long-long (ptr &optional (offset 0))
  (%%get-signed-longlong ptr offset))

(defun %set-signed-long-long (ptr arg1
				  &optional
				  (arg2 (prog1 arg1 (setq arg1 0))))
  (%%set-signed-longlong ptr arg1 arg2))
				  
(defun %get-unsigned-long-long (ptr &optional (offset 0))
  (%%get-unsigned-longlong ptr offset))

(defun %set-unsigned-long-long (ptr arg1
				  &optional
				  (arg2 (prog1 arg1 (setq arg1 0))))
  (%%set-unsigned-longlong ptr arg1 arg2))
				  

;end of L1-utils.lisp

