;;;-*-Mode: LISP; Package: CCL -*-
;;;
;;;   Copyright (C) 1994-2001 Digitool, Inc
;;;   This file is part of Opensourced MCL.
;;;
;;;   Opensourced MCL is free software; you can redistribute it and/or
;;;   modify it under the terms of the GNU Lesser General Public
;;;   License as published by the Free Software Foundation; either
;;;   version 2.1 of the License, or (at your option) any later version.
;;;
;;;   Opensourced MCL is distributed in the hope that it will be useful,
;;;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;;   Lesser General Public License for more details.
;;;
;;;   You should have received a copy of the GNU Lesser General Public
;;;   License along with this library; if not, write to the Free Software
;;;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;;;


; l1-boot-lds.lisp

(in-package :ccl)





(defun command-line-arguments ()
  *command-line-argument-list*)

(defun startup-ccl (&optional init-file)
  (with-simple-restart (abort "Abort startup.")
    (when init-file
      (with-simple-restart (continue "Skip loading init file.")
	(load init-file :if-does-not-exist nil :verbose nil)))
    (flet ((eval-string (s)
	     (with-simple-restart (continue "Skip evaluation of ~a" s)
	       (eval (read-from-string s))))
	   (load-file (name)
	     (with-simple-restart (continue "Skip loading ~s" name)
	       (load name))))
      (dolist (p *lisp-startup-parameters*)
	(case (car p)
	  (:eval (eval-string (cdr p)))
	  (:load (load (cdr p))))))))

(defparameter *listener-process-stackseg-size* (ash 1 17))

(defun make-mcl-listener-process ()
  (let ((p (make-process *main-listener-process-name* :background-p t
                         :stack-size (truncate (* 4/3 *listener-process-stackseg-size*))
                         :vstack-size *listener-process-stackseg-size*
                         :tstack-size (ceiling *listener-process-stackseg-size* 3))))
                         
    (process-preset p #'(lambda ()
                          (let ((*listener-p* t))
                            (unless *inhibit-greeting* 
                              (format t "~&Welcome to ~A ~A!~%"
                                      (lisp-implementation-type)
                                      (lisp-implementation-version)))
                            (toplevel-loop))))
    (process-enable p)
    p))


; End of l1-boot-lds.lisp
