;;;-*- Mode: Lisp; Package: CCL -*-
;;;
;;;   Copyright (C) 1994-2001 Digitool, Inc
;;;   This file is part of Opensourced MCL.
;;;
;;;   Opensourced MCL is free software; you can redistribute it and/or
;;;   modify it under the terms of the GNU Lesser General Public
;;;   License as published by the Free Software Foundation; either
;;;   version 2.1 of the License, or (at your option) any later version.
;;;
;;;   Opensourced MCL is distributed in the hope that it will be useful,
;;;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;;   Lesser General Public License for more details.
;;;
;;;   You should have received a copy of the GNU Lesser General Public
;;;   License along with this library; if not, write to the Free Software
;;;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;;;

#+allow-in-package
(in-package "CCL")

(eval-when (:compile-toplevel :execute)
  (require "NUMBER-MACROS")
  (require :number-case-macro) 
  

; see "Optimizing PowerPC Code" p. 156
; Note that the constant #x4330000080000000 is now in fp-s32conv
  (defppclapmacro int-to-freg (int freg imm)
    `(let ((temp 8)
           (temp.h 8)
           (temp.l 12))
      (stwu tsp -16 tsp)
      (stw tsp 4 tsp)
      (stfd ppc::fp-s32conv temp tsp)
      (unbox-fixnum ,imm ,int)
      (xoris ,imm ,imm #x8000)       ; invert sign of unboxed fixnum
      (stw ,imm temp.l tsp)
      (lfd ,freg temp tsp)
      (lwz tsp 0 tsp)
      (fsub ,freg ,freg ppc::fp-s32conv)))
 

  (defppclapmacro 48x32-divide (x-hi16 x-lo y freg temp-freg freg2 immx)
    `(let ((temp 16)
           (temp.h 16)
           (temp.l 20)
           (zero 8)
           (zero.h 8)
           (zero.l 12))
      (stwu tsp -24 tsp)
      (stw tsp 4 tsp)
      (lwi ,immx #x43300000)  ; 1075 = 1022+53 
      (stw ,immx zero.h tsp)
      (stw rzero zero.l tsp)
      (lfd ,temp-freg zero tsp)
      (rlwimi ,immx ,x-hi16 0 16 31)           
      (stw ,immx temp.h tsp)
      (stw ,x-lo temp.l tsp)
      (lfd ,freg temp tsp)
      
      (fsub ,freg ,freg ,temp-freg)
      (lwi ,immx #x43300000)
      (stw ,immx temp.h tsp)
      (stw ,y temp.l tsp)
      (lfd ,freg2 temp tsp)
      (lwz tsp 0 tsp)
      (fsub ,freg2 ,freg2 ,temp-freg)
      (fdiv ,freg ,freg ,freg2)
      ))
   
)





; get xidx thing from x, yidx thing from y
; if same return #xffff #xffff
; otherwise get another thing from x and 1- xidx and do as %floor of xthing otherx ything
(defppclapfunction %floor-99 ((x-stk 0)(xidx arg_x)(yptr arg_y)(yidx arg_z))
  (let ((xptr temp0)
        (a imm1)
        (b imm2)
        (y imm3)
        (quo imm0)) 
    (vpop xptr)
    (la imm4 arch::misc-data-offset XIDX)
    (lwzx a xptr imm4)
    (la imm4 arch::misc-data-offset YIDX)
    (lwzx y yptr imm4)
    (cmpw a y)
    (bne @more)
    (li imm4 #xffff)
    (rlwinm imm4 imm4 arch::fixnumshift (- 16 arch::fixnumshift) (- 31 arch::fixnum-shift))
    (vpush imm4)
    (vpush imm4)
    (la temp0 8 vsp)
    (set-nargs 2)
    (ba .spvalues)
    @MORE
    ;  a has 16 bits from ahi, bhi gets alo blo gets bhi
    (la imm4 (- arch::misc-data-offset 4) xidx)
    (lwzx b xptr imm4)
    (rlwinm b b 16 16 31)  ; bhi to blo 
    (rlwimi b a 16 0 15)   ; alo to bhi
    (rlwinm a a 16 16 31)  ; a gets alo 
    (48x32-divide a b y fp0 fp1 fp2 imm4)
    (fctiwz fp0 fp0)
    (stwu tsp -32 tsp)
    (stw tsp 4 tsp)
    (stfd fp0 24 tsp)
    (lwz quo (+ 24 4) tsp) ; 16 quo bits above stuff used by 48x32
    ; now mul quo by y
    (mullw imm4 y quo)
    ; and subtract from a,b
    (subfc b imm4 b)
    ; AND AGAIN
    (rlwinm a b -16 16 31) ; a gets b hi
    (rlwinm b b 16 0 15)   ; b lo to b hi
    (la imm4 (- arch::misc-data-offset 4) xidx) 
    (lwzx imm4 imm4 xptr)
    (rlwimi b imm4 0 16 31)
    (48x32-divide a b y fp0 fp1 fp2 imm4)
    (fctiwz fp0 fp0)
    (stfd fp0 16 tsp)  ; quo lo
    (lwz quo (+ 24 4) tsp) ; quo-hi
    (box-fixnum temp0 quo)
    (vpush temp0)
    (lwz quo (+ 16 4) tsp) ; quo lo
    (lwz tsp 0 tsp)
    (box-fixnum temp0 quo)
    (vpush temp0)    
    (la temp0 8 vsp)
    (set-nargs 2)
    (ba .SPvalues)))
    
    
    

; for truncate-by-fixnum etal
; doesnt store quotient - just returns rem in 2 halves
(defppclapfunction %floor-loop-no-quo ((q arg_x)(yhi arg_y)(ylo arg_z))
  (let ((a imm1)
        (b imm2)
        (y imm3)
        (quo imm0)
        (qidx temp0)
        (qlen temp1))
    (lwz imm4 (- arch::fulltag-misc) q)
    (header-length qlen imm4)
    (subi qidx qlen 4)
    (mr b rzero)
    (compose-digit y yhi ylo)
    @loop
    (rlwinm a b -16 16 31)
    (rlwinm b b 16 0 15)
    (la imm4 arch::misc-data-offset q)
    (lwzx imm4 qidx imm4) ; q contents
    (rlwimi b imm4 16 16 31) ; hi 16 to lo b
    ;(dbg)         
    (48x32-divide a b y fp0 fp1 fp2 imm4)
    (fctiwz fp0 fp0)
    (stwu tsp -32 tsp)
    (stw tsp 4 tsp)
    (stfd fp0 24 tsp)
    (lwz quo (+ 24 4) tsp) ; 16 quo bits above stuff used by 48x32
    ; now mul quo by y
    (mullw imm4 y quo)
    ; and subtract from a,b
    (subfc b imm4 b)
    ; new a and b are low 2 digits of this (b) and last digit in array
    ; and do it again on low 3 digits
    ;(dbg)
    (rlwinm a b -16 16 31)
    (rlwinm b b 16 0 15)
    (la imm4 arch::misc-data-offset q)
    (lwzx imm4 qidx imm4)
    (rlwimi b imm4 0 16 31)
    (48x32-divide a b y fp0 fp1 fp2 imm4)
    (fctiwz fp0 fp0)
    (stfd fp0 16 tsp)  ; quo lo
    (subi qidx qidx 4)
    (cmpwi :cr1 qidx 0)
    (lwz quo (+ 16 4) tsp)
    (lwz tsp 0 tsp)
    (mullw imm4 y quo)
    (subfc b imm4 b)  ; b is remainder
    (bge :cr1 @loop)
    (digit-h temp0 b)
    (vpush temp0)
    (digit-l temp0 b)
    (vpush temp0)
    (la temp0 8 vsp)
    (set-nargs 2)
    (ba .SPvalues)))

; store result in dest, return rem in 2 halves
(defppclapfunction %floor-loop-quo ((q-stk 0)(dest arg_x)(yhi arg_y)(ylo arg_z))
  (let ((a imm1)
        (b imm2)
        (y imm3)
        (quo imm0)
        (qidx temp0)
        (qlen temp1)
        (q temp2))
    (vpop q)
    (lwz imm4 (- arch::fulltag-misc) q)
    (header-length qlen imm4)
    (subi qidx qlen 4)
    (mr b rzero)
    (compose-digit y yhi ylo)
    @loop
    (rlwinm a b -16 16 31)
    (rlwinm b b 16 0 15)
    (la imm4 arch::misc-data-offset q)
    (lwzx imm4 qidx imm4) ; q contents
    (rlwimi b imm4 16 16 31) ; hi 16 to lo b        
    (48x32-divide a b y fp0 fp1 fp2 imm4)
    (fctiwz fp0 fp0)
    (stwu tsp -32 tsp)
    (stw tsp 4 tsp)
    (stfd fp0 24 tsp)
    (lwz quo (+ 24 4) tsp) ; 16 quo bits above stuff used by 48x32
    ; now mul quo by y
    (mullw imm4 y quo)
    ; and subtract from a,b
    (subfc b imm4 b)
    ; new a and b are low 2 digits of this (b) and last digit in array
    ; and do it again on low 3 digits
    ;(dbg)
    (rlwinm a b -16 16 31)
    (rlwinm b b 16 0 15)
    (la imm4 arch::misc-data-offset q)
    (lwzx imm4 qidx imm4)
    (rlwimi b imm4 0 16 31)
    (48x32-divide a b y fp0 fp1 fp2 imm4)
    (fctiwz fp0 fp0)
    (stfd fp0 16 tsp)  ; quo lo
    (lwz quo (+ 16 4) tsp)
    (mullw imm4 y quo)
    (subfc b imm4 b)  ; b is remainder    
    (lwz quo (+ 24 4) tsp) ; quo-hi
    (rlwinm quo quo 16 0 15)
    (lwz imm4 (+ 16 4) tsp) ; quo lo
    (lwz tsp 0 tsp)
    (rlwimi quo imm4 0 16 31)    
    (la imm4 arch::misc-data-offset dest)
    (stwx quo qidx imm4)
    (subic. qidx qidx 4)
    (bge @loop)
    (digit-h temp0 b)
    (vpush temp0)
    (digit-l temp0 b)
    (vpush temp0)
    (la temp0 8 vsp)
    (set-nargs 2)
    (ba .SPvalues)))




; make a float from hi - high 24 bits mantissa (ignore implied higher bit)
;                   lo -  low 28 bits mantissa
;                   exp  - take low 11 bits
;                   sign - sign(sign) => result
; hi result - 1 bit sign: 11 bits exp: 20 hi bits of hi arg
; lo result - 4 lo bits of hi arg: 28 lo bits of lo arg
; no error checks, no tweaks, no nuthin 

(defppclapfunction %make-float-from-fixnums ((float 4)(hi 0) (lo arg_x) (exp arg_y) (sign arg_z))
  (rlwinm imm0 sign 0 0 0)  ; just leave sign bit 
  (rlwimi imm0 exp (- 20 arch::fixnumshift)  1 11) ;  exp left 20 right 2 keep 11 bits
  (lwz imm1 hi vsp)
  (srawi imm1 imm1 arch::fixnumshift)   ; fold into below? nah keep for later
  (rlwimi imm0 imm1 (- 32 4) 12 31)   ; right 4 - keep  20 - stuff into hi result
  (rlwinm imm1 imm1 28 0 3)  ; hi goes left 28 - keep 4 hi bits
  (rlwimi imm1 lo (- 32 arch::fixnumshift) 4 31) ; stuff in 28 bits of lo
  (lwz temp0 float vsp)         ; the float
  (stw imm0 arch::double-float.value temp0)
  (stw imm1 arch::double-float.val-low temp0)
  (la vsp 8 vsp)
  (blr))

(defppclapfunction %make-short-float-from-fixnums ((float 0) (sig arg_x) (exp arg_y) (sign arg_z))
  (unbox-fixnum imm0 sig)
  (rlwimi imm0 exp (- 29 8) 1 8)
  (inslwi imm0 sign 1 0)
  (vpop arg_z)
  (stw imm0 arch::single-float.value arg_z)
  (blr))



; t/nil - could as well be 1/0
(defppclapfunction %double-float-sign ((n arg_z))
  (lwz imm1 arch::double-float.value n)
  (rlwinm. imm1 imm1 0 0 0)  ; or or.
  (setpred arg_z :cr0 :lt) 
  (blr))

(defppclapfunction %short-float-sign ((n arg_z))
  (lwz imm1 arch::single-float.value n)
  (rlwinm. imm1 imm1 0 0 0)  ; or or.
  (setpred arg_z :cr0 :lt) 
  (blr))
 

; also in ppc-numbers using fpu - don't know which is better
; Well, this was wrong ..
; this does not (obviously) set anything in fpscr, wheras doing fcmpo with 0.0 will
; set fex & invalid-operation if n is a NAN
(defppclapfunction %double-float-zerop ((n arg_z))
  (lwz imm1 arch::double-float.value n)
  (clrlwi imm1 imm1 1)  ; nuke sign
  (lwz imm0 arch::double-float.val-low n)
  (or imm1 imm1 imm0 )
  (eq0->boolean arg_z imm1 imm0)
  (blr))

(defppclapfunction %short-float-zerop ((n arg_z))
  (lwz imm1 arch::single-float.value n)
  (clrlwi imm1 imm1 1)
  (eq0->boolean arg_z imm1 imm0)
  (blr))
    

; this is also wrong - it doesn't check for invalid-operation
; same is true for double-float-negate
(defppclapfunction %%double-float-abs ((n arg_y)(val arg_z))
  (get-double-float fp1 n)
  (fabs fp1 fp1)
  (put-double-float fp1 val)
  (blr))

; Likewise.
(defppclapfunction %%short-float-abs ((n arg_y) (val arg_z))
  (get-single-float fp1 n)
  (fabs fp0 fp1)
  (put-single-float fp0 val)
  (blr))



; rets hi (25 bits) lo (28 bits) exp sign
(defppclapfunction %integer-decode-double-float ((n arg_z))
  (lwz imm0  arch::double-float.value n)
  (rlwinm imm1 imm0 (+ 1 arch::fixnumshift) (- 32 arch::fixnumshift 1) ; sign boxed
          				   (- 32 arch::fixnumshift 1))
  (add imm1 imm1 imm1)  ; imm1 = (fixnum 2) (neg) or 0 (pos)
  (subfic temp0 imm1 '1)  ; sign boxed
  (rlwinm. imm2 imm0 (- 32 20)  21  31)   ; right 20, keep 11 bits exp - test for 0
  ;(subi imm2 imm2 (+ 53 1022))            ; unbias and scale
  (slwi imm2 imm2 arch::fixnumshift)      ; box
  (mr temp1 imm2)                        ; boxed unbiased exponent
  (rlwinm imm0 imm0 12  0 19)            ; 20 bits of hi float left 12
  (beq @denorm)                          ; cr set way back
  (addi imm0 imm0 1)                     ;  add implied 1
  @denorm
  (rlwinm imm0 imm0 (+ (- 32 12) 4 arch::fixnumshift) 0 31)
  (lwz imm1 arch::double-float.val-low n) ; 
  (rlwimi imm0 imm1 (+ 4 arch::fixnumshift)
                    (1+ (- 31 4 arch::fixnumshift))
                    (- 31 arch::fixnumshift))  ; high 4 bits in fixnum pos
  (rlwinm imm1 imm1 (- 4 arch::fixnumshift) 
                    (- 4 arch::fixnumshift)
                    (- 31 arch::fixnum-shift)) ; 28 bits  thats 2 2 29
  (vpush imm0)   ; hi 25 bits of mantissa (includes implied 1)
  (vpush imm1)   ; lo 28 bits of mantissa
  (vpush temp1)  ; exp
  (vpush temp0)  ; sign
  (set-nargs 4)
  (la temp0 16 vsp)
  (ba .SPvalues))


; hi is 25 bits lo is 28 bits
; big is 32 lo, 21 hi right justified
(defppclapfunction make-big-53 ((hi arg_x)(lo arg_y)(big arg_z))
  (rlwinm imm0 lo (- 32 arch::fixnumshift) 4 31)
  (rlwimi imm0 hi (- 32 4 arch::fixnumshift) 0 3)
  (stw imm0 (+ arch::misc-data-offset 0) big)   ; low goes in 1st wd
  (rlwinm imm0 hi (- 32 (+ arch::fixnumshift 4)) 11 31)  ; high in second
  (stw imm0 (+ arch::misc-data-offset 4) big)
  (blr))





(defppclapfunction dfloat-significand-zeros ((dfloat arg_z))
  (lwz imm1 arch::double-float.value dfloat)
  (rlwinm. imm1 imm1 12 0 19)
  (cntlzw imm1 imm1)
  (beq @golo)
  (box-fixnum arg_z imm1)
  (blr)
  @golo
  (lwz imm1 arch::double-float.val-low dfloat)
  (cntlzw imm1 imm1)
  (addi imm1 imm1 20)
  (box-fixnum arg_z imm1)
  (blr))

(defppclapfunction sfloat-significand-zeros ((sfloat arg_z))
  (lwz imm1 arch::single-float.value sfloat)
  (rlwinm imm1 imm1 9 0 22)
  (cntlzw imm1 imm1)
  (box-fixnum arg_z imm1)
  (blr))




(defppclapfunction %%scale-dfloat ((float arg_x)(int arg_y)(result arg_z))
  (let ((fl.h 8)
        (fl.l 12)
        (sc.h 16)
        (sc.l 20))
    (clear-fpu-exceptions)
    (lwz imm0 arch::double-float.value float)
    (lwz imm1 arch::double-float.val-low float)
    (stwu tsp -16 tsp)
    (stw tsp 4 tsp)
    (stw imm0 fl.h tsp)
    (stw imm1 fl.l tsp)
    (unbox-fixnum imm0 int)
    ;(addi imm0 imm0 1022)  ; bias exponent - we assume no ovf
    (slwi imm0 imm0 20)     ; more important - get it in right place
    (stw imm0 sc.h tsp)
    (stw rzero sc.l tsp)
    (lfd fp0 fl.h tsp)
    (lfd fp1 sc.h tsp)
    (lwz tsp 0 tsp)
    (fmul. fp2 fp0 fp1)
    (fp-check-binop-exception fp2 fp0 fp1)
    (stfd fp2 arch::double-float.value result)
    (blr)))

(defppclapfunction %%scale-sfloat ((float arg_x)(int arg_y)(result arg_z))
  (let ((sc.h 12))
    (clear-fpu-exceptions)
    (lfs fp0 arch::single-float.value float)
    (unbox-fixnum imm0 int)
    (slwi imm0 imm0 IEEE-single-float-mantissa-width)
    (stwu tsp -16 tsp)
    (stw tsp 4 tsp)
    (stw imm0 sc.h tsp)
    (lfs fp1 sc.h tsp)
    (lwz tsp 0 tsp)
    (fmuls. fp2 fp0 fp1)
    (fp-check-binop-exception fp2 fp0 fp1)
    (stfs fp2 arch::single-float.value result)
    (blr)))
                   




(defppclapfunction %copy-double-float ((f1 arg_y) (f2 arg_z))
  (lfd fp0 arch::double-float.value f1)
  (stfd fp0 arch::double-float.value f2)
  (blr))
                   

(defppclapfunction %copy-short-float ((f1 arg_y) (f2 arg_z))
  (lfs fp0 arch::single-float.value f1)
  (stfs fp0 arch::single-float.value f2)
  (blr))

(defppclapfunction %double-float-exp ((n arg_z))
  (lwz imm1 arch::double-float.value n)
  (rlwinm arg_z imm1 (- 32 (- 20 arch::fixnumshift)) 19  29) ; right 20 left 2 = right 18 = left 14
  (blr))

(defppclapfunction set-%double-float-exp ((float arg_y) (exp arg_z))
  (lwz imm1 arch::double-float.value float)
  (rlwimi imm1 exp (- 20 arch::fixnumshift) 1 11)
  (stw imm1 arch::double-float.value float) ; hdr - tag = 8 - 2
  (blr))


(defppclapfunction %short-float-exp ((n arg_z))
  (lwz imm1 arch::single-float.value n)
  (rlwinm arg_z imm1 (- 32 (- 23 arch::fixnumshift)) 22 29)
  (blr))

(defppclapfunction set-%short-float-exp ((float arg_y) (exp arg_z))
  (lwz imm1 arch::single-float.value float)
  (rlwimi imm1 exp (- 23 arch::fixnumshift) 1 8)
  (stw imm1 arch::single-float.value float)
  (blr))

  
(defppclapfunction %short-float->double-float ((src arg_y) (result arg_z))
  (get-single-float fp0 src)
  (put-double-float fp0 result)
  (blr))

(defppclapfunction %double-float->short-float ((src arg_y) (result arg_z))
  (clear-fpu-exceptions)
  (get-double-float fp0 src)
  (frsp. fp1 fp0)
  (fp-check-unaryop-exception fp1 fp0 fp0)
  (put-single-float fp1 result)
  (blr))
  



(defppclapfunction %int-to-sfloat ((int arg_y) (sfloat arg_z))
  (int-to-freg int fp0 imm0)
  (stfs fp0 arch::single-float.value sfloat)
  (blr))

(defppclapfunction %int-to-dfloat ((int arg_y) (dfloat arg_z))
  (int-to-freg int fp0 imm0)
  (stfd fp0 arch::double-float.value dfloat)
  (blr))



; Manipulating the FPSCR.
; This  returns the bottom 8 bits of the FPSCR
(defppclapfunction %get-fpscr-control ()
  (mffs fp0)
  (stwu tsp -16 tsp)
  (stw tsp 4 tsp)
  (stfd fp0 8 tsp)
  (lbz imm0 (+ 8 7) tsp)
  (lwz tsp 0 tsp)
  (box-fixnum arg_z imm0)
  (blr))

; Returns the high 24 bits of the FPSCR
(defppclapfunction %get-fpscr-status ()
  (mffs fp0)
  (stwu tsp -16 tsp)
  (stw tsp 4 tsp)
  (stfd fp0 8 tsp)
  (lwz imm0 12 tsp)
  (lwz tsp 0 tsp)
  (clrrwi imm0 imm0 8)
  (srwi arg_z imm0 (- 8 arch::fixnumshift))
  (blr))

; Set the high 24 bits of the FPSCR; leave the low 8 unchanged
(defppclapfunction %set-fpscr-status ((new arg_z))
  (slwi imm0 new (- 8 arch::fixnumshift))
  (stwu tsp -16 tsp)
  (stw tsp 4 tsp)
  (stw imm0 12 tsp)
  (lfd fp0 8 tsp)
  (lwz tsp 0 tsp)
  (mtfsf #xfc fp0)                      ; set status fields [0-5]
  (blr))

; Set the low 8 bits of the FPSCR; leave the high 24 unchanged
(defppclapfunction %set-fpscr-control ((new arg_z))
  (unbox-fixnum imm0 new)
  (stwu tsp -16 tsp)
  (stw tsp 4 tsp)
  (stw imm0 12 tsp)
  (lfd fp0 8 tsp)
  (lwz tsp 0 tsp)
  (mtfsf #x03 fp0)                      ; set control fields [6-7]
  (blr))


; See if the binary double-float operation OP set any enabled
; exception bits in the fpscr
(defun %df-check-exception-2 (operation op0 op1 fp-status)
  (declare (type (unsigned-byte 24) fp-status))
  (when (logbitp (- 23 ppc::fpscr-fex-bit) fp-status)
    (%set-fpscr-status 0)
    ;; Ensure that operands are heap-consed
    (%fp-error-from-status fp-status 
			   (%get-fpscr-control)
			   operation 
			   (%copy-double-float op0 (%make-dfloat)) 
			   (%copy-double-float op1 (%make-dfloat)))))

(defun %sf-check-exception-2 (operation op0 op1 fp-status)
  (declare (type (unsigned-byte 24) fp-status))
  (when (logbitp (- 23 ppc::fpscr-fex-bit) fp-status)
    (%set-fpscr-status 0)
    ;; Ensure that operands are heap-consed
    (%fp-error-from-status fp-status 
			   (%get-fpscr-control)
			   operation 
			   (%copy-short-float op0 (%make-sfloat)) 
			   (%copy-short-float op1 (%make-sfloat)))))

(defun %df-check-exception-1 (operation op0 fp-status)
  (when (logbitp (- 23 ppc::fpscr-fex-bit) fp-status)
    (%set-fpscr-status 0)
    ;; Ensure that operands are heap-consed
    (%fp-error-from-status fp-status 
                              (%get-fpscr-control)
                              operation 
                              (%copy-double-float op0 (%make-dfloat)))))

(defun %sf-check-exception-1 (operation op0 fp-status)
  (declare (type (unsigned-byte 24) fp-status))
  (when (logbitp (- 23 ppc::fpscr-fex-bit) fp-status)
    (%set-fpscr-status 0)
					; Ensure that operands are heap-consed
    (%fp-error-from-status fp-status 
			   (%get-fpscr-control)
			   operation 
			   (%copy-short-float op0 (%make-sfloat)))))


(defun fp-condition-from-fpscr (status-bits control-bits)
  (cond 
   ((and (logbitp (- 23 ppc::fpscr-vx-bit) status-bits)
         (logbitp (- 31 ppc::fpscr-ve-bit) control-bits)) 'invalid-operation)
   ((and (logbitp (- 23 ppc::fpscr-ox-bit) status-bits)
         (logbitp (- 31 ppc::fpscr-oe-bit) control-bits)) 'floating-point-overflow)
   ((and (logbitp (- 23 ppc::fpscr-ux-bit) status-bits)
         (logbitp (- 31 ppc::fpscr-ue-bit) control-bits)) 'floating-point-underflow)
   ((and (logbitp (- 23 ppc::fpscr-zx-bit) status-bits)
         (logbitp (- 31 ppc::fpscr-ze-bit) control-bits)) 'division-by-zero)
   ((and (logbitp (- 23 ppc::fpscr-xx-bit) status-bits)
         (logbitp (- 31 ppc::fpscr-xe-bit) control-bits)) 'inexact-result)))

; This assumes that the FEX and one of {VX OX UX ZX XX} is set.
; Ignore 
(defun %fp-error-from-status (status-bits control-bits operation &rest operands)
  (declare (type (unsigned-byte 16) status-bits))
  (let* ((condition-class (fp-condition-from-fpscr status-bits control-bits)))
    (if condition-class
      (error (make-instance condition-class
               :operation operation
               :operands operands)))))

(defun fp-minor-opcode-operation (minor-opcode)
  (case minor-opcode
    (25 '*)
    (18 '/)
    (20 '-)
    (21 '+)
    (t 'unknown)))

; Don't we already have about 20 versions of this ?
(defppclapfunction %double-float-from-macptr! ((ptr arg_x) (byte-offset arg_y) (dest arg_z))
  (lwz imm0 arch::macptr.address ptr)
  (unbox-fixnum imm1 byte-offset)
  (lfdx fp1 imm0 imm1)
  (put-double-float fp1 dest)
  (blr))


(defvar *rounding-mode-alist*
  '((:nearest . 0) (:zero . 1) (:positive . 2) (:negative . 3)))

(defun get-fpu-mode ()
  (let* ((flags (%get-fpscr-control)))
    `(:rounding-mode ,(car (nth (logand flags 3) *rounding-mode-alist*))
                     :overflow ,(logbitp 6 flags)
                     :underflow ,(logbitp 5 flags)
                     :division-by-zero ,(logbitp 4 flags)
                     :invalid ,(logbitp 7 flags)
                     :inexact ,(logbitp 2 flags))))

;; did we document this?
(defun set-fpu-mode (&key (rounding-mode :nearest rounding-p)
                          (overflow t overflow-p)
                          (underflow t underflow-p)
                          (division-by-zero t zero-p)
                          (invalid t invalid-p)
                          (inexact t inexact-p))
  (let* ((mask (logior (if rounding-p #x03 #x00)
                       (if invalid-p #x80 #x00)
                       (if overflow-p #x40 #x00)
                       (if underflow-p #x20 #x00)
                       (if zero-p #x10 #x00)
                       (if inexact-p #x08 #x00)))
         (new (logior (or (cdr (assoc rounding-mode *rounding-mode-alist*))
                          (error "Unknown rounding mode: ~s" rounding-mode))
                      (if invalid #x80 0)
                      (if overflow #x40 0)
                      (if underflow #x20 0)
                      (if division-by-zero #x10 0)
                      (if inexact #x08 0))))
    (declare (type (unsigned-byte 8) new mask))
    (%set-fpscr-control (logior (logand new mask)
                                (logandc2 (%get-fpscr-control) mask)))
    (get-fpu-mode)))
    