;;;-*- Mode: Lisp; Package: CCL -*-
;;;
;;;   Copyright (C) 1994-2001 Digitool, Inc
;;;   This file is part of Opensourced MCL.
;;;
;;;   Opensourced MCL is free software; you can redistribute it and/or
;;;   modify it under the terms of the GNU Lesser General Public
;;;   License as published by the Free Software Foundation; either
;;;   version 2.1 of the License, or (at your option) any later version.
;;;
;;;   Opensourced MCL is distributed in the hope that it will be useful,
;;;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;;   Lesser General Public License for more details.
;;;
;;;   You should have received a copy of the GNU Lesser General Public
;;;   License along with this library; if not, write to the Free Software
;;;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;;;
(in-package "CCL")
(eval-when (:compile-toplevel :load-toplevel :execute)
  (require "BACKEND"))

(defvar *sparc-vinsn-templates* (make-hash-table :test #'eq))

(eval-when (:compile-toplevel :execute)
  (require "NXENV"))
  
(next-nx-defops)
(defvar *sparc2-specials* nil)
(let* ((newsize (%i+ (next-nx-num-ops) 10))
       (old *sparc2-specials*)
       (oldsize (length old)))
  (declare (fixnum newsize oldsize))
  (unless (>= oldsize newsize)
    (let* ((v (make-array newsize :initial-element nil)))
      (dotimes (i oldsize (setq *sparc2-specials* v))
        (setf (svref v i) (svref old i))))))

(defun lookup-sparc-opcode (name)
  (gethash (string name) sparc::*sparc-opcode-numbers*))

(defvar *sparc-backend*
  (make-backend :lookup-opcode #'lookup-sparc-opcode
		:lookup-macro #'false
		:lap-opcodes sparc::*sparc-opcodes*
		:p2-dispatch *sparc2-specials*
		:p2-vinsn-templates *sparc-vinsn-templates*
		:p2-template-hash-name '*sparc-vinsn-templates*
		:p2-compile 'sparc2-compile
		:target-specific-features
		'(:sparc-target :sparc :solaris-target :solaris)
		:target-fasl-pathname (make-pathname :type "sfsl")
		:target-architecture 16
		:name :sparc))

(defun fixup-sparc-backend ()
  (let* ((b *sparc-backend*))
    (setf (backend-lap-opcodes b) sparc::*sparc-opcodes*
	  (backend-p2-dispatch b) *sparc2-specials*
	  (backend-p2-vinsn-templates b)  *sparc-vinsn-templates*)))



(fixup-sparc-backend)

#+sparc-target
(setq *host-backend* *sparc-backend*
      *target-backend* *sparc-backend*)

(pushnew *sparc-backend* *known-backends* :key #'backend-name)

(require "SPARC-VINSNS")
(provide "SPARC-BACKEND")
