;;;-*- Mode: Lisp; Package: (SPARC :use CL ARCH) -*-
;;;
;;;   Copyright (C) 1994-2001 Digitool, Inc
;;;   This file is part of Opensourced MCL.
;;;
;;;   Opensourced MCL is free software; you can redistribute it and/or
;;;   modify it under the terms of the GNU Lesser General Public
;;;   License as published by the Free Software Foundation; either
;;;   version 2.1 of the License, or (at your option) any later version.
;;;
;;;   Opensourced MCL is distributed in the hope that it will be useful,
;;;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;;   Lesser General Public License for more details.
;;;
;;;   You should have received a copy of the GNU Lesser General Public
;;;   License along with this library; if not, write to the Free Software
;;;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;;;

(eval-when (:compile-toplevel :load-toplevel :execute)
  (require "ARCH"))

(defpackage "SPARC" (:use "CL" "ARCH"))

(in-package "SPARC")

(eval-when (:compile-toplevel :load-toplevel :execute)


;;; Lisp registers.
(eval-when (:compile-toplevel :execute)
  (defmacro defregs (&body regs)
    `(progn
       (defenum () ,@regs)
       (defparameter *gpr-register-names* ,(coerce (mapcar #'string regs) 'vector))))
  (defmacro deffpregs (&body regs)
    `(progn
       (defenum () ,@regs)
       (defparameter *fpr-register-names* ,(coerce (mapcar #'string regs) 'vector)))))

;;; SPARC ABI (C) conventions:
;;; %g0-%g7 (%r0-%r7)
;;; %o0-%o7 (%r8-%r15)
;;; %l0-%l7 (%r16-%r23)
;;; %i0-%i7 (%r24-%r31)
;;; Where: %g0 (%r0) is always 0 by hardware (not C) convention
;;;        %o6 (%r14) must always point to 16 scratch words
(defregs
    ;; Sparc global regs
  %rzero                                 ; Always contains 0.
  %loc-g                                 ; Node locative
  %rnil                                  ; Keep NIL here; don't use TOC.
  %freeptr                               ; Heap free pointer. Shared among lisp threads.
  %memo                                  ; EGC memoization stack pointer.
  %arg_x                                 ; Next-to-next-to-last function argument.
  %arg_y                                 ; Next-to-last function argument.
  %arg_z                                 ; Last function argument.
  ;; Sparc out regs
  %imm0                                  ; Unboxed, volatile registers.
  %imm1 
  %imm2 
  %imm3 
  %imm4
  %nargs                                 ; Volatile.  SHOULDN'T be used for tag extraction. (TWI handler confusion.)
  %sp                                    ; The C control stack.  Aligned on 8-byte boundary.
  %ra0                                   ; Primary return address (pc-locative.)
  ;; Sparc locals
  %lsp                                   ; Lisp stack pointer
  %tsp                                   ; Temp-stack pointer.
  %vsp                                   ; Value stack pointer; grows towards 0.
  %fn                                    ; Current function (constants vector).
  %temp0                                 ; Boxed, volatile registers.  Some may be defined on function entry.
  %temp1 
  %temp2 
  %temp3 
  
  ;; Sparc in regs
  %save0                                 ; Boxed, nonvolatile registers
  %save1 
  %save2 
  %save3 
  %save4
  %save5
  %register-windows-suck                 ; One reason: we can't touch C's frame pointer.
  %ra1                                   ; Secondary return address (PC locative)
)

(deffpregs 
  %fp-zero
  %f1
  %f2
  %f3
  %f4
  %f5
  %f6
  %f7
  %f8
  %f9
  %f10
  %f11
  %f12
  %f13
  %f14
  %f15
  %f16
  %f17
  %f18
  %f19
  %f20
  %f21
  %f22
  %f23
  %f24
  %f25
  %f26
  %f27
  %f28
  %f29
  %f30
  %f31)


(defconstant %fname %temp3)

;;; Calling sequence may pass additional arguments in temp registers.
;;; "nfn" (new function) is always passed; it's the new value of "fn".
(defconstant %nfn %temp2)

;;; CLOS may pass the context for, e.g.., CALL-NEXT-METHOD in 
;;;; the "next-method-context" register.
(defconstant %next-method-context %temp1)








(defconstant max-64-bit-constant-index (ash (+ #xfff misc-dfloat-offset) -3))
(defconstant max-32-bit-constant-index (ash (+ #xfff misc-data-offset) -2))
(defconstant max-16-bit-constant-index (ash (+ #xfff misc-data-offset) -1))
(defconstant max-8-bit-constant-index (+ #xfff misc-data-offset))
(defconstant max-1-bit-constant-index (ash (+ #xfff misc-data-offset) 5))


; The objects themselves look something like this:


;; For the eabi port: mark this stack frame as Lisp's (since EABI
;; foriegn frames can be the same size as a lisp frame.)


(define-storage-layout lisp-frame 0
  backlink
  savefn
  savelr
  savevsp
)

(define-storage-layout c-frame 64
  struct-ptr                            ; hidden arg for aggregate return
  param0
  param1
  param2
  param3
  param4
  param5
  pad
)

(defconstant c-frame.minsiz  c-frame.size)


(defenum ()
  regclass-gpr                          ; 32 general-purpose registers
  regclass-fpr                          ; 32 floating-point registers
  regclass-crf                          ; 8 fields in CR register
  regclass-misc                         ; CR,XER,LR,CTR,FPSCR, ...
)

(defenum ()
  storage-class-lisp                    ; General lisp objects
  storage-class-imm                     ; Fixnums, chars, NIL: not relocatable
  storage-class-wordptr                 ; "Raw" (fixnum-tagged) pointers to stack,etc
  storage-class-u8                      ; Unsigned, untagged, 8-bit objects
  storage-class-s8                      ; Signed, untagged, 8-bit objects
  storage-class-u16                     ; Unsigned, untagged, 16-bit objects
  storage-class-s16                     ; Signed, untagged, 16-bit objects
  storage-class-u32                     ; Unsigned, untagged, 8-bit objects
  storage-class-s32                     ; Signed, untagged, 8-bit objects
  storage-class-address                 ; "raw" (untagged) 32-bit addresses.
  storage-class-single-float            ; 32-bit single-float objects
  storage-class-double-float            ; 64-bit double-float objects
  storage-class-pc                      ; pointer to/into code vector
  storage-class-locative                ; pointer to/into node-misc object
  storage-class-crf                     ; condition register field
  storage-class-crbit                   ; condition register bit: 0-31
  storage-class-crfbit                  ; bit within condition register field : 0-3
)



(defenum (:prefix "FPSCR-" :suffix "-BIT")
  fx
  fex
  vx
  ox
  ux
  zx
  xx
  vxsnan
  vxisi
  vxidi
  vxzdz
  vximz
  vxvc
  fr
  fi
  fprfc
  fl
  fg
  fe
  fu
  nil
  vxsoft
  vxsqrt
  vxcvi
  ve
  oe
  ue
  ze
  xe
  ni
  rn0
  rn1
)

(defenum (:prefix "TRAP-" :start 16)
  sp-overflow
  lisptag-check
  fulltag-check
  typecode-check
  nargs
  bounds-check
  unbound-variable
  event-poll
  rank-check
  array-flags-check
  lowbyte-check
  breakpoint
)
)

(defmacro sparc-subprim-nil-offset (spno)
  `(+ (- (+ arch::fulltag-nil 2048)) ,spno))

;;; Condition encoding for branches & traps.
(defenum (:prefix "COND")
  n					;never
  e					;equal
  le					;less than or equal
  l					;less than
  leu					;less than or equal unsigned
  cs					;carry set
  neg					;negative
  vs					;overflow set
  ; Note that (logxor cond #x8) is the condition's inverse.
  a					;always
  ne					;not equal
  g					;greater
  ge					;greater than or equal
  gu					;greater than unsigned
  cc					;carry clear
  pos					;positive
  vc					;overflow clear
)



(defenum (:prefix "FCOND")
  n
  ne
  lg
  ul
  l
  ug
  g
  u
; again, inverses are congruent mod 7.
  a
  e
  ue
  ge
  uge
  le
  ule
  o
)


(ccl::provide "SPARC-ARCH")
