<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// This must be first - includes config.php
require_once("./include/begin.inc.php");

include_once("./include/language.php");
include_once("./include/theme.php");

include_once("./functions/database.php");
include_once("./functions/auth.php");
include_once("./functions/logging.php");

include_once("./functions/user.php");
include_once("./functions/widgets.php");
include_once("./functions/http.php");
include_once("./functions/email.php");
include_once("./functions/datetime.php");
include_once("./functions/borrowed_item.php");
include_once("./functions/item.php");
include_once("./functions/review.php");
include_once("./functions/item_input.php");
include_once("./functions/address_type.php");

/**
* @lookup_rs - is an array, not a $result set
*/
function radio_grid2($name, $lookup_rs, $mask, $columns, $border, $value)
{
	$count=0;
	$grid_row=0;
	$value_checked=FALSE;
	
	reset($lookup_rs);
	while(list(,$lookup_r) = each($lookup_rs))
	{
		if($count==0)
		{
			$var .= "<tr>";
			$grid_row++;
		}
		
		$field = "";
		if(!$value_checked && $value==NULL && $lookup_r['checked_ind']=="Y")
		{
			$value_checked=TRUE;
			$field .= "\n<input type=\"radio\" name=\"$name\" value=\"".$lookup_r['value']."\" CHECKED>";
		}
		else
		{
			// Case insensitive!
			if($value!==NULL && strcasecmp(trim($value), $lookup_r['value'])===0)
			{
				$value_checked=TRUE;
				$field .= "\n<input type=\"radio\" name=\"$name\" value=\"".$lookup_r['value']."\" CHECKED>";
			}
			else
			{
				$field .= "\n<input type=\"radio\" name=\"$name\" value=\"".$lookup_r['value']."\">";
			}
		}
		
		// now the display value.
		$field .= format_display_value($mask, $lookup_r['img'], $lookup_r['value'], $lookup_r['display'])."&nbsp;&nbsp;\n";
		$var .= format_data(NULL, $field);
    	$count++;
		
		if(is_numeric($columns) && $count == $columns)
		{
			$count=0;
			$var .="</tr>";
		}
	}
	
	// Add the value to the list of options and select it.
	if(strlen($value)>0 && !$value_checked)
	{
		if($count==0)
			$var .= "<tr>";
		$var .= format_data(NULL, "<input type=\"radio\" name=\"$name\" value=\"$value\" CHECKED>$value");
		$count++;
	}
	
	// Now close current row if required.
	if(is_numeric($columns) && $count!=0 && $grid_row>1)
	{
		for ($i=0; $i<($columns-$count); $i++)
		{
			$var.= format_data(NULL, "&nbsp;");
		}
		$var.="</tr>";
	}
	
	// Now return complete table.
	return "<table cellpadding=1 cellspacing=0 border=\"".(is_numeric($border)?$border:0)."\">$var</table>";
}

/**
* 	Assumes that is_user_admin check has been made
*/
function get_new_user_usertype_input_form($HTTP_VARS, $user_type_r, $user_type)
{
	global $CONFIG_VARS;
	global $LANG_VARS;
	global $PHP_SELF;
	global $HTTP_SESSION_VARS;
	
	echo("<h3>".$LANG_VARS['choose_user_type']."</h3>");
	
	if($CONFIG_VARS['widgets.enable_javascript_validation']!==FALSE)
	{
		// Include validation javascript, which will validate data input.
		$buffer = get_validation_javascript();
	}
	
	$buffer .= 
		"<table border=0 frameborder=0 cellspacing=1 cellpadding=1>".
		"<form action=\"$PHP_SELF\" method=\"post\">".
		get_url_fields($HTTP_VARS, NULL, array('user_type')); // Pass all http variables
	
	$buffer .= format_field(
			$LANG_VARS['user_type'], 
			NULL, 
			radio_grid2(
				'user_type', // name
				get_user_types_rs($user_type_r, $user_type), //lookup_rs
				'%value% - %display%', //mask
				1,// columns
				0,// border
				$HTTP_VARS['user_type']));//value
				
	$buffer .= "\n<tr>";
	
	if($CONFIG_VARS['widgets.enable_javascript_validation']!==FALSE)
		$onclick_event = "if(!checkForm(this.form)){return false;}else{this.form.submit();}";
	else
		$onclick_event = "this.form.submit();";
						
	$buffer .= "\n<td colspan=2>".
			"\n<input type=\"button\" onclick=\"$onclick_event\" value=\"".$LANG_VARS['create_new_user']."\">";
	$buffer .= "</td>";

	$buffer .= "\n</tr>".
				"\n</form>".
			"</table>";
			
	return $buffer;
}

/**
* @param $op is 'edit' or 'new'
*/
function get_user_input_form($user_r, $HTTP_VARS)
{
	global $CONFIG_VARS;
	global $_OPENDB_THEME;
	global $LANG_VARS;
	global $PHP_SELF;
	global $HTTP_SESSION_VARS;

	if($CONFIG_VARS['widgets.enable_javascript_validation']!==FALSE)
	{
		// Include validation javascript, which will validate data input.
		$buffer = get_validation_javascript();
	}
	
	$buffer .= 
		"<table border=0 frameborder=0 cellspacing=1 cellpadding=1>".
		"<form action=\"$PHP_SELF\" method=\"post\">";

	if(is_not_empty_array($user_r))
	{
		$buffer .= get_input_field("user_id",
				NULL, // s_attribute_type
				$LANG_VARS['userid'], 
				"readonly", //input type.
				"", //compulsory!
				$user_r['user_id'],
				TRUE);
	}
	else
	{
		$buffer .= get_input_field("user_id",
				NULL, // s_attribute_type
				$LANG_VARS['userid'], 
				"filtered(20,20,a-zA-Z0-9_.)", //input type.
				"Y", //compulsory!
				$HTTP_VARS['user_id'],
				TRUE);
	}			
	
	$buffer .= format_field(
					$LANG_VARS['user_type'],
					NULL, 
					get_usertype_description(ifempty($HTTP_VARS['user_type'],$user_r['type'])));
	
	if(!is_array($user_r))
	{
		$buffer .= "\n<input type=hidden name=\"user_type\" value=\"".$HTTP_VARS['user_type']."\">";
	}
							
	$buffer .= get_input_field("fullname",
				NULL, // s_attribute_type
				$LANG_VARS['fullname'], 
                "text(30,100)", //input type.
   	            "Y", //compulsory!
       	        ifempty($HTTP_VARS['fullname'],$user_r['fullname']),
				TRUE);
	
	if($CONFIG_VARS['user_admin.user_themes_support']!==FALSE)
	{	
		$uid_theme = ifempty($HTTP_VARS['uid_theme'],$user_r['theme']);
		$buffer .= format_field($LANG_VARS['user_theme'], 
						NULL, 
						custom_select("uid_theme", get_user_theme_r(), "%value%", 1, is_legal_user_theme($uid_theme)?$uid_theme:$CONFIG_VARS['site.theme']));// If theme no longer exists, then set to default!
	}
	
	if($CONFIG_VARS['user_admin.user_language_support']!==FALSE)
	{	
		$language_r = get_language_r();
		
		// Do not bother with language input field if only one language pack available.
		if(count($language_r)>1)
		{
			$uid_language = ifempty($HTTP_VARS['uid_language'],$user_r['language']);
			$buffer .= format_field($LANG_VARS['user_language'], 
							NULL, 
							custom_select("uid_language", $language_r, "%value%", 1, is_legal_language($uid_language)?$uid_language:$CONFIG_VARS['site.language']));// If language no longer exists, then set to default!
		}				
	}
	
	// Now do the addresses
	if(is_not_empty_array($user_r))
	{
		$addr_results = fetch_user_address_type_rs($user_r['user_id'], $user_r['type'], TRUE);
	}
	else
	{
		$addr_results = fetch_address_type_rs($HTTP_VARS['user_type'], TRUE);
	}

	if($addr_results)
	{
		while($address_type_r = mysql_fetch_array($addr_results, MYSQL_ASSOC))
		{
			$v_address_type = strtolower($address_type_r['s_address_type']);
			
			if(is_not_empty_array($user_r))
			{
				$attr_results = fetch_address_type_attribute_type_rs($address_type_r['s_address_type'], $user_r['type'], 'update', TRUE);
			}
			else
			{
				$attr_results = fetch_address_type_attribute_type_rs($address_type_r['s_address_type'], $HTTP_VARS['user_type'], 'update', TRUE);
			}	
			
			if($attr_results)
			{
				$buffer .= '<tr><td colspan=2>&nbsp;</td></tr>';
				$buffer .= '<tr><td colspan=2 align=left><div class="navbar" style="text-align:left">- '.$address_type_r['description'].':</div></td></tr>';
			
				while($addr_attribute_type_r = mysql_fetch_array($attr_results, MYSQL_ASSOC))
				{
					$fieldname = get_field_name($addr_attribute_type_r['s_attribute_type'], $addr_attribute_type_r['order_no']);
					
					$value = NULL;
					if($address_type_r['sequence_number']!==NULL)
					{
						if(is_lookup_attribute_type($addr_attribute_type_r['s_attribute_type']))
						{
							$value = fetch_user_address_lookup_attribute_val(
														$address_type_r['sequence_number'], 
														$addr_attribute_type_r['s_attribute_type'], 
														$addr_attribute_type_r['order_no']);
						}
						else
						{
							
							$value = fetch_user_address_attribute_val(
														$address_type_r['sequence_number'], 
														$addr_attribute_type_r['s_attribute_type'],
														$addr_attribute_type_r['order_no']);
						}
						
						$value = ifempty(
								filter_input_field(
										$addr_attribute_type_r['s_attribute_type'], 
										$addr_attribute_type_r['input_type'], 
										$HTTP_VARS[$v_address_type][$fieldname]),
								$value);
					}
					else
					{
						$value = filter_input_field(
									$addr_attribute_type_r['s_attribute_type'], 
									$addr_attribute_type_r['input_type'], 
									$value);
					}
						
					// If this is an edit operation - the value must be NOT NULL
					// for some widgets to work properly.
					if($address_type_r['sequence_number']!==NULL && $value === NULL)
					{
						$value = '';
					}
					
					$buffer .= get_input_field($v_address_type.'['.$fieldname.']', 
							$addr_attribute_type_r['s_attribute_type'], 
							$addr_attribute_type_r['prompt'], 
							$addr_attribute_type_r['input_type'], 
							$addr_attribute_type_r['compulsory_ind'], 
							$value);
				}//while
				mysql_free_result($attr_results);
			}//if($attr_results)
		}//while
		mysql_free_result($addr_results);
	}//if($addr_results)
	
	if(!is_array($user_r) || 
				$CONFIG_VARS['user_admin.user_passwd_change_allowed']!==FALSE || 
				is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']))
	{
		if($CONFIG_VARS['widgets.show_prompt_compulsory_ind']!==FALSE)
		{
			$buffer .= "\n<tr><td align=left nowrap>".
							format_help_block(array(array('img'=>'compulsory.gif', 'text'=>$LANG_VARS['compulsory_field']))).
						"</td><td>&nbsp;</td></tr>";
		}
		
		$buffer .= "\n<tr><td colspan=2>&nbsp;</td></tr>";
								
		if(!is_array($user_r))
		{
			if($CONFIG_VARS['email.use_php_mail']!==FALSE && ($HTTP_VARS['user_type'] == 'A' || $HTTP_VARS['user_type'] == 'N' || $HTTP_VARS['user_type'] == 'B'))
				$compulsory_ind = 'N';
			else
				$compulsory_ind = 'Y';
		}
		else
		{
			$compulsory_ind = 'N';
		}
		
		$buffer .= get_input_field("pwd",
				NULL, // s_attribute_type
				$LANG_VARS['new_passwd'], 
                "password(30,40)", //input type.
				$compulsory_ind, //compulsory!
				"",
				TRUE);
				
		$buffer .= get_input_field("confirmpwd",
				NULL, // s_attribute_type
				$LANG_VARS['confirm_passwd'], 
				"password(30,40)", //input type.
				$compulsory_ind, //compulsory!
				"",
				TRUE,
				NULL,
				$CONFIG_VARS['widgets.enable_javascript_validation']!==FALSE?"if( (this.form.pwd.value.length!=0 || this.form.confirmpwd.value.length!=0) && this.form.pwd.value!=this.form.confirmpwd.value){alert('".$LANG_VARS['passwds_do_not_match']."'); this.focus(); return false;}":"");
	}
	
	$buffer .= "\n<tr>";
	
	if($CONFIG_VARS['widgets.enable_javascript_validation']!==FALSE)
		$onclick_event = "if(!checkForm(this.form)){return false;}else{this.form.submit();}";
	else
		$onclick_event = "this.form.submit();";
						
	// If user_id defined, we are in update mode.			
	if(is_not_empty_array($user_r))
	{		
		$buffer .= "\n<input type=\"hidden\" name=\"op\" value=\"update\">";
			
		if($HTTP_VARS['user_id'] != $HTTP_SESSION_VARS['user_id'])
		{
			$buffer .= "\n<td><input type=\"button\" onclick=\"this.form.op.value='update'; $onclick_event\" value=\"".$LANG_VARS['update_user']."\">";
			
			if(is_user_active($HTTP_VARS['user_id']) && $CONFIG_VARS['user_admin.user_delete_support'] !== FALSE)
			{
				if($CONFIG_VARS['user_admin.user_delete_support'] === TRUE)
					$buffer .= "\n<td><input type=\"button\" onclick=\"this.form.op.value='delete'; this.form.submit();\" value=\"".$LANG_VARS['delete_user']."\"></td>";
				else if($CONFIG_VARS['user_admin.user_delete_support'] === 'deactivate')
					$buffer .= "\n<td><input type=\"button\" onclick=\"this.form.op.value='deactivate'; this.form.submit();\" value=\"".$LANG_VARS['deactivate_user']."\"></td>";
			}
			else if(!is_user_active($HTTP_VARS['user_id']))
			{
				$buffer .= "\n<td><input type=\"button\" onclick=\"this.form.op.value='activate'; this.form.submit();\" value=\"".$LANG_VARS['activate_user']."\"></td>";
			}
			else
			{
				$buffer .= "\n<td>&nbsp;</td>";
			}
		}
		else
		{
			$buffer .= "\n<td colspan=2 align=left>".
					"\n<input type=\"button\" onclick=\"$onclick_event\" value=\"".$LANG_VARS['update_details']."\">";
		}
	}
	else //insert mode
	{
		$buffer .= "\n<td colspan=2>";
		
		if($HTTP_VARS['op'] != 'signup')
		{
			$buffer .= "\n<input type=\"hidden\" name=\"op\" value=\"insert\">".
						"\n<input type=\"button\" onclick=\"$onclick_event\" value=\"".$LANG_VARS['add_user']."\">";
				
			if($CONFIG_VARS['email.use_php_mail']!==FALSE && ($HTTP_VARS['user_type'] == 'A' || $HTTP_VARS['user_type'] == 'N' || $HTTP_VARS['user_type'] == 'B'))
			{
				// If we are actually showing the form, because an insert has failed,
				// we should set the email_user indicator according to what the user
				// has chosen.
				if($HTTP_VARS['op'] == 'insert')
				{
					if($HTTP_VARS['email_user'] == 'Y')
						$checked = "CHECKED";
					else
						$checked = "";
				}						
				else
					$checked = "CHECKED";
			
				$buffer .= "<input type=\"checkbox\" name=\"email_user\" value=\"Y\" $checked>".
							$LANG_VARS['send_welcome_email'];
			}
		}//if($HTTP_VARS['op'] != 'signup')
		else
		{
			// have to stay in signup mode.
			$buffer .= "\n<input type=\"hidden\" name=\"op\" value=\"signup\">".
						"<input type=\"hidden\" name=\"op2\" value=\"send_info\">".
						"<input type=\"button\" onclick=\"$onclick_event\" value=\"".$LANG_VARS['continue']."\">";
		}
		//else
		$buffer .= "</td>";
	}		
	
	$buffer .= "\n</tr>".
				"\n</form>".
			"</table>";

	// insert user
	if(!is_array($user_r))
	{
		if($CONFIG_VARS['email.use_php_mail']!==FALSE && ($HTTP_VARS['user_type'] == 'A' || $HTTP_VARS['user_type'] == 'N' || $HTTP_VARS['user_type'] == 'B'))
		{
			$buffer .= format_help_block($LANG_VARS['new_passwd_will_be_autogenerated_if_not_specified']);
		}
	}
	
	return $buffer;		
}

function is_empty_attribute($s_attribute_type, $attribute_val)
{
	if(is_lookup_attribute_type($s_attribute_type))
	{
		if(is_array($attribute_val))
		{
			if(count($attribute_val)>0)
				return TRUE;
			else
				return FALSE;
		}
		else
		{
			if(strlen($attribute_val)>0)
				return TRUE;
			else
				return FALSE;
		}
	}
	else
	{
		if(strlen($attribute_val)>0)
			return TRUE;
		else
			return FALSE;
	}
}

/*
*/
function handle_user_insert(&$HTTP_VARS, &$errors)
{
	global $CONFIG_VARS;
	global $LANG_VARS;
	global $HTTP_SESSION_VARS;

	// We need to check if user already exists, so we can return a nice error.
	// A userid CANNOT differ in case alone!
	if(!is_user_valid($HTTP_VARS['user_id'], TRUE))
	{
		if(is_usertype_valid($HTTP_VARS['user_type']))
		{
			$HTTP_VARS['user_id'] = strtolower(filter_input_field(NULL, "filtered(20,20,a-zA-Z0-9_.)", $HTTP_VARS['user_id']));
			$HTTP_VARS['fullname'] = filter_input_field(NULL, "text(30,100)", $HTTP_VARS['fullname']);
			
			$is_uid_validated = validate_input_field(NULL, $LANG_VARS['userid'], "filtered(20,20,a-zA-Z0-9_.)", "Y", $HTTP_VARS['user_id'], $errors);
			$is_fullname_validated = validate_input_field(NULL, $LANG_VARS['fullname'], "text(30,100)", "Y", $HTTP_VARS['fullname'], $errors);
			if($is_uid_validated && $is_fullname_validated)
			{
				$is_address_validated = TRUE;
				$addr_results = fetch_address_type_rs($HTTP_VARS['user_type'], TRUE);
				if($addr_results)
				{
					while($address_type_r = mysql_fetch_array($addr_results, MYSQL_ASSOC))
					{
						$v_address_type = strtolower($address_type_r['s_address_type']);
						$address_attribs_provided[$v_address_type] = FALSE;
						
						$attr_results = fetch_address_type_attribute_type_rs($address_type_r['s_address_type'], $HTTP_VARS['user_type'], 'update', TRUE);
						if($attr_results)
						{
							while($addr_attribute_type_r = mysql_fetch_array($attr_results, MYSQL_ASSOC))
							{
								$fieldname = get_field_name($addr_attribute_type_r['s_attribute_type'],$addr_attribute_type_r['order_no']);
								$HTTP_VARS[$v_address_type][$fieldname] = filter_input_field($addr_attribute_type_r['s_attribute_type'], $addr_attribute_type_r['input_type'], $HTTP_VARS[$v_address_type][$fieldname]);
								
								if(is_empty_attribute($addr_attribute_type_r['s_attribute_type'], $HTTP_VARS[$v_address_type][$fieldname])!==FALSE)
								{
									$address_attribs_provided[$v_address_type] = TRUE;
									
									if(!validate_input_field($addr_attribute_type_r['s_attribute_type'], $addr_attribute_type_r['prompt'], $addr_attribute_type_r['input_type'], $addr_attribute_type_r['compulsory_ind'], $HTTP_VARS[$v_address_type][$fieldname], $errors))
									{
										$is_address_validated = FALSE;
									}
								}
							}
							mysql_free_result($attr_results);
						}//if($addr_results)
					}
					mysql_free_result($addr_results);
				}//if($addr_results)
				
				if($is_address_validated)
				{
					// If no password specified, generate one
					if(strlen($HTTP_VARS['pwd'])==0)
					{
						// check whether a password is provided or not
						if($CONFIG_VARS['email.use_php_mail']!==FALSE && ($HTTP_VARS['user_type'] == 'A' || $HTTP_VARS['user_type'] == 'N' || $HTTP_VARS['user_type'] == 'B'))
						{
							$HTTP_VARS['pwd'] = generate_password(8);
						}
						else
						{
							$errors[] = array('error'=>$LANG_VARS['passwd_not_specified']);
							return FALSE;				
						}
					}
					else if($HTTP_VARS['pwd'] != $HTTP_VARS['confirmpwd'])
					{
						$errors[] = array('error'=>$LANG_VARS['passwds_do_not_match']);
						return FALSE;
					}
			
					// Do not allow update with illegal theme!
					if($CONFIG_VARS['user_admin.user_themes_support']===FALSE || !is_legal_user_theme($HTTP_VARS['uid_theme']))
					{
						$HTTP_VARS['uid_theme'] = NULL;
					}
				
					// Do not allow update with illegal language.			
					if($CONFIG_VARS['user_admin.user_language_support']===FALSE || !is_legal_language($HTTP_VARS['uid_language']))
					{
						$HTTP_VARS['uid_language'] = NULL;
					}

					// Do not actually perform any inserts in signup mode, but we still want to perform validations.				
					if($HTTP_VARS['op'] != 'signup')
					{
						if(insert_user($HTTP_VARS['user_id'], $HTTP_VARS['fullname'], $HTTP_VARS['pwd'], $HTTP_VARS['user_type'], $HTTP_VARS['uid_language'], $HTTP_VARS['uid_theme']))
						{
							$address_creation_success = TRUE;
							$addr_results = fetch_address_type_rs($HTTP_VARS['user_type'], TRUE);
							if($addr_results)
							{
								while($address_type_r = mysql_fetch_array($addr_results, MYSQL_ASSOC))
								{
									$v_address_type = strtolower($address_type_r['s_address_type']);
									
									if($address_attribs_provided[$v_address_type]!==FALSE)
									{
										$new_sequence_number = insert_user_address($HTTP_VARS['user_id'], $address_type_r['s_address_type']);
										if($new_sequence_number !== FALSE)
										{
											$attr_results = fetch_address_type_attribute_type_rs($address_type_r['s_address_type'], $HTTP_VARS['user_type'], 'update', TRUE);
											if($attr_results)
											{
												while($addr_attribute_type_r = mysql_fetch_array($attr_results, MYSQL_ASSOC))
												{
													$fieldname = get_field_name($addr_attribute_type_r['s_attribute_type'], $addr_attribute_type_r['order_no']);
													
													if(is_lookup_attribute_type($addr_attribute_type_r['s_attribute_type']))
													{
														$lookup_value_r = NULL;
														if(is_array($HTTP_VARS[$v_address_type][$fieldname]))
															$lookup_value_r =& $HTTP_VARS[$v_address_type][$fieldname];
														else if(strlen(trim($HTTP_VARS[$v_address_type][$fieldname]))>0)
															$lookup_value_r[] = $HTTP_VARS[$v_address_type][$fieldname];
														
														if(is_not_empty_array($lookup_value_r))
														{
															if(!insert_lookup_user_address_attributes($new_sequence_number, $addr_attribute_type_r['s_attribute_type'], $addr_attribute_type_r['order_no'], $lookup_value_r))
															{
																$errors[] = array('error'=>$LANG_VARS['user_address_not_added'],'detail'=>mysql_error());
																$address_creation_success = FALSE;
															}
														}
													}
													else
													{
														if(strlen($HTTP_VARS[$v_address_type][$fieldname])>0)
														{
															if(!insert_user_address_attribute($new_sequence_number, $addr_attribute_type_r['s_attribute_type'], $addr_attribute_type_r['order_no'], $HTTP_VARS[$v_address_type][$fieldname]))
															{
																$errors[] = array('error'=>$LANG_VARS['user_address_not_added'],'detail'=>mysql_error());
																$address_creation_success = FALSE;
															}
														}
													}
												}
												mysql_free_result($attr_results);
											}//if($addr_results)
										}//if($new_sequence_number !== FALSE)
										else
										{
											$errors[] = array('error'=>$LANG_VARS['user_address_not_added'],'detail'=>mysql_error());
											$address_creation_success = FALSE;
										}
									}//if($address_attribs_provided[$v_address_type]!==FALSE)
								}
								mysql_free_result($addr_results);
							}//if($addr_results)
				
							if($address_creation_success)
							{
								return TRUE;
							}
							else
							{
								return FALSE;
							}
						}
						else
						{
							$errors[] = array('error'=>replace_lang_var("user_id", $HTTP_VARS['user_id'], $LANG_VARS['user_not_added']),'detail'=>mysql_error());
							return FALSE;
						}
					}//if($HTTP_VARS['op'] != 'signup')
					else
					{
						return TRUE;
					}
				}//if($is_address_validated)
				else
				{
					return FALSE;
				}
			}//if($is_uid_validated && $is_fullname_validated)
			else // not all required information specified
			{
				return FALSE;				
			}
		}//if(is_usertype_valid($HTTP_VARS['user_type']))
		else
		{
			return FALSE;
		}
	}			
	else
	{
		$errors[] = array('error'=>replace_lang_var("user_id", $HTTP_VARS['user_id'], $LANG_VARS['user_exists']),'detail'=>'');
		return FALSE;
	}
}

/*
*/
function handle_user_update(&$HTTP_VARS, &$errors)
{
	global $LANG_VARS;
	global $CONFIG_VARS;
	global $HTTP_SESSION_VARS;
	
	$user_r = fetch_user_r($HTTP_VARS['user_id']);
	if(is_not_empty_array($user_r))
	{
		$HTTP_VARS['fullname'] = filter_input_field(NULL, "text(30,100)", $HTTP_VARS['fullname']);
		
		$is_fullname_validated = validate_input_field(NULL, $LANG_VARS['fullname'], "text(30,100)", "Y", $HTTP_VARS['fullname'], $errors);
		if($is_fullname_validated)
		{
			$address_attribs_provided = NULL;
			$is_address_validated = TRUE;
			$addr_results = fetch_user_address_type_rs($user_r['user_id'], $user_r['type'], TRUE);
			if($addr_results)
			{
				while($address_type_r = mysql_fetch_array($addr_results, MYSQL_ASSOC))
				{
					$v_address_type = strtolower($address_type_r['s_address_type']);
					
					$address_attribs_provided[$v_address_type] = FALSE;
					
					$attr_results = fetch_address_type_attribute_type_rs($address_type_r['s_address_type'], $user_r['type'], 'update', TRUE);
					if($attr_results)
					{
						while($addr_attribute_type_r = mysql_fetch_array($attr_results, MYSQL_ASSOC))
						{
							$fieldname = get_field_name($addr_attribute_type_r['s_attribute_type'],$addr_attribute_type_r['order_no']);
					
							$HTTP_VARS[$v_address_type][$fieldname] = filter_input_field($addr_attribute_type_r['s_attribute_type'], $addr_attribute_type_r['input_type'], $HTTP_VARS[$v_address_type][$fieldname]);
							if(is_empty_attribute($addr_attribute_type_r['s_attribute_type'], $HTTP_VARS[$v_address_type][$fieldname])!==FALSE)
							{
								$address_attribs_provided[$v_address_type] = TRUE;
								
								if(!validate_input_field($addr_attribute_type_r['s_attribute_type'], $addr_attribute_type_r['prompt'], $addr_attribute_type_r['input_type'], $addr_attribute_type_r['compulsory_ind'], $HTTP_VARS[$v_address_type][$fieldname], $errors))
								{
									$is_address_validated = FALSE;
								}
							}
						}
						mysql_free_result($attr_results);
					}//if($addr_results)
				}
				mysql_free_result($addr_results);
			}//if($addr_results)
			
			if($is_address_validated)
			{
				// Do not allow update with illegal theme!
				if($CONFIG_VARS['user_admin.user_themes_support']===FALSE || !is_legal_user_theme($HTTP_VARS['uid_theme']))
				{
					$HTTP_VARS['uid_theme'] = FALSE; // Do not update theme!
				}
				
				// Do not allow update with illegal language.			
				if($CONFIG_VARS['user_admin.user_language_support']===FALSE || !is_legal_language($HTTP_VARS['uid_language']))
				{
					$HTTP_VARS['uid_language'] = NULL;
				}
			
				if(update_user($HTTP_VARS['user_id'], $HTTP_VARS['fullname'], $HTTP_VARS['uid_language'], $HTTP_VARS['uid_theme'], FALSE))
				{
					// No errors recorded at this stage.
					$errors = NULL;
				
					$address_creation_success = TRUE;
					$address_type_sequence_number_r = NULL;
					
					$addr_results = fetch_user_address_type_rs($user_r['user_id'], $user_r['type'], TRUE);
					if($addr_results)
					{
						while($address_type_r = mysql_fetch_array($addr_results, MYSQL_ASSOC))
						{
							$v_address_type = strtolower($address_type_r['s_address_type']);
							
							$address_creation_success = TRUE;
							
							// address does not currently exist, so create it.
							if($address_type_r['sequence_number'] === NULL)
							{
								if($address_attribs_provided[$v_address_type]!==FALSE)
								{
									$new_sequence_number = insert_user_address($user_r['user_id'], $address_type_r['s_address_type']);
									if($new_sequence_number !== FALSE)
									{
										$address_type_r['sequence_number'] = $new_sequence_number;
									}
									else
									{
										$address_creation_success = FALSE;
									}
								}
							}
							
							if($address_creation_success!==FALSE)
							{
								if($address_attribs_provided[$v_address_type]!==FALSE)
								{
									$attr_results = fetch_address_type_attribute_type_rs($address_type_r['s_address_type'], $user_r['type'], 'update', TRUE);
									if($attr_results)
									{
										while($addr_attribute_type_r = mysql_fetch_array($attr_results, MYSQL_ASSOC))
										{
											$fieldname = get_field_name($addr_attribute_type_r['s_attribute_type'], $addr_attribute_type_r['order_no']);
											
											if(is_lookup_attribute_type($addr_attribute_type_r['s_attribute_type']))
											{
												$lookup_value_r = NULL;
												if(is_array($HTTP_VARS[$v_address_type][$fieldname]))
													$lookup_value_r =& $HTTP_VARS[$v_address_type][$fieldname];
												else if(strlen(trim($HTTP_VARS[$v_address_type][$fieldname]))>0)
													$lookup_value_r[] = $HTTP_VARS[$v_address_type][$fieldname];
								
												$user_addr_attr_lookup_val_r = fetch_user_address_lookup_attribute_val(
																$address_type_r['sequence_number'], 
																$addr_attribute_type_r['s_attribute_type'], 
																$addr_attribute_type_r['order_no']);
												
												if($user_addr_attr_lookup_val_r !== FALSE)
												{
													if(is_not_empty_array($lookup_value_r)) // insert/update mode
													{
														if(!update_lookup_user_address_attributes($address_type_r['sequence_number'], $addr_attribute_type_r['s_attribute_type'], $addr_attribute_type_r['order_no'], $lookup_value_r))
														{
															$errors[] = array('error'=>$LANG_VARS['user_address_not_updated'],'detail'=>mysql_error());
															$address_creation_success = FALSE;
														}
													}
													else
													{
														if(!delete_lookup_user_address_attributes($address_type_r['sequence_number'], $addr_attribute_type_r['s_attribute_type'], $addr_attribute_type_r['order_no']))
														{
															$errors[] = array('error'=>$LANG_VARS['user_address_not_updated'],'detail'=>mysql_error());
															$address_creation_success = FALSE;
														}
													}
												}
												else if(is_not_empty_array($lookup_value_r))
												{
													if(!insert_lookup_user_address_attributes($address_type_r['sequence_number'], $addr_attribute_type_r['s_attribute_type'], $addr_attribute_type_r['order_no'], $lookup_value_r))
													{
														$errors[] = array('error'=>$LANG_VARS['user_address_not_updated'],'detail'=>mysql_error());
														$address_creation_success = FALSE;
													}
												}
											}
											else
											{
												$attribute_val = fetch_user_address_attribute_val(
																$address_type_r['sequence_number'], 
																$addr_attribute_type_r['s_attribute_type'],
																$addr_attribute_type_r['order_no']);
												
												if($attribute_val!==FALSE)
												{
													if(strlen($HTTP_VARS[$v_address_type][$fieldname])>0)
													{
														if(!update_user_address_attribute($address_type_r['sequence_number'], $addr_attribute_type_r['s_attribute_type'], $addr_attribute_type_r['order_no'], $HTTP_VARS[$v_address_type][$fieldname]))
														{
															$errors[] = array('error'=>$LANG_VARS['user_address_not_updated'],'detail'=>mysql_error());
															$address_creation_success = FALSE;
														}
													}
													else
													{
														if(!delete_user_address_attribute($address_type_r['sequence_number'], $addr_attribute_type_r['s_attribute_type'], $addr_attribute_type_r['order_no']))
														{
															$errors[] = array('error'=>$LANG_VARS['user_address_not_updated'],'detail'=>mysql_error());
															$address_creation_success = FALSE;
														}
													}
												}
												else
												{
													if(strlen($HTTP_VARS[$v_address_type][$fieldname])>0)
													{
														if(!insert_user_address_attribute($address_type_r['sequence_number'], $addr_attribute_type_r['s_attribute_type'], $addr_attribute_type_r['order_no'], $HTTP_VARS[$v_address_type][$fieldname]))
														{
															$errors[] = array('error'=>$LANG_VARS['user_address_not_updated'],'detail'=>mysql_error());
															$address_creation_success = FALSE;
														}
													}
												}
											}
										}//while($addr_attribute_type_r = mysql_fetch_array($attr_results, MYSQL_ASSOC))
										mysql_free_result($attr_results);
									}//if($attr_results)
								}//if($address_attribs_provided[$v_address_type]!==FALSE)
								else
								{
									// existing address, we want to get rid of it here
									if($address_type_r['sequence_number']!==NULL)
									{
										if(delete_user_address_attributes($address_type_r['sequence_number']))
										{
											delete_user_address($address_type_r['sequence_number']);
										}
									}
								}
							}//if($address_creation_success!==FALSE)
						}
						mysql_free_result($addr_results);
					}//if($addr_results)
						
					// If at least one password specified, we will try to perform update.
					if(strlen($HTTP_VARS['pwd'])>0 || strlen($HTTP_VARS['confirmpwd'])>0)
					{
						if($CONFIG_VARS['user_admin.user_passwd_change_allowed']!==FALSE || is_user_admin($HTTP_SESSION_VARS['user_id'],$HTTP_SESSION_VARS['user_type']))
						{
							if ($HTTP_VARS['pwd'] != $HTTP_VARS['confirmpwd'])
							{
								$errors[] = array('error'=>$LANG_VARS['passwd_not_changed'],'detail'=>$LANG_VARS['passwds_do_not_match']);
							}
							else if(strlen($HTTP_VARS['pwd'])==0)
							{
								$errors[] = array('error'=>$LANG_VARS['passwd_not_changed'],'detail'=>$LANG_VARS['passwd_not_specified']);
							}
							else
							{
								if(!update_user_passwd($HTTP_VARS['user_id'], $HTTP_VARS['pwd']))
								{
									$errors[] = array('error'=>$LANG_VARS['passwd_not_changed'],'detail'=>mysql_error());
								}
							}
						}
						else
						{
							$errors[] = array('error'=>$LANG_VARS['passwd_not_changed']);
						}
					}
					
					if($address_creation_success!==FALSE)
					{
						return TRUE;
					}
					else
					{
						// address update failed.
						return FALSE;
					}
				}//if(update_user($HTTP_VARS['user_id'], $HTTP_VARS['fullname'], $HTTP_VARS['location'], $HTTP_VARS['email'], $HTTP_VARS['uid_language'], $HTTP_VARS['uid_theme'], FALSE)) 
				else
				{
					$errors[] = array('error'=>replace_lang_var("user_id", $HTTP_VARS['user_id'], $LANG_VARS['user_not_updated']),'detail'=>mysql_error());
					return FALSE;
				}
			}//if($is_address_validated)
			else
			{
				return FALSE;
			}
		}
		else // not all required information specified
		{
			return FALSE;
		}
	}
	else
	{
		$errors[] = array('error'=>replace_lang_var("user_id", $HTTP_VARS['user_id'], $LANG_VARS['user_not_found']));
		return FALSE;
	}		
}

/*
* The Deactivate process will not delete any records.  All pending reservations
* for the users items, and made by the user will be cancelled, but thats it.
*/
function handle_user_deactivate($user_id, $HTTP_VARS, &$errors)
{
	global $HTTP_SESSION_VARS;
	global $LANG_VARS;
	global $CONFIG_VARS;
	
	if($CONFIG_VARS['user_admin.user_delete_support'] === 'deactivate')
	{
		if($user_id == $HTTP_SESSION_VARS['user_id'])
		{
			$errors[] = array('error'=>$LANG_VARS['cannot_deactivate_yourself'],'detail'=>'');
			return FALSE;
		}
		else if(fetch_my_borrowed_item_cnt($user_id)>0)
		{
			$errors[] = array('error'=>$LANG_VARS['user_with_borrows_not_deactivated'],'detail'=>'');
			return FALSE;
		}
		else if(fetch_owner_borrowed_item_cnt($user_id)>0)
		{
			$errors[] = array('error'=>$LANG_VARS['user_with_owner_borrows_not_deactivated'],'detail'=>'');
			return FALSE;
		}
		else if($HTTP_VARS['confirmed'] == 'true')
		{
			// Cancel all reservations.
			$results = fetch_owner_reserved_item_rs($user_id);
			if($results)
			{
				while($borrowed_item_r = mysql_fetch_array($results, MYSQL_ASSOC))
				{
					cancel_reserve_item($borrowed_item_r['sequence_number']);
				}
				mysql_free_result($results);
			}
	
			$results = fetch_my_reserved_item_rs($user_id);
			if($results)
			{
				while($borrowed_item_r = mysql_fetch_array($results, MYSQL_ASSOC))
				{
					cancel_reserve_item($borrowed_item_r['sequence_number']);
				}
				mysql_free_result($results);
			}

			// deactivate user.
			if(deactivate_user($user_id))
				return TRUE;
			else
				return FALSE;
		}
		else if($HTTP_VARS['confirmed'] != 'false')// confirmation required.
		{
			return "__CONFIRM__";
		}
		else 
		{
			return "__ABORTED__";				
		}
	}
	else // if($CONFIG_VARS['user_admin.user_delete_support'] === 'deactivate')
	{
		$errors[] = array('error'=>$LANG_VARS['user_deactivate_not_supported'],'detail'=>'');
		return FALSE;
	}
}

function handle_user_activate($user_id, $HTTP_VARS, &$errors)
{
	if($HTTP_VARS['confirmed'] == 'true')
	{
		if(activate_user($user_id))
			return TRUE;
		else
			return FALSE;
	}
	else if($HTTP_VARS['confirmed'] != 'false')// confirmation required.
	{
		return "__CONFIRM__";
	}
	else 
	{
		return "__ABORTED__";				
	}
}

/*
* The validation for deleting a user, is exactly the same as for 
* deactivating one, except where this function actually returns
* __DEACTIVATE__, which indicates that the user is available for
* deactivation.
* 
* @param $op - 'delete' or 'deactivate' if delete is not possible because of
* borrowed items and/or item_instance records.
* 
*/
function handle_user_delete($user_id, $HTTP_VARS, &$errors)
{
	global $LANG_VARS;
	global $HTTP_SESSION_VARS;
	global $CONFIG_VARS;
	
	if($CONFIG_VARS['user_admin.user_delete_support'] === TRUE)
	{
		// We need to ensure that the user does not have any titles or borrowed/reserved items.
		if($user_id == $HTTP_SESSION_VARS['user_id'])
		{
			$errors[] = array('error'=>$LANG_VARS['cannot_delete_yourself'],'detail'=>'');
			return FALSE;
		}
		else if(fetch_my_borrowed_item_cnt($user_id)>0)
		{
			$errors[] = array('error'=>$LANG_VARS['user_with_borrows_not_deleted'],'detail'=>'');
			return FALSE;
		}
		else if(fetch_owner_borrowed_item_cnt($user_id)>0)
		{
			$errors[] = array('error'=>$LANG_VARS['user_with_owner_borrows_not_deleted'],'detail'=>'');
			return FALSE;
		}
		
		// Now that we can proceed, we need to know whether we are performing a Delete or Deactivate
		// operation.
		if($CONFIG_VARS['user_admin.user_delete_with_reviews']!==TRUE && is_user_author($user_id, TRUE)>0)
		{
			$errors = array('error'=>$LANG_VARS['user_with_reviews_not_deleted'],'detail'=>'');
			$confirm_operation = "__CONFIRM_DEACTIVATE__";
		}
		else if($CONFIG_VARS['item_input.allow_delete_with_closed_or_cancelled_borrow_records']!==TRUE && 
					$CONFIG_VARS['user_admin.user_delete_with_borrower_inactive_borrowed_items']!==TRUE && 
					(fetch_my_reserved_item_cnt($user_id)>0 || fetch_my_history_item_cnt($user_id)>0))
		{
			$errors = array('error'=>$LANG_VARS['user_with_inactive_borrowed_items_not_deleted'],'detail'=>'');
			$confirm_operation = "__CONFIRM_DEACTIVATE__";
		}
		else if($CONFIG_VARS['item_input.allow_delete_with_closed_or_cancelled_borrow_records']!==TRUE && 
					$CONFIG_VARS['user_admin.user_delete_with_owner_inactive_borrowed_items']!==TRUE && 
					(fetch_owner_reserved_item_cnt($user_id)>0 || fetch_owner_history_item_cnt($user_id)>0))
		{
			$errors = array('error'=>$LANG_VARS['user_with_owner_inactive_borrowed_items_not_deleted'],'detail'=>'');
			$confirm_operation = "__CONFIRM_DEACTIVATE__";
		}
		else // User can be completely deleted
		{
			$confirm_operation = "__CONFIRM__";
		}
				
		// If already confirmed operation.
		if($HTTP_VARS['confirmed'] == 'true')
		{
			// Cancel all reservations.
			$results = fetch_owner_reserved_item_rs($user_id);
			if($results)
			{
				while($borrowed_item_r = mysql_fetch_array($results, MYSQL_ASSOC))
				{
					cancel_reserve_item($borrowed_item_r['sequence_number']);
				}
				mysql_free_result($results);
			}
	
			$results = fetch_my_reserved_item_rs($user_id);
			if($results)
			{
				while($borrowed_item_r = mysql_fetch_array($results, MYSQL_ASSOC))
				{
					cancel_reserve_item($borrowed_item_r['sequence_number']);
				}
				mysql_free_result($results);
			}
				
			// We are proceeding with the delete operation here.
			if($confirm_operation == "__CONFIRM__")
			{
				// Delete all user reviews.
				if(is_user_author($user_id))
				{
					delete_author_reviews($user_id);
				}
				
				// Delete all inactive borrowed items
				delete_my_inactive_borrowed_items($user_id);
				
				// If no items, we can proceed to delete user.
				$results = fetch_owner_item_instance_rs($user_id);
				if($results)
				{
					// For each item, check if there are any dependencies.  If not, delete the
					// item_instance, and the item itself if no other instances.  Delete all
					// reviews, if this is the only dependency.
					while($item_r = mysql_fetch_array($results, MYSQL_ASSOC))
					{
						// Force it to true, so that the handle_item_delete function will remove inactive borrowed thems.
						$CONFIG_VARS['item_input.allow_delete_with_closed_or_cancelled_borrow_records'] = TRUE;
						//delete_item_instance_inactive_borrowed_items($item_r['item_id'], $item_r['instance_no']);
						
						// The handle_item_delete does all the required checking before proceeding to
						// delete the item, so call - and programmatically set the 'confirmed = true' setting.
						if(!handle_item_delete(NULL, $item_r, fetch_status_type_r($item_r['s_status_type']), array('confirmed'=>'true'), $error))
						{
							$errors[] = $error;
						}
					}
					mysql_free_result($results);
				}
			}//if($confirm_operation == "__CONFIRM__")
			
			if($confirm_operation == "__CONFIRM_DEACTIVATE__" || 
						is_user_author($user_id, TRUE) || // If user has any dependent records left we cannot continue.
						is_exists_borrower_borrowed_item($user_id) || 
						is_exists_item_instance_with_owner($user_id))
			{
				if(deactivate_user($user_id))
					return "__DEACTIVATED__";
				else
					return FALSE;
			}
			else // user can be completely deleted.
			{
				// delete user addresses first.
				if(delete_user_addresses($user_id))
				{
					if(delete_user($user_id))
						return TRUE;
					else
					{
						$errors = array('error'=>$LANG_VARS['user_not_deleted'],'detail'=>mysql_error());
						return FALSE;
					}
				}
				else
				{
					$errors = array('error'=>$LANG_VARS['user_not_deleted'],'detail'=>mysql_error());
					return FALSE;
				}
			}
		}
		else if($HTTP_VARS['confirmed'] != 'false')// confirmation required.
		{
			return $confirm_operation;
		} 
		else 
		{
			return "__ABORTED__";				
		}
	}
	else // if($CONFIG_VARS['user_admin.user_delete_support'] === TRUE)
	{
		$errors = array('error'=>$LANG_VARS['user_delete_not_supported'],'detail'=>'');
		return FALSE;
	}
}

/**
 Signup functions

	@param $newuser_signup_restrict_usertypes A restricted list of user types to display
		the form for, should be at least two types.
*/
function get_user_type_signup_form($newuser_signup_restrict_usertypes)
{
	global $LANG_VARS;
	global $PHP_SELF;
	
	$buffer = "\n<form action=\"$PHP_SELF\" method=\"get\">".
		"\n<input type=hidden name=\"op\" value=\"signup\">";
	
	$checked = FALSE;
	
	while(list($key, $value) = each($newuser_signup_restrict_usertypes))
	{
		$buffer .= "\n<p><h3><input type=\"radio\" name=\"user_type\" value=\"$value\"".(!$checked?" CHECKED":"").">".get_usertype_description($value)."</h3>".
			$LANG_VARS['new_account_usertype_intro'][$value].
				"</p>";
		
		//flag to indicate we have checked first option
		if(!$checked)
			$checked=TRUE;
	}
	
	$buffer .= "\n<input type=\"submit\" value=\"".$LANG_VARS['continue']."\">".
			"\n</form>";
	
	return $buffer;
}

/**
* This function will not be called, unless PHP email is functional.
*/
function signup_send_info($HTTP_VARS, &$errors)
{
	global $CONFIG_VARS;
	global $LANG_VARS;
	global $PHP_SELF;
	
	$http_vars['user_id'] = $HTTP_VARS['user_id'];
	$http_vars['fullname'] = $HTTP_VARS['fullname'];
	$http_vars['user_type'] = $HTTP_VARS['user_type'];
	$http_vars['pwd'] = $HTTP_VARS['pwd'];
	$http_vars['confirmpwd'] = $HTTP_VARS['pwd'];
	
	if(!is_user_valid($HTTP_VARS['user_id']))
	{	
		$user_info_lines = $LANG_VARS['userid'].": ".$HTTP_VARS['user_id'];
	}
	else
	{	
		$user_info_lines = $LANG_VARS['userid'].": ".$HTTP_VARS['user_id']
						." (".replace_lang_var('user_id', $HTTP_VARS['user_id'], $LANG_VARS['user_exists']).")";
	}
	
	$user_info_lines .= 
		"\n".$LANG_VARS['fullname'].": ".$HTTP_VARS['fullname'].
		"\n".$LANG_VARS['new_passwd'].": ".$HTTP_VARS['pwd'].
		"\n".$LANG_VARS['user_type'].": ".get_usertype_description($HTTP_VARS['user_type']).
		"\n".$LANG_VARS['user_theme'].": ".$HTTP_VARS['uid_theme'];
	
	$email_addr = NULL;
	
	$addr_results = fetch_address_type_rs($HTTP_VARS['user_type'], TRUE);
	if($addr_results)
	{
		while($address_type_r = mysql_fetch_array($addr_results, MYSQL_ASSOC))
		{
			$address_type = strtolower($address_type_r['s_address_type']);
			$attr_results = fetch_address_type_attribute_type_rs($address_type_r['s_address_type'], $HTTP_VARS['user_type'], 'update', TRUE);
			if($attr_results)
			{
				while($addr_attribute_type_r = mysql_fetch_array($attr_results, MYSQL_ASSOC))
				{
					$fieldname = get_field_name($addr_attribute_type_r['s_attribute_type'], $addr_attribute_type_r['order_no']);
	
					// get the email_addresss field.
					if(is_array($CONFIG_VARS['email.user_address_attribute']) && 
							isset($CONFIG_VARS['email.user_address_attribute']['s_attribute_type']) && 
							strcasecmp($addr_attribute_type_r['s_attribute_type'], 
									$CONFIG_VARS['email.user_address_attribute']['s_attribute_type']) === 0)
					{
						$email_addr = $HTTP_VARS[$address_type][$fieldname];
					}
			
					// may have to change this if statement, if fieldname will contain array, instead of scalar value
					if(is_not_empty_array($HTTP_VARS[$address_type][$fieldname]) || 
							(!is_array($HTTP_VARS[$address_type][$fieldname]) && strlen($HTTP_VARS[$address_type][$fieldname])>0))
					{
						$http_vars[$address_type][$fieldname] = $HTTP_VARS[$address_type][$fieldname];
						
						if(is_not_empty_array($HTTP_VARS[$address_type][$fieldname]))
						{
							$value = '';	
							for($i=0; $i<count($HTTP_VARS[$address_type][$fieldname]); $i++)
							{
								if(strlen($value)>0)
									$value .= ',';
								
								$value .= $HTTP_VARS[$address_type][$fieldname][$i];
							}
						}
						else
						{
							$value = $HTTP_VARS[$address_type][$fieldname];
						}
						$user_info_lines .= "\n".$addr_attribute_type_r['prompt'].": ".$value;
					}
				}
				mysql_free_result($attr_results);
			}//if($attr_results)
		}
		mysql_free_result($addr_results);
	}//if($addr_results)
	
	$http_vars['email_user'] = 'Y';
	$url = get_site_url().'user_admin.php?op=insert&'.get_url_string($http_vars);
		
	$message = 
		replace_lang_vars(
			array(
				'admin_name'=>$CONFIG_VARS['site.admin_name'],
				'user_info'=>$user_info_lines,
				'site'=>$CONFIG_VARS['site.title'],
				'url'=>$url),
			expand_langvar_newlines($LANG_VARS['new_account_email']));

	// if $email_addr is not compulsory for a user, then use the administrators
	// own from address instead.	
	if(strlen($email_addr)==0)
	{
		$email_addr = $CONFIG_VARS['site.admin_email'];
	}
	
	$results = opendb_email(
			$CONFIG_VARS['site.admin_email'], // to email
			$CONFIG_VARS['site.admin_name'], // to name
			$email_addr, // from email
			$HTTP_VARS['fullname'], // from name
			$LANG_VARS['new_account'],
			$message);
	
	if($results !== TRUE)
	{
		$errors = $results;
		return FALSE;
	}
	else
	{
		return TRUE;
	}
}

if($CONFIG_VARS['site.enable']!==FALSE)
{
	session_start();
	if(is_opendb_valid_session() || $HTTP_VARS['op'] == 'signup')
	{ 
		if ( $HTTP_VARS['op'] == 'signup' || 
					($HTTP_VARS['user_id'] === $HTTP_SESSION_VARS['user_id'] && 
					$HTTP_VARS['op'] != 'insert' && 
					$HTTP_VARS['op'] != 'new_user' && 
					$HTTP_VARS['op'] != 'deactivate' && 
					is_user_allowed_to_edit_info($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']) ) || 
					is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']) ) // Can only access if admin or own user (not guest) record.
		{
			if($HTTP_VARS['op'] == 'insert') //inserting a new record.
			{
				echo _theme_header($LANG_VARS['create_new_user']);
				echo("<h2>".$LANG_VARS['create_new_user']."</h2>");
				
				$return_val = handle_user_insert($HTTP_VARS, $errors);
				if($return_val !== FALSE)
				{
					echo("\n<div class=\"success\">".replace_lang_var("user_id", $HTTP_VARS['user_id'], $LANG_VARS['user_added'])."</div>");
					if($HTTP_VARS['email_user'] == 'Y')
					{
						$from = NULL;
						$from_name = NULL;
						
						if($CONFIG_VARS['user_admin.welcome_email_use_admin_email']!==FALSE)
						{
							$from = $CONFIG_VARS['site.admin_email'];
							$from_name = $CONFIG_VARS['site.admin_name'];
						}
						else
						{
							$from       = fetch_user_email($HTTP_SESSION_VARS['user_id']);
							$from_name  = fetch_user_name($HTTP_SESSION_VARS['user_id']);
						}

						$subject    = replace_lang_var("site", $CONFIG_VARS['site.title'], $LANG_VARS['welcome_to_site']);
						$message    = replace_lang_var("fullname", fetch_user_name($HTTP_VARS['user_id']), expand_langvar_newlines($LANG_VARS['to_user_email_intro'])).
									"\n\n".
										expand_langvar_newlines(replace_lang_var("site", $CONFIG_VARS['site.title'], $LANG_VARS['welcome_email'])).
									 "\n\n".
				    	    	     $LANG_VARS['userid'].": ".$HTTP_VARS['user_id']."\n".
				        	    	 $LANG_VARS['new_passwd'].": ".$HTTP_VARS['pwd'];
						
						if(is_user_allowed_to_edit_info($HTTP_VARS['user_id']))
						{ 
							// Provide a link to open User Info form in edit mode.
							$message .= "\n\n".
								$LANG_VARS['edit_my_info'].":\n".
									"    ".get_site_url()."user_admin.php?op=edit&user_id=".urlencode($HTTP_VARS['user_id']);
					 	}
					 	
						$email_addr = fetch_user_email($HTTP_VARS['user_id']);
						if(is_valid_email_addr($email_addr))
						{
							// In this case ask the email function not to append [OpenDb] to subject line, as we will already
							// be including it!
							$results = opendb_email(
										$email_addr, 
										$HTTP_VARS['fullname'], 
										$from, 
										$from_name, 
										$subject, 
										$message,
										FALSE);
							if($results!==TRUE)
							{
								echo format_error_block(
									array('error'=>replace_lang_vars(array("fullname"=>$HTTP_VARS['fullname'],"user_id"=>$HTTP_VARS['user_id']), $LANG_VARS['welcome_email_error']),'detail'=>$results));
							}
							else
							{
								echo("\n<br><div class=\"smsuccess\">".replace_lang_vars(array("fullname"=>$HTTP_VARS['fullname'],"user_id"=>$HTTP_VARS['user_id']), $LANG_VARS['welcome_email_sent'])."</div>");
							}
						}// ignore - assume email address is not compulsory, because otherwise, the user would not have been added
					}
					
					$footer_links_r[] = array(url=>"$PHP_SELF?op=edit&user_id=".$HTTP_VARS['user_id'],text=>($HTTP_VARS['user_id'] == $HTTP_SESSION_VARS['user_id']?$LANG_VARS['edit_my_info']:$LANG_VARS['edit_user_info']));
				}
				else // $return_val === FALSE
				{
					echo format_error_block($errors);
					if(is_usertype_valid($HTTP_VARS['user_type']))
					{
						echo(get_user_input_form(NULL, $HTTP_VARS));
					}
					else
					{
						echo(get_new_user_usertype_input_form($HTTP_VARS, get_user_types_r(), 'N'));
					}
				}
			}
			else if($HTTP_VARS['op'] == 'update')
			{
				if($HTTP_VARS['user_id'] == $HTTP_SESSION_VARS['user_id'])
					$page_title = $LANG_VARS['my_info'];
				else
					$page_title = $LANG_VARS['user_info'];
				
				echo _theme_header($page_title);
				echo("<h2>".$page_title."</h2>");
				
				if(handle_user_update($HTTP_VARS, $errors))
				{
					echo("<div class=\"success\">".$LANG_VARS['user_updated']."</div>");
					
					// Any warnings that should be displayed.
					if($errors!==NULL)
						echo format_error_block($errors);
						
					// If updating current user, then update theme!!!
					if($HTTP_VARS['user_id'] === $HTTP_SESSION_VARS['user_id']) 
					{
						if(strlen($HTTP_VARS['uid_theme'])>0)
						{
							$HTTP_SESSION_VARS['user_theme'] = $HTTP_VARS['uid_theme'];
							if(is_register_globals_enabled())
							{
								session_register("user_theme");
								$user_theme = $HTTP_SESSION_VARS['user_theme'];
							}
						}
						
						if(strlen($HTTP_VARS['uid_language'])>0)
						{
							$HTTP_SESSION_VARS['user_language'] = $HTTP_VARS['uid_language'];
							if(is_register_globals_enabled())
							{
								session_register("user_language");
								$user_language = $HTTP_SESSION_VARS['user_language'];
							}
						}
					}
					
					$footer_links_r[] = array(url=>"$PHP_SELF?op=edit&user_id=".$HTTP_VARS['user_id'],text=>($HTTP_VARS['user_id'] == $HTTP_SESSION_VARS['user_id']?$LANG_VARS['edit_my_info']:$LANG_VARS['edit_user_info']));
				}
				else
				{
					echo format_error_block($errors);
					
					$user_r = fetch_user_r($HTTP_VARS['user_id']);
					if(is_not_empty_array($user_r))
					{
						echo get_user_input_form($user_r,$HTTP_VARS);
					}
					else //user not found.
					{
						echo _theme_error(
								replace_lang_var("user_id", $HTTP_VARS['user_id'], $LANG_VARS['user_not_found']));
					}
				}
			}
			else if($HTTP_VARS['op'] == 'delete')
			{
				echo _theme_header($LANG_VARS['delete_user']);
				echo("<h2>".$LANG_VARS['delete_user']."</h2>");
	
				if(is_user_valid($HTTP_VARS['user_id']))
				{
					$return_val = handle_user_delete($HTTP_VARS['user_id'], $HTTP_VARS, $errors);
					if($return_val === '__CONFIRM__')
					{
						echo get_op_confirm_form(
								$PHP_SELF,
								replace_lang_vars(array("fullname"=>fetch_user_name($HTTP_VARS['user_id']),"user_id"=>$HTTP_VARS['user_id']), $LANG_VARS['confirm_user_delete']), 
								$HTTP_VARS);
					}
					else if($return_val === '__CONFIRM_DEACTIVATE__')
					{
						echo format_error_block($errors);
						echo get_op_confirm_form(
										$PHP_SELF, 
										replace_lang_vars(array("fullname"=>fetch_user_name($HTTP_VARS['user_id']),"user_id"=>$HTTP_VARS['user_id']), $LANG_VARS['confirm_user_delete_deactivate']),
										$HTTP_VARS);
					}
					else if($return_val === '__ABORTED__')
					{
						echo("<div class=\"success\">".$LANG_VARS['user_not_deleted']."</div>");
						$footer_links_r[] = array(url=>"$PHP_SELF?op=edit&user_id=".$HTTP_VARS['user_id'],text=>($HTTP_VARS['user_id'] == $HTTP_SESSION_VARS['user_id']?$LANG_VARS['edit_my_info']:$LANG_VARS['edit_user_info']));
					}
					else if($return_val === '__DEACTIVATED__')
					{
						echo("<div class=\"success\">".$LANG_VARS['user_deactivated']."</div>");
					}
					else if($return_val === TRUE)
					{
						echo("<div class=\"success\">".$LANG_VARS['user_deleted']."</div>");
					}
					else //if($return_val === FALSE)
					{
						echo format_error_block($errors);
					}
				}
				else
				{
					echo _theme_error(
							replace_lang_var("user_id", $HTTP_VARS['user_id'], $LANG_VARS['user_not_found']));
				}				
			}
			else if($HTTP_VARS['op'] == 'deactivate')
			{
				echo _theme_header($LANG_VARS['deactivate_user']);
				echo("<h2>".$LANG_VARS['deactivate_user']."</h2>");
					
				if(is_user_valid($HTTP_VARS['user_id']))
				{
					// user has to be currently active for a deactivation process to succeed
					if(is_user_active($HTTP_VARS['user_id']))
					{
						$return_val = handle_user_deactivate($HTTP_VARS['user_id'], $HTTP_VARS, $errors);
						if($return_val === "__CONFIRM__")
						{
							echo get_op_confirm_form(
								$PHP_SELF, 
								replace_lang_vars(array("fullname"=>fetch_user_name($HTTP_VARS['user_id']),"user_id"=>$HTTP_VARS['user_id']), $LANG_VARS['confirm_user_deactivate']), 
								$HTTP_VARS);
						}
						else if($return_val === "__ABORTED__")
						{
							echo("<div class=\"success\">".$LANG_VARS['user_not_deactivated']."</div>");
							$footer_links_r[] = array(url=>"$PHP_SELF?op=edit&user_id=".$HTTP_VARS['user_id'],text=>$LANG_VARS['edit_user_info']);
						}
						else if($return_val === TRUE)
						{
							echo("<div class=\"success\">".$LANG_VARS['user_deactivated']."</div>");
						}
						else //if($return_val === FALSE)
						{
							echo format_error_block($errors);
							$footer_links_r[] = array(url=>"$PHP_SELF?op=edit&user_id=".$HTTP_VARS['user_id'],text=>$LANG_VARS['edit_user_info']);
						}
					}//if(is_user_active($HTTP_VARS['user_id']))
					else
					{
						echo format_error_block($LANG_VARS['operation_not_available']);
					}
				}
				else
				{
					echo _theme_error(
							replace_lang_var("user_id", $HTTP_VARS['user_id'], $LANG_VARS['user_not_found']));
				}
			}
			else if($HTTP_VARS['op'] == 'activate')
			{
				echo _theme_header($LANG_VARS['activate_user']);
				echo("<h2>".$LANG_VARS['activate_user']."</h2>");
				
				if(is_user_valid($HTTP_VARS['user_id']))
				{
					// user must be deactivated in order for this process to continue.
					if(!is_user_active($HTTP_VARS['user_id']))
					{
						$return_val = handle_user_activate($HTTP_VARS['user_id'], $HTTP_VARS, $errors);
						if($return_val === '__CONFIRM__')
						{
							echo get_op_confirm_form(
								$PHP_SELF, 
								replace_lang_vars(array("fullname"=>fetch_user_name($HTTP_VARS['user_id']),"user_id"=>$HTTP_VARS['user_id']), $LANG_VARS['confirm_user_activate']), 
								$HTTP_VARS);
						}
						else if($return_val === '__ABORTED__')
						{
							echo("<div class=\"success\">".$LANG_VARS['user_not_activated']."</div>");
						}
						else if($return_val === TRUE)
						{
							echo("<div class=\"success\">".$LANG_VARS['user_activated']."</div>");
							$footer_links_r[] = array(url=>"$PHP_SELF?op=edit&user_id=".$HTTP_VARS['user_id'],text=>$LANG_VARS['edit_user_info']);
						}
						else 
						{
							echo format_error_block($errors);
							$footer_links_r[] = array(url=>"$PHP_SELF?op=edit&user_id=".$HTTP_VARS['user_id'],text=>$LANG_VARS['edit_user_info']);
						}
					}//if(!is_user_active($HTTP_VARS['user_id']))
					else
					{
						echo format_error_block($LANG_VARS['operation_not_available']);
					}
				}
				else
				{
					echo _theme_error(
							replace_lang_var("user_id", $HTTP_VARS['user_id'], $LANG_VARS['user_not_found']));
				}
			}
			else if($HTTP_VARS['op'] == 'new_user')
			{
				echo _theme_header($LANG_VARS['create_new_user']);
				echo("<h2>".$LANG_VARS['create_new_user']."</h2>");
				
				if(is_usertype_valid($HTTP_VARS['user_type']))
				{
					echo(get_user_input_form(NULL, $HTTP_VARS));
				}
				else
				{
					echo(get_new_user_usertype_input_form($HTTP_VARS, get_user_types_r(), 'N'));
				}
			}
			else if ($HTTP_VARS['op'] == 'edit')
			{
				if($HTTP_VARS['user_id'] == $HTTP_SESSION_VARS['user_id'])
					$page_title = $LANG_VARS['my_info'];
				else
					$page_title = $LANG_VARS['user_info'];
					
				echo _theme_header($page_title);
				echo("<h2>".$page_title."</h2>");
	
				$user_r = fetch_user_r($HTTP_VARS['user_id']);
				if(is_not_empty_array($user_r))
				{
					echo(get_user_input_form($user_r, $HTTP_VARS));
				}
				else //user not found.
				{
					echo(_theme_error(replace_lang_var("user_id", $HTTP_VARS['user_id'], $LANG_VARS['user_not_found'])));
				}
			}
			else if($HTTP_VARS['op'] == 'signup')
			{
				if($CONFIG_VARS['newuser.signup_enable']!==FALSE)
				{
					// if no array defined, enforce default choices
					if(is_empty_array($CONFIG_VARS['newuser.signup_restrict_usertypes']))
					{
						$CONFIG_VARS['newuser.signup_restrict_usertypes'] = array('B', 'N');
					}
					
					if(count($CONFIG_VARS['newuser.signup_restrict_usertypes']) == 1)
					{
						// if only one usertype, then assign it to user_type variable, so we
						// can pretend it was user specified.
						$HTTP_VARS['user_type'] = $CONFIG_VARS['newuser.signup_restrict_usertypes'][0];
					}
					
					// either valid usertype, or a single user type specified
					if(is_usertype_valid($HTTP_VARS['user_type']))
					{
						if($HTTP_VARS['op2'] == 'send_info')
						{
							$page_title = replace_lang_var('site', $CONFIG_VARS['site.title'], $LANG_VARS['new_site_account']);
							echo(_theme_header($page_title));
							echo("<h2>".$page_title."</h2>");
							
							// The handle_user_insert will not perform any actual inserts, but only validate all the input fields.
							if(!is_user_valid($HTTP_VARS['user_id']))
								$returl_val = handle_user_insert($HTTP_VARS, $errors);
							else // pretend the user does not exist - as we do not want to provide ability to work out what userid's do exist
								$returl_val = TRUE;
								
							if($returl_val !== FALSE)
							{
								if(signup_send_info($HTTP_VARS, $errors))
								{
									echo("\n<div class=\"success\">".replace_lang_var('site', $CONFIG_VARS['site.title'], $LANG_VARS['new_account_reply'])."</div>");
									echo("\n<div class=\"smsuccess\"><br>".replace_lang_var('site', $CONFIG_VARS['site.title'], $LANG_VARS['new_account_admin_email_sent'])."</div>");
								}
								else
								{
									echo(format_error_block($errors));
								}
							}
							else // $return_val === FALSE
							{
								echo(format_error_block($errors));
								echo(get_user_input_form(NULL, $HTTP_VARS));
							}
						}//if($HTTP_VARS['op2'] == 'send_info')
						else
						{
							$page_title = replace_lang_var('site', $CONFIG_VARS['site.title'], $LANG_VARS['new_site_account']);
							echo(_theme_header($page_title));
							echo("<h2>".$page_title."</h2>");
							echo(get_user_input_form(NULL, $HTTP_VARS));
						}
					}
					else
					{
						$page_title = replace_lang_var('site', $CONFIG_VARS['site.title'], $LANG_VARS['new_site_account']);
						echo(_theme_header($page_title));
						echo("\n<h2>".$page_title."</h2>");
						echo(get_user_type_signup_form($CONFIG_VARS['newuser.signup_restrict_usertypes']));
					}
				}
				else
				{
					echo _theme_header($LANG_VARS['operation_not_available']);
					echo _theme_error($LANG_VARS['operation_not_available']);	
				}
				
				echo(format_footer_links(array(array(url=>"login.php?op=login",text=>$LANG_VARS['return_to_login_page']))));
				
			}//End of $HTTP_VARS['op'] checks
			else
			{
				echo _theme_header($LANG_VARS['operation_not_available']);
				echo _theme_error($LANG_VARS['operation_not_available']);	
			}
		}//not an administrator or own user.
		else
		{
			echo _theme_header($LANG_VARS['not_authorized_to_page']);
			echo _theme_error($LANG_VARS['not_authorized_to_page']);
		}
		
		echo format_footer_links($footer_links_r);
		echo _theme_footer();
	}
	else
	{
		// invalid login, so login instead.
		include("./login.php");
	}
}//if($CONFIG_VARS['site.enable']!==FALSE)
else
{
	echo _theme_header($LANG_VARS['site_is_disabled'], FALSE);
	echo _theme_error($LANG_VARS['site_is_disabled']);
	echo _theme_footer();
}

// Cleanup after begin.inc.php
require_once("./include/end.inc.php");
?>