###################################################################
# Support for Games
# by Guillaume Proux, Jason Pell & Marc Powell
###################################################################
#

#
# Cleanup first.
#
DELETE FROM s_item_type WHERE s_item_type = 'GAME';
DELETE FROM s_item_attribute_type WHERE s_item_type = 'GAME';
DELETE FROM s_attribute_type WHERE s_attribute_type IN('GAMESYSTEM', 'GAMEPBLSHR', 'GAMEPBDATE', 'NO_PLAYERS', 'GAMEGENRE', 'CONTROLLER','GAMERATING', 'FEATURES', 'GAME_PLOT');
DELETE FROM s_attribute_type_lookup WHERE s_attribute_type  IN('GAMEGENRE', 'GAMESYSTEM', 'GAMERATING');

#
# Item type
#
INSERT INTO s_item_type (s_item_type, description, image, order_no) VALUES ( 'GAME', 'Console / PC Game', 'joystick.gif', '10');

#
# New s_attribute_types required
# The COMMENTS & IMAGEURL s_attribute_type's already exists.
#
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'GAMESYSTEM', 'Game System', 'System', 'radio_grid(%img% %display%, 3)', 'display(%img% %display%, list-link)', NULL, NULL);
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'GAMEPBLSHR', 'Publisher', 'Publisher', 'text(50)', 'display(%value%, list-link)', NULL, NULL);
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'GAMEPBDATE', 'Date Published', 'Published', 'filtered(10,10,0-9/, %field% (DD/MM/YYYY))', '%value%', NULL, NULL);
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'NO_PLAYERS', 'Number Players', 'Players', 'value_select(\"1,2,3,4,5,6,7,8,9,10\")', 'display(%value%, list-link)', NULL, NULL);
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'GAMEGENRE', 'Game Genre', 'Genre', 'checkbox_grid(%display%, 4)', 'category(%display%, list-link)', 'CATEGORY', NULL);
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'CONTROLLER', 'Special Controller', 'Special Controller', 'text(50)', '%value%', NULL, NULL);
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'GAMERATING', 'ESRB Video and Computer Game Rating', 'Rating', 'radio_grid(%img% %display%, 3)', 'display(%img% %display%, list-link)', NULL, NULL);
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'GAME_PLOT', 'Description of game', 'Description', 'textarea(50,5)', '%value%', NULL, NULL);
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'FEATURES', 'Game Extra Features Details', 'Features', 'textarea(50,5)', 'list(ticks)', NULL, NULL);
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'GAMEREGION','Game Region','Region','single_select(%display%)','display(%display%, list-link)', NULL, NULL);

#
# s_item_attribute_type relationships
#
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'GAME', 'AMAZONASIN', '0', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'GAME', 'S_TITLE', '1', NULL, 'Y');
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'GAME', 'IMAGEURL', '2', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'GAME', 'GAME_PLOT', '10', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'GAME', 'GAMEPBLSHR', '20', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'GAME', 'GAMESYSTEM', '30', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'GAME', 'GAMEGENRE', '40', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'GAME', 'GAMEPBDATE', '45', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'GAME', 'NO_PLAYERS', '50', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'GAME', 'CONTROLLER', '60', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'GAME', 'GAMERATING', '65', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'GAME', 'FEATURES', '70', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'GAME', 'COMMENTS', '70', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'GAME', 'S_DURATION', '200', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'GAME', 'S_STATUS', '254', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'GAME', 'S_STATCMNT', '255', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'GAME', 'GAMEREGION', '43', NULL, NULL);

#
# s_attribute_type_lookup values
#
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'GAMEGENRE', NULL, 'Action', NULL, NULL,'Y');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'GAMEGENRE', NULL, 'Puzzle', NULL, NULL,NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'GAMEGENRE', NULL, 'Strange', NULL, NULL,NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'GAMEGENRE', NULL, 'Adventure', NULL, NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'GAMEGENRE', NULL, 'Exploration', NULL, NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'GAMEGENRE', NULL, 'RPG', NULL, NULL,NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'GAMEGENRE', NULL, 'Fighting', NULL, NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'GAMEGENRE', NULL, 'Race', NULL, NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'GAMEGENRE', NULL, 'Futuristic', NULL, NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'GAMEGENRE', NULL, 'Shooting', NULL, NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'GAMEGENRE', NULL, 'Platform', NULL, NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'GAMEGENRE', NULL, 'Sports', NULL, NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'GAMEGENRE', NULL, 'MusicSimulation', 'Music Simulation', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'GAMEGENRE', NULL, 'FlightSimulation', 'Flight Simulation', NULL, NULL);

INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ('GAMESYSTEM', '1', 'PS1', 'Playstation', 'ps1.gif', NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ('GAMESYSTEM', '2', 'PS2', 'Playstation 2', 'ps2.gif', NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ('GAMESYSTEM', '3', 'DREAMCAST', 'Dreamcast', 'dreamcast.gif', NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ('GAMESYSTEM', '4', 'GAMEBOY', 'Gameboy', 'gameboy.gif', NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ('GAMESYSTEM', '5', 'GAMEBOYADVANCE', 'Gameboy ADVANCE', 'gba.gif', NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ('GAMESYSTEM', '6', 'N64', 'Nintendo 64', 'n64.gif', NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ('GAMESYSTEM', '7', 'GAMECUBE', 'Game Cube', 'gamecube.gif', NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ('GAMESYSTEM', '8', 'XBOX', 'Xbox', 'xbox.gif', NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ('GAMESYSTEM', '9', 'PCCDROM', 'PC-Cdrom', 'pc-cdrom.gif', NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ('GAMESYSTEM', '9', 'MACCDROM', 'Mac-Cdrom', 'apple.gif', NULL);

# This is the american ESRB rating system.
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'GAMERATING', '0', 'EC', 'Early Childhood', 'game/game_ec.gif', NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'GAMERATING', '1', 'K-A', 'Kids to Adults', 'game/game_ka.gif', NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'GAMERATING', '2', 'E', 'Everyone', 'game/game_e.gif', 'Y');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'GAMERATING', '3', 'T', 'Teen', 'game/game_t.gif', NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'GAMERATING', '4', 'M', 'Mature', 'game/game_m.gif', NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'GAMERATING', '5', 'AO', 'Adults Only', 'game/game_ao.gif', NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'GAMERATING', '6', 'RP', 'Rating Pending', 'game/game_rp.gif', NULL);

#
# Game Region
#
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ('GAMEREGION',NULL,'US','United States','usa.gif',NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ('GAMEREGION',NULL,'JP','Japan','japanese.gif',NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ('GAMEREGION',NULL,'EU_DE','Germany','german.gif',NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ('GAMEREGION',NULL,'EU_UK','England','english.gif',NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ('GAMEREGION',NULL,'EU_FR','France','french.gif',NULL); 
