<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// This must be first - includes config.php
require_once("./include/begin.inc.php");

include_once("./include/language.php");
include_once("./include/theme.php");

include_once("./functions/database.php");
include_once("./functions/auth.php");
include_once("./functions/logging.php");

include_once("./functions/utils.php");
include_once("./functions/datetime.php");
include_once("./functions/http.php");
include_once("./functions/user.php");
include_once("./functions/review.php");
include_once("./functions/borrowed_item.php");
include_once("./functions/item.php");
include_once("./functions/widgets.php");
include_once("./functions/item_type.php");
include_once("./functions/listutils.php");
include_once("./functions/status_type.php");
include_once("./functions/export.php");
include_once("./functions/item_attribute.php");
include_once("./functions/thumbnails.php");

//For site plugins.
include_once("./functions/site_plugin.php");

function get_list_username($user_id, $mode, $subject=NULL, $allow_email=FALSE, $redirect_link=NULL, $redirect_url=NULL)
{
	global $HTTP_SESSION_VARS;
	global $LANG_VARS;
	global $CONFIG_VARS;
	
	// Do not include email link, if Current User.
	if($user_id == $HTTP_SESSION_VARS['user_id'])
	{
		return replace_lang_vars(array('fullname'=>str_replace(" ", "&nbsp;", fetch_user_name($user_id)), 'user_id'=>$user_id), str_replace(" ", "&nbsp;", $LANG_VARS['current_user']));	
	}
	else
	{
		$user_name = replace_lang_vars(array('fullname'=>str_replace(" ", "&nbsp;", fetch_user_name($user_id)), 'user_id'=>$user_id), $LANG_VARS['user_name']);
		if($mode != 'printable' && $allow_email!==FALSE && is_user_allowed_to_borrow($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']))
			return "<a href=\"email.php?op=send_to_uid&uid=".$user_id."&subject=".urlencode(ifempty($subject, $LANG_VARS['no_subject']))."&redirect_link=".urlencode($redirect_link)."&redirect_url=".urlencode($redirect_url)."\" title=\"".htmlspecialchars($LANG_VARS['send_email'])."\">$user_name</a>";
		else
			return $user_name;
	}
}

/**
	@selected will be currently selected record.

	$borrow_duration is the item_instance.borrow_duration value in all cases, the rest of the values to do
	with borrow duration will be calculated.
*/
function get_item_status_row($class, $item_r, $listing_link, $selected)
{
	global $LANG_VARS;
	global $CONFIG_VARS;
	global $HTTP_SESSION_VARS;
	global $HTTP_VARS;

	$rowcontents = "\n<tr><td class=\"$class\" align=center>".$item_r['instance_no'];
	if($selected)
		$rowcontents .= "&nbsp;"._theme_image("tick.gif", NULL, $LANG_VARS['current_item_instance']);
	$rowcontents .= "\n</td>";
	
	$page_title = expand_item_title_mask($item_r, $CONFIG_VARS['item_display.title_display_mask']);
	$rowcontents .= "<td class=\"$class\" align=center>".
			get_list_username($item_r['owner_id'], $HTTP_VARS['mode'], $page_title, $CONFIG_VARS['item_display.owner_email_link'], $LANG_VARS['back_to_item'], 'item_display.php?item_id='.$item_r['item_id'].'&instance_no='.$item_r['instance_no'].(strlen($listing_link)>0?'&listing_link='.$listing_link:'')).
			"</td>";
	
	$status_type_r = fetch_status_type_r($item_r['s_status_type']);		
	
	// ---------------------- Borrow,Reserve,Cancel,Edit,Delete,etc operations here.
	$action_links_rs = NULL;
	
	if($HTTP_VARS['mode'] != 'printable')
	{
		if($HTTP_SESSION_VARS['user_id'] === $item_r['owner_id'] || is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']))
		{
			if($status_type_r['change_owner_ind'] == 'Y' && !is_item_borrowed($item_r['item_id'], $item_r['instance_no']))
			{
				$action_links_rs[] = array(url=>'item_input.php?op=change_owner&item_id='.$item_r['item_id'].'&instance_no='.$item_r['instance_no'].(strlen($listing_link)>0?'&listing_link='.$listing_link:''),img=>'change_owner.gif',text=>$LANG_VARS['change_owner']);		
			}
			
			$action_links_rs[] = array(url=>'item_input.php?op=updateinstance&item_id='.$item_r['item_id'].'&instance_no='.$item_r['instance_no'].(strlen($listing_link)>0?'&listing_link='.$listing_link:''), img=>'update.gif', text=>$LANG_VARS['update']);
			$action_links_rs[] = array(url=>'item_input.php?op=edit&item_id='.$item_r['item_id'].'&instance_no='.$item_r['instance_no'].(strlen($listing_link)>0?'&listing_link='.$listing_link:''),img=>'edit.gif',text=>$LANG_VARS['edit']);
									
			// Checks if any legal site plugins defined for $item_r['s_item_type']
			if(is_item_legal_site_type($item_r['s_item_type']))
			{
				$action_links_rs[] = array(url=>'item_add.php?item_id='.$item_r['item_id'].'&instance_no='.$item_r['instance_no'].'&item_link=y'.(strlen($listing_link)>0?'&listing_link='.$listing_link:''),img=>'refresh.gif',text=>$LANG_VARS['refresh']);
			}
			
			if($status_type_r['delete_ind'] == 'Y' && !is_item_reserved_or_borrowed($item_r['item_id'], $item_r['instance_no']))
			{
				$action_links_rs[] = array(url=>'item_input.php?op=delete&item_id='.$item_r['item_id'].'&instance_no='.$item_r['instance_no'].(strlen($listing_link)>0?'&listing_link='.$listing_link:''),img=>'delete.gif',text=>$LANG_VARS['delete']);		
			}
			
			// Quick checkout NOT available to Admin user, unless they are also explicitly the owner.
			if($CONFIG_VARS['borrow.enable']!==FALSE && $HTTP_SESSION_VARS['user_id'] === $item_r['owner_id'] && $CONFIG_VARS['borrow.quick_checkout']!==FALSE && ($status_type_r['borrow_ind'] == 'Y' || $status_type_r['borrow_ind'] == 'N'))
			{
				// Cannot quick checkout an item already borrowed.
				if(!is_item_borrowed($item_r['item_id'], $item_r['instance_no']))
				{
					$action_links_rs[] = array(url=>'item_borrow.php?op=quick_check_out&item_id='.$item_r['item_id'].'&instance_no='.$item_r['instance_no'].'&item_link=y'.(strlen($listing_link)>0?'&listing_link='.$listing_link:''),img=>'quick_check_out.gif',text=>$LANG_VARS['quick_check_out']);
				}						
			}
		}
		
		if($HTTP_SESSION_VARS['user_id'] !== $item_r['owner_id'] && 
					is_user_allowed_to_borrow($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']) && 
					(strlen($status_type_r['min_display_user_type'])==0 || in_array($status_type_r['min_display_user_type'], get_min_user_type_r($HTTP_SESSION_VARS['user_type'])))
				)
		{
			if($CONFIG_VARS['borrow.enable']!==FALSE)
			{
				// Check if already in reservation session variable.
				if($CONFIG_VARS['borrow.reserve_basket']!==FALSE && is_not_empty_array($HTTP_SESSION_VARS['reserve_basket_listing']) && in_array($item_r['item_id']."_".$item_r['instance_no'], $HTTP_SESSION_VARS['reserve_basket_listing']))
				{
					$action_links_rs[] = array(url=>'borrow.php?op=delete_from_my_reserve_basket&item_id='.$item_r['item_id'].'&instance_no='.$item_r['instance_no'].'&item_link=y&listing_link='.$listing_link,img=>'delete_from_reserve_list.gif',text=>$LANG_VARS['delete_from_reserve_list']);		
				}
				else if(is_item_reserved_or_borrowed($item_r['item_id'], $item_r['instance_no']))
				{
					if(is_item_reserved_by_user($item_r['item_id'], $item_r['instance_no'], $HTTP_SESSION_VARS['user_id']))
					{
						$action_links_rs[] = array(url=>'item_borrow.php?op=cancel_reserve&item_id='.$item_r['item_id'].'&instance_no='.$item_r['instance_no'].'&item_link=y&listing_link='.$listing_link,img=>'cancel.gif',text=>$LANG_VARS['cancel_reservation']);
					}
					else if(!is_item_borrowed_by_user($item_r['item_id'], $item_r['instance_no'], $HTTP_SESSION_VARS['user_id']))
					{
						if($status_type_r['borrow_ind'] == 'Y' &&
									($CONFIG_VARS['borrow.allow_reserve_if_borrowed']!==FALSE || !is_item_borrowed($item_r['item_id'], $item_r['instance_no'])) &&
									($CONFIG_VARS['borrow.allow_multi_reserve']!==FALSE || !is_item_reserved($item_r['item_id'], $item_r['instance_no'])) )
						{
							if($CONFIG_VARS['borrow.reserve_basket']!==FALSE)
							{
								$action_links_rs[] = array(url=>'borrow.php?op=update_my_reserve_basket&item_id='.$item_r['item_id'].'&instance_no='.$item_r['instance_no'].'&item_link=y'.(strlen($listing_link)>0?'&listing_link='.$listing_link:''),img=>'add_to_reserve_list.gif',text=>$LANG_VARS['add_to_reserve_list']);
							}
							else
							{
								$action_links_rs[] = array(url=>'item_borrow.php?op=reserve&item_id='.$item_r['item_id'].'&instance_no='.$item_r['instance_no'].'&item_link=y'.(strlen($listing_link)>0?'&listing_link='.$listing_link:''),img=>'reserve.gif',text=>$LANG_VARS['reserve_item']);
							}
						}
					}
				}
				else
				{   
					if($status_type_r['borrow_ind'] == 'Y')
					{
						if($CONFIG_VARS['borrow.reserve_basket']!==FALSE)
						{
							$action_links_rs[] = array(url=>'borrow.php?op=update_my_reserve_basket&item_id='.$item_r['item_id'].'&instance_no='.$item_r['instance_no'].'&item_link=y'.(strlen($listing_link)>0?'&listing_link='.$listing_link:''),img=>'add_to_reserve_list.gif',text=>$LANG_VARS['add_to_reserve_list']);
						}
						else
						{
							$action_links_rs[] = array(url=>'item_borrow.php?op=reserve&item_id='.$item_r['item_id'].'&instance_no='.$item_r['instance_no'].'&item_link=y'.(strlen($listing_link)>0?'&listing_link='.$listing_link:''),img=>'borrow.gif',text=>$LANG_VARS['borrow_item']);
						}
					}
				}
			}			
		} // else -- guest user
		
		if($CONFIG_VARS['borrow.enable']!==FALSE && ($HTTP_SESSION_VARS['user_id'] === $item_r['owner_id'] || is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type'])) && is_exists_item_instance_borrowed_item($item_r['item_id'], $item_r['instance_no']))
		{
			$action_links_rs[] = array(url=>'borrow.php?op=my_item_history&item_id='.$item_r['item_id'].'&instance_no='.$item_r['instance_no'].(strlen($listing_link)>0?'&listing_link='.$listing_link:''),img=>'item_history.gif',text=>$LANG_VARS['item_history']);
		}
		
		$rowcontents .= format_action_links(
									$action_links_rs,
									"\n<td align=\"center\" class=\"$class\" %nowrap%><font class=\"smlink\">%field%</font></td>",
									$LANG_VARS['not_applicable']);
	}
	
	// Item Status Image.
	$rowcontents .= "\n<td class=\"$class\" align=center>";
	$rowcontents .= _theme_image($status_type_r['img'], $status_type_r['description'], NULL, NULL, "borrowed_item");
	$rowcontents .= "\n</td>";
	
	// If a comment is allowed and defined, add it in.
	$rowcontents .= "\n<td class=\"$class\" align=center>";
	if($status_type_r['status_comment_ind'] == 'Y' || ($status_type_r['status_comment_ind'] == 'H' && ($HTTP_SESSION_VARS['user_id'] === $item_r['owner_id'] || is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']))))
		$rowcontents .= ifempty(nl2br($item_r['status_comment']),"&nbsp;"); // support newlines in this field
	else
	{
		$rowcontents .= $LANG_VARS['not_applicable'];
	}
	$rowcontents .= "\n</td>";
	
	if($CONFIG_VARS['borrow.enable']!==FALSE)
	{
		if($CONFIG_VARS['borrow.include_borrower_column']!==FALSE)
		{
			$rowcontents .= "\n<td class=\"$class\" align=center>";
			if(is_item_borrowed($item_r['item_id'], $item_r['instance_no']))
				$rowcontents .= get_list_username(fetch_item_borrower($item_r['item_id'], $item_r['instance_no']), NULL, $page_title, $CONFIG_VARS['item_display.borrower_email_link'], $LANG_VARS['back_to_item'], 'item_display.php?item_id='.$item_r['item_id'].'&instance_no='.$item_r['instance_no'].'&listing_link='.$listing_link);
			else
				$rowcontents .= $LANG_VARS['not_applicable'];
			$rowcontents .= "\n</td>";
		}
		
		// Borrow Status Image.
		$rowcontents .= "\n<td class=\"$class\" align=center>";
		if(is_item_borrowed($item_r['item_id'], $item_r['instance_no']))
		{
			$rowcontents .= _theme_image("borrowed.gif", $LANG_VARS['borrowed'], NULL, NULL, "borrowed_item");
		}
		else if(($status_type_r['borrow_ind'] == 'Y' || $status_type_r['borrow_ind'] == 'N') && is_item_reserved($item_r['item_id'], $item_r['instance_no']))
		{
			$rowcontents .= _theme_image("reserved.gif", $LANG_VARS['reserved'], NULL, NULL, "borrowed_item");
		}
		else
		{
			$rowcontents .= $LANG_VARS['not_applicable'];
		}
		$rowcontents .= "\n</td>";
		
		if($CONFIG_VARS['borrow.duration_support']!==FALSE)
		{
			// 'Due Back' functionality.	
			$rowcontents .= "\n<td class=\"$class\" align=center>";
			if(is_item_borrowed($item_r['item_id'], $item_r['instance_no']))
			{
				$due_date = fetch_item_duedate_timestamp($item_r['item_id'], $item_r['instance_no']);
				if(strlen($due_date)>0)
					$rowcontents .= get_localised_timestamp($CONFIG_VARS['borrow.date_mask'], $due_date);
				else
					$rowcontents .= $LANG_VARS['undefined'];
			}
			else if($status_type_r['borrow_ind'] != 'Y' && $status_type_r['borrow_ind'] != 'N')// s_status_type CAN be changed to 
				$rowcontents .= $LANG_VARS['not_applicable'];							// type with borrow_ind=N, even if item checked out / reserved
			else if(is_numeric($item_r['borrow_duration']))
			{
				$duration_attr_type_r = fetch_sfieldtype_item_attribute_type_r($item_r['s_item_type'], 'DURATION', TRUE);
				$rowcontents .= get_display_field($duration_attr_type_r['s_attribute_type'], NULL, $duration_attr_type_r['display_type'], $item_r['borrow_duration'], FALSE);
			}
			else
				$rowcontents .= $LANG_VARS['undefined'];
			$rowcontents .= "\n</td>";
		}
	}
	
	$rowcontents .= "\n</tr>";
	return $rowcontents;		
}//function get_item_status_row($class, $item_r, $listing_link, $selected)

if($CONFIG_VARS['site.enable']!==FALSE)
{
	session_start();
	if (is_opendb_valid_session())
	{
		if(is_numeric($HTTP_VARS['parent_id']) && is_numeric($HTTP_VARS['parent_instance_no']))
			$parent_item_r = fetch_item_instance_r($HTTP_VARS['parent_id'], $HTTP_VARS['parent_instance_no']);
			
		if(is_not_empty_array($parent_item_r))
			$item_r = fetch_child_item_r($HTTP_VARS['item_id']);
		else if(is_numeric($HTTP_VARS['instance_no']))
			$item_r = fetch_item_instance_r($HTTP_VARS['item_id'], $HTTP_VARS['instance_no']);
	
		if(is_not_empty_array($item_r))
		{
			if(is_not_empty_array($parent_item_r))
				$status_type_r = fetch_status_type_r($parent_item_r['s_status_type']);
			else
				$status_type_r = fetch_status_type_r($item_r['s_status_type']);
			
			if(( (is_not_empty_array($parent_item_r) && $parent_item_r['owner_id'] == $HTTP_SESSION_VARS['user_id']) || 
						(!is_array($parent_item_r) && $item_r['owner_id'] == $HTTP_SESSION_VARS['user_id']) ) ||
						(strlen($status_type_r['min_display_user_type'])==0 || in_array($status_type_r['min_display_user_type'], get_min_user_type_r($HTTP_SESSION_VARS['user_type']))))
			{
				$page_title = expand_item_title_mask($item_r, $CONFIG_VARS['item_display.title_display_mask']);
				echo _theme_header($page_title, $HTTP_VARS['inc_menu']);
			
				echo("<table width=100% border=0 frameborder=0 cellspacing=1>");
				echo("<tr><td valign=bottom>");
		    	
				// Show heading...
				echo ("<h2>".$page_title." ".get_item_image($item_r['s_item_type'], $item_r['item_id'], is_numeric($item_r['parent_id']))."</h2>\n");
			
				// --------------------- Indicate whether title has been reviewed or not -----------
				echo("<div class=\"colortext\">");
				if(!is_item_reviewed($item_r['item_id']))
				{
					echo("<b>".$LANG_VARS['not_reviewed']."</b>");
					if($HTTP_VARS['mode'] != 'printable' && is_user_allowed_to_review($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']))
						echo ("&nbsp;[<a href=\"item_review.php?op=add&item_id=".$item_r['item_id']."&instance_no=".$item_r['instance_no']."&parent_id=".$HTTP_VARS['parent_id']."&parent_instance_no=".$HTTP_VARS['parent_instance_no']."&listing_link=".$HTTP_VARS['listing_link']."\">".$LANG_VARS['review']."</a>]");
				}
				else
				{
					$average = fetch_review_rating($item_r['item_id']);
					echo ("<b>".$LANG_VARS['rating'].":</b> ");
					if ($average == 0)
					{
						echo($LANG_VARS['no_rating']);
					}
					else
					{
						$attribute_type_r = fetch_attribute_type_r('S_RATING');
						echo get_display_field($attribute_type_r['s_attribute_type'], 
									NULL, 
									'review()',
									$average,
									FALSE);
					}
				}
				echo("</div>\n");
				echo ("</td>");
	
				// ---------------- Display IMAGE attributes ------------------------------------
				// Will bypass the display of images if the config.php $CONFIG_VARS['item_display.show_item_image']
				// variable has been explicitly set to FALSE.  This means that if the variable does 
				// not exist, this block should still execute.
				if($CONFIG_VARS['item_display.show_item_image']!==FALSE)
				{
					echo(get_popup_javascript());
					
					// Here we need to get the image_attribute_type and check if it is set.
					$results = fetch_sfieldtype_item_attribute_type_rs($item_r['s_item_type'], 'IMAGE', FALSE, TRUE);
					echo("<td align=right>");
					if($results)
					{
						$coverimages_found = FALSE;
						
						echo("<table border=0><tr>");
						while($image_attribute_type_r = mysql_fetch_array($results, MYSQL_ASSOC))
						{
							$image_attribute_type_r = fetch_siat_with_prompt_and_val_r($item_r['s_item_type'], $image_attribute_type_r['s_attribute_type'], $image_attribute_type_r['order_no'], $item_r['item_id']);
							// If an image is specified.
							if($image_attribute_type_r && strlen($image_attribute_type_r['attribute_val'])>0)
							{
								$imageurl = $image_attribute_type_r['attribute_val'];
								
								// No need to check_url() as we will show a broken image if not found.
								if(strlen($imageurl)>0)
								{
									if(strlen($image_attribute_type_r['display_type'])>0)
									{
										$widget = prc_function_spec($image_attribute_type_r['display_type']);
										
										// The dedicated popupsize or urlpopup, if also displaying in list, can both be used.
										if(($widget['type'] == 'popupsize' || $widget['type'] == 'urlpopup') && is_not_empty_array($widget['args']))
										{
											if(is_numeric($widget['args']['0']))
											{
												$default_imageurlsize = array(
														width=>ifempty($widget['args']['0'], 400), 
														height=>ifempty($widget['args']['1'], 300));
											}
											else 
											{
												$default_imageurlsize = array(
														width=>ifempty($widget['args']['1'], 400), 
														height=>ifempty($widget['args']['2'], 300));
											}
										}
									}
									
									$cover_image_block = get_cover_image(
																$imageurl, 
																$image_attribute_type_r['prompt'],
																$CONFIG_VARS['item_display.item_image_size'],
																NULL,
																$default_imageurlsize, 
																$HTTP_VARS['mode'] != 'printable');
									
									if($cover_image_block!==FALSE)
									{
										echo("<td>".$cover_image_block."</td>");
										$coverimages_found = TRUE;
									}
								}
							}
						}
						mysql_free_result($results);
						
						if($coverimages_found===FALSE && strlen($CONFIG_VARS['item_display.no_image'])>0)
						{
							echo("<td>".
								ifempty(
									get_cover_image(_theme_image_src($CONFIG_VARS['item_display.no_image']), NULL, $CONFIG_VARS['item_display.item_image_size']), '&nbsp;').
								"</td>");
						}
										
						echo("</tr></table>");
					}
					else
					{
						echo("&nbsp;");
					}
					echo("</td>");
					// -------------------------------------------------------------------------
				}
				echo("</tr></table>");
	
				echo("<table width=100% border=0 frameborder=0 cellspacing=1>");
				// Do all the attributes.  Ignore any attributes that have an input_type of hidden.
				$results = fetch_item_attribute_type_rs($item_r['s_item_type'], TRUE, TRUE);
				if($results)
				{
					while($item_attribute_type_r = mysql_fetch_array($results, MYSQL_ASSOC))
					{
						// If display_type == '' AND input_type == 'hidden' we set to 'hidden'
						$display_type = trim($item_attribute_type_r['display_type']);
						if(strlen($display_type)==0 && strcasecmp(get_function_type(trim($item_attribute_type_r['input_type'])),'hidden')==0)
						{
							// We allow the get_display_field to handle hidden variable, in case at some stage
							// we might want to change the functionality of 'hidden' to something other than ignore.
							$display_type = 'hidden';
						}
						
						if($item_attribute_type_r['s_field_type'] != 'DURATION') // duration goes in the Instance Info section.
						{
							if($item_attribute_type_r['s_field_type'] == 'CATEGORY')
								$value = trim_explode(' ', $item_r['category']); //expects a array of categories
							else if($item_attribute_type_r['s_field_type'] == 'ITEM_ID')
								$value = $item_r['item_id'];
							else if(is_lookup_attribute_type($item_attribute_type_r['s_attribute_type']))
								$value = fetch_lookup_attribute_val_r($item_r['item_id'], $item_attribute_type_r['s_attribute_type'], $item_attribute_type_r['order_no']);
							else
								$value = fetch_attribute_val($item_r['item_id'], $item_attribute_type_r['s_attribute_type'],  $item_attribute_type_r['order_no']);
	
							// Only show attributes which have a value.
							if(strlen($value)>0)
							{
								if($HTTP_VARS['mode'] == 'printable')
								{
									// remove link
									$display_type = str_replace('list-link', '', $display_type);
								}
								
								echo get_display_field(
										$item_attribute_type_r['s_attribute_type'],
										$item_attribute_type_r['prompt'],
										$display_type,
										$value);
							}
						}
					}
					mysql_free_result($results);
				}
				echo("\n</table>");
				
				// ---------------------Site Link Block -----------------------
				if($HTTP_VARS['mode'] != 'printable')
				{
					echo("\n<table><tr><td colspan=2 align=right>");
					echo(get_site_plugin_links_table($page_title, $item_r));
					echo("\n</td></tr></table>");
				}
				// -------------------------------------------------------------
	
				// There are no instances for child items.
				if(!is_array($parent_item_r))
				{
					$instance_info_links = NULL;
					
					if($HTTP_VARS['mode'] != 'printable')
					{
						if($status_type_r['insert_ind'] == 'Y' && is_user_allowed_to_own($HTTP_SESSION_VARS['user_id']))
						{
							if($CONFIG_VARS['item_input.item_instance_support'] !== FALSE)
							{
								if(is_exists_item_instance_with_owner_and_status($item_r['item_id'], $item_r['s_status_type'], $HTTP_SESSION_VARS['user_id']))
								{
									if($status_type_r['new_owner_instance_ind'] == 'Y')
									{
										$instance_info_links[] = array(url=>"item_input.php?op=newinstance&item_id=".$item_r['item_id']."&instance_no=".$item_r['instance_no'].(strlen($HTTP_VARS['listing_link'])>0?'&listing_link='.$HTTP_VARS['listing_link']:''),text=>$LANG_VARS['new_item_instance']);
									}
								}
								else if($CONFIG_VARS['item_input.new_instance_owner_only'] !== TRUE && $status_type_r['new_not_owner_instance_ind'] == 'Y')
								{
									$instance_info_links[] = array(url=>"item_input.php?op=newinstance&item_id=".$item_r['item_id']."&instance_no=".$item_r['instance_no'].(strlen($HTTP_VARS['listing_link'])>0?'&listing_link='.$HTTP_VARS['listing_link']:''),text=>$LANG_VARS['new_item_instance']);
								}
							}
								
							if($CONFIG_VARS['item_input.clone_item_support'] !== FALSE)
							{
								$instance_info_links[] = array(url=>"item_input.php?op=clone_item&item_id=".$item_r['item_id']."&instance_no=".$item_r['instance_no'].(strlen($HTTP_VARS['listing_link'])>0?'&listing_link='.$HTTP_VARS['listing_link']:''),text=>$LANG_VARS['clone_item']);
							}
						}
					}
					
					echo("\n<a name=\"item_instance\"></a>".
						"\n<p><div class=\"colortext\"><b>".$LANG_VARS['instance_info'].":</b> ".
						(is_not_empty_array($instance_info_links)?"[".format_action_links($instance_info_links)."]":"").
						"\n</div>".
						"\n<table width=100% border=0 cellpadding=0 cellspacing=1>".
						"\n<tr>".
						"\n<td class=\"navbar\" align=center>&nbsp;".$LANG_VARS['instance']."&nbsp;</div></td>".
						"\n<td class=\"navbar\" align=center>".$LANG_VARS['owner']."</td>".
						($HTTP_VARS['mode'] != 'printable'?"\n<td class=\"navbar\" align=center>".$LANG_VARS['action']."</td>":"").
						"\n<td class=\"navbar\" align=center>".$LANG_VARS['status']."</td>".
						"\n<td class=\"navbar\" align=center>".$LANG_VARS['status_comment']."</td>");
					
					$columns = 5;
					if($CONFIG_VARS['borrow.enable']!==FALSE)
					{
						if($CONFIG_VARS['borrow.include_borrower_column']!==FALSE)
						{
							echo("\n<td class=\"navbar\" align=center>".$LANG_VARS['borrower']."</td>");
							$columns++;
						}
						
						echo("\n<td class=\"navbar\" align=center>".$LANG_VARS['borrow_status']."</td>");
						$columns++;
						
						if($CONFIG_VARS['borrow.duration_support']!==FALSE)
						{
							echo("\n<td class=\"navbar\" align=center>".$LANG_VARS['due_date_or_duration']."</td>");
							$columns++;
						}
					}
					echo("\n</tr>");
	
					// -------------------
					if($CONFIG_VARS['item_input.item_instance_support'] !== FALSE)
					{
						// Now do the Status Info:
						$results = fetch_item_instance_rs($item_r['item_id'], NULL);
						if($results)
						{
							$toggle=TRUE;
							$numrows = mysql_num_rows($results);
							while($item_instance_r = mysql_fetch_array($results, MYSQL_ASSOC))
							{
								if($toggle)
									$color="top";
								else
			 						$color="top2";
								$toggle = !$toggle;
								
								echo(get_item_status_row(
										$color,
										array_merge($item_r, $item_instance_r),
										$HTTP_VARS['listing_link'], 
										$numrows>1 && $item_r['instance_no']===$item_instance_r['instance_no']));
							}
						}
						else
						{	// No instances found, because user has been deactivated and/or items are hidden.
							echo("<tr><td colspan=$columns align=center><div class=\"error\">- ".$LANG_VARS['no_records_found']." -</div></td></tr>");
						}
					}
					else//lone instance only.
					{
						$numrows = 1;
						echo(get_item_status_row(
								"top",
								$item_r, 
								$HTTP_VARS['listing_link'], 
								FALSE));
					}
					echo("\n</table>");
					if($numrows>1)
						echo(format_help_block(array('img'=>'tick.gif','text'=>$LANG_VARS['current_item_instance'])));
					
					// ---------------------- Child items here.
					$results = fetch_child_item_rs($item_r['item_id']);
					if($results)
					{
						// A interpage link to be used from listings.
						echo("\n<a name=\"linked_item\"></a>".
							"\n<br><div class=\"colortext\"><b>".$LANG_VARS['linked_item(s)'].":</b>&nbsp;");
						
						if($HTTP_VARS['mode'] != 'printable' && $CONFIG_VARS['item_input.linked_item_support'] !== FALSE)
						{
							echo("[<a href=\"item_add.php?".($CONFIG_VARS['item_input.link_same_type_only']===TRUE?"s_item_type=".$item_r['s_item_type']."&":"")."parent_id=".$item_r['item_id']."&parent_instance_no=".$item_r['instance_no']."&listing_link=".$HTTP_VARS['listing_link']."\">".$LANG_VARS['add_linked']."</a>]");
						}
						
						echo("</div>".
							"<table border=0 width=100% cellpadding=0 cellspacing=1>".
							"<tr>".
								"<td class=\"navbar\" align=center>".$LANG_VARS['type']."</div></td>".
								"<td class=\"navbar\" align=center width=40%>".$LANG_VARS['title']."</div></td>".
								($HTTP_VARS['mode'] != 'printable'?"<td class=\"navbar\" align=center>".$LANG_VARS['action']."</div></td>":"").
								"<td class=\"navbar\" align=center>".$LANG_VARS['category']."</div></td>".
							"</tr>");
						
						$toggle = TRUE;
						$show_item_reviewed = FALSE;
						while($child_item_r = mysql_fetch_array($results, MYSQL_ASSOC))
						{
							if($toggle)
								$color="top";
							else
			 					$color="top2";
							$toggle = !$toggle;
								
							echo("\n<tr>");
							echo("\n<td class=\"$color\" align=center>".get_item_image($child_item_r['s_item_type'],NULL,TRUE)."</td>");
							
							$child_item_r['title'] = expand_type_title_mask($child_item_r, $CONFIG_VARS['listings.title_display_mask'], $parsed_title_mask_r);
							
							if($HTTP_VARS['mode'] != 'printable')
								$title = "<a href=\"$PHP_SELF?item_id=".$child_item_r['item_id']."&parent_id=".$item_r['item_id']."&parent_instance_no=".$item_r['instance_no'].(strlen($HTTP_VARS['listing_link'])>0?'&listing_link='.$HTTP_VARS['listing_link']:'')."\">".$child_item_r['title']."</a>";
							else
								$title = $child_item_r['title'];
								
							$append_to_title = "";
							if(is_item_reviewed($child_item_r['item_id']))
							{
								$show_item_reviewed = TRUE;
								$append_to_title = _theme_image("rs.gif", NULL, $LANG_VARS['item_reviewed']); // show star if rated
							}
								
							if($CONFIG_VARS['item_display.show_linked_item_image']!==FALSE)
							{
								if(strlen($item_types_rs[$child_item_r['s_item_type']]['image_attribute_type'])==0)
								{
									$item_types_rs[$child_item_r['s_item_type']]['image_attribute_type'] = fetch_sfieldtype_item_attribute_type($child_item_r['s_item_type'], 'IMAGE');
								}
								
								if(strlen($item_types_rs[$child_item_r['s_item_type']]['image_attribute_type'])>0)
								{
									$imageurl = fetch_attribute_val($child_item_r['item_id'], $item_types_rs[$child_item_r['s_item_type']]['image_attribute_type']);
									if(strlen($imageurl)==0 && strlen($CONFIG_VARS['item_display.no_image'])>0)
									{
										$imageurl = _theme_image_src($CONFIG_VARS['item_display.no_image']);
									}
								}
								
								echo("<td align=\"center\" class=\"$color\">".
									"<table width=100% border=0 cellpadding=0 cellspacing=0><tr><td width=10% class=\"$color\">".
									ifempty(get_cover_image($imageurl, NULL, $CONFIG_VARS['listings.item_image_size']), '&nbsp;').
									"</td>".
									"<td align=\"center\" class=\"$color\">".
									$title.
								   	(strlen($append_to_title)>0?"&nbsp;".$append_to_title:"").
									"</td></tr></table></td>");
							}	
							else
							{
								echo("<td align=\"center\" class=\"$color\">".
									$title.
							    	(strlen($append_to_title)>0?"&nbsp;".$append_to_title:"").
									"</td>");
							}
							
							$action_links_rs = NULL;
							if($HTTP_VARS['mode'] != 'printable')
							{
								$action_links_rs[] = array(url=>'item_input.php?op=edit&item_id='.$child_item_r['item_id'].'&parent_id='.$item_r['item_id'].'&parent_instance_no='.$item_r['instance_no'].(strlen($HTTP_VARS['listing_link'])>0?'&listing_link='.$HTTP_VARS['listing_link']:''),img=>'edit.gif',text=>$LANG_VARS['edit']);
								if($CONFIG_VARS['listings.show_refresh_links'] && is_item_legal_site_type($child_item_r['s_item_type']))
								{
									$action_links_rs[] = array(url=>'item_add.php?item_id='.$child_item_r['item_id'].'&parent_id='.$item_r['item_id'].'&parent_instance_no='.$item_r['instance_no'].(strlen($HTTP_VARS['listing_link'])>0?'&listing_link='.$HTTP_VARS['listing_link']:''),img=>'refresh.gif',text=>$LANG_VARS['refresh']);
								}
								$action_links_rs[] = array(url=>'item_input.php?op=delete&item_id='.$child_item_r['item_id'].'&parent_id='.$item_r['item_id'].'&parent_instance_no='.$item_r['instance_no'].(strlen($HTTP_VARS['listing_link'])>0?'&listing_link='.$HTTP_VARS['listing_link']:''),img=>'delete.gif',text=>$LANG_VARS['delete']);
							
								echo(format_action_links(
									$action_links_rs,
									"\n<td align=\"center\" class=\"$color\" %nowrap%>%field%</td>",
									$LANG_VARS['not_applicable']));
							}
							
							$category_value = NULL;
							if(strlen(trim($child_item_r['category']))>0)
							{
								$attribute_type_r = fetch_sfieldtype_item_attribute_type_r($child_item_r['s_item_type'], 'CATEGORY', TRUE);
								if(is_array($attribute_type_r))
								{
									if($HTTP_VARS['mode'] == 'printable')
									{
										// remove link
										$attribute_type_r['display_type'] = str_replace('list-link', '', $attribute_type_r['display_type']);
									}
								
									$category_value = get_display_field(
														$attribute_type_r['s_attribute_type'], 
														$attribute_type_r['prompt'], 
														$attribute_type_r['display_type'], 
														trim_explode(' ', $child_item_r['category']), 
														FALSE);
								}
							}
						
							echo("\n<td class=\"$color\" align=center>");
							if(strlen($category_value)>0)
								echo $category_value;
							else
								echo "&nbsp;";
							echo("\n</td></tr>");
						}
						echo("\n</table>");
						
						// don't show it, unless there is actually any child items that have been reviewed.
						if($show_item_reviewed)
						{
							echo(format_help_block(array('img'=>'rs.gif','text'=>$LANG_VARS['item_reviewed'])));
						}
					}
				}
			
				// -------------------------- REVIEWS ---------------------------------------------------------
				$result = fetch_review_rs($item_r['item_id']);
				if($result)
				{
					// inter page link
					echo("\n<a name=\"item_review\"></a>");
	
					echo("\n<br><div class=\"colortext\"><b>".$LANG_VARS['review(s)'].":</b>");
					if($HTTP_VARS['mode'] != 'printable' && is_user_allowed_to_review($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']))
						echo ("&nbsp;[<a href=\"item_review.php?op=add&item_id=".$item_r['item_id']."&instance_no=".$item_r['instance_no']."&parent_id=".$HTTP_VARS['parent_id']."&parent_instance_no=".$HTTP_VARS['parent_instance_no'].(strlen($HTTP_VARS['listing_link'])>0?'&listing_link='.$HTTP_VARS['listing_link']:'')."\">".$LANG_VARS['review']."</a>]");
					echo("\n</div>");
	
					echo ("\n<table width=100% border=0 cellpadding=1 cellspacing=1>");
					while($review_r = mysql_fetch_array($result))
					{
						if($HTTP_VARS['mode'] != 'printable' && 
								(is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']) || is_review_author($review_r['sequence_number'], $HTTP_SESSION_VARS['user_id'])))
						{
							$action_links_rs = NULL;
							if($CONFIG_VARS['item_review.update_support']!==FALSE)
								$action_links_rs[] = array(url=>"item_review.php?op=edit&sequence_number=".$review_r['sequence_number']."&item_id=".$item_r['item_id']."&instance_no=".$item_r['instance_no']."&parent_id=".$HTTP_VARS['parent_id']."&parent_instance_no=".$HTTP_VARS['parent_instance_no'].(strlen($HTTP_VARS['listing_link'])>0?'&listing_link='.$HTTP_VARS['listing_link']:''),img=>'edit.gif',text=>$LANG_VARS['edit']);	
							if($CONFIG_VARS['item_review.delete_support']!==FALSE)
								$action_links_rs[] = array(url=>"item_review.php?op=delete&sequence_number=".$review_r['sequence_number']."&item_id=".$item_r['item_id']."&instance_no=".$item_r['instance_no']."&parent_id=".$HTTP_VARS['parent_id']."&parent_instance_no=".$HTTP_VARS['parent_instance_no'].(strlen($HTTP_VARS['listing_link'])>0?'&listing_link='.$HTTP_VARS['listing_link']:''),img=>'delete.gif',text=>$LANG_VARS['delete']);	
						
							$actions = format_action_links(
								$action_links_rs,
								"<td align=\"center\" class=\"prompt\" %nowrap%><font class=\"smlink\">%field%</font></td>",
								"&nbsp;");
						}
						else
						{
							//where no permissions are allowed, 
							$actions = "<td>&nbsp;</td>";
						}
							
						echo("<tr><td class=\"prompt\" align=left><table width=100% cellpadding=0 cellspacing=0 border=0><tr><td class=\"prompt\" align=left>".replace_lang_vars(array('date'=>get_localised_timestamp($CONFIG_VARS['item_display.review_datetime_mask'],$review_r['update_on']),'fullname'=>fetch_user_name($review_r['author_id']), 'user_id'=>$review_r['author_id']), $LANG_VARS['on_date_name_wrote_the_following']).":</td>".
								$actions."</td></tr></table>");
						
						echo("\n<tr><td class=\"data\">");
						echo(nl2br(trim($review_r['comment'])));
						echo("&nbsp;&nbsp;");
						if($review_r['item_id']!=$item_r['item_id'])
						{
							echo(replace_lang_vars(
									array('s_item_type'=>$review_r['s_item_type'], 'item_id'=>$review_r['item_id']),
									$LANG_VARS['review_for_item_type_title']));
						}
						echo("<br><br>");
						$average = $review_r['rating'];
						
						echo ("<b>".$LANG_VARS['rating'].":</b> ");
						if ($average == 0)
						{
							echo($LANG_VARS['no_rating']);
						}
						else
						{
							$attribute_type_r = fetch_attribute_type_r("S_RATING");
							echo get_display_field($attribute_type_r['s_attribute_type'], 
									NULL, 
									'review()', // display_type
									$average,
									FALSE);
						}
						
						echo("\n<br></td></tr>\n");
					}//while
					echo ("</table>");
				}
				
				if(!is_array($parent_item_r))
				{
					if(is_export_plugin($CONFIG_VARS['item_display.export_link']))
					{
						$footer_links_r[] = array(url=>"export.php?op=export&plugin=".$CONFIG_VARS['item_display.export_link']."&item_id=".$item_r['item_id']."&send_as_format=attachment",text=>replace_lang_var('type', get_display_export_type($CONFIG_VARS['item_display.export_link']), $LANG_VARS['type_export_item_record']));		
					}
				}
			}
			else // if(!in_array($status_type_r['min_display_user_type'], get_min_user_type_r($HTTP_SESSION_VARS['user_type'])))
			{
				$page_title = replace_lang_vars(array('usertype'=>get_usertype_description($HTTP_SESSION_VARS['user_type']),'s_status_type_desc'=>$status_type_r['description']),$LANG_VARS['s_status_type_display_access_disabled_for_usertype']);
				echo _theme_header($page_title);
				echo("<div class=\"error\">".$page_title."</div>");
			}
		}
		else //if(is_not_empty_array($item_r))
		{
			echo _theme_header($LANG_VARS['item_not_found']);
			echo("<div class=\"error\">".$LANG_VARS['item_not_found']."</div>");
		}//$item_r found
		
		// ------------------------------------------------------------------------------------------
		if(is_not_empty_array($parent_item_r))
		{
			$footer_links_r[] = array(url=>"$PHP_SELF?item_id=".$HTTP_VARS['parent_id']."&instance_no=".$HTTP_VARS['parent_instance_no'].(strlen($HTTP_VARS['listing_link'])>0?'&listing_link='.$HTTP_VARS['listing_link']:''),text=>$LANG_VARS['back_to_parent']);
		}
			
		// Include a Back to Listing link.
		if($HTTP_VARS['listing_link'] === 'y' && is_array($HTTP_SESSION_VARS['listing_url_vars']))
		{
			$footer_links_r[] = array(url=>"listings.php?".get_url_string($HTTP_SESSION_VARS['listing_url_vars']),text=>$LANG_VARS['back_to_listing']);
		}
	
		if($HTTP_VARS['mode'] != 'printable')
		{
			echo format_footer_links($footer_links_r);
		
			echo("\n<p align=center class=\"footer\"><i><a href=\"".$PHP_SELF."?".
					get_url_string(
						$HTTP_VARS, 
						array('mode'=>'printable'), //include
						array( //exclude
							'page_no',
							'listing_link',
							'internal_link',
							'items_per_page')).
				"\" target=_blank>"._theme_image('printable.gif', '', NULL, 'absmiddle').$LANG_VARS['printable_version']."</a></i></p>");
		}
			
		echo _theme_footer();
	}
	else
	{
		// invalid login, so login instead.
		include("./login.php");
	}
}//if($CONFIG_VARS['site.enable']!==FALSE)
else
{
	echo _theme_header($LANG_VARS['site_is_disabled'], FALSE);
	echo _theme_error($LANG_VARS['site_is_disabled']);
	echo _theme_footer();
}

// Cleanup after begin.inc.php
require_once("./include/end.inc.php");
?>