<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
include_once("./functions/database.php");
include_once("./functions/logging.php");
include_once("./functions/utils.php");
include_once("./functions/item_type.php");
include_once("./functions/item_attribute.php");
include_once("./functions/item_type_group.php");
include_once("./functions/parseutils.php");

function &get_site_plugin_instance($site_type)
{
	$site_plugin_classname = fetch_site_plugin_classname($site_type);
	if($site_plugin_classname !== FALSE)
	{
		include_once("./site/".$site_plugin_classname.".class.php");
		$sitePlugin =& new $site_plugin_classname($site_type);
				
		return $sitePlugin;
	}
	else
	{
		return FALSE;
	}
}

/**
* check for record in site_plugin table and class in site/ directory.
*/
function is_exists_site_plugin($site_type, $check_classname = TRUE)
{
	$query = "SELECT site_type, classname ".
			"FROM s_site_plugin ".
			"WHERE site_type = '".$site_type."'";
	
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		$site_plugin_r = mysql_fetch_array($result, MYSQL_ASSOC);
		mysql_free_result($result);
		
		if($check_classname === FALSE || file_exists("site/".$site_plugin_r['classname'].".class.php"))
			return TRUE;
		else
			return FALSE;
	}
	else
	{
		return FALSE;
	}
}

/**
* Returns site_plugin record from table for site_type
*/
function fetch_site_plugin_r($site_type)
{
	$query = "SELECT site_type, classname, title, image, description, external_url, items_per_page, more_info_url ".
			"FROM s_site_plugin ".
			"WHERE site_type = '".$site_type."'";
			
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		$site_plugin_r = mysql_fetch_array($result, MYSQL_ASSOC);
		mysql_free_result($result);
		
		return $site_plugin_r;
	}
	else
		return FALSE;
}

function fetch_site_plugin_classname($site_type)
{
	$query = "SELECT classname ".
			"FROM s_site_plugin ".
			"WHERE site_type = '".$site_type."'";
			
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		$site_plugin_r = mysql_fetch_array($result, MYSQL_ASSOC);
		mysql_free_result($result);
		
		return $site_plugin_r['classname'];
	}

	//else
	return FALSE;
}

function get_site_plugin_list_r()
{
	$query = "SELECT site_type ".
			"FROM s_site_plugin ".
			"ORDER BY order_no";
	
	$results = run_opendb_query($query);
	if($results && mysql_num_rows($results)>0)
	{
		$site_list_r = array();
		
		while($site_plugin_r = mysql_fetch_array($results, MYSQL_ASSOC))
		{
			$site_list_r[] = $site_plugin_r['site_type'];
		}
		mysql_free_result($results);
		
		return $site_list_r;
	}
	else
	{
		return FALSE;
	}
}

/*
* 	Return resultset of all relevant site types, including all details such as
* title, image, description, external_url, order_no, etc.
*/
function fetch_site_plugin_rs($s_item_type = NULL)
{
	$query = "SELECT site_type, classname, title, image, description, external_url, items_per_page, more_info_url, order_no ".
			"FROM s_site_plugin ";
				
	if($s_item_type!=NULL)
	{
		$inclause = format_sql_in_clause(fetch_site_type_rs($s_item_type));
		if($inclause!=NULL)
		{
			$query .= "WHERE site_type IN (".$inclause.") ";
		}
		else
		{
			return FALSE;
		}
	}
	
	$query .= "ORDER BY order_no";
	
	$results = run_opendb_query($query);
	if($results && mysql_num_rows($results)>0)
		return $results;
	else
		return FALSE;
}
										
/**
* Will return a complete array structure of configuration information for a 
* $site_type.
*/
function get_site_plugin_conf_r($site_type)
{
	$results = fetch_site_plugin_conf_rs($site_type);
	if($results)
	{
		$site_plugin_conf_rs = array();
		
		$name = NULL;
		$value = NULL;
		while($site_plugin_conf_r = mysql_fetch_array($results, MYSQL_ASSOC))
		{
			if($name == NULL || $name != $site_plugin_conf_r['name'])
			{
				// need to process entries added to $value
				if($name != NULL)
				{
					if(is_array($value))
					{
						if(count($value)==1 && isset($value[0]))
							$site_plugin_conf_rs[$name] = $value[0];
						else
							$site_plugin_conf_rs[$name] = $value;
					}
				}
				
				$value = NULL;
				$name = $site_plugin_conf_r['name'];
			}
			
			$value[$site_plugin_conf_r['keyid']] = $site_plugin_conf_r['value'];
		}
		
		if(is_array($value))
		{
			if(count($value)>1)
				$site_plugin_conf_rs[$name] = $value;
			else
				$site_plugin_conf_rs[$name] = $value[0];
		}
		mysql_free_result($results);
		
		return $site_plugin_conf_rs;
	}
	else
	{
		return FALSE;
	}
}

function fetch_site_plugin_conf_rs($site_type)
{
	$query = "SELECT site_type, name, keyid, description, value ".
			"FROM s_site_plugin_conf ".
			"WHERE site_type = '".$site_type."' ".
			"ORDER BY name, keyid";
	
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
		return $result;
	else
		return FALSE;
}

/**
* Fetch a set of site plugin links, optionally for a specific s_item_type
*/
function fetch_site_plugin_link_rs($site_type, $s_item_type = NULL)
{
	$query = "SELECT site_type, sequence_number, s_item_type_group, s_item_type, site_type, description, url, title_url, order_no ".
		"FROM s_site_plugin_link ".
		"WHERE site_type = '".$site_type."' ";
		
	if($s_item_type != NULL)
	{
		$query .= "AND (s_item_type = '*' OR s_item_type = '".$s_item_type."') AND ";
		
		$query .= "(s_item_type_group = '*' ";
		$item_type_group_arr = fetch_item_type_groups_for_item_type_r($s_item_type, 'Y');// only system_ind='Y' groups here.
		if(is_array($item_type_group_arr))
			$query .= "OR s_item_type_group IN (".format_sql_in_clause($item_type_group_arr).")) ";
		else
			$query .= ") ";	
	}
	
	$query .= "ORDER BY order_no";
	
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
		return $result;
	else
		return FALSE;
}

function fetch_site_plugin_input_field_rs($site_type)
{
	$query = "SELECT site_type, order_no, field, description, prompt, field_type, default_value, refresh_mask ".
			"FROM s_site_plugin_input_field ".
			"WHERE site_type = '".$site_type."' ".
			"ORDER BY order_no";
	
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
		return $result;
	else
		return FALSE;
}

function fetch_site_plugin_s_attribute_type_map_rs($site_type)
{
	$query = "SELECT site_type, sequence_number, s_item_type_group, s_item_type, variable, s_attribute_type ".
		"FROM s_site_plugin_s_attribute_type_map ".
		"WHERE site_type = '".$site_type."' ".
		"ORDER BY variable, s_attribute_type";
	
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
		return $result;
	else
		return FALSE;
}

function fetch_site_plugin_s_attribute_type_lookup_map_rs($site_type, $s_attribute_type = NULL)
{
	$query = "SELECT site_type, sequence_number, s_attribute_type, value, lookup_attribute_val ".
		"FROM s_site_plugin_s_attribute_type_lookup_map ".
		"WHERE site_type = '".$site_type."' ";
		
	if(strlen($s)>0)
	{
		$query .= " AND s_attribute_type = '".$s_attribute_type."' ";
	}
	
	$query .= "ORDER BY s_attribute_type, value, lookup_attribute_val";
		
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
		return $result;
	else
		return FALSE;
}

/**
	Returns value -> lookup_attribute_val mappings for a specified site_type and attribute type
	combination.  The key of each array entry is the value, while the look_attribute_val is
	the value.
*/
function get_site_plugin_s_attribute_type_lookup_map_r($site_type, $s_attribute_type)
{
	$results = fetch_site_plugin_s_attribute_type_lookup_map_rs($site_type, $s_attribute_type);
	if($results && mysql_num_rows($results)>0)
	{
		$lookup_mappings_r = NULL;
		while($lookup_map_r = mysql_fetch_array($results, MYSQL_ASSOC))
		{
			$lookup_mappings_r[$lookup_map_r['value']] = $lookup_map_r['lookup_attribute_val']; 
		}
		mysql_free_result($results);
		
		return $lookup_mappings_r;
	}
	
	//else
	return FALSE;
}

function fetch_site_plugin_link_r($site_type, $sequence_number)
{
	$query = "SELECT sequence_number, s_item_type_group, s_item_type, site_type, description, url, title_url, order_no ".
		"FROM s_site_plugin_link ".
		"WHERE site_type = '".$site_type."' AND sequence_number = $sequence_number";

	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		$found = mysql_fetch_array($result, MYSQL_ASSOC);
		mysql_free_result($result);
		return $found;
	}
	else
		return FALSE;
}

function fetch_site_plugin_conf_r($site_type, $name, $keyid)
{
	$query = "SELECT name, keyid, description, value ".
			"FROM s_site_plugin_conf ".
			"WHERE site_type = '".$site_type."' AND name = '$name' AND keyid = '$keyid'";
	
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		$found = mysql_fetch_array($result, MYSQL_ASSOC);
		mysql_free_result($result);
		return $found;
	}
	else
		return FALSE;
}

function fetch_site_plugin_input_field_r($site_type, $field)
{
	$query = "SELECT order_no, field, description, prompt, field_type, default_value, refresh_mask ".
			"FROM s_site_plugin_input_field ".
			"WHERE site_type = '".$site_type."' AND field = '$field'";
	
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		$found = mysql_fetch_array($result, MYSQL_ASSOC);
		mysql_free_result($result);
		return $found;
	}
	else
		return FALSE;
}

function fetch_site_plugin_s_attribute_type_map_r($site_type, $sequence_number)
{
	$query = "SELECT sequence_number, s_item_type_group, s_item_type, variable, s_attribute_type ".
		"FROM s_site_plugin_s_attribute_type_map ".
		"WHERE site_type = '".$site_type."' AND sequence_number = $sequence_number";
	
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		$found = mysql_fetch_array($result, MYSQL_ASSOC);
		mysql_free_result($result);
		return $found;
	}
	else
		return FALSE;
}

function fetch_site_plugin_s_attribute_type_lookup_map_r($site_type, $sequence_number)
{
	$query = "SELECT sequence_number, s_attribute_type, value, lookup_attribute_val ".
		"FROM s_site_plugin_s_attribute_type_lookup_map ".
		"WHERE site_type = '".$site_type."' AND sequence_number = $sequence_number";
		
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		$found = mysql_fetch_array($result, MYSQL_ASSOC);
		mysql_free_result($result);
		return $found;
	}
	else
		return FALSE;
}

/**
* The $site_plugin_attributes_r will consist of array entries, each identified by a 
* alphakey.  The value may in fact be another array and this has to be handled
* appropriately.
*/
function get_expanded_site_plugin_item_variables_r($site_type, $s_item_type, $site_item_attributes_r)
{
	$query = "SELECT variable, s_attribute_type ".
		"FROM s_site_plugin_s_attribute_type_map ".
		"WHERE site_type = '".$site_type."' ";
		
	$query .= "AND (s_item_type = '*' OR s_item_type = '".$s_item_type."') AND ";
		
	$query .= "(s_item_type_group = '*' ";
	$item_type_group_arr = fetch_item_type_groups_for_item_type_r($s_item_type, 'Y');// only system_ind='Y' groups here.
	if(is_array($item_type_group_arr))
		$query .= "OR s_item_type_group IN (".format_sql_in_clause($item_type_group_arr).")) ";
	else
		$query .= ") ";	
	
	$query .= "ORDER BY variable, s_attribute_type";
	
	$new_attributes_r = array();
	
	$results = run_opendb_query($query);
	if($results && mysql_num_rows($results)>0)
	{
		$variable = NULL;
		
		while($attribute_type_map_r = mysql_fetch_array($results, MYSQL_ASSOC))
		{
			if($variable == NULL || $variable != $attribute_type_map_r['variable'])
			{
				$variable = $attribute_type_map_r['variable'];
				
				// need to know whether there is a matching entry
				if(isset($site_item_attributes_r[$variable]))
				{
					$value = $site_item_attributes_r[$variable];
					unset($site_item_attributes_r[$variable]);
				}
				else
				{
					$value = NULL;
				}
			}
			
			if($value!==NULL)
			{
				$new_attributes_r[strtolower($attribute_type_map_r['s_attribute_type'])] = $value;
			}
		}
		mysql_free_result($results);
	}
	
	// now for any variables that do not have a mapping, add them to the
	// $new_attributes_r, remember to strtoupper the variable name, because
	// in item_input, will be looking for an exact match on the s_attribute_type
	reset($site_item_attributes_r);
	while(list($key,$value) = @each($site_item_attributes_r))
	{
		// some consideration was given to checking whether the $variable corresponded
		// to a s_attribute_type, but the fact of the matter is, item_input process will
		// ignore any attributes that do not correspond, so why waste processing time
		// filtering them now.
		$new_attributes_r[strtolower($key)] = $value;
	}
	
	$site_item_attributes_r = NULL;
	
	// now we need to check to see if any lookup mappings exist for each
	// of the attribute values, and update the $value's appropriately.
	reset($new_attributes_r);
	while(list($s_attribute_type,$value) = @each($new_attributes_r))
	{
		// temporary UPPER so we can work with actual s_attribute_type records in database
		$s_attribute_type = strtoupper($s_attribute_type);
		
		if(is_lookup_attribute_type($s_attribute_type))
		{
			$values_r = NULL;
			
			// if a lookup attribute type, we want to make sure that the $value's
			// are all arrays anyway, so lets do that check each time.
			if(is_array($value))
				$values_r = $value;
			else
				$values_r[] = $value;
			
			$results = fetch_site_plugin_s_attribute_type_lookup_map_rs($site_type, $s_attribute_type);
			if($results)
			{
				$found_entries_r = array();
				$new_values_r = array();
				while($lookup_map_r = mysql_fetch_array($results, MYSQL_ASSOC))
				{
					for($i=0; $i<count($values_r); $i++)
					{
						// if match - case insensitive.
						if(strcasecmp($values_r[$i], $lookup_map_r['value'])===0)
						{
							$found_entries_r[] = $values_r[$i];
							
							//jpell - 0.81p8
							if(!in_array($lookup_map_r['lookup_attribute_val'], $new_values_r))
							{
								$new_values_r[] = $lookup_map_r['lookup_attribute_val'];
							}
						}
					}
				}
				mysql_free_result($results);
				
				// now process all back into $values_r
				for($i=0; $i<count($values_r); $i++)
				{
					// do not include if already in $new_values_r.  This may because a previous
					// value was mapped to a value also passed, but with no mapping to add it to
					// the $found_entries_r
					if(!in_array($values_r[$i], $found_entries_r) && !in_array($values_r[$i], $new_values_r))
					{
						$new_values_r[] = $values_r[$i];
					}
				}
				$values_r = $new_values_r;
			}
			
			// now reassign back.
			$site_item_attributes_r[strtolower($s_attribute_type)] = $values_r;
		}
		else
		{
			$site_item_attributes_r[strtolower($s_attribute_type)] = $value;
		}
	}
	
	//else
	return $site_item_attributes_r;
}

/**
*/
function get_mapped_site_plugin_item_variables_r($site_type, $s_item_type, $site_item_attributes_r)
{
	$new_attributes_r = $site_item_attributes_r;
	$site_item_attributes_r = NULL;
	
	// now we want to expand the $new_attributes_r, so we have a set of
	// variables that include the order_no $fieldname type format.
	$results = fetch_item_attribute_type_rs($s_item_type, 's_attribute_type');
	if($results)
	{
		// this will be set if array encountered, but not lookup value.
		$processing_s_attribute_type = FALSE;
		
		while($attribute_type_r = mysql_fetch_array($results, MYSQL_ASSOC))
		{
			$variable = strtolower($attribute_type_r['s_attribute_type']);
			if(isset($new_attributes_r[$variable]))
			{
				$fieldname = get_field_name($attribute_type_r['s_attribute_type'], $attribute_type_r['order_no']);
				
				if(is_not_empty_array($new_attributes_r[$variable]))
				{
					// TODO: Consider adding values not found in the lookup table to the
					// s_attribute_type_lookup.
					if(is_lookup_attribute_type($attribute_type_r['s_attribute_type']))
					{
						// here is where we want some sanity checking of the options
						$value_r = $new_attributes_r[$variable];
						
						$lookup_value_r = array();
						for($i=0; $i<count($value_r); $i++)
						{
							$raw_value = trim($value_r[$i]);
							if(strlen($raw_value)>0)
							{
								$value = fetch_exists_attribute_type_lookup_value($attribute_type_r['s_attribute_type'], $raw_value);
								if($value !== FALSE)
									$lookup_value_r[] = $value;
								else
									$lookup_value_r[] = $raw_value;
							}
						}
						
						$site_item_attributes_r[$fieldname] = $lookup_value_r;
					}
					else
					{
						// This indicates we have a repeated s_attribute_type, and so should act appropriately.
						if($processing_s_attribute_type!=NULL && $attribute_type_r['s_attribute_type'] == $processing_s_attribute_type)
						{
							$site_item_attributes_r[$fieldname] = $new_attributes_r[$variable][0];
							
							// remove it
							array_splice( $new_attributes_r[$variable], 0, 1);
						}
						else if(count($new_attributes_r[$variable])>1)
						{
							// this is the first occurence of the s_attribute_type, so lets see if
							// its repeated at least once.
							if(is_numeric(fetch_s_item_attribute_type_next_order_no($s_item_type, $attribute_type_r['s_attribute_type'], $attribute_type_r['order_no'])))
							{
								$site_item_attributes_r[$fieldname] = $new_attributes_r[$variable][0];
								
								// remove it
								array_splice( $new_attributes_r[$variable], 0, 1);
								
								$processing_s_attribute_type = $attribute_type_r['s_attribute_type'];
							}
							else
							{
								// otherwise just copy the whole thing.
								$site_item_attributes_r[$fieldname] = $new_attributes_r[$variable];
							}
						}
						else
						{
							$site_item_attributes_r[$fieldname] = $new_attributes_r[$variable][0];
						}
					}
				}
				else if(!is_array($new_attributes_r[$variable]))
				{
					$site_item_attributes_r[$fieldname] = $new_attributes_r[$variable];
				}
			}
			else if($attribute_type_r['s_field_type'] == 'TITLE' && isset($new_attributes_r['title']))
			{
				// in case developer forgot to setup title mapping.
				$fieldname = get_field_name($attribute_type_r['s_attribute_type'], $attribute_type_r['order_no']);
				$site_item_attributes_r[$fieldname] = $new_attributes_r['title'];
			}
		}//while
		mysql_free_result($results);	
	}
	
	//else
	return $site_item_attributes_r;
}

/**
	This function will return a complete table of all links valid
	for this item_type.

	This is useful because it allows the use of a site plugin for
	generating links only, by specifying as the default site type.
*/
function get_site_plugin_links_table($page_title, $item_r)
{
	global $CONFIG_VARS;
	
	$results = fetch_site_plugin_rs($item_r['s_item_type']);
	if($results)
	{
		$table = "<table border=0 cellspacing=10><tr>";
		
		while($site_plugin_type_r = mysql_fetch_array($results, MYSQL_ASSOC))
		{
			if(is_exists_site_plugin($site_plugin_type_r['site_type']))
			{
				$site_plugin_conf_rs = get_site_plugin_conf_r($site_plugin_type_r['site_type']);
				
				// Get the primary link, which will be extended with details for each individual link.
				if(strlen($site_plugin_type_r['image'])>0)
					$link_text = "<img src=\"./site/images/".$site_plugin_type_r['image']."\" border=0 align=absmiddle valign=absmiddle title=\"".htmlspecialchars($site_plugin_type_r['title'])."\" alt=\"".htmlspecialchars($site_plugin_type_r['title'])."\">";
				else
					$link_text = "[".$site_r['title']."]";
							
				$results2 = fetch_site_plugin_link_rs($site_plugin_type_r['site_type'], $item_r['s_item_type']);
				if($results2)
				{
					while($site_plugin_link_r = mysql_fetch_array($results2, MYSQL_ASSOC))
					{
						$parse_url = NULL;
						
						if(strlen($site_plugin_link_r['url'])>0 && is_exists_site_item_attribute($site_plugin_type_r['site_type'], $item_r))
							$parse_url = $site_plugin_link_r['url'];
						else if(strlen($site_plugin_link_r['title_url'])>0)
							$parse_url = $site_plugin_link_r['title_url'];
						
						if($parse_url != NULL)
						{
							// now we want to expand the $parse_url
							$mask_elements = parse_field_mask($parse_url);
							$parse_url = expand_title_mask($item_r, $parse_url, $mask_elements, $site_plugin_conf_rs);
						
							$table .= "<td class=\"footer\"><a href=\"external.php?url=".urlencode($parse_url)."&title=".urlencode($page_title.' - '.$site_plugin_type_r['title'].' ['.$site_plugin_link_r['description'].']')."\" target=\"_blank\">$link_text";
							$table .= "&nbsp;[".str_replace(" ", "&nbsp;", $site_plugin_link_r['description'])."]";
							$table .= "</a></td>";
						}
					}//while
					mysql_free_result($results2);
				}
			}
		}//while
		mysql_free_result($results);
		
		$table .= "</tr></table>";
		return $table;
	}
	else
	{
		return "&nbsp;";
	}
}

//
// ###### EXPERIMENTAL ######
//

/**
	We have to convert the OpenDb language specifiers to 
	Google equivalents.
*/
$translate_with_google_lang_map
				 = array(
					'german'=>'de',
					'spanish'=>'es',
					'french'=>'fr',
					'italian'=>'it',
					'portuguese'=>'pt');

/*
	Will translate english text to $to_lang using the Google
	language site.

	@param $text
	@param $language	This value should be the same as that
				used in include/config.php $CONFIG_VARS['site.language']
				but it does not have to be, as long as the
				variable is specified in the same manner (The
				full name of the language, rather than an 
				abbreviation)
*/
function translate_with_google($text, $language)
{
	// from config.php
	global $CONFIG_VARS;
	global $translate_with_google_lang_map;

	$snoopy = new Snoopy;
	
	// if no proxy
	if ($CONFIG_VARS['proxy_server.enable']==TRUE)
	{
		$snoopy->proxy_host = $CONFIG_VARS['proxy_server.host'];
		$snoopy->proxy_port = $CONFIG_VARS['proxy_server.port'];
		$snoopy->user = $CONFIG_VARS['proxy_server.userid'];
		$snoopy->pass = $CONFIG_VARS['proxy_server.password'];
	}

	if(strlen($translate_with_google_lang_map[$language])>0)
	{
		$formvars["langpair"] = "en|".$translate_with_google_lang_map[$language];
		$formvars["text"] = $text;

		if($snoopy->submit("http://translate.google.com/translate_t", $formvars) && $snoopy->status == 200)
		{
			if(preg_match("/<textarea name=q.+?>(.+?)<\/textarea>/is", $snoopy->results, $regs))
			{
				return $regs[1];
			}
		}	
		else
		{
			opendb_logger(OPENDB_LOG_ERROR, 'functions/site_plugin.php', 'translate_with_google', NULL, $snoopy->error, array($text, $language));
		}
	}
	else
	{
		opendb_logger(OPENDB_LOG_ERROR, 'functions/site_plugin.php', 'translate_with_google', NULL, NULL, array($text, $language));
	}
	
	//else - return original text as last resort.
	return $text;
}
?>
