<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	Note:
		This backup code is based on the "dump" feature from the phpMyAdmin project.
*/

// This must be first - includes config.php
require_once("./include/begin.inc.php");

include_once("./include/language.php");
include_once("./include/theme.php");

include_once("./functions/database.php");
include_once("./functions/auth.php");
include_once("./functions/logging.php");
include_once("./functions/user.php");
include_once("./functions/widgets.php");
include_once("./functions/http.php");
include_once("./functions/utils.php");
include_once("./functions/datetime.php");

/**
	Get the content of $table as a series of INSERT statements.
	
	Simplified, as this is purely a SQL generation script
	now. 
*/	
function get_table_content($table, $send_as_format, $crlf)
{
	global $CONFIG_VARS;
	
   	$result = run_opendb_query("SELECT * FROM $table");

	//prefix if required to table name before exporting.
	if(strlen($CONFIG_VARS['db_server.table_prefix'])>0)
	{
		$table = $CONFIG_VARS['db_server.table_prefix'].$table;
	}
	
   	$i = 0;
    while($row = mysql_fetch_row($result))
	{
		$table_list = "";
		for($j=0; $j<mysql_num_fields($result);$j++)
		{
			if(strlen($table_list)>0)
				$table_list .= ", ";
				
			$table_list .= mysql_field_name($result,$j);
		}
		$table_list = "(".$table_list.")";

		$schema_insert = "";	
		for($j=0; $j<mysql_num_fields($result);$j++)
		{
			if(strlen($schema_insert)>0)
				$schema_insert .= ", ";
				
			if(!isset($row[$j]))
				$schema_insert .= "NULL";
			else if($row[$j] != "")
			{
				$row[$j] = replace_newlines($row[$j]);
				
				// Escape normal addslashes: \', \", \\, \0 add to that \n
				$row[$j] = addcslashes($row[$j], "\'\"\\\0\n");
				$schema_insert .= "'".$row[$j]."'";
			}
			else
				$schema_insert .= "''";
		}
		
		$schema_insert = "INSERT INTO $table $table_list VALUES (".$schema_insert.")";

		// Get rid of newlines.
		$schema_insert = str_replace("\n","", $schema_insert);
		$schema_insert = str_replace("\r","", $schema_insert);
		
		if(strlen($send_as_format)>0)
			echo(trim($schema_insert).";".$crlf);
		else
			echo htmlspecialchars(trim($schema_insert).";".$crlf);
				
		$i++;
	}
	return TRUE;
}

if($CONFIG_VARS['site.enable']!==FALSE)
{
	session_start();
	if (is_opendb_valid_session())
	{
		// Only admin user is allowed to access this.
		if(is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']))
		{
			$_TABLES = array('user'=>'Y',
							'user_address'=>'Y',
							'user_address_attribute'=>'Y',
							'review'=>'Y',
							'item'=>'Y',
							'item_instance'=>'Y',
							'item_attribute'=>'Y',
							'borrowed_item'=>'Y',
							's_item_type'=>'N',
							's_item_type_group'=>'N',
							's_item_type_group_rltshp'=>'N',
							's_attribute_type'=>'N',
							's_attribute_type_lookup'=>'N',
							's_item_attribute_type'=>'N',
							's_status_type'=>'N',
							's_address_type'=>'N',
							's_addr_attribute_type_rltshp'=>'N',
							's_site_plugin'=>'N',
							's_site_plugin_conf'=>'N',
							's_site_plugin_input_field'=>'N',
							's_site_plugin_s_attribute_type_map'=>'N',
							's_site_plugin_s_attribute_type_lookup_map'=>'N',
							's_site_plugin_link'=>'N'
						);
								
			if($HTTP_VARS['op'] == 'export')
			{
				@set_time_limit(600);
				if(strlen($HTTP_VARS['send_as_format'])==0)
				{ 
					echo _theme_header($LANG_VARS['backup_database']);
					echo "<pre>\n";
					
					// if in browser then use simple unix newline.
					$CRLF = "\n";
				}
				else
				{
					header("Cache-control: no-store");
					header("Pragma: no-store");
					header("Expires: 0");
					header("Content-disposition: attachment; filename=backup.sql");
					header("Content-type: application/octet-stream");
					
					$CRLF = get_user_browser_crlf();
				}
	
				echo("# -------------------------------------------------------------".$CRLF);
			    echo("# ".replace_lang_vars(array('site'=>$CONFIG_VARS['site.title'], 'version'=>$CONFIG_VARS['site.version']), $LANG_VARS['tbl_dump_header']).$CRLF);
	   			echo("# http://sourceforge.net/projects/opendb/".$CRLF);
			    echo("#".$CRLF);
	   			echo("# ".replace_lang_var("host", $CONFIG_VARS['db_server.dbname']."@".$CONFIG_VARS['db_server.host'], $LANG_VARS['connected_to']).$CRLF);
				echo("# ".replace_lang_var("date", get_localised_timestamp($CONFIG_VARS['print_listing.datetime_mask']), $LANG_VARS['backup_log_generated']).$CRLF);
			    echo("# -------------------------------------------------------------".$CRLF);
	
				// special all tables option reset $HTTP_VARS['tables'] array as a result
				if(strcasecmp($HTTP_VARS['all_tables'],'y')===0)
				{
					unset($HTTP_VARS['tables']);
					
					while(list($key,$value) = each($_TABLES))
					{
						$HTTP_VARS['tables'][] = $key;
					}
				}
				
				@reset($HTTP_VARS['tables']);
				while (list(,$table) = @each($HTTP_VARS['tables']))
				{
					echo $CRLF."#".$CRLF;
					echo "# ".replace_lang_var('table', $table, $LANG_VARS['dumping_data_for_table']).$CRLF; 
					echo "#".$CRLF.$CRLF;
	
					get_table_content($table, $HTTP_VARS['send_as_format'], $CRLF);
				}			
	
				if(strlen($HTTP_VARS['send_as_format'])==0)
				{
					echo "\n</pre>";
					echo _theme_footer();
				}
			}
			else //if($HTTP_VARS['op'] == 'export')
			{
				echo _theme_header($LANG_VARS['backup_database']);
				echo("<h2>".$LANG_VARS['backup_database']."</h2>");
				
				echo(get_setcheckboxes_javascript());
				
				echo("<form method=\"post\" action=\"$PHP_SELF\">"
					."<input type=hidden name=op value=export>"
					."<table cellspacing=1 border=0>");
				
				$field = "<table border=0>\n<tr>";
				$count=0;
				while(list($key,$value) = each($_TABLES))
				{
					if($count>=2)
					{
						$field .= "\n</tr>\n<tr>";
						$count=0;
					}
					$field .= "\n<td nowrap><input type=checkbox name=\"tables[]\" value=\"$key\" ".($value=='Y'?"CHECKED":"").">$key</td>";
					
					$count++;
				}
				
				if($count>0 && $count < 2) // $count == 1 would have been easier, but might change to 3 columns, so logic is easier to maintain
				{
					for($i=$count; $i<2; $i++)
					{
						$field .= "\n<td>&nbsp;</td>";
					}					
				}
				
				$field .= "\n</tr>\n";
				
				$field .= "\n<tr><td colspan=2>&nbsp;</td></tr>";
				$field .= "\n<tr><td colspan=2>".
							"<input type=button value=\"".$LANG_VARS['check_all']."\" onClick=\"setCheckboxes(this.form, 'tables[]', true);\">&nbsp;".
							"<input type=button value=\"".$LANG_VARS['uncheck_all']."\" onClick=\"setCheckboxes(this.form, 'tables[]', false);\">&nbsp;".
							"<input type=reset value=\"".$LANG_VARS['reset']."\">".
							"</td></tr>";
				
				$field .= "\n</table>\n";
				
				echo format_field(
					$LANG_VARS['table'], 
					NULL, 
					$field);
	
				echo format_field(
					$LANG_VARS['send_as_file'],
					NULL,
					"<input type=\"checkbox\" name=\"send_as_format\" value=\"file\" CHECKED>");
			
				echo("</table>
					<br>
					<input type=\"submit\" value=\"".$LANG_VARS['backup_database']."\">
					</form>");
					
				echo _theme_footer();
			}
		}
		else//not an administrator or own user.
		{
			echo _theme_header($LANG_VARS['not_authorized_to_page']);
			echo _theme_error($LANG_VARS['not_authorized_to_page']);
			echo _theme_footer();
		}	
	}
	else
	{
		// invalid login, so login instead.
		include("./login.php");
	}
}//if($CONFIG_VARS['site.enable']!==FALSE)
else
{
	echo _theme_header($LANG_VARS['site_is_disabled'], FALSE);
	echo _theme_error($LANG_VARS['site_is_disabled']);
	echo _theme_footer();
}

// Cleanup after begin.inc.php
require_once("./include/end.inc.php");
?>
