# 
# Patch for 0.33-dev3
#

#
# Update all IMAGEURL item_attributes to include 'http://' prefix!
# This is required for the new support for locally stored Cover images.  We need to be able to check for 
# the existence of 'http://' at the start of IMAGEURL attribute_val, to work out whether they are relative
# or not.
#
UPDATE item_attribute SET attribute_val = CONCAT('http://',attribute_val) WHERE s_attribute_type = 'IMAGEURL' AND attribute_val NOT LIKE 'http://%' AND LENGTH(TRIM(attribute_val)) > 0;

#
# Ordering of s_item_type's in Lists of Values, etc.
# The tinyint(2) unsigned limits the number of order_no to 100 (including 0)
#
ALTER TABLE s_item_type ADD order_no tinyint(2) unsigned AFTER default_site_type;

# Reduce s_attribute_type_lookup value column size
ALTER TABLE s_attribute_type_lookup CHANGE value value varchar(100) NOT NULL;

#
# Replace category_ind/image_ind and now duration_ind with a new s_field_type, which
# will have values like 'CATEGORY', 'IMAGE', 'DURATION'
#
ALTER TABLE s_item_attribute_type ADD s_field_type varchar(10) AFTER prompt;

UPDATE s_item_attribute_type SET s_field_type = 'CATEGORY' where UPPER(category_ind) = 'Y';
UPDATE s_item_attribute_type SET s_field_type = 'IMAGE' where UPPER(image_ind) = 'Y';

ALTER TABLE s_item_attribute_type DROP category_ind;
ALTER TABLE s_item_attribute_type DROP image_ind;

#
# ALT_TITLE support.
#
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, site_type) VALUES ('ALT_TITLE', 'Original Title of film', 'Original Title', 'text(50)', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'RATIO', NULL, '2.20', NULL, NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'RATIO', NULL, '1.78', NULL, NULL, NULL);

#
# By default the display_type of all input_type = 'hidden', should also be
# hidden, but only if display_type does not already have a value.
#
UPDATE s_attribute_type SET display_type = 'hidden' WHERE input_type = 'hidden' AND LENGTH(TRIM(display_type)) = 0;

#
# Borrow Duration.  A maximum of 999 days is all that is allowed for borrow_duration/total values.
#
ALTER TABLE item_instance ADD borrow_duration smallint(3) unsigned AFTER owner_id;
ALTER TABLE borrowed_item ADD borrow_duration smallint(3) unsigned AFTER borrower_id;
ALTER TABLE borrowed_item ADD total_duration smallint(3) unsigned AFTER borrow_duration;

#
# This attribute is reserved for use in Borrow Duration functionality.  Please do not use it for your own s_item_attribute_type structures.
# If you want you could run this update to change the input type for S_DURATION a numeric input field instead:
# UPDATE s_attribute_type SET input_type = 'number(3, %field% <i>days</i>)' WHERE s_attribute_type = 'S_DURATION'
#
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, site_type) VALUES ( 'S_DURATION', 'Borrow Duration', 'Borrow Duration', 'single_select(%display%)', NULL, NULL);

INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ('S_DURATION', '0', '', 'Undefined', NULL, 'Y');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ('S_DURATION', '1', '1', 'One Day', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ('S_DURATION', '2', '3', 'Three Days', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ('S_DURATION', '3', '7', 'One Week', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ('S_DURATION', '4', '14', 'Two Weeks', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ('S_DURATION', '5', '28', 'One Month', NULL, NULL);

#
# Now link it in.
#
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DVD', 'S_DURATION', '200', NULL, 'DURATION', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'LD', 'S_DURATION', '200', NULL, 'DURATION', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'VCD', 'S_DURATION', '200', NULL, 'DURATION', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'VHS', 'S_DURATION', '200', NULL, 'DURATION', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'CD', 'S_DURATION', '200', NULL, 'DURATION', NULL);
# DIVX not even added, so will be linked in as part of DIVX addition!

#
# DIVX Support
#
INSERT INTO s_item_type (s_item_type, description, image, title_prompt, default_site_type, order_no) VALUES ( 'DIVX', 'DivX Video', 'divX.gif', NULL, 'imdb', '3');

# DivX Attributes
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, site_type) VALUES ( 'DIVXVIDVER', 'Video Codec Version', 'Video Codec', 'single_select(%display%)', '%display%', NULL); 
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, site_type) VALUES ( 'DIVXAUDVER', 'Audio Codec Version', 'Audio Codec', 'single_select(%display%)', '%display%', NULL); 
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, site_type) VALUES ( 'DIVXQUALIT', 'DIVX Quality', 'Quality', 'single_select(%display%)', '%display%', NULL); 

# Disable this line in favour of specific Alternate title patch.
#INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DIVX', 'ALT_TITLE', '10', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DIVX', 'MOVIE_PLOT', '20', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DIVX', 'DIRECTOR', '30', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DIVX', 'ACTORS', '40', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DIVX', 'MOVIEGENRE', '50', NULL, 'CATEGORY', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DIVX', 'YEAR', '60', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DIVX', 'RUN_TIME', '70', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DIVX', 'AUDIO_LANG', '80', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DIVX', 'SUBTITLES', '90', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DIVX', 'AGE_RATING', '100', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DIVX', 'RATIO', '110', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DIVX', 'DIVXVIDVER', '120', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DIVX', 'DIVXAUDVER', '130', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DIVX', 'DIVXQUALIT', '140', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DIVX', 'DVD_FORMAT', '150', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DIVX', 'DVD_EXTRAS', '160', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DIVX', 'IMAGEURL', '0', NULL, 'IMAGE', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DIVX', 'TRAILER', '0', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DIVX', 'IMDB_ID', '0', NULL, NULL, NULL);
# Heres the DURATION support added to DIVX
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DIVX', 'S_DURATION', '200', NULL, 'DURATION', NULL);

# Divx audio and video
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'DIVXAUDVER', NULL, 'mp3', 'Mp3', NULL, 'Y');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'DIVXAUDVER', NULL, 'mp2', 'Mp2', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'DIVXAUDVER', NULL, 'ogg', 'Ogg', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'DIVXVIDVER', NULL, 'divx4', 'Divx4', NULL, 'Y');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'DIVXVIDVER', NULL, 'divx3', 'Divx3 3.11 Alpha', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'DIVXVIDVER', NULL, 'angelpotion', 'Angel Potion Codec', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'DIVXQUALIT', NULL, 'poor', 'Poor', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'DIVXQUALIT', NULL, 'medium', 'Medium', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'DIVXQUALIT', NULL, 'Good', 'Good', NULL, NULL);

#
# Replace ORIG_TITLE attribute references with ALT_TITLE onces.
#
delete from s_attribute_type where s_attribute_type = 'ORIG_TITLE';

update item_attribute set s_attribute_type = 'ALT_TITLE'
where s_attribute_type = 'ORIG_TITLE';

update s_item_attribute_type set s_attribute_type = 'ALT_TITLE'
where s_attribute_type = 'ORIG_TITLE';

#
# Update Movie Genre to support composite genre's
#
UPDATE s_attribute_type set input_type = 'checkbox_grid(%display%, 4)',
			display_type = 'category(%display%)'
WHERE s_attribute_type = 'MOVIEGENRE';

#
# All the prompts here are the same as that defined in s_attribute_type for 'MOVIEGENRE'
#
update s_item_attribute_type
set prompt = NULL
where s_attribute_type = 'MOVIEGENRE';

#
# Subtitles input looks better with 4 wide grids
#
UPDATE s_attribute_type set input_type = 'checkbox_grid(%img% %display%, 4)'
WHERE s_attribute_type = 'SUBTITLES';

#
# Default order for all system item types.
#
UPDATE s_item_type set order_no = 0 where s_item_type = 'DVD';
UPDATE s_item_type set order_no = 1 where s_item_type = 'VHS';
UPDATE s_item_type set order_no = 2 where s_item_type = 'CD';
# DIVX has just been inserted, so order_no already set!
UPDATE s_item_type set order_no = 4 where s_item_type = 'VCD';
UPDATE s_item_type set order_no = 5 where s_item_type = 'LD';

#
# This attribute is reserved for use in item_review.  Please do not use it for your own s_item_attribute_type structures.
#
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, site_type) VALUES ( 'S_RATING', 'Item Rating', 'Rating', 'review_options(%display%, VERTICAL)', NULL, NULL);

INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'S_RATING', NULL, '1', 'Disgraceful!', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'S_RATING', NULL, '2', 'Terrible!', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'S_RATING', NULL, '3', 'Decent!', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'S_RATING', NULL, '4', 'Great!', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ( 'S_RATING', NULL, '5', 'Sensational!', NULL, NULL);

#
# For performance reasons you should explicity set the display_type of any attributes where no comparison
# to lookup values is required.
#
UPDATE s_attribute_type SET display_type = '%value%' WHERE s_attribute_type IN('ALT_TITLE','COMMENTS','MOVIE_PLOT','CDTRACK','CDTIME');

#
# List Link functionality
#
UPDATE s_attribute_type SET display_type = 'display(%value%, list-link)' where s_attribute_type IN('YEAR','VID_FORMAT','DVD_REGION');
UPDATE s_attribute_type SET display_type = 'display(%display%, list-link)' where s_attribute_type IN('VIDQUALITY','VHS_TYPE','DIVXVIDVER','DIVXAUDVER','DIVXQUALIT');
UPDATE s_attribute_type SET display_type = 'display(%img% %display%, list-link)' where s_attribute_type IN('AUDIO_LANG', 'SUBTITLES');

# Do it for Director as well in case there is dual directorship!
UPDATE s_attribute_type SET display_type = 'list(plain, " ", list-link)' where s_attribute_type IN('DIRECTOR','ACTORS','ARTIST');
# The display(%value%, list-link) widget does not work for attributes which have more than one %value%.
UPDATE s_attribute_type SET display_type = 'list(plain, " ", list-link)' where s_attribute_type IN('RATIO');
UPDATE s_attribute_type SET display_type = 'display(%img%, list-link)' where s_attribute_type  = 'AGE_RATING';
UPDATE s_attribute_type SET display_type = 'category(%display%, list-link)' where s_attribute_type IN('MOVIEGENRE','MUSICGENRE');

#
# Save Covers locally functionality.
#
UPDATE s_attribute_type SET input_type = 'upload_or_saveurl(50,*,"gif,jpg,png")', display_type = 'hidden' WHERE s_attribute_type = 'IMAGEURL';

#
# Used to display item.id in item_display.php script.
#
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, site_type) VALUES ( 'S_ITEM_ID', 'OpenDb Item ID', 'ID#', 'hidden', '%value%', NULL);

INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DVD', 'S_ITEM_ID', '0', NULL, 'ITEM_ID', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'LD', 'S_ITEM_ID', '0', NULL, 'ITEM_ID', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'VHS', 'S_ITEM_ID', '0', NULL, 'ITEM_ID', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'VCD', 'S_ITEM_ID', '0', NULL, 'ITEM_ID', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DIVX', 'S_ITEM_ID', '0', NULL, 'ITEM_ID', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'CD', 'S_ITEM_ID', '0', NULL, 'ITEM_ID', NULL);

# Amazon dummy attribute - may never be used to populate records, but will allow addition of links to particular items.
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, site_type) VALUES ( 'AMAZONASIN', 'Amazon Standard Item Number', 'Amazon ASIN', 'hidden', 'hidden', 'amazon');

INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DVD', 'AMAZONASIN', '0', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'LD', 'AMAZONASIN', '0', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'VHS', 'AMAZONASIN', '0', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'VCD', 'AMAZONASIN', '0', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DIVX', 'AMAZONASIN', '0', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'CD', 'AMAZONASIN', '0', NULL, NULL, NULL);

