<?php
/* 	OpenDb - Open Lending Database Project
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// This must be first - includes config.php
require_once("./include/begin.inc.php");

include_once("./include/language.php");
include_once("./include/theme.php");

include_once("./include/language.php");
include_once("./functions/function.php");
include_once("./functions/http.php");
include_once("./functions/user.php");
include_once("./functions/email.php");
include_once("./functions/whatsnew.php");
include_once("./functions/widgets.php");

/*
* This function will not be called if borrow functionality is not 
* enabled.  A Normal user will be created.
*/
function user_type()
{
	global $CONFIG_VARS;
	global $LANG_VARS;
	global $PHP_SELF;
	
	$page_title = replace_lang_var('site', $CONFIG_VARS['site.title'], $LANG_VARS['new_account']);
	echo _theme_header($page_title);

	echo("\n<h2>".$page_title."</h2>".
		"\n<form action=\"$PHP_SELF\" method=\"get\">".
		"\n<input type=hidden name=\"op\" value=\"edit_info\">");
	
	echo("\n<p><h3><input type=\"radio\" name=\"usertype\" value=\"N\" CHECKED>".get_usertype_description('N')."</h3>".
		$LANG_VARS['new_account_usertype_intro']['N'].
			"</p>");
	
	echo("\n<h3><input type=\"radio\" name=\"usertype\" value=\"B\">".get_usertype_description('B')."</h3>".
			$LANG_VARS['new_account_usertype_intro']['B'].
			"</p>");
			
		echo("\n<input type=\"submit\" value=\"".$LANG_VARS['edit_info']."\">".
			"\n</form>");
}

function edit_info($HTTP_VARS)
{
	global $CONFIG_VARS;
	global $LANG_VARS;
	global $_OPENDB_THEME;
	global $PHP_SELF;
	
	$page_title = replace_lang_var('site', $CONFIG_VARS['site.title'], $LANG_VARS['new_account_edit_info']);
	echo _theme_header($page_title);

	echo get_validation_javascript();

	echo "<h2>".$page_title."</h2>".
		"\n<form action=\"$PHP_SELF\" method=\"post\">".
		"\n<input type=hidden name=\"op\" value=\"send_info\">".
		"\n<input type=hidden name=\"usertype\" value=\"".$HTTP_VARS['usertype']."\">".
		"\n<table border=0>";

	echo get_input_field("uid",
				NULL, // s_attribute_type
				$LANG_VARS['userid'], 
				"filtered(20,20,a-zA-Z0-9_.)", //input type.
				"Y", //compulsory!
				"",
				TRUE);
				
	echo get_input_field("fullname",
				NULL, // s_attribute_type
				$LANG_VARS['fullname'], 
                "text(30,100)", //input type.
   	            "Y", //compulsory!
       	        "",
				TRUE);
	
	echo get_input_field("email",
				NULL, // s_attribute_type
				$LANG_VARS['email'], 
                "email(30,50)", //input type.
   	            "Y", //compulsory!
       	        "",
				TRUE);
	
	if($CONFIG_VARS['user_admin.user_themes_support']!==FALSE)
	{
		echo format_field($LANG_VARS['user_theme'], 
				NULL, 
				custom_select("uid_theme", get_user_theme_r(), "%value%", 1, $_OPENDB_THEME));
	}
	
	if($CONFIG_VARS['newuser.include_address_fields']!==FALSE)
	{
		echo("\n<tr><td colspan=2>&nbsp;</td></tr>");
		echo get_input_field("phone", NULL, $LANG_VARS['phone_number'], "filtered(20,50,0-9 \\\-+)","Y","",TRUE);
		echo get_input_field("address", NULL, $LANG_VARS['address'], "textarea(25,2)","Y","",TRUE);
		echo get_input_field("city", NULL, $LANG_VARS['city'], "text(20,100)","Y","",TRUE);
		echo get_input_field("state", NULL, $LANG_VARS['state'], "text(20,100)","Y","",TRUE);
		echo get_input_field("zip", NULL, $LANG_VARS['zip'], "text(10)","Y","",TRUE);
		echo get_input_field("country", NULL, $LANG_VARS['country'], "text(2,2)","N","",TRUE);
	}
	else
	{
		echo get_input_field("location",
				NULL, // s_attribute_type
				$LANG_VARS['location'], 
           	    "text(30,50)", //input type.
               	"Y", //compulsory!
				"",
				TRUE);
	}
	
	echo("\n<tr><td colspan=2>&nbsp;</td></tr>");
	echo get_input_field("pwd",
				NULL, // s_attribute_type
				$LANG_VARS['new_passwd'], 
                "password(30,40)", //input type.
   	            "N", //compulsory!
       	        "",
				TRUE);
				
	echo get_input_field("confirmpwd",
				NULL, // s_attribute_type
				$LANG_VARS['confirm_passwd'], 
                "password(30,40)", //input type.
   	            "N", //compulsory!
       	        "",
				TRUE,
				NULL,
				$CONFIG_VARS['widgets.enable_javascript_validation']!==FALSE?"if( (this.form.pwd.value.length!=0 || this.form.confirmpwd.value.length!=0) && this.form.pwd.value!=this.form.confirmpwd.value){alert('".$LANG_VARS['passwds_do_not_match']."'); this.focus(); return false;}":"");
	
	if($CONFIG_VARS['widgets.enable_javascript_validation']!==FALSE)
		$onclick_event = "if(!checkForm(this.form)){return false;}else{this.form.submit();}";
	else
		$onclick_event = "this.form.submit();";
					
	echo("<tr><td><input type=\"button\" onclick=\"$onclick_event\" value=\"".$LANG_VARS['send_info']."\"</td></tr>".
			"\n</table></form>");
			
	// insert user
	if(!is_array($user_r))
		echo(format_help_block($LANG_VARS['user_add_help']));
}

function send_info($HTTP_VARS)
{
	global $CONFIG_VARS;
	global $LANG_VARS;
	global $PHP_SELF;
	
	$page_title = replace_lang_var('site', $CONFIG_VARS['site.title'], $LANG_VARS['new_account_send_info']);
	echo _theme_header($page_title);

	if($CONFIG_VARS['borrow.enable']!==FALSE)
		$user_type_desc = get_usertype_description($HTTP_VARS['usertype']);
	else
		$user_type_desc = get_usertype_description('N');
	
	echo "\n<h2>".$page_title."</h2>".
		"\n<div class=\"success\">".replace_lang_var('site', $CONFIG_VARS['site.title'], $LANG_VARS['new_account_reply'])."</div>";

	// All User_id's in OpenDb are lowercase.
	$HTTP_VARS['uid'] = strtolower($HTTP_VARS['uid']);

	// Unless the confirmed password matches, we should ignore.	
	if(strlen($HTTP_VARS['pwd'])==0 || $HTTP_VARS['pwd'] != $HTTP_VARS['confirmpwd'])
		$HTTP_VARS['pwd'] = "";
	
	$message = 
		"\n".$LANG_VARS['userid'].": ".$HTTP_VARS['uid'].
		"\n".$LANG_VARS['fullname'].": ".$HTTP_VARS['fullname'].
		(strlen($HTTP_VARS['pwd'])>0?"\n".$LANG_VARS['new_passwd'].": ".$HTTP_VARS['pwd']:"").
		"\n".$LANG_VARS['user_type'].": ".$user_type_desc.
		"\n".$LANG_VARS['user_theme'].": ".$HTTP_VARS['uid_theme'].
		"\n".$LANG_VARS['email'].": ".$HTTP_VARS['email'];
		
	if($CONFIG_VARS['newuser.include_address_fields']!==FALSE)
	{
		$message .= 
			"\n".$LANG_VARS['phone_number'].": ".$HTTP_VARS['phone'].
			"\n\n".$LANG_VARS['address'].": ".$HTTP_VARS['address'].
			"\n".$LANG_VARS['city'].": ".$HTTP_VARS['city'].
			"\n".$LANG_VARS['state'].": ".$HTTP_VARS['state'].
			"\n".$LANG_VARS['zip'].": ".$HTTP_VARS['zip'].
			"\n".$LANG_VARS['country'].": ".$HTTP_VARS['country'];
	}
	else
	{
		$message .= "\n".$LANG_VARS['location'].": ".$HTTP_VARS['location'];
	}
		
	// The email is sent to the admin user, so we do not have to worry about doing the check here, it
	// is secure.
	if(!is_user_valid($HTTP_VARS['uid']))
	{
		if($CONFIG_VARS['newuser.include_address_fields']!==FALSE)
		{
			// Ensure no more than 50 characters for location.
			if(strlen($HTTP_VARS['city'])>0 && strlen($HTTP_VARS['state'])>0 && strlen($HTTP_VARS['country'])>0 && strlen($HTTP_VARS['city'].", ".$HTTP_VARS['state']." ".$HTTP_VARS['country'])<=50)
			{
				$location = $HTTP_VARS['city'].", ".$HTTP_VARS['state']." ".$HTTP_VARS['country'];
			}
			else if(strlen($HTTP_VARS['city'])>0 && strlen($HTTP_VARS['state'])>0 && strlen($HTTP_VARS['city'].", ".$HTTP_VARS['state'])<=50)
			{
				$location = $HTTP_VARS['city'].", ".$HTTP_VARS['state'];
			}
			else
				$location = $HTTP_VARS['city'];
		}
		else
		{
			$location = $HTTP_VARS['location'];
		}
	
		$message .= "\n\n".
			replace_lang_vars(
				array(
					'site'=>$CONFIG_VARS['site.title'],
					'url'=>get_site_url()."user_admin.php?".
						"op=insert".
						"&uid=".urlencode($HTTP_VARS['uid']).
						"&fullname=".urlencode($HTTP_VARS['fullname']).
						(strlen($HTTP_VARS['pwd'])>0?"&pwd=".urlencode($HTTP_VARS['pwd'])."&confirmpwd=".urlencode($HTTP_VARS['pwd']):"").
						"&location=".urlencode($location).
						"&email=".urlencode($HTTP_VARS['email']).
						"&uid_theme=".urlencode($HTTP_VARS['uid_theme']).
						"&usertype=".$HTTP_VARS['usertype'].
						"&email_user=Y"),
				expand_langvar_newlines($LANG_VARS['new_account_add_user_url']));
	}
	else
	{
		$message .= "\n\n". replace_lang_var('user_id', $HTTP_VARS['uid'], $LANG_VARS['user_exists']);
	}				
	
	$results = opendb_email(
					$CONFIG_VARS['site.admin_email'], 
					$CONFIG_VARS['site.admin_name'], 
					$HTTP_VARS['email'], 
					$HTTP_VARS['fullname'],
					replace_lang_var('site', '', $LANG_VARS['new_account']),
					$message);

	if($results !==TRUE)
	{
		echo format_error_block($results);
	}
}

session_start();

if($CONFIG_VARS['newuser.signup_enable']!==FALSE)
{
	if($HTTP_VARS['op'] == "edit_info")
	{
		edit_info($HTTP_VARS);
	}
	else if($HTTP_VARS['op'] == "send_info")
	{
		send_info($HTTP_VARS);
	}
	else
	{
		if($CONFIG_VARS['borrow.enable']!==FALSE)
			user_type();
		else
			edit_info(NULL);
	}
}
else//if($CONFIG_VARS['site.signup_enable']!==FALSE)
{
	echo _theme_header($LANG_VARS['operation_not_available']);
	echo _theme_error($LANG_VARS['operation_not_available']);	
}

echo format_footer_links(array(array(url=>"login.php",text=>$LANG_VARS['return_to_login_page'])));
echo theme_footer();

// Cleanup after begin.inc.php
require_once("./include/end.inc.php");
?>
