<?php
/* 	OpenDb - Open Lending Database Project
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*
Secure the log directory via Web Server configuration.  For
example, this is my Apache 1.3.x configuration for Opendb.
I have secured the /opendb/log virtual_location with the
second directive.
	
Alias /opendb /opt/opendb
<Location /opendb>
  Options Indexes FollowSymLinks
  order deny,allow
  deny from all
  allow from all
</Location>
 
<Location "/opendb/log/">
order deny,allow
deny from all
</Location>
*/

// This must be first - includes config.php
require_once("./include/begin.inc.php");

include_once("./include/language.php");
include_once("./include/theme.php");

include_once("./functions/function.php");
include_once("./functions/user.php");
include_once("./functions/datetime.php");

/**
	Will attempt to explode old format $CONFIG_VARS['logging.file'], with the
	following format:
	
		Date -- Message [ip_address/hostname]

	Note: This function has not been thoroughly tested!  This is because
	in most cases you should not need it.  It is strongly suggested that
	you clear out your $CONFIG_VARS['logging.file'] after upgrading from a version
	prior to OpenDb 0.31!
*/
function explode_line($line)
{
	$pos = strpos($line, "--");
	if($pos!==FALSE){
		$exploded[0] = trim(substr($line,0,$pos));

		$pos2 = strrpos($line, "[");
		// Found ip_address.
		if($pos2!==FALSE)
		{
			$exploded[1] = trim(substr($line,$pos+2,$pos2-($pos+2)));//+2 = "--"
			$pos3 = strrpos($line,"]");
			if($pos3!==FALSE)
			{
				// Strip off hostname.
				$exploded[2] = trim(substr($line,$pos2+1,$pos3-($pos2+1)));//+1 = "["
				$pos = strpos($exploded[2],"/");
				if($pos!==FALSE)
					$exploded[2] = trim(substr($exploded[2],0,$pos));
			}
		}
	}
	// If not processed, this will evaluate to FALSE!
	return $exploded;
}

//---------------------------------------------------
// Highlight the log buffer with the specified colors/keywords
// NOTE: Potential problem with windows servers since "\r\n" is not taken into account ??
function highlight($buffer, $keyword, $type, $fg, $bg)
{
	// make sure we actually have something to do
	if($buffer==NULL || $keyword==NULL || ($fg==NULL && $bg==NULL))
	{
		return $buffer;
	}
	
	// setup css style to match requested display	
	$style = "font-weight:bold;";
	if($fg) $style=$style."color:".$fg."; ";
	if($bg) $style=$style."background-color:".$bg."; ";
	
	// underline, bold, and color matching word
	if($type=="word")
	{
		$style = "text-decoration:underline;".$style;
		$buffer = preg_replace("/(".$keyword.")/i", "<font style=\"".$style."\">\\1</font>", $buffer);
	}

	// bold and color line containing matching word
	if($type=="line")
	{
		$startline_token = "^|\n";
		$endline_token   = "]|$";
	
		$buffer = preg_replace("/(".$startline_token.")(.*?)(".$keyword.")(.*?)(".$endline_token.")/i", "\\1<font style=\"".$style."\">\\2\\3\\4\\5</font>", $buffer);
	}
	
	return $buffer;
}

//---------------------------------------------------
// Create a option-drop box with color choices
function generate_colorbox($name, $option)
{
	// So we can access the language values.
	global $LANG_VARS;

	echo( "<select name=\"$name\">\n" );
	$found=false;
	for( $ix=0; $ix < count($LANG_VARS['colors']); $ix++ )
	{
		// Select the requested choice
		if($option==$LANG_VARS['colors'][$ix][1])
		{
			$selected=" selected";
			$found=true;
		}
		else
			$selected="";
			
		echo( "<option value=\"".$LANG_VARS['colors'][$ix][1]."\"".$selected.">".$LANG_VARS['colors'][$ix][0]."\n");
	}

	// Was our requested color even an option?
	if($found==false)
		echo( "<option value=\"".$option."\" selected>Other: ".$option."\n");

	echo( "</select>\n" );
}
//---------------------------------------------------

session_start();
if (is_opendb_valid_session())
{
	if (is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type'])) // Only admin allowed
	{
		// Not much point continuing if no logfile.
		if(strlen($CONFIG_VARS['logging.file'])>0)
		{
			if(is_readable($CONFIG_VARS['logging.file']))
			{
				if(isset($HTTP_VARS['doDownload'])) // user wants to download usagelog
				{
					$filename = basename($CONFIG_VARS['logging.file']);

					header("Cache-control: no-store");
					header("Pragma: no-store");
					header("Expires: 0");
				    header("Content-disposition: attachment; filename=$filename");
					header("Content-type: application/octetstream");
	
					$fp = fopen($CONFIG_VARS['logging.file'], "r");
					fpassthru($fp);

					//no theme here!
					return;
				}
				else
				{
					if(!isset($HTTP_VARS['doList']))  // setup our default log behavior in here
					{
						$HTTP_VARS['items_count'] = 10;      // define some default keywords to highlight
						$HTTP_VARS['doListMode'] = "highlight";

						$HTTP_VARS['bg'][0]		= "#FF69B4";
						$HTTP_VARS['type'][0]	= "line";
						$HTTP_VARS['keyword'][0]= "fail";

						$HTTP_VARS['fg'][1]		= "#8A2BE2";
						$HTTP_VARS['type'][1]	= "line";
					    $HTTP_VARS['keyword'][1]= "log";

						$HTTP_VARS['fg'][2]		= "#008080";
						$HTTP_VARS['type'][2]	= "line";
						$HTTP_VARS['keyword'][2]= "visit";
	
					    $HTTP_VARS['fg'][3]		= "#FF8C00";
						$HTTP_VARS['type'][3]	= "line";
						$HTTP_VARS['keyword'][3]= "updated";

						$HTTP_VARS['fg'][4]		= "#0000FF";
						$HTTP_VARS['type'][4]	= "line";
						$HTTP_VARS['keyword'][4]= "inserted";
		
						$HTTP_VARS['fg'][5]		= "#FF0000";
						$HTTP_VARS['type'][5]	= "line";
						$HTTP_VARS['keyword'][5]= "deleted";

						$HTTP_VARS['fg'][6]		= "#A52A2A";
						$HTTP_VARS['type'][6]	= "line";
						$HTTP_VARS['keyword'][6]= "email";
	
						$HTTP_VARS['bg'][7]		= "#FFFF00";
						$HTTP_VARS['type'][7]	= "word";
						$HTTP_VARS['keyword'][7]= $HTTP_SESSION_VARS['user_id'];
					}
					
					echo _theme_header($LANG_VARS['view_log_file']);

					// always show menu options
					echo("<h2>".$LANG_VARS['log_file_options']."</h2>");

					echo("<form action=\"$PHP_SELF\" method=\"post\">\n" );
		
					echo("<input type=\"submit\" name=\"doList\" value=\"".$LANG_VARS['list_usagelog']."\">\n" );	
					echo("<input type=\"submit\" name=\"doHighlight\" value=\"".$LANG_VARS['highlight_usagelog']."\">\n" );
					echo("<input type=\"submit\" name=\"doClearConfirm\" value=\"".$LANG_VARS['clear_usagelog']."\">\n" );	
					echo("<input type=\"submit\" name=\"doBackupCopy\" value=\"".$LANG_VARS['backup_usagelog']."\">\n" );	
					echo("<input type=\"submit\" name=\"doDownload\" value=\"".$LANG_VARS['download_usagelog']."\">\n" );	
	
					echo("<input type=\"hidden\" name=\"op\" value=\"menu_option\">\n" );
	
					// encode the default or current highlight settings too
					echo("<input type=\"hidden\" name=\"items_count\" value=\"".$HTTP_VARS['items_count']."\">\n" );
					for($ix=0; $ix<$HTTP_VARS['items_count']; $ix++)
					{
						if($HTTP_VARS['keyword'][$ix])
							echo( "<input type=\"hidden\" name=\"keyword[$ix]\" value=\"".$HTTP_VARS['keyword'][$ix]."\">\n" );
						if($HTTP_VARS['type'][$ix])     
							echo( "<input type=\"hidden\" name=\"type[$ix]\" value=\"".$HTTP_VARS['type'][$ix]."\">\n" );		
						if($HTTP_VARS['fg'][$ix])  	 
							echo( "<input type=\"hidden\" name=\"fg[$ix]\" value=\"".$HTTP_VARS['fg'][$ix]."\">\n" );
						if($HTTP_VARS['bg'][$ix])  	 
							echo( "<input type=\"hidden\" name=\"bg[$ix]\" value=\"".$HTTP_VARS['bg'][$ix]."\">\n" );
					}
	
					echo( "</form>\n" );

					if(isset($HTTP_VARS['doClearConfirm'])) // confirm with user to delete log
					{
						echo("<h3>".$LANG_VARS['clear_usagelog'].":</h3>\n");
		
						echo("<div class=\"colortext\">".$LANG_VARS['clear_log_warning']."</div>");

						echo( "<br><div class=\"error\">".$LANG_VARS['are_you_sure']."</div>\n" );
						echo( "<form action=\"$PHP_SELF\" method=\"post\">\n" );
						echo( "<input type=\"submit\" name=\"doDelete\" value=\" ".$LANG_VARS['yes']." \">\n" );	
						echo( "<input type=\"submit\" name=\"doNothing\" value=\" ".$LANG_VARS['no']." \">\n" );
						echo( "</form>\n" );
					}
					else if(isset($HTTP_VARS['doDelete'])) // delete log file
					{
						echo("<h3>".$LANG_VARS['clear_usagelog'].":</h3>\n");
						
						$result = @unlink($CONFIG_VARS['logging.file']);
						if($result)
						{
							opendb_log("Usage log cleared (update_who=".$HTTP_SESSION_VARS['user_id'].")");
							echo( "<div class=\"success\">".$LANG_VARS['log_cleared']."</div>\n" );
						}
						else
						{
							opendb_log("Failed to clear usage log (update_who=".$HTTP_SESSION_VARS['user_id'].")");
							echo( "<div class=\"error\">".$LANG_VARS['log_not_cleared']."</div>\n" );
						}
					}
					else if(isset($HTTP_VARS['doBackupCopy'])) // get filename to copy log to
					{
						echo( "<h3>".$LANG_VARS['backup_usagelog'].":</h3>\n" );
			
						echo( "<form action=\"$PHP_SELF\" method=\"post\">\n" );
	
						echo( "<div class=\"colortext\">".$LANG_VARS['enter_backup_filename'].":</div>\n" );
	
						if(strlen($CONFIG_VARS['logging.backup_ext_date_format'])>0)
							$dayVal = get_localised_timestamp($CONFIG_VARS['logging.backup_ext_date_format']);
						else
							$dayVal = get_localised_timestamp('DDMMYY');
						echo( "<input type=\"text\" name=\"filename\" value=\"".$CONFIG_VARS['logging.file'].".$dayVal\">\n" );		
						echo( "<input type=\"submit\" name=\"doCopy\" value=\"".$LANG_VARS['backup_usagelog']."\">\n" );	
	
						echo( "</form>\n" );
					}
					else if(isset($HTTP_VARS['doCopy'])) // copy log
					{
						echo( "<h3>".$LANG_VARS['backup_usagelog'].":</h3>\n" );
						
						$result = @copy($CONFIG_VARS['logging.file'], $HTTP_VARS['filename']);
						if($result)
						{
							opendb_log("Usage log backup (backup=".$HTTP_VARS['filename'].", update_who=".$HTTP_SESSION_VARS['user_id'].")");
							echo( "<div class=\"success\">".replace_lang_var("filename", $HTTP_VARS['filename'], $LANG_VARS['backup_successful'])."</div>\n" );
						}
						else
						{
							opendb_log("Failed to backup usage log (backup=".$HTTP_VARS['filename'].", update_who=".$HTTP_SESSION_VARS['user_id'].")");
							echo( "<div class=\"error\">".replace_lang_var("filename",$HTTP_VARS['filename'], $LANG_VARS['backup_unsuccessful'])."</div>\n" );
						}
					}
					else
					{
						if(isset($HTTP_VARS['minusH']) || isset($HTTP_VARS['plusH'])) // add or remove highlight fields
						{
							$HTTP_VARS['doHighlight'] = "yes";

							// calculate new number of fields to show	
							if($HTTP_VARS['minusH'] && $HTTP_VARS['items_count']>5 ) $HTTP_VARS['items_count'] -=5;
							if($HTTP_VARS['plusH']  && $HTTP_VARS['items_count']<50) $HTTP_VARS['items_count'] +=5;
						}
			
						if(isset($HTTP_VARS['doHighlight'])) // Offer options for syntax highlighting
						{
							echo( "<h3>".$LANG_VARS['highlight_options'].":</h3>\n");

							echo( "<form action=\"$PHP_SELF\" method=\"post\">\n" );
	
							echo( "<table cellspacing=1 border=0 frameborder=0>\n" );
							echo( "<tr>\n" );
							echo( "<td class=\"navbar\">&nbsp;</td>\n" );
							echo( "<td class=\"navbar\">&nbsp;".$LANG_VARS['foreground']."&nbsp;</td>\n");
							echo( "<td class=\"navbar\">&nbsp;".$LANG_VARS['background']."&nbsp;</td>\n");
							echo( "<td class=\"navbar\">&nbsp;".$LANG_VARS['highlight_type']."&nbsp;</td>\n");
							echo( "<td class=\"navbar\">".$LANG_VARS['keyword']."</td>\n");
							echo( "</tr>\n" );
	
							for( $ix=0; $ix<$HTTP_VARS['items_count']; $ix++ )
							{
								echo( "<tr class=\"top2\" align=\"center\">\n");
		
								echo( "<td>".($ix+1)."</td>\n" );
								echo( "<td>\n" );
								generate_colorbox( "fg[$ix]", $HTTP_VARS['fg'][$ix]);
								echo( "</td>\n" );
								echo( "<td>\n" );
								generate_colorbox( "bg[$ix]", $HTTP_VARS['bg'][$ix]);
								echo( "</td>\n" );
								echo( "<td>\n");
			
								if($HTTP_VARS['type'][$ix] == "word")    // default check is line
								{
									$line_check = "";
									$word_check = "CHECKED";
								}
								else
								{
									$line_check = "CHECKED";
									$word_check = "";
								}
			
								echo( "<input type=\"radio\" name=\"type[$ix]\" value=\"line\" $line_check>&nbsp;".$LANG_VARS['line']."\n" );	
								echo( "<input type=\"radio\" name=\"type[$ix]\" value=\"word\" $word_check>&nbsp;".$LANG_VARS['word']."\n" );		
								echo( "</td>\n");
								echo( "<td><input type=\"text\" name=\"keyword[$ix]\" value=\"".$HTTP_VARS['keyword'][$ix]."\" size=\"20\"></td>" );
								echo( "</tr>\n");
							}

							echo( "</table>\n" );
							
							echo( "<input type=\"hidden\" name=\"items_count\" value=\"".$HTTP_VARS['items_count']."\">\n" );
							echo( "<input type=\"hidden\" name=\"doListMode\" value=\"highlight\">\n" );
							echo( "<input type=\"submit\" name=\"plusH\"  value=\"(+) ".$LANG_VARS['more_highlight_fields']."\">" );
							echo( "<input type=\"submit\" name=\"minusH\" value=\"(-) ".$LANG_VARS['less_highlight_fields']."\"><br>\n" );
							echo( "<br><input type=\"submit\" name=\"doList\" value=\"".$LANG_VARS['apply_to_usagelog']."\">\n" );
							echo( "</form>\n" );
						}//if($doHighlight)
						else
						{
							$HTTP_VARS['doList'] = "true";
						}
					}
							
					if(isset($HTTP_VARS['doList'])) // actual log listing
					{
						echo( "<h3>".$LANG_VARS['log_file'].":</h3>\n" );

						// We have already checked whether this file is readable or not, so fopen should
						// work fine.
						$logfile = fopen($CONFIG_VARS['logging.file'], "r");
						if($logfile)
						{
							// Might need this much time to display logfile
							@set_time_limit(600);
							
							echo("<table border=0 width=100% cellpadding=1 cellspacing=2>");
							echo("<tr><td class=\"navbar\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;".$LANG_VARS['date']."&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td><td class=\"navbar\">".$LANG_VARS['details']."</td><td class=\"navbar\">".$LANG_VARS['user_ip']."</td></tr>");
							while(!feof($logfile))
							{
								// Max line length of 4000 characters.
								$line = trim(fgets($logfile, 4000));
	
								// Format of a log entry: date\tmessage\tip_address
								$tokens = explode("\t", $line);
								
								// Check for old (Prior to 0.31) log file format.
								if(count($tokens)!==3)
									$tokens = explode_line($line);
				
								// Ensure any special characters in message are dealt with.
								$tokens[1] = htmlspecialchars($tokens[1]);

								if($HTTP_VARS['doListMode'] == 'highlight')
								{
									if(function_exists("wordwrap"))
										$tokens[1] = str_replace("\n", "<br>", wordwrap($tokens[1],80,"\n",1));
								
									for( $ix=0; $ix<$HTTP_VARS['items_count']; $ix++ )
										$tokens[1] = highlight($tokens[1], $HTTP_VARS['keyword'][$ix], $HTTP_VARS['type'][$ix], $HTTP_VARS['fg'][$ix], $HTTP_VARS['bg'][$ix]);
								}
								
								echo("\n<tr>\n\t<td align=center valign=top>" .$tokens[0]. "</td>\n\t<td>" .$tokens[1]."</td>\n\t<td align=center>" .$tokens[2]. "</td>\n</tr>");
							}
							fclose($logfile);
				
							echo("</table>");
						}
						else//if($logfile)
						{	
							// Should never heve happen, as we have already cheched if logfile 'is_readable'
							echo("<div class=\"error\">".$lang_var['undefined_error']."</div>");
						}
					}
				}
			}
			else //if(is_readable($CONFIG_VARS['logging.file']))
			{
				echo _theme_header($LANG_VARS['no_logfile_found']);
				echo _theme_error($LANG_VARS['no_logfile_found']);
			}
		}
		else//if(strlen($CONFIG_VARS['logging.file'])>0)
		{
			echo _theme_header($LANG_VARS['no_logfile_defined']);
			echo _theme_error($LANG_VARS['no_logfile_defined']);
		}
	}//not an administrator!
	else
	{
		echo _theme_header($LANG_VARS['not_authorized_to_page']);
		echo _theme_error($LANG_VARS['not_authorized_to_page']);
	}
	echo _theme_footer();
}
else
{
	include("./include/invalidsession.php");
}

// Cleanup after begin.inc.php
require_once("./include/end.inc.php");
?>
