<?php
/* 	OpenDb - Open Lending Database Project
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// This must be first - includes config.php
require_once("./include/begin.inc.php");

include_once("./include/theme.php");
include_once("./include/language.php");

include_once("./functions/function.php");
include_once("./functions/utils.php");
include_once("./functions/user.php");
include_once("./functions/review.php");
include_once("./functions/borrowed_item.php");
include_once("./functions/item_type.php");
include_once("./functions/item.php");
include_once("./functions/item_attribute.php");
include_once("./functions/widgets.php");
include_once("./functions/http.php");
include_once("./functions/parseutils.php");
include_once("./functions/listings.php");
include_once("./functions/status_type.php");
include_once("./functions/Listing.class.inc");

function get_list_item_types($s_item_type_group, $s_item_type_rs=NULL)
{
	global $CONFIG_VARS;

	if(strlen($s_item_type_group)>0 && is_not_empty_array($CONFIG_VARS['listings.s_item_type_groups'][$s_item_type_group]))
	{
		// If a group specified, then restrict the list of s_item_types appropriately.
		$types = $CONFIG_VARS['listings.s_item_type_groups'][$s_item_type_group];
	}
	else if(is_not_empty_array($s_item_type_rs))//set of s_item_types.
	{
		$types = $s_item_type_rs;
	}		
	else
	{
		$itemtype_results = fetch_item_type_rs();
		while($itemtype_r = mysql_fetch_array($itemtype_results))
			$types[] = $itemtype_r['s_item_type'];
	}
	return $types;
}

function get_list_item_type_groups()
{
	global $CONFIG_VARS;
	if(is_not_empty_array($CONFIG_VARS['listings.s_item_type_groups']))
	{
		// We only want the group names here!
		reset($CONFIG_VARS['listings.s_item_type_groups']);
		while(list($group,) = each($CONFIG_VARS['listings.s_item_type_groups']))
			$groups[] = $group;
			
		return $groups;
	}
	else
		return NULL;
}

function get_search_query_matrix($HTTP_VARS)
{
	global $LANG_VARS;
	global $CONFIG_VARS;

	function get_match_type($match)
	{
		global $LANG_VARS;
		if($match == 'word')
			return $LANG_VARS['word_match'];
		else if($match == 'partial')
			return $LANG_VARS['partial_match'];
		else if($match == 'exact')
			return $LANG_VARS['exact_match'];
		else
			return NULL;
	}
	
	$searches = array();
	
	if(strlen($HTTP_VARS['title'])>0)
	{
		// Default title match is exact match.
		$HTTP_VARS['title_match'] = ifempty($HTTP_VARS['title_match'],'exact');
		
		if($HTTP_VARS['title_match'] == 'word' || $HTTP_VARS['title_match'] == 'partial' || $HTTP_VARS['title_match'] == 'exact')
			$searches[] = array(prompt=>$LANG_VARS['title'].' (<i>'.get_match_type($HTTP_VARS['title_match']).'</i>)',field=>$HTTP_VARS['title']);
		else
			$searches[] = array(prompt=>$LANG_VARS['title'],field=>$HTTP_VARS['title']);
	}
	
	if(strlen($HTTP_VARS['category'])>0)
	{
		// If s_item_type defined, we can get at the s_attribute_type of the category value.
		if(strlen($HTTP_VARS['s_item_type'])>0)
		{
			$attribute_type_r = fetch_sfieldtype_item_attribute_type_r($HTTP_VARS['s_item_type'], 'CATEGORY', TRUE);
			$searches[] = array(prompt=>$LANG_VARS['category'],field=>get_display_field($attribute_type_r['s_attribute_type'], $attribute_type_r['prompt'], $attribute_type_r['display_type'], $HTTP_VARS['category'], FALSE));
		}
		else
			$searches[] = array(prompt=>$LANG_VARS['category'],field=>$HTTP_VARS['category']);
	}
	
	if(strlen($HTTP_VARS['owner_id'])>0)
	{
		$username = fetch_user_name($HTTP_VARS['owner_id']);
		if(strlen($username)>0)
			$searches[] = array(prompt=>$LANG_VARS['owner'],field=>$username.' ('.$HTTP_VARS['owner_id'].')');
	}
	
	if(is_numeric($HTTP_VARS['rating']))
	{
		$attribute_type_r = fetch_attribute_type_r("S_RATING");
		$searches[] = array(
					prompt=>$attribute_type_r['prompt'],
					field=>get_display_field(
						$attribute_type_r['s_attribute_type'], 
						$attribute_type_r['prompt'], 
						'review(%display%)',
						$HTTP_VARS['rating'],
						FALSE));
	}
	
	if(strlen($HTTP_VARS['attribute_type'])>0 && (strlen($HTTP_VARS['attribute_val'])>0 || is_not_empty_array($HTTP_VARS['attribute_vals'])) )
	{
		$attribute_type_r = fetch_attribute_type_r($HTTP_VARS['attribute_type']);
		if(is_not_empty_array($attribute_type_r))
		{
			// Default title match is exact match.
			$HTTP_VARS['attr_match'] = ifempty($HTTP_VARS['attr_match'],'exact');
		
			// Special category search, but ignore if category variable actually specified.
			if(strlen($HTTP_VARS['category'])==0 && strlen($HTTP_VARS['attribute_val'])>0 && $HTTP_VARS['attr_match'] == 'category')
			{
				// We do not want the Listing Link to be added to this display field
				$searches[] = array(
					prompt=>$attribute_type_r['prompt'],
					field=>get_display_field($attribute_type_r['s_attribute_type'], $attribute_type_r['prompt'], str_replace('list-link', '', $attribute_type_r['display_type']), stripslashes($HTTP_VARS['attribute_val']), FALSE));

			}
			else
			{
				if(strlen($HTTP_VARS['attribute_val'])>0)
				{
					// We do not want the Listing Link to be added to this display field
					$search = get_display_field($attribute_type_r['s_attribute_type'], $attribute_type_r['prompt'], str_replace('list-link', '', $attribute_type_r['display_type']), stripslashes($HTTP_VARS['attribute_val']), FALSE);
				}
				else if(is_not_empty_array($HTTP_VARS['attribute_vals']))
				{
					$search = "";
					for($i=0; $i<count($HTTP_VARS['attribute_vals']); $i++)
					{
						if(strlen(trim($HTTP_VARS['attribute_vals']))>0)
						{
							if(strlen($search)>0)
								$search .= ", ";
				
							// We do not want the Listing Link to be added to this display field
							$search .= get_display_field($attribute_type_r['s_attribute_type'], $attribute_type_r['prompt'], str_replace('list-link', '', $attribute_type_r['display_type']), stripslashes($HTTP_VARS['attribute_vals'][$i]), FALSE);
						}
					}
				}
				
				if(!is_lookup_attribute_type($HTTP_VARS['attribute_type']))
					$searches[] = array(prompt=>$attribute_type_r['prompt'].' (<i>'.get_match_type($HTTP_VARS['attr_match']).'</i>)',field=>$search);
				else
					$searches[] = array(prompt=>$attribute_type_r['prompt'],field=>$search);
			}
		}//if(is_not_empty_array($attribute_type_r))
	}
	
	if(strlen($HTTP_VARS['update_on'])>0)
	{
		if(strlen($HTTP_VARS['datetimemask'])>0)
			$searches[] = array(prompt=>$LANG_VARS['updated'],field=>$HTTP_VARS['update_on'].' ('.$HTTP_VARS['datetimemask'].')');
		else
			$searches[] = array(prompt=>$LANG_VARS['updated'],field=>$HTTP_VARS['update_on']);
	}
	else if(is_numeric($HTTP_VARS['update_on_days']))
	{
		if($HTTP_VARS['update_on_days'] == '1')
			$field = $LANG_VARS['one_day_ago'];
		else if($HTTP_VARS['update_on_days'] == '7')
			$field = $LANG_VARS['one_week_ago'];
		else if($HTTP_VARS['update_on_days'] == '28')
			$field = $LANG_VARS['one_month_ago'];
		else if($HTTP_VARS['update_on_days'] == '365')
			$field = $LANG_VARS['one_year_ago'];
			
		$searches[] = array(prompt=>$LANG_VARS['updated'],field=>$field);
	}
	
	if(is_not_empty_array($HTTP_VARS['s_status_type'])>0)
	{
		$search = "";
		for($i=0; $i<count($HTTP_VARS['s_status_type']); $i++)
		{
			// Add a new line every third element.
			if($i>0 && ($i % 3)==0)
				$search .= "<br>";
			else if(strlen($search)>0)
				$search .= ", ";
				
			$status_type_r = fetch_status_type_r($HTTP_VARS['s_status_type'][$i], FALSE);
			if(is_not_empty_array($status_type_r))
			{
				$search .= format_display_value('%img%', 
										$status_type_r['img'], 
										'Y',
										$status_type_r['description'],
										"borrowed_item");
			}
		}
		
		if(strlen($search)>0)
		{
			$searches[] = array(prompt=>$LANG_VARS['s_status_type'],field=>$search);
		}
	}
	
	if($HTTP_VARS['linked_items'] == 'exclude')
		$searches[] = array(prompt=>$LANG_VARS['linked_item(s)'],field=>$LANG_VARS['exclude']);
	else if($HTTP_VARS['linked_items'] == 'include')
		$searches[] = array(prompt=>$LANG_VARS['linked_item(s)'],field=>$LANG_VARS['include']);
	
	return $searches;
}

session_start(); 
if (is_opendb_valid_session())
{
	// validate specified owner_id, if not an owner, unset, so we pretend it was not even specified.
	if(strlen($HTTP_VARS['owner_id'])>0 && is_user_allowed_to_own($HTTP_VARS['owner_id']))
	{
		$show_owner_column=FALSE;
	}
	else
	{
		$show_owner_column=TRUE;
		
		// Specified owner, is not actually a valid owner user, so ignore it.
		unset($HTTP_VARS['owner_id']);
	}
	
	// Work out whether Item action checkboxes should be displayed.
	$show_checkbox_column=FALSE;
	if($CONFIG_VARS['borrow.enable']!==FALSE && 
			$CONFIG_VARS['listings.show_multi_reserve']!==FALSE && 
				(($CONFIG_VARS['borrow.reserve_basket']!==FALSE && 
					($CONFIG_VARS['listings.show_add_to_reserve_basket_action']===TRUE ||
					($CONFIG_VARS['listings.show_add_to_reserve_basket_action']==='IF_NOT_EMPTY' && 
						is_not_empty_array($HTTP_SESSION_VARS['reserve_basket_listing'])) )) ||
				$CONFIG_VARS['listings.show_reserve_action']!==FALSE) )
	{
		if(is_user_allowed_to_borrow($HTTP_SESSION_VARS['user_id'],$HTTP_SESSION_VARS['user_type'])) // Only users who can borrow should see checkboxes and their own listings.
		{
			if($HTTP_VARS['owner_id'] !== $HTTP_SESSION_VARS['user_id'])
				$show_checkbox_column=TRUE;
		}
	}
		
	// set to null, so we know if it has been updated within the if structure below!
	$page_title = NULL;
	$page_subtitle = NULL;
	
	if($HTTP_VARS['search_list'] == 'y' || $HTTP_VARS['attribute_list'] == 'y')
	{
		$page_title = $LANG_VARS['search_results'];
	
		$matrix_rs = get_search_query_matrix($HTTP_VARS);
		if(is_not_empty_array($matrix_rs))
		{
			$page_subtitle = "<table border=1 cellpadding=0 cellspacing=1><tr><td><table cellspacing=1 border=0>".
							"<tr><td class=\"navbar\" colspan=2 align=middle>".$LANG_VARS['search_query']."</td></tr>";
			while(list(,$matrix_r) = each($matrix_rs))
			{
				$page_subtitle .= format_field($matrix_r['prompt'], NULL, $matrix_r['field']);
			}
			$page_subtitle .= "</table></td></tr></table>";
		}
	}
	else if(is_valid_s_status_type($HTTP_VARS['s_status_type']))
	{
		// Current user.
		if($HTTP_VARS['owner_id'] == $HTTP_SESSION_VARS['user_id'])
			$page_title = replace_lang_var('s_status_type_desc', fetch_status_type_col($HTTP_VARS['s_status_type'], 'description'), $LANG_VARS['my_s_status_type_item_listing']);
		else if(strlen($HTTP_VARS['owner_id'])>0)
			$page_title = replace_lang_vars(array('s_status_type_desc'=>fetch_status_type_col($HTTP_VARS['s_status_type'], 'description'), 'fullname'=>fetch_user_name($HTTP_VARS['owner_id']), 'user_id'=>$HTTP_VARS['owner_id']), $LANG_VARS['s_status_type_item_listing_for_name']);
		else if(strlen($HTTP_VARS['not_owner_id'])>0)
			$page_title = replace_lang_var('s_status_type_desc', fetch_status_type_col($HTTP_VARS['s_status_type'], 'description'), $LANG_VARS['other_s_status_type_item_listing']);
		else
			$page_title = replace_lang_var('s_status_type_desc', fetch_status_type_col($HTTP_VARS['s_status_type'], 'description'), $LANG_VARS['all_s_status_type_item_listing']);
	}
	else
	{
		// Current user.
		if($HTTP_VARS['owner_id'] == $HTTP_SESSION_VARS['user_id'])
			$page_title = $LANG_VARS['my_item_listing'];
		else if(strlen($HTTP_VARS['owner_id'])>0)
			$page_title = replace_lang_vars(array('fullname'=>fetch_user_name($HTTP_VARS['owner_id']), 'user_id'=>$HTTP_VARS['owner_id']), $LANG_VARS['item_listing_for_name']);
		else if(strlen($HTTP_VARS['not_owner_id'])>0)
			$page_title = $LANG_VARS['other_item_listing'];
		else
			$page_title = $LANG_VARS['all_item_listing'];
	}
		
	if($HTTP_VARS['mode'] == "printable")
	{
		// No checkbox for Printable version.
		$show_checkbox_column=FALSE;
		$show_action_column=FALSE;
			
		$category_display_type = 'category(%display%)';
	}
	else
	{
		$category_display_type = 'category('.ifempty($CONFIG_VARS['listings.category_display_type_args'],'%display%').')';
			
		// Do we need to include the actions column?
		if(is_user_allowed_to_borrow($HTTP_SESSION_VARS['user_id'],$HTTP_SESSION_VARS['user_type']) &&
		(
			(
				(
					(
						strlen($HTTP_VARS['owner_id'])==0 && 
						strlen($HTTP_VARS['not_owner_id'])==0
					) || $HTTP_VARS['owner_id'] == $HTTP_SESSION_VARS['user_id'] 
					  || is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type'])
				) && 
				(
					$CONFIG_VARS['listings.show_input_links'] || 
					($CONFIG_VARS['borrow.enable']!==FALSE && $CONFIG_VARS['listings.show_quick_checkout'])
				)
			) || ($CONFIG_VARS['borrow.enable']!==FALSE && $CONFIG_VARS['listings.show_borrow_links'])))
		{	
			$show_action_column=TRUE;
		}
	}
		
	echo(_theme_header($page_title, $HTTP_VARS['inc_menu']));
	
	// Where clause is generated once for both count and listings.
	$from_and_where_clause = from_and_where_clause($HTTP_VARS);
	
	// temporary, to investigate issues with boolean clause parser
	echo "\n\n<!-- SQL: $from_and_where_clause -->\n\n";
	
	$listingObject = new Listing($HTTP_VARS['mode'], $CONFIG_VARS['listings.navigation_form_method']);
	$listingObject->setCheckBoxColumn('item_id_instance_no', $show_checkbox_column);
	$listingObject->setItemsPerPage($CONFIG_VARS['listings.items_per_page']);
	$listingObject->setTotalItems(fetch_item_listing_cnt($from_and_where_clause));
	$listingObject->initListing($HTTP_VARS);
	
	if($HTTP_VARS['mode'] != "printable")
	{
		echo("<h2>".$page_title."</h2>");

		// Currently only used to display search query matrix
		if(strlen($page_subtitle)>0)
			echo("$page_subtitle<br>");
		
		// #######################################################################
		// RESERVATIONS FUNCTIONALITY
		// #######################################################################
		$listingObject->setCheckedList(
					$CONFIG_VARS['borrow.reserve_basket']!==FALSE?$HTTP_SESSION_VARS['reserve_basket_listing']:NULL,
					$HTTP_VARS);
			
		if($CONFIG_VARS['listings.show_owner_lov']!==FALSE)
		{
			$listingObject->addSelectControl(
									$LANG_VARS['owner_id'],
									'owner_id',
									fetch_user_rs(get_owner_user_types_r()),
									'%fullname% (%user_id%)',
									$HTTP_VARS['owner_id'],
									'user_id');
		}
		
		if($CONFIG_VARS['listings.show_s_status_type_lov']!==FALSE)
		{
			if(!is_array($HTTP_VARS['s_status_type']) || ($HTTP_VARS['search_list'] != 'y' && $HTTP_VARS['attribute_list'] != 'y'))
			{
				$results = fetch_status_type_rs(TRUE);
				if($results && mysql_num_rows($results)>1)
				{		
					$listingObject->addSelectControl(
										$LANG_VARS['s_status_type'],
										's_status_type',
										$results,
										'%s_status_type% - %description%',
										$HTTP_VARS['s_status_type'],
										's_status_type');
				}
			}
		}
			
		if($CONFIG_VARS['listings.show_type_lov']!==FALSE)
		{										
			$item_types = get_list_item_types($HTTP_VARS['s_item_type_group'], $HTTP_VARS['s_item_type_rs']);
			if(is_not_empty_array($item_types))
			{	
				$item_type_groups = get_list_item_type_groups();
				if(is_not_empty_array($item_type_groups))
				{
					$listingObject->addSelectControl(
										$LANG_VARS['s_item_type_group'],
										's_item_type_group',
										$item_type_groups,
										'%value%',
										$HTTP_VARS['s_item_type_group'],
										'valkey');
				}
					
				$listingObject->addSelectControl(
										$LANG_VARS['s_item_type'],
										's_item_type',
										$item_types,
										'%value%',
										$HTTP_VARS['s_item_type'],
										'valkey');
			}
		}
		
		$listingObject->addAlphaList($HTTP_VARS['letter']);
		
		if($CONFIG_VARS['listings.allow_override_show_item_image']!==FALSE)
		{
			$listingObject->addToggleControl(
							$LANG_VARS['show_item_image'], 
							'show_item_image', 
							ifempty($HTTP_VARS['show_item_image'], $CONFIG_VARS['listings.show_item_image']==TRUE?'Y':'N'));
		}
		// --------------------------------
	}
	
	$HTTP_VARS['listing_link'] = 'y';
	
	$listingObject->startListing($PHP_SELF, $HTTP_VARS);
	
	$listingObject->startHeaderRow();
	
	$listingObject->writeHeaderColumn($LANG_VARS['type'], "s_item_type");
	$listingObject->writeHeaderColumn($LANG_VARS['title'], "title");
		
	if($show_action_column)
	{
		$listingObject->writeHeaderColumn($LANG_VARS['action']);
	}
		
	if($show_owner_column)
	{
		$listingObject->writeHeaderColumn($LANG_VARS['owner'], "owner_id");
	}
		
	$listingObject->writeHeaderColumn($LANG_VARS['s_status_type'], "s_status_type");
	$listingObject->writeHeaderColumn($LANG_VARS['category'], "category");
	
	$listingObject->endHeaderRow();
	
	// -------------------------------------- Process the Query here -----------------------------------------------------------------
	$result = fetch_item_listing_rs(
				$from_and_where_clause, 
				$HTTP_VARS['order_by'], 
				$HTTP_VARS['sortorder'], 
				$listingObject->getStartIndex(),
				$listingObject->getItemsPerPage());	
	if($result)
	{
		// ----------------------------------------------------------------------------
		// Save current url string, so we can return to last listings page if required.
		//
		// We need to put it here, so that we can get rid of any of the $HTTP_VARS
		// that are not required.
		// ----------------------------------------------------------------------------
		if($CONFIG_VARS['listings.save_listing_url'] && $HTTP_VARS['mode'] != "printable")
		{
			$HTTP_SESSION_VARS['listing_url_vars'] = $HTTP_VARS;

			// These variables should not be passed back from a 'Back to Listing' link!		
			$HTTP_SESSION_VARS['listing_url_vars']['internal_link'] = NULL;
			$HTTP_SESSION_VARS['listing_url_vars']['listing_link'] = NULL;
			$HTTP_SESSION_VARS['listing_url_vars']['item_id_instance_no'] = NULL;
			$HTTP_SESSION_VARS['listing_url_vars']['checked_item_id_instance_no'] = NULL;
			$HTTP_SESSION_VARS['listing_url_vars']['checked_item_id_instance_no_list'] = NULL;

			if(is_register_globals_enabled())
			{
				session_register("listing_url_vars");
				$listing_url_vars = $HTTP_SESSION_VARS['listing_url_vars'];
			}			
		}
		
		while($item_r = mysql_fetch_array($result))
		{  	
			$listingObject->startRow();
			
			// Get the Status Type config for the current item_instance.s_status_type, but grab it once.
			if(!is_array($status_type_rs[$item_r['s_status_type']]))
				$status_type_rs[$item_r['s_status_type']] = fetch_status_type_r($item_r['s_status_type']);
				
			// If we are looking at a linked item, then swap the values so that for a majority of the logic
			// things will work without issue.
			if($item_r['parent_id']	!= null)
			{
				$item_r['linked_item_id'] = $item_r['item_id'];
				$item_r['item_id'] = $item_r['parent_id'];
			}

			if($listingObject->isCheckBoxColumn())
			{
				if($item_r['linked_item_id'] == NULL && 
								$status_type_rs[$item_r['s_status_type']]['borrow_ind'] == 'Y' && 
								$item_r['owner_id'] !== $HTTP_SESSION_VARS['user_id'] && 
								is_user_allowed_to_borrow($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']) && 
								!is_item_reserved_or_borrowed_by_user($item_r['item_id'], $item_r['instance_no'], $HTTP_SESSION_VARS['user_id']) &&
								($CONFIG_VARS['borrow.allow_reserve_if_borrowed']!==FALSE || !is_item_borrowed($item_r['item_id'], $item_r['instance_no'])) &&
								($CONFIG_VARS['borrow.allow_multi_reserve']!==FALSE || !is_item_reserved($item_r['item_id'], $item_r['instance_no'])) )
				{
					$listingObject->writeColumn($item_r['item_id']."_".$item_r['instance_no']);
				}
				else
				{
					$listingObject->writeColumn();
				}
			}

			// get the s_item_type icon only once!
			if(strlen($item_types_rs[$item_r['s_item_type']]['icon'])==0)
			{
				$item_types_rs[$item_r['s_item_type']]['icon'] = get_item_image($item_r['s_item_type']);
			}
			
			// Unfortunately we cannot use the isLinked parameter to get_item_image, because
			// we want to save having to get the image twice, just because one item is linked and another is not!
			if($item_r['linked_item_id'] != NULL)
			{
				$listingObject->writeColumn(
							$item_types_rs[$item_r['s_item_type']]['icon'].
							_theme_image("linked.gif",NULL,$LANG_VARS['linked_item'],"absbottom"));
			}
			else
			{
				$listingObject->writeColumn(
							$item_types_rs[$item_r['s_item_type']]['icon']);
			}

			// Expand title mask.
			$item_r['title'] = expand_type_title_mask($item_r['title'], $item_r['s_item_type'], is_numeric($item_r['linked_item_id'])?$item_r['linked_item_id']:$item_r['item_id'], $item_r['instance_no'], $item_r['s_status_type'], $CONFIG_VARS['listings.title_display_mask'], $parsed_title_mask_r);
				
			if($HTTP_VARS['mode'] != "printable")
				$item_r['title'] = "<a href=\"item_display.php?item_id=".$item_r['item_id']."&instance_no=".$item_r['instance_no']."&listing_link=y".($item_r['linked_item_id']!= NULL?"#linked_item":"")."\">".$item_r['title']."</a>";
				
			$append_to_title = "";
				
			// Whereas in this case we actually want to test the real item_id even of linked items.
			if(is_item_reviewed($item_r['linked_item_id']!=null?$item_r['linked_item_id']:$item_r['item_id']))
			{
				// show star if rated - Add it to the actual title, so we can do a bit more with title masks
				$append_to_title .= _theme_image("rs.gif", NULL, $LANG_VARS['item_reviewed']);
			}
				
			// Check whether item has been borrowed or returned by the current user before.
			if($CONFIG_VARS['listings.show_borrowed_or_returned'])
			{
				// Do not even bother if user owns item - they cannot borrow their own item.
			 	if($item_r['owner_id'] != $HTTP_SESSION_VARS['user_id'])
				{
					if(is_item_borrowed_or_returned_by_user($item_r['item_id'], $item_r['instance_no'], $HTTP_SESSION_VARS['user_id']))
						$append_to_title .= _theme_image("tick.gif", NULL, $LANG_VARS['youve_borrow_or_return']); // show tick if previously borrowed or returned.
				}
			}
				
			if(($CONFIG_VARS['listings.allow_override_show_item_image']===FALSE && $CONFIG_VARS['listings.show_item_image']!==FALSE) ||
						$CONFIG_VARS['listings.allow_override_show_item_image']!==FALSE && (($CONFIG_VARS['listings.show_item_image']!==FALSE && strlen($HTTP_VARS['show_item_image'])==0) || $HTTP_VARS['show_item_image'] == 'Y'))
			{
				$listingObject->writeColumn(
					"<table width=100% border=0 cellpadding=0 cellspacing=0><tr><td width=10% class=\"".$listingObject->getRowCSSClass()."\">".
					get_item_cover_image($item_r['linked_item_id']!=null?$item_r['linked_item_id']:$item_r['item_id'], $item_r['s_item_type'], $item_type_rs).
					"</td>".
					"<td align=\"center\" class=\"".$listingObject->getRowCSSClass()."\">".
					$item_r['title'].(strlen($append_to_title)>0?"&nbsp;".$append_to_title:"").
					"</td></tr></table>");
			}	
			else
			{
				$listingObject->writeColumn(
					$item_r['title'].(strlen($append_to_title)>0?"&nbsp;".$append_to_title:""));
			}
				
			// Add links for owner items.
			if($show_action_column)
			{
				$action_links_rs = NULL;
					
				// Administrator and Owner actions here.
				if($item_r['owner_id'] == $HTTP_SESSION_VARS['user_id'] || is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']))
				{
					// The option of having only Quick Checkout links should be provided.
					if($CONFIG_VARS['listings.show_input_links'] || $CONFIG_VARS['listings.show_quick_checkout'])
					{
						if($item_r['linked_item_id'] == NULL)
						{
							if($CONFIG_VARS['listings.show_input_links'])
							{
								$action_links_rs[] = array(url=>'item_input.php?op=updateinstance&item_id='.$item_r['item_id'].'&instance_no='.$item_r['instance_no'].'&listing_link=y', img=>'update.gif',text=>$LANG_VARS['update']);
								$action_links_rs[] = array(url=>'item_input.php?op=edit&item_id='.$item_r['item_id'].'&instance_no='.$item_r['instance_no'].'&listing_link=y',img=>'edit.gif',text=>$LANG_VARS['edit']);

								// So we only have to check the 'is_legal_site_type' once!
								if(strlen($item_types_rs[$item_r['s_item_type']]['legal_site_type'])==0)
								{
									$item_types_rs[$item_r['s_item_type']]['legal_site_type'] = is_item_legal_site_type($item_r['s_item_type']);
								}
									
								// Only site types which are considered legal can be allowed for refresh operation.
								if($CONFIG_VARS['listings.show_refresh_links'] && $item_types_rs[$item_r['s_item_type']]['legal_site_type'])
								{
									$action_links_rs[] = array(url=>'item_add.php?item_id='.$item_r['item_id'].'&instance_no='.$item_r['instance_no'].'&listing_link=y',img=>'refresh.gif',text=>$LANG_VARS['refresh']);
								}
									
								if($status_type_rs[$item_r['s_status_type']]['delete_ind'] == 'Y' && !is_item_reserved_or_borrowed($item_r['item_id'], $item_r['instance_no']))
								{
									$action_links_rs[] = array(url=>'item_input.php?op=delete&item_id='.$item_r['item_id'].'&instance_no='.$item_r['instance_no'].'&listing_link=y',img=>'delete.gif',text=>$LANG_VARS['delete']);
								}
							}
								
							// Quick checkout NOT available to Admin user, unless they are also explicitly the owner.
							if($CONFIG_VARS['borrow.enable']!==FALSE && 
										$item_r['owner_id'] == $HTTP_SESSION_VARS['user_id'] && 
										$CONFIG_VARS['borrow.quick_checkout'] && 
										$CONFIG_VARS['listings.show_quick_checkout'] && 
										($status_type_rs[$item_r['s_status_type']]['borrow_ind'] == 'Y' || $status_type_rs[$item_r['s_status_type']]['borrow_ind'] == 'N'))
							{
								// Cannot quick checkout an item already borrowed.
								if(!is_item_borrowed($item_r['item_id'], $item_r['instance_no']))
								{
									$action_links_rs[] = array(url=>'item_borrow.php?op=quick_check_out&item_id='.$item_r['item_id'].'&instance_no='.$item_r['instance_no'].'&listing_link=y',img=>'quick_check_out.gif',text=>$LANG_VARS['quick_check_out']);
								}
							}								
						}
						else // You cannot checkout a linked item!
						{
							$action_links_rs[] = array(url=>'item_input.php?op=edit&item_id='.$item_r['linked_item_id'].'&parent_id='.$item_r['item_id'].'&parent_instance_no='.$item_r['instance_no'].'&listing_link=y',img=>'edit.gif',text=>$LANG_VARS['edit']);
							if($CONFIG_VARS['listings.show_refresh_links'] && is_item_site_type($item_r['s_item_type']))
							{
								$action_links_rs[] = array(url=>'item_add.php?item_id='.$item_r['linked_item_id'].'&parent_id='.$item_r['item_id'].'&parent_instance_no='.$item_r['instance_no'].'&listing_link=y',img=>'refresh.gif',text=>$LANG_VARS['refresh']);
							}
							$action_links_rs[] = array(url=>'item_input.php?op=delete&item_id='.$item_r['linked_item_id'].'&parent_id='.$item_r['item_id'].'&parent_instance_no='.$item_r['instance_no'].'&listing_link=y',img=>'delete.gif',text=>$LANG_VARS['delete']);
						}
					}
				}
				
				if($item_r['owner_id'] != $HTTP_SESSION_VARS['user_id']) //non-owner items here.
				{   
					// Reservation/Cancel Information.
					if($CONFIG_VARS['borrow.enable']!==FALSE && $CONFIG_VARS['listings.show_borrow_links']!==FALSE && $item_r['linked_item_id']==NULL)
					{
						if(is_user_allowed_to_borrow($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']) && $status_type_rs[$item_r['s_status_type']]['borrow_ind'] == 'Y')
						{
							if(is_item_reserved_or_borrowed($item_r['item_id'], $item_r['instance_no']))
							{
								if(is_item_reserved_by_user($item_r['item_id'], $item_r['instance_no'], $HTTP_SESSION_VARS['user_id']))
								{
									$action_links_rs[] = array(url=>'item_borrow.php?op=cancel_reserve&item_id='.$item_r['item_id'].'&instance_no='.$item_r['instance_no'].'&listing_link=y',img=>'cancel.gif',text=>$LANG_VARS['cancel']);
								}
								else if(!is_item_borrowed_by_user($item_r['item_id'], $item_r['instance_no'], $HTTP_SESSION_VARS['user_id']))
								{
									if(($CONFIG_VARS['borrow.allow_reserve_if_borrowed']!==FALSE || !is_item_borrowed($item_r['item_id'], $item_r['instance_no'])) &&
											($CONFIG_VARS['borrow.allow_multi_reserve']!==FALSE || !is_item_reserved($item_r['item_id'], $item_r['instance_no'])) )
									{
										if($CONFIG_VARS['borrow.reserve_basket']!==FALSE)
										{
											$action_links_rs[] = array(url=>'borrow.php?op=update_my_reserve_basket&item_id='.$item_r['item_id'].'&instance_no='.$item_r['instance_no'].'&listing_link=y',img=>'add_to_reserve_list.gif',text=>$LANG_VARS['add_to_reserve_list']);
										}
										else
										{
											$action_links_rs[] = array(url=>'item_borrow.php?op=reserve&item_id='.$item_r['item_id'].'&instance_no='.$item_r['instance_no'].'&listing_link=y',img=>'reserve.gif',text=>$LANG_VARS['reserve']);
										}
									}
								}
							}
							else
							{
								if($CONFIG_VARS['borrow.reserve_basket']!==FALSE)
								{
									$action_links_rs[] = array(url=>'borrow.php?op=update_my_reserve_basket&item_id='.$item_r['item_id'].'&instance_no='.$item_r['instance_no'].'&listing_link=y',img=>'add_to_reserve_list.gif',text=>$LANG_VARS['add_to_reserve_list']);
								}
								else
								{
									$action_links_rs[] = array(url=>'item_borrow.php?op=reserve&item_id='.$item_r['item_id'].'&instance_no='.$item_r['instance_no'].'&listing_link=y',img=>'borrow.gif',text=>$LANG_VARS['borrow']);
								}
							}
						}
					}
				}
				
				$listingObject->writeColumn(
						NULL, 
						$action_links_rs);
						
			}//if($show_action_column)
  
			// Only show owner column value, if not single owner listing!
			if($show_owner_column)
			{
				$listingObject->writeColumn(
					get_list_username(
							$item_r['owner_id'], 
							$HTTP_VARS['mode'], 
							$CONFIG_VARS['listings.owner_email_link'], 
							$LANG_VARS['back_to_listing'], 
							$PHP_SELF."?".get_url_string($HTTP_SESSION_VARS['listing_url_vars'])));
			}//if($show_owner_column)

			if(is_item_borrowed($item_r['item_id'],$item_r['instance_no']))
			{
				$listingObject->writeColumn(
						_theme_image("borrowed.gif", $LANG_VARS['borrowed'], NULL, NULL, "borrowed_item"));
	  		}
			else if (($status_type_rs[$item_r['s_status_type']]['borrow_ind'] == 'Y' || $status_type_rs[$item_r['s_status_type']]['borrow_ind'] == 'N') && is_item_reserved($item_r['item_id'], $item_r['instance_no']))
			{
				$listingObject->writeColumn(
						_theme_image("reserved.gif", $LANG_VARS['reserved'], NULL, NULL, "borrowed_item"));
			}
			else
			{
				$listingObject->writeColumn(
						_theme_image($status_type_rs[$item_r['s_status_type']]['img'], $status_type_rs[$item_r['s_status_type']]['description'], NULL, NULL, "borrowed_item"));
			}
	  
			// category
			if(strlen($item_types_rs[$item_r['s_item_type']]['category'])==0)
			{
				$item_types_rs[$item_r['s_item_type']]['category'] = fetch_sfieldtype_item_attribute_type($item_r['s_item_type'], 'CATEGORY');
			}
				
			// Finally the category column
			$listingObject->writeColumn(
					get_display_field($item_types_rs[$item_r['s_item_type']]['category'], 
									$LANG_VARS['category'], 
									$category_display_type, 
									$item_r['category'], 
									FALSE));
									
			$listingObject->endRow();
		}//end of while
		mysql_free_result($result);
		// ---------------------------------------------------------------------------------------------------------------
	}//end of if($result)

	if($HTTP_VARS['mode'] != 'printable')
	{
		if($CONFIG_VARS['borrow.enable']!==FALSE && $CONFIG_VARS['listings.show_multi_reserve']!==FALSE)
		{
			if($CONFIG_VARS['listings.show_reserve_action']!==FALSE)
			{
				// The getCheckedListCount is the number of checkboxes checked from other pages.
				if($listingObject->getCheckBoxCount() > 0 || $listingObject->getCheckedListCount() > 0)
				{
					$listingObject->addListOpAction(
								$LANG_VARS['reserve_item(s)'], 
								'item_borrow.php', 
								'reserve',
								$listingObject->getCheckedListCount() == 0);//Do isChecked javascript, if no items chosen from other pages);
				}
			}
			
			if($CONFIG_VARS['borrow.reserve_basket']!==FALSE && 
					($CONFIG_VARS['listings.show_add_to_reserve_basket_action']===TRUE ||
					($CONFIG_VARS['listings.show_add_to_reserve_basket_action']==='IF_NOT_EMPTY' && 
						is_not_empty_array($HTTP_SESSION_VARS['reserve_basket_listing'])) ))
			{
				// The getCheckedListCount is the number of checkboxes checked from other pages.
				if($listingObject->getCheckBoxCount() > 0 || $listingObject->getCheckedListCount() > 0)
				{
					$listingObject->addListOpAction(
								$LANG_VARS['add_to_reserve_list'], 
								'borrow.php', 
								'update_my_reserve_basket', 
								$listingObject->getCheckedListCount() == 0);//Do isChecked javascript, if no items chosen from other pages
				}
			}
		}
	}

	$listingObject->endListing();
	
	$help_entries_rs[] = array('img'=>'rs.gif', 'text'=>$LANG_VARS['item_reviewed']);
	if($CONFIG_VARS['borrow.enable']!==FALSE)
		$help_entries_rs[] = array('img'=>'tick.gif', 'text'=>$LANG_VARS['youve_borrow_or_return']);
	if($CONFIG_VARS['item_input.linked_item_support']!==FALSE)
		$help_entries_rs[] = array('img'=>'linked.gif', 'text'=>$LANG_VARS['linked_item']);

	if($HTTP_VARS['mode'] != 'printable')
	{
		if($listingObject->getTotalItemCount() > 0)
			$help_entries_rs[] = replace_lang_var("total", $listingObject->getTotalItemCount(), $LANG_VARS['printable_version_notes']);
		
		while(list(,$help) = @each($LANG_VARS['listings_help']))
			$help_entries_rs[] = $help;
			
		if($listingObject->getSessionCheckedCount() > 0)
		{
			$help_entries_rs[] = array('img'=>'gs.gif', 'text'=>$LANG_VARS['item_in_reserve_list']);
		}
	}
	
	if($CONFIG_VARS['listings.title_mask_macro_theme_img_help']!==FALSE)
	{
		$title_mask_elements_r = get_title_mask_macro_element_r('theme_img');
		if(is_array($title_mask_elements_r))
		{
			while(list($img,$prompt) = each($title_mask_elements_r))
				$help_entries_rs[] = array('img'=>$img, 'text'=>$prompt);
		}
	}
	echo(format_help_block($help_entries_rs));
	
	if($HTTP_VARS['mode'] != 'printable' && $listingObject->getTotalItemCount() > 0)
	{
		echo("\n<p align=center class=\"footer\"><i><a href=\"$PHP_SELF?".
				get_url_string(
					$HTTP_VARS, 
					array('mode'=>'printable'), 
					array( //exclude
						'page_no',
						'listing_link',
						'internal_link')).
			"\" target=_blank>"._theme_image("printable.gif", "", NULL, "absmiddle").$LANG_VARS['printable_version']."</a></i></p>");
	}
	
	unset($listingObject);//kill object, as not needed anymore.
	echo(_theme_footer());
}
else
{
	include("./include/invalidsession.php");
}

// Cleanup after begin.inc.php
require_once("./include/end.inc.php");
?>
