/***************************************************************************
						mapmaker.h    -  description
							-------------------
	begin                : july 2nd, 2006
	copyright            : (C) 2006 by Frdric RODRIGO
	email                : f.rodrigo free.fr
	
	$Id: mapmaker.h 20 2006-07-16 10:28:39Z neoneurone $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   any later version.                                                    *
 *                                                                         *
 ***************************************************************************/

#ifndef _OPENCITY_MAPMAKER_H_
#define _OPENCITY_MAPMAKER_H_ 1

#include "map.h"

namespace mapgen
{

/**
	Map generators and filters interface
*/
class MapMaker {
public:
	enum MAP_TYPE {
		PLAIN = 0,
		HILL,
		MOUNTAIN
	};

	MapMaker(
		const uint w,
		const uint h,
		const MAP_TYPE type );

	~MapMaker();

	int* getMap();

private:
	uint		_w;
	uint		_h;
	MAP_TYPE	_type;
	Map*		_map;


   /*=====================================================================*/
   /*                         PRIVATE     METHODS                         */
   /*=====================================================================*/
	void _generate();
};

}

#endif
