/**
 * OpenAL cross platform audio library
 * Copyright (C) 1999-2000 by authors.
 * This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the
 *  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA  02111-1307, USA.
 * Or go to http://www.gnu.org/copyleft/lgpl.html
 */

#if defined(__APPLE__) & defined(__MACH__) // check for OS X
#define MAC_OS_X
#else
#ifdef TARGET_CLASSIC
#include <Sound.h>
#else
#include <Carbon/Carbon.h>
#endif
#endif

#include "globaltypes.h"

extern ALbuffer gBuffer[AL_MAXBUFFERS]; // holds data on each buffer
extern ALsource gSource[AL_MAXSOURCES]; // holds data on each source
extern ALfloat gDopplerFactor;
extern ALfloat gDopplerVelocity;
extern ALfloat gDistanceScale;
extern ALfloat gPropagationSpeed;
extern ALlistener gListener;
extern ALuint gBufferSize;

#ifdef MAC_OS_X
extern void *pVorbisLib;
#else
extern SndCallBackUPP gpSMRtn;
#endif
