############################################################################
#    Copyright (C) 2007 by Tobias Koenig <tokoe@kde.org>                   #
#    Copyright (C) 2009 by David Palacio                                   #
#    dpalacio@uninorte.edu.co                                              #
#                                                                          #
#    This program is free software; you can redistribute it and#or modify  #
#    it under the terms of the GNU General Public License as published by  #
#    the Free Software Foundation; either version 3 of the License, or     #
#    (at your option) any later version.                                   #
#                                                                          #
#    This program is distributed in the hope that it will be useful,       #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
#    GNU General Public License for more details.                          #
#                                                                          #
#    You should have received a copy of the GNU General Public License     #
#    along with this program; if not, write to the                         #
#    Free Software Foundation, Inc.,                                       #
#    51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          #
############################################################################

require 'korundum4'
require 'document'

module OkularComicBookDir
begin
	require('okular')
	class GeneratorComicbook < Okular::Generator
		def initialize( parent, args )
			super
			@document = OkularComicBookDir::Document.new
			#setFeature Okular::Generator::Threaded
			setFeature Okular::Generator::PrintNative
			#setFeature Okular::Generator::PrintToFile
		end
		
		def loadDocument( path, pages_vector )
			unless @document.open path
				errstr = @document.last_error_string
				emit error( errstr, -1 ) unless errstr.empty?
				return false
			end
			pages = @document.pages
			size = nil
			pages.times do |index|
				size = @document.page_size( index )
				pages_vector << Okular::Page.new( index,
					size.width, size.height, 0 )#Okular::Rotation0
			end
			true
		end
		
		def print( printer )
			p = Qt::Painter.new printer
			pages = Okular::FilePrinter.page_list( printer, document.pages,
												   document.bookmarked_page_list )
			pages.count.times do |i|
				image = @document.page_image( pages[ i ] -1 )
				if image.width > printer.width || image.height > printer.height
					image = image.scaled( printer.width, printer.height,
																Qt::KeepAspectRatio,
																Qt::SmoothTransformation )
				end
				if i != 0
					printer.newPage
				end
				p.draw_image 0, 0, image
			end
			true
		end
		
		protected
		
		def doCloseDocument
			@document.close
		end
		
		def image( request )
			width = request.width
			height = request.height
			image = @document.page_image request.page_number
			rimage = image.scaled( width, height, Qt::IgnoreAspectRatio, Qt::SmoothTransformation )
			image.dispose
			return rimage
		end
	end
rescue LoadError
	class GeneratorComicBook
	end
end
end
