/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef CREATEPATCHEVENT_H
#define CREATEPATCHEVENT_H

#include "SlowEvent.h"
#include <string>
#include "List.h"

namespace Om {

	
class Patch;
class Node;
class TreeNode;
class Plugin;

using std::string;


/** An event to create a new Patch.
 *
 * \ingroup engine
 */
class CreatePatchEvent : public SlowEvent
{
public:
	CreatePatchEvent(Request* request, const string& path, int poly);

	void prepare();
	void execute(uint sample_offset);
	void post_process();

private:
	enum ErrorType { NO_ERROR, PATCH_EXISTS, INVALID_POLY };
	
	string            m_path;
	Patch*            m_patch;
	Patch*            m_parent;
	List<Node*>*      m_process_order;
	ListNode<Patch*>* m_patch_listnode;
	TreeNode*         m_patch_treenode;
	int               m_poly;
	ErrorType         m_error;
	bool              m_acquired_mutex;
};


} // namespace Om


#endif // CREATEPATCHEVENT_H
