/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef LOADPLUGINWINDOW_H
#define LOADPLUGINWINDOW_H

#include "PluginModel.h"
#include <list>
#include <libglademm/xml.h>
#include <libglademm.h>
#include <gtkmm.h>

using std::list;
using LibOmClient::PluginModel;

namespace OmGtk {
	
class PatchController;

// Gtkmm _really_ needs to add some helper to abstract away this stupid nonsense

/** Columns for the plugin list in the load plugin window. */
class ModelColumns : public Gtk::TreeModel::ColumnRecord
{
public:
  ModelColumns() {
	  add(m_col_name);
	  add(m_col_library);
	  add(m_col_label);
	  add(m_col_type);
	  add(m_col_plugin_model);
  }

  Gtk::TreeModelColumn<Glib::ustring> m_col_name;
  Gtk::TreeModelColumn<Glib::ustring> m_col_library;
  Gtk::TreeModelColumn<Glib::ustring> m_col_label;
  Gtk::TreeModelColumn<Glib::ustring> m_col_type;
  // This one's not displayed, just used for lookup purposes
  Gtk::TreeModelColumn<const PluginModel*> m_col_plugin_model;
};


/** Column for the criteria combo box in the load plugin window. */
class CriteriaColumns : public Gtk::TreeModel::ColumnRecord
{
public:
	enum Criteria { NAME, TYPE, LIBRARY, LABEL };
	
	CriteriaColumns() { add(m_col_label); add(m_col_criteria); }
	
	Gtk::TreeModelColumn<Glib::ustring> m_col_label;
	Gtk::TreeModelColumn<Criteria>      m_col_criteria;
};


/** 'Load Plugin' window.
 *
 * Loaded by glade as a derived object.
 *
 * \ingroup OmGtk
 */
class LoadPluginWindow : public Gtk::Window
{
public:
	LoadPluginWindow(BaseObjectType* cobject, const Glib::RefPtr<Gnome::Glade::Xml>& xml);

	void patch_controller(PatchController* pc);
	void set_plugin_model(const list<const PluginModel*>& l);

	void set_next_module_location(int x, int y)
		{ m_new_module_x = x; m_new_module_y = y; }
	
	void add_plugin(const PluginModel* info);
	bool has_shown() const { return m_has_shown; }

protected:
	void on_show();
	void on_hide();

private:
	void add_clicked();
	void close_clicked();
	void ok_clicked();
	void filter_clicked();
	void clear_clicked();

	void plugin_activated(const Gtk::TreeModel::Path& path, Gtk::TreeViewColumn* col);
	void plugin_selection_changed();
	string generate_module_name(int offset = 0);

	PatchController* m_patch_controller;
	bool m_has_shown; // plugin list only populated on show to speed patch window creation

	Glib::RefPtr<Gtk::ListStore> m_plugins_liststore;
	ModelColumns                 m_plugins_columns;

	Glib::RefPtr<Gtk::ListStore> m_criteria_liststore;
	CriteriaColumns              m_criteria_columns;
	
	Glib::RefPtr<Gtk::TreeSelection> m_selection;
	
	int m_plugin_name_offset; // see comments for generate_plugin_name
	
	int m_new_module_x;
	int m_new_module_y;

	Gtk::TreeView*    m_plugins_treeview;
	Gtk::CheckButton* m_polyphonic_checkbutton;
	Gtk::Entry*       m_node_name_entry;
	Gtk::Button*      m_add_button;
	Gtk::Button*      m_close_button;
	Gtk::Button*      m_ok_button;
	Gtk::ComboBox*    m_filter_combo;
	Gtk::Entry*       m_search_entry;
};


} // namespace OmGtk

#endif // LOADPLUGINWINDOW_H
