#ifndef OKLE_IFACE_H
#define OKLE_IFACE_H

#include <dcopobject.h>

class OkleIface : virtual public DCOPObject
{
 K_DCOP
k_dcop:
 virtual void setFullScreen(bool) = 0;
 virtual bool isFullScreen()const = 0;
 virtual void toggleFullScreen() = 0;

 virtual void openDisc() = 0;
 virtual void openFile(const QString&) = 0;
 virtual void closeDisc() = 0;

 virtual void quit() = 0;

 virtual bool isPaused()const = 0;
 virtual bool isPlaying()const = 0;

 virtual void play() = 0;
 virtual void reverse() = 0;
 virtual void pause() = 0;
 virtual void unpause() = 0;
 virtual void stop() = 0;
 virtual void rewind() = 0;
 virtual void fastForward() = 0;
 virtual void nextChapter() = 0;
 virtual void previousChapter() = 0;
 virtual void stepReverse() = 0;
 virtual void stepForward() = 0;
 virtual void fast() = 0;
 virtual void slow() = 0;

 virtual int currentTitle()const = 0;
 virtual int currentChapter()const = 0;
 
 virtual void up() = 0;
 virtual void down() = 0;
 virtual void left() = 0;
 virtual void right() = 0;
 virtual void enter() = 0;
 virtual void goUp() = 0;
 virtual void resume() = 0;
 
 virtual void titleMenu() = 0;
 virtual void rootMenu() = 0;
 virtual void audioMenu() = 0;
 virtual void angleMenu() = 0;
 virtual void chapterMenu() = 0;
 virtual void subtitleMenu() = 0;

 virtual void addBookmark(const QString&) = 0;
 virtual void removeBookmark(int) = 0;
 virtual void removeAllBookmarks() = 0;

 virtual void setVolume(int) = 0;
 virtual int volume() = 0;

 virtual void mute() = 0;
 virtual void unmute() = 0;
 virtual void toggleMute() = 0;
 virtual bool isMuted()const = 0;

 virtual void takeScreenshot(const QString&,bool) = 0;
};

#endif // OKLE_IFACE_H
