/***************************************************************************
                          jdxblockwidget.h  -  description
                             -------------------
    begin                : Mon Aug 5 2005
    copyright            : (C) 2002 by Thies H. Jochimsen
    email                : jochimse@cns.mpg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef JDXBLOCKWIDGET_H
#define JDXBLOCKWIDGET_H

#include <qgroupbox.h>

#include "odinqt.h"

#include <odinpara/jdxblock.h>

class JDXwidgetDialog; // forward declaration

////////////////////////////////////////////////////////////

class JcampDxBlockGrid : public QWidget  {

 Q_OBJECT

 public:
  JcampDxBlockGrid(JcampDxBlock& block,unsigned int columns=1,QWidget *parent=0,const char* omittext="");

 signals:
  // public:
  void valueChanged();

  // private:
  void updateSubWidget();
  void deleteSubDialogs();

 public slots:
  void updateWidget();
  void deleteDialogs();
  void swapSliderTracking() {}
  void emitValueChanged() {emit valueChanged();}


 private:
  friend class JcampDxBlockScrollView;

  void createDialog();

  GuiGridLayout* grid;

  JcampDxBlock& val;
  STD_list<JDXwidgetDialog*> subdialogs;

};

////////////////////////////////////////////////////////////

class JcampDxBlockScrollView : public QObject {
 Q_OBJECT

 public:
  JcampDxBlockScrollView(JcampDxBlock& block, unsigned int columns=1, QWidget *parent=0, const char* omittext="");
  ~JcampDxBlockScrollView();

//  QSize gridsize() const {return jdxgrid->frameSize();}

  QWidget* get_widget() {return scroll->get_widget();}

 signals:
  void valueChanged();

 public slots:
  void updateWidget() {jdxgrid->updateWidget();}
  void deleteDialogs() {jdxgrid->deleteDialogs();}
  void swapSliderTracking() {jdxgrid->swapSliderTracking();}
  void emitValueChanged() {emit valueChanged();}

 private:
  friend class JcampDxBlockWidget;

  void createDialog() {jdxgrid->createDialog();}

  GuiScroll* scroll;
  JcampDxBlockGrid* jdxgrid;

};

////////////////////////////////////////////////////////////

class JcampDxBlockWidget : public QGroupBox  {

 Q_OBJECT

 public:
  JcampDxBlockWidget(JcampDxBlock& jdxblock,unsigned int columns=1,QWidget *parent=0,bool doneButton=false,bool is_dialog=false,const char* omittext="", bool storeLoadButtons=false);
  ~JcampDxBlockWidget();

//  QSize gridsize() const {if(jdxscroll) return jdxscroll->gridsize(); else return QSize();}

 signals:
  void valueChanged();
  void doneButtonPressed();


 public slots:
  void updateWidget() {if(jdxscroll) jdxscroll->updateWidget();}
  void deleteDialogs() {if(jdxscroll) jdxscroll->deleteDialogs();}
  void swapSliderTracking() {if(jdxscroll) jdxscroll->swapSliderTracking();}
  void createDialog();
  void emitValueChanged() {emit valueChanged();}

 private slots:
  void emitDone();
  void storeBlock();
  void loadBlock();

 private:

  GuiGridLayout *grid;
  GuiButton *pb_done;
  GuiButton *pb_edit;
  GuiButton *pb_store;
  GuiButton *pb_load;

  JcampDxBlock& parblock;

  JcampDxBlockScrollView* jdxscroll;
};

////////////////////////////////////////////////////////////





class JDXwidgetDialog : public QObject, public GuiDialog  {
   Q_OBJECT
public:
  JDXwidgetDialog(JcampDxBlock& ldr,unsigned int columns=1,QWidget *parent=0, bool modal=false);
  ~JDXwidgetDialog();

 public slots:
  void updateWidget();
  void emitChanged();

 private:
  GuiGridLayout *grid;
  JcampDxBlockWidget *jdx;


private slots:
  void callDone();

signals:
  void finished();
  void valueChanged();


};


#endif
