//program to preform a unit test on crucial ODIN components

#include <tjutils/tjtest.h>
#include <tjutils/tjlog.h>

// Avoid including lots of header
void alloc_TjToolsTest();
void alloc_ComplexTest();
void alloc_VectorTest();
void alloc_ValListTest();
void alloc_ListTest();
void alloc_StringTest();
void alloc_StlTest();
void alloc_NdimTest();
void alloc_ArrayTest();
void alloc_IndexTest();
void alloc_ProcessTest();
void alloc_ThreadTest();
void alloc_DownhillSimplexTest();
void alloc_JDXstringArrTest();
void alloc_JDXintArrTest();
void alloc_JDXcomplexArrTest();
void alloc_GeometryTest();
void alloc_JDXintTest();
void alloc_JDXstringTest();
void alloc_JDXcomplexTest();
void alloc_JDXboolTest();
void alloc_JDXenumTest();
void alloc_JDXfileNameTest();
void alloc_CoilSensitivityTest();
void alloc_ProtocolTest();
void alloc_DataTest();
void alloc_ComplexDataTest();
void alloc_FileIOTest();
#ifndef FILEIO_ONLY
void alloc_FunctionFitTest();
void alloc_LinAlgTest();
void alloc_FunctionIntegralTest();
void alloc_StatisticsTest();
void alloc_GriddingTest();
#endif //FILEIO_ONLY


int main(int argc, char* argv[]) {
  if(LogBase::set_log_levels(argc,argv)) return 0;

  if(hasHelpOption(argc,argv)) {STD_cout << "UnitTest of ODIN" << STD_endl; return 0;}

#ifdef NO_UNIT_TEST
  STD_cout << "UnitTest disabled" << STD_endl;
  return 0;
#else

  alloc_TjToolsTest();
  alloc_ComplexTest();
  alloc_VectorTest();
  alloc_ValListTest();
  alloc_ListTest();
  alloc_StringTest();
  alloc_StlTest();
  alloc_NdimTest();
  alloc_ArrayTest();
  alloc_IndexTest();
  alloc_ProcessTest();
  alloc_ThreadTest();
  alloc_JDXintTest();
  alloc_JDXstringTest();
  alloc_JDXcomplexTest();
  alloc_JDXboolTest();
  alloc_JDXenumTest();
  alloc_JDXfileNameTest();
  alloc_JDXstringArrTest();
  alloc_JDXintArrTest();
  alloc_JDXcomplexArrTest();
  alloc_GeometryTest();
  alloc_CoilSensitivityTest();
  alloc_ProtocolTest();
  alloc_DataTest();
  alloc_ComplexDataTest();
  alloc_FileIOTest();
#ifndef FILEIO_ONLY
  alloc_FunctionFitTest();
  alloc_LinAlgTest();
  alloc_FunctionIntegralTest();
  alloc_StatisticsTest();
  alloc_GriddingTest();
#endif //FILEIO_ONLY

  int result=UnitTest::check_all();
  Static::destroy_all(); // testing StaticHandler
  return result;
#endif
}
