## Copyright (C) 1999 Paul Kienzle
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

## magic(n)
## returns an n-by-n magic square.
## Note: only handles odd n for the moment.

##TODO: even n
function A = magic(n)
  if nargin != 1
    usage("magic (n)");
  endif

  A = zeros(n,n);
  if (mod(n,2) == 1)
    r = 0; c = floor(n/2);
    for i = 1:n^2
      if (A(r+1,c+1) != 0)
	r = mod(r+2,n);
	c = mod(c-1,n);
      endif
      A(r+1,c+1) = i;
      r = mod(r-1,n);
      c = mod(c+1,n);
    endfor
  else
    error("magic: only handles odd n");
  endif
endfunction
