function g = trisolvem(l, d, u, g)

  n = length(d);

  if length(l) == n-1  # simple system
    ## forward
    for i=1:n-1
      u(i) = u(i)/d(i);
      g(i,:) = g(i,:)/d(i);
      d(i+1) = d(i+1) - l(i)*u(i);
      g(i+1,:) = g(i+1,:) - l(i)*g(i,:);
    endfor
    g(n,:) = g(n,:) / d(n);

    ## backward
    for i=n-1:-1:1
      g(i,:) = g(i,:) - u(i)*g(i+1,:);
    endfor
  else
    right = zeros(n-1,1);
    right(1) = u(n);
    bottom = l(n);

    ## forward
    for i=1:n-2
      ## row(i) = row(i)/A(i,i)
      u(i) = u(i)/d(i);
      right(i) = right(i)/d(i);
      g(i,:) = g(i,:)/d(i);

      ## row(last) = row(last) - A(last,i)*row(i);
      d(n) = d(n) - bottom*right(i);
      g(n,:) = g(n,:) - bottom*g(i,:);
      bottom = -bottom*u(i);

      ## row(i+1) = row(i+1) - A(i+1,i)*row(i);
      d(i+1) = d(i+1) - l(i)*u(i);
      g(i+1,:) = g(i+1,:) - l(i)*g(i,:);
      right(i+1) = -l(i)*right(i);
    endfor
    ## Handle collision between bottom row/right column and l,u
    l(n-1) = l(n-1) + bottom;
    u(n-1) = u(n-1) + right(n-1);

    ## Perform elimination on the last row
    u(n-1) = u(n-1)/d(n-1);
    g(n-1,:) = g(n-1,:)/d(n-1);
    d(n) = d(n) - l(n-1)*u(n-1);
    g(n,:) = g(n,:) - l(n-1)*g(n-1,:);

    ## Eliminate the final diagonal
    g(n,:) = g(n,:) / d(n);

    ## backward
    g(n-1,:) = g(n-1,:) - u(n-1)*g(n,:);
    for i=n-2:-1:1
      g(i,:) = g(i,:) - right(i)*g(n,:) - u(i)*g(i+1,:);
    endfor
  endif

endfunction    