## Copyright (C) 1999 Daniel Heiserer
##
## This program is free software; it is distributed in the hope that it
## will be useful, but WITHOUT ANY WARRANTY; without even the implied
## warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
## the GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this file; see the file COPYING.  If not, write to the
## Free Software Foundation, 59 Temple Place - Suite 330, Boston, MA
## 02111-1307, USA.

## USAGE: print('filename','device')
##	sends a copy of the current plot to a 'device' file
## 	named FILENAME.
##	if no arguments at all are specified a postscript file
##	is piped to "|lpr"
##
##
##      SPECIFICATION OF THE OUTPUT FILE
##        'filename' specifies the name of the file
##      
##      DEVICE DRIVERS
##        the following devices are supported according to gnuplot's great support of 
##        "terminals":
##        'aed512'
##        'aed767'
##        'aifm'
##        'bitgraph'
##        'cgm'
##        'corel'
##        'dumb'
##        'dxf'
##        'eepic'
##        'emtex'
##        'epson-180dpi'
##        'epson-60dpi'
##        'epson-lx800'
##        'fig'
##        'gpic'
##        'hp2623a'
##        'hp2648'
##        'hp500c'
##        'hpdj'
##        'hpgl'
##        'hpljii'
##        'hppj'
##        'imagen'
##        'kc-tek40xx'
##        'km-tek40xx'
##        'latex'
##        'mf'
##        'mif'
##        'nec-cp6'
##        'okidata'
##        'pbm'
##        'png'
##        'pcl5'
##        'postscript'
##        'pslatex'
##        'pstex'
##        'pstricks'
##        'qms'
##        'regis'
##        'selanar'
##        'starc'
##        'table'
##        'tandy-60dpi'
##        'tek40xx'
##        'tek410x'
##        'texdraw'
##        'tgif'
##        'tkcanvas'
##        'tpic'
##        'vttek'
##        'x11'
##        'xlib'
##       
##       However some devices are also available under other names: (A "+" indicates support).
##    +   '-dps'    # same as -postscript
##    +   '-dpsc'   # same as -postscript, but colored 
##    +   '-deps'   # Encapsulated PostScript
##    +   '-depsc'  # colored Encapsulated PostScript
##        '-dhpgl'  # same as -hpgl
##        '-djpeg'  # jpeg file format, will be translated via pbm and convert
##        '-dgif'   # gif file format, will be translated via pbm and convert
##        '-dtiff'  # tiff file, will be translated via pbm and convert
##    +   '-dpng'   # Portable Network Graphics. 
##
##
## REQUIRES: gget
##
##
## REMARK: original terminal and output of gnuplot is restored.
## AUTHOR: Daniel Heiserer <Daniel.heiserer@physik.tu-muenchen.de>
##	Thanks to Mario Storti for his 1st version. 

function print(file,terminal);

% remember to reset!
OLD_automatic_replot=automatic_replot;

% change it to 0. automatic replot is cool because it's interactive, so many people might use it.
% otherwise it has some bad features for printing (writing to a file):
	% for me it created always to plots in a postscript file. 
	% for the png terminal the replot emptied the file, while switiching the "terminal" back.
automatic_replot=0;

% take care of the settings we had before
origterm=sprintf('gset terminal %s',gget('terminal'));
origout=sprintf('gset output %s',gget('output'));

% never used and never checked
if nargin==0
	file="|lpr";
	terminal='ps';
end

% us a default for the terminal. Postcript is cool. So take it.
if nargin==1
	terminal='ps';
end

% maybe somebody specified some blanks in the device-name (terminal) and we don't want
% blanks inside our device-names
% if someones specified some blanks inside the filename. maybe he wants that ... (?)
terminal=terminal(find(terminal~=' '));

% lets cut down the first 2 characters, if we have a "-d" device specification:
END=length(terminal);
if terminal(1:2)=='-d'
	terminal=terminal(3:END);
end
extension=terminal;

% make sure the string is long enough, otherwise octave has problems with comparing them, unfortunately
% octave is far off beeing as cool as perl in handling strings :-((
terminal=[terminal,'      '];

% lets create a filename, assuming you want to have the extension indicating the terminal
% if you have already a '.' in the file, I assume you don't want it.
if length(find(file=='.'))>0
	filename=file;
else
	filename=sprintf('%s.%s',file,extension);
end
# just to make sure, the stuff is not appended, happend for the png terminal
unlink(filename);
eval(['gset output "',filename,'"']);

% let's have a look at the terminal now:
	if terminal(1:2)=='ps' || terminal(1:3)=='psc'
		gset term postscript color
		replot
	elseif terminal(1:3)=='eps' 
		gset term postscript eps color
		replot
	elseif terminal(1:3)=='pbm' 
		gset term pbm color
		replot
        elseif terminal(1:3)=='png' 
		gset term png color medium
		replot
# no gif, due to patent problems, and because it would require either an additional lib or "convert"
#	elseif terminal(1:3)=='gif' 
#		[STDOUT,STDERR]=system('which convert');
#		if STDERR==0
#			gset term pbm color
#			replot
#			todo=sprintf('convert %s %s.%s\n',filename,file,'gif');
#			system(todo);
#			unlink(filename);
#		else
#			error("Sorry you don't have convert on your machine, gif-device not supportet");
#		end
%%%%%%%-----------> What about the other terminals?
	else
		% ok, now lets look at the gnuplot devices, be blind and use what we have
		disp(['Warning: assuming raw gnuplot setting for terminal: ',terminal]);
		todo=['gset term ',terminal];
		eval(todo);
		replot
	end
	
% In fact we are nearly finished. Lets clean up the things we changed and restore the settings:
	%===================================
	% restore our old settings:
	%-----------------------------------
	% 1) terminal
		%disp(origterm)
		eval(origterm);
	%-----------------------------------
	% 2) output
	# gnuplot is a bit messy here, once we start with a x11 device, he says output is "", should be STDOUT
		%disp(origout)
		origout=[origout,'                                '];
	if origout(1:19)=="gset output output\n"
		eval('gset output');
		%disp('gset output');
	else
		%disp(origout)
		eval(origout);
	end
	replot
	%-----------------------------------
	% 3) plotting options
	automatic_replot=OLD_automatic_replot;
	%-----------------------------------
endfunction 
