require "lib.getopt"

if #arg < 2 then
    print("usage: ... [--k=value] [--w=value] input output")
    os.exit(1)
end

binarizer = ocr.make_BinarizeBySauvola()
if options["k"] then binarizer:set("k",0.0+options["k"]) end
if options["w"] then binarizer:set("w",0.0+options["w"]) end

input = bytearray()
output = bytearray()
iulib.read_image_gray(input,arg[1])
binarizer:binarize(output,input)
iulib.write_image_gray(arg[2],output)
