/* OpenCP Module Player
 * copyright (c) '94-'05 Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *
 * CPIface main interface code
 *
 * revision history: (please note changes here)
 *  -cp1.7   Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *    -first release
 *  -kb_in_between   Tammo Hinrichs <opencp@gmx.net>
 *    -reintegrated it into OpenCP, 'coz it r00ls ;)
 *  -fd980717  Felix Domke <tmbinc@gmx.net>
 *    -added Wuerfel Mode ][ (320x200)
 */

#include "config.h"
#include <stdlib.h>
#include <fcntl.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include "types.h"
#include "stuff/poutput.h"
#include "cpiface.h"
#include "stuff/timer.h"
#include "boot/psetting.h"
#include <curses.h>

static unsigned char *plWuerfel=NULL;
static int plWuerfelDirect;
static uint8_t wuerfelpal[720];
static uint16_t wuerfelpos;
static uint32_t wuerfeltnext;
static uint32_t wuerfelscroll;
static uint16_t wuerfelstframes;
static uint16_t wuerfelframes;
static uint16_t wuerfelrle;
static uint16_t wuerfeldlt;
static uint8_t wuerfellowmem;
static uint8_t *wuerfelloadedframes;
static uint16_t *wuerfelframelens;
static uint32_t *wuerfelframepos;
static uint16_t *wuerfelcodelens;
static uint32_t wuerfelframe0pos;
static uint32_t wuerfelframesize;
static uint32_t wuerfelscanlines, wuerfellinelength, wuerfelversion;
static int wuerfelfile;
static uint8_t *wuerfelframebuf;
static uint32_t cfUseAnis=0xFFFFFFFF;

static void memcpyintr(char *d, const char *s, unsigned long l)
{
	do {
		*d=*s;
		d++;
		*d=*s;
		d+=3;
		s++;
		*d=*s;
		d++;
		*d=*s;
		d+=3;
		s+=3;
		l-=2;
	} while(l);
}

static int plCloseWuerfel(void)
{
	if (plWuerfel)
	{
		free(plWuerfel);
		plWuerfel=NULL;
		free(wuerfelcodelens);
		free(wuerfelframelens);
		free(wuerfelframepos);
		free(wuerfelframebuf);
		free(wuerfelloadedframes);
		wuerfelframelens=NULL;
		wuerfelframepos=NULL;
		wuerfelframebuf=NULL;
		wuerfelloadedframes=0;
		if (wuerfelfile)
		{
			close(wuerfelfile);
			wuerfelfile=0;
		}
		return 1;
	}
	return 0;
}

static char plLoadWuerfel(void)
{
	int ifile;
	uint8_t sig[8];
	uint16_t opt, pallen, codelenslen;
	int i;
	uint16_t maxframe;
	uint32_t framemem;

	if (plWuerfel)
		plCloseWuerfel();

	ifile=-1;

	while (cfUseAnis)
	{
		int use=rand()&31;
		char path[PATH_MAX+1];

		if (!(cfUseAnis&(1<<use)))
			continue;
		snprintf(path, sizeof(path), "%sCPANI0%c%c.DAT", cfDataDir, '0'+use/10, '0'+use%10);
		ifile=open(path, O_RDONLY);
		if (ifile<0)
		{
			snprintf(path, sizeof(path), "%sCPANI0%c%c.DAT", cfConfigDir, '0'+use/10, '0'+use%10);
			ifile=open(path, O_RDONLY);
			if (ifile<0)
				cfUseAnis&=~(1<<use);
			else
				break;
		} else
			break;
	}
	if (ifile<0)
		return 0;

	wuerfelfile=ifile;

	if (read(ifile, sig, 8)!=8)
	{
		plCloseWuerfel();
		return 0;
	}
	if (memcmp(sig, "CPANI\x1A\x00\x00", 8))
	{
		plCloseWuerfel();
		return 0;
	}
	lseek(ifile, 32, SEEK_CUR);

	read(ifile, &wuerfelframes, 2);
	wuerfelframes=uint16_little(wuerfelframes);
	read(ifile, &wuerfelstframes, 2);
	wuerfelstframes=uint16_little(wuerfelstframes);

	read(ifile, &opt, 2);
	opt=uint16_little(opt);
	wuerfelrle=opt&1;
	wuerfeldlt=!!(opt&2);
	wuerfelframesize=(opt&4)?64000:16000;
	wuerfelscanlines=(opt&4)?200:100;
	wuerfellinelength=(opt&4)?320:160;
	wuerfelversion=!!(opt&4);

	wuerfelframelens=calloc(sizeof(uint16_t), wuerfelframes+wuerfelstframes);
	wuerfelframepos=calloc(sizeof(uint32_t), wuerfelframes+wuerfelstframes);
	wuerfelframebuf=calloc(sizeof(uint8_t), wuerfelframesize);
	wuerfelloadedframes=calloc(sizeof(uint8_t), wuerfelframes+wuerfelstframes);

	if (!wuerfelframelens||!wuerfelframepos||!wuerfelframebuf||!wuerfelloadedframes)
	{
		plCloseWuerfel();
		return 0;
	}

	lseek(ifile, 2, SEEK_CUR);
	read(ifile, &codelenslen, 2);
	codelenslen=uint16_little(codelenslen);
	wuerfelcodelens=calloc(sizeof(uint16_t), codelenslen);
	if (!wuerfelcodelens)
	{
		plCloseWuerfel();
		return 0;
	}
	read(ifile, &pallen, 2);
	pallen=uint16_little(pallen);
	read(ifile, wuerfelframelens, 2*(wuerfelframes+wuerfelstframes));

	if(wuerfelversion)
		read(ifile, wuerfelcodelens, codelenslen);
	else
		lseek(ifile, codelenslen, SEEK_CUR);

	read(ifile, wuerfelpal, pallen);

	memset(wuerfelloadedframes, 0, wuerfelframes+wuerfelstframes);
	wuerfelframepos[0]=0;
	maxframe=0;
	for (i=1; i<(wuerfelframes+wuerfelstframes); i++)
	{
		if (maxframe<wuerfelframelens[i-1])
			maxframe=wuerfelframelens[i-1];
		wuerfelframepos[i]=wuerfelframepos[i-1]+wuerfelframelens[i-1];
	}

	if (maxframe<wuerfelframelens[i-1])
		maxframe=wuerfelframelens[i-1];

	framemem=wuerfelframepos[i-1]+wuerfelframelens[i-1];

	plWuerfel=calloc(sizeof(uint8_t),  framemem);

	wuerfelframe0pos=lseek(ifile, 0, SEEK_CUR);

	if (plWuerfel)
	{
		wuerfellowmem=0;
		/* do preload, if desired! */
	} else {
		for (i=0; i<wuerfelstframes; i++)
			framemem-=wuerfelframelens[i];
		plWuerfel=calloc(sizeof(uint8_t), framemem);
		if (plWuerfel)
			wuerfellowmem=1;
		else {
			free(wuerfelloadedframes);
			wuerfelloadedframes=0;
			wuerfellowmem=2;
			plWuerfel=calloc(sizeof(uint8_t), maxframe);
			if (!plWuerfel)
			{
				plCloseWuerfel();
				return 0;
			}
		}
	}

	return 1;
}

static void plPrepareWuerfel(void)
{
	int i;
	vga13();
/*	if(!wuerfelversion)
	{
		outp(0x3c4, 4);
		outp(0x3c5, (inp(0x3c5)&~8)|4);
		outp(0x3d4, 0x14);
		outp(0x3d5, inp(0x3d5)&~0x40);
		outp(0x3d4, 0x17);
		outp(0x3d5, inp(0x3d5)|0x40);
		outp(0x3d4, 0x09);
		outp(0x3d5, inp(0x3d5)|2);
		 outpw(0x3c4, 0x0F02);
	}
	memset((char*)0xA0000, 0, 65536);
	*/
	for (i=16; i<256; i++)
		gupdatepal(i, wuerfelpal[i*3-48], wuerfelpal[i*3+1-48], wuerfelpal[i*3+2-48]);
	gflushpal();
	wuerfelpos=0;
	wuerfeltnext=0;
	wuerfelscroll=0;
/* This was commented out
    outpw(0x3c4, 0x0302);
    memcpyintr((void*)(0xA0000+80*24), plWuerfel[wuerfelpos], 160*76/2);
    outpw(0x3c4, 0x0C02);
    memcpyintr((void*)(0xA0000+80*24), plWuerfel[wuerfelpos]+1, 160*76/2);
*/
}

static void decodrle(uint8_t *rp, uint16_t rbuflen)
{
	uint8_t *op=wuerfelframebuf;
	uint8_t *re=rp+rbuflen;
	while (rp<re)
	{
		uint8_t c=*rp++;
		if (c<=0x0F)
		{
			memset(op, *rp++, c+3);
			op+=c+3;
		}  else
			*op++=c;
	}
}

static void decodrledlt(uint8_t *rp, uint16_t rbuflen)
{
	uint8_t *op=wuerfelframebuf;
	uint8_t *re=rp+rbuflen;
	while (rp<re)
	{
		uint8_t c=*rp++;
		if (c<=0x0E)
		{
			uint8_t c2=*rp++;
			if (c2!=0x0F)
				memset(op, c2, c+3);
			op+=c+3;
		} else {
			if (c!=0x0F)
				*op=c;
			op++;
		}
	}
}

static void wuerfelDraw(void)
{
	int i;
	uint8_t *curframe;
	uint16_t framelen;

	if (tmGetTimer()<(wuerfeltnext+(wuerfelversion?wuerfelcodelens[wuerfelpos]:3072)))
		return;

	wuerfeltnext=tmGetTimer();

	if(!wuerfelversion)
	{
		/* TODO-vga-mode-stuff
		outp(0x3c4, 4);
		outp(0x3c5, inp(0x3c5)&~8);  */
	}

	if (wuerfeldlt)
		plWuerfelDirect=0;

	if (wuerfelpos<wuerfelstframes)
	{
		plWuerfelDirect=0;
		wuerfelscroll=wuerfelscanlines;
	}

	framelen=wuerfelframelens[wuerfelpos];
	if (wuerfellowmem==2)
	{
		lseek(wuerfelfile, wuerfelframe0pos+wuerfelframepos[wuerfelpos], SEEK_SET);
		read(wuerfelfile, plWuerfel, framelen);
		curframe=plWuerfel;
	} else if (wuerfellowmem==1)
	{
		if (wuerfelpos<wuerfelstframes)
		{
			lseek(wuerfelfile, wuerfelframe0pos+wuerfelframepos[wuerfelpos], SEEK_SET);
			read(wuerfelfile, plWuerfel, framelen);
			curframe=plWuerfel;
		} else {
			curframe=plWuerfel+wuerfelframepos[wuerfelpos];
			if (!wuerfelloadedframes[wuerfelpos])
			{
				lseek(wuerfelfile, wuerfelframe0pos+wuerfelframepos[wuerfelpos], SEEK_SET);
			        read(wuerfelfile, curframe, framelen);
			        wuerfelloadedframes[wuerfelpos]=1;
			}
		}
	} else {
		curframe=plWuerfel+wuerfelframepos[wuerfelpos];
		if (!wuerfelloadedframes[wuerfelpos])
		{
			lseek(wuerfelfile, wuerfelframe0pos+wuerfelframepos[wuerfelpos], SEEK_SET);
			read(wuerfelfile, curframe, framelen);
			wuerfelloadedframes[wuerfelpos]=1;
		}
	}

	if (wuerfeldlt)
		decodrledlt(curframe, framelen);
	else if (wuerfelrle)
		decodrle(curframe, framelen);
	else
		memcpy(wuerfelframebuf, curframe, framelen);

	for (i=0; i<wuerfelscroll; i++)
	{
		if(!wuerfelversion)
		{
			memcpyintr(plVidMem+320*(100+i-wuerfelscroll)*2, (char *)wuerfelframebuf+i*160, 80);
			memcpyintr(plVidMem+320*((100+i-wuerfelscroll)*2+1), (char *)wuerfelframebuf+i*160, 80);
			memcpyintr(plVidMem+320*(100+i-wuerfelscroll)*2+2, (char *)wuerfelframebuf+i*160+1, 80);
			memcpyintr(plVidMem+320*((100+i-wuerfelscroll)*2+1)+2, (char *)wuerfelframebuf+i*160+1, 80);
		} else {
			memcpy(plVidMem+320*(wuerfelscanlines+i-wuerfelscroll),(char *)wuerfelframebuf+i*320, 320);
		}
	}

	if (wuerfelscroll<wuerfelscanlines)
		wuerfelscroll+=(wuerfelversion?2:1);
	if (wuerfelpos<wuerfelstframes)
		wuerfelpos++;
	else
		wuerfelpos=wuerfelstframes+(wuerfelpos-wuerfelstframes+(plWuerfelDirect?(wuerfelframes-1):1))%wuerfelframes;
}

static int wuerfelKey(uint16_t key)
{
	switch (key)
	{
#if 0
  case 0x9700: /*alt-home*/
  case 0x4700: /*home */
    break;
#endif
		case 9: /* tab */
		/*case 0x0F00:  shift-tab 
		case 0xA500:*/
			plWuerfelDirect=!plWuerfelDirect;
			return 1;
		case 'w': case 'W':
			plLoadWuerfel();
			plPrepareWuerfel();
			return 1;
	}
	return 0;
}

static void wuerfelSetMode(void)
{
	plPrepareWuerfel();
}

static int wuerfelEvent(int ev)
{
	switch (ev)
	{
		case cpievInitAll:
			return 1;
		case cpievInit:
			return plLoadWuerfel();
		case cpievDoneAll:
			plCloseWuerfel();
	}
	return 1;
}

static int wuerfelIProcessKey(uint16_t key)
{
	switch (key)
	{
		case KEY_ALT_K:
			cpiKeyHelp('w', "Enable wurfel mode");
			cpiKeyHelp('W', "Enable wurfel mode");
			return 0;
		case 'w': case 'W':
			if (_vga13)
				cpiSetMode("wuerfel2");
		return 1;
	}
	return 0;
}

static struct cpimoderegstruct cpiModeWuerfel = {"wuerfel2", wuerfelSetMode, wuerfelDraw, wuerfelIProcessKey, wuerfelKey, wuerfelEvent};

static void __attribute__((constructor))init(void)
{
	cpiRegisterDefMode(&cpiModeWuerfel);
}

static void __attribute__((destructor))done(void)
{
	cpiUnregisterDefMode(&cpiModeWuerfel);
}
