/* OpenCP Module Player
 * copyright (c) '94-'05 Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *
 * DGA graphic driver
 *
 * revision history: (please note changes here)
 *  -ss040707   Stian Skjelstad <stian@nixia.no>
 *    -first release
 *  -ss040920   Stian Skjelstad <stian@nixia.no>
 *    -DGA leaves a descriptor to /dev/mem open, so we tell the kernel to close
 *     it a exec()
 *  -ss050117   Stian Skjelstad <stian@nixia.no>
 *    -http://bugs.freedesktop.org/show_bug.cgi?id=1162
 */

#define _CONSOLE_DRIVER
#include "config.h"
#include <curses.h> /* for key-codes */
#include <ctype.h>
#include <fcntl.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <X11/extensions/xf86dga1.h> /* just using the old version query to state a warning for now */
#include <X11/extensions/xf86dga.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#include "boot/psetting.h"
#include "types.h"
#include "poutput-dga.h"
#include "boot/console.h"
#include "poutput.h"
#include "pfonts.h"
#include "x11-common.h"

#define MINMAJOR 2
#define MINMINOR 0

static int plBPP=8;
static int plRealBytesPerLine;
static int cachemode=-1;

static XDGADevice *mDevice;
static XDGAMode modes[3]; /* lowres = 0, highres = 1 , and the biggest one / default res*/
static int framebufferopen=0;
static uint8_t *virtual_framebuffer, *virtual_framebuffer_end;
static uint8_t currentpage;

static int sloppyreset;
static int brokentrident;
static int broken_keypress_state;

static int points(XDGAMode *mode, int X, int Y)
{
	int retval=0;
	if (mode->depth<8)
		return 0;
	if (((mode->viewportWidth>X)&&(mode->viewportHeight>=Y)) || ((mode->viewportWidth>=X)&&(mode->viewportHeight>Y)) )
		retval=2;
	else if ((mode->viewportWidth==X)&&(mode->viewportHeight==Y))
		retval=4;
	if ((mode->depth==8)&&(mode->bitsPerPixel==8))
		retval+=1;
	return retval;
}

static int __plSetGraphMode(int high)
{
#ifdef DGA_DEBUG
	if (high==-1)
		fprintf(stderr, "dga: set normale mode\n");
	else if (high)
		fprintf(stderr, "dga: set 1024x768\n");
	else
		fprintf(stderr, "dga: set 640x480\n");
#endif

	if ((high==cachemode)&&(high>=0))
		goto quick;
	cachemode=high;

	if (virtual_framebuffer)
	{
		free(virtual_framebuffer);
		virtual_framebuffer=0;
	}
	
	if (high==-1)
	{
		plVidMem=0;
		if (framebufferopen)
		{
			XUngrabKeyboard(mDisplay, CurrentTime);
/*			XDGACloseFramebuffer(mDisplay, mScreen);*/
			if (sloppyreset)
				XDGASetMode(mDisplay, mScreen, modes[2].num);
			XDGASetMode(mDisplay, mScreen, 0);
			framebufferopen=0;
		}
		return 0;
	}

	if (!framebufferopen)
	{		
/*		if (!XDGAOpenFramebuffer(mDisplay, mScreen))
		{
			fprintf(stderr, "dga: XDGAOpenFramebuffer failed\n");
			return -1;
		}*/

	 	/* HACK HACK HACK, keys get stuck when they are pressed when
		 * XDGASetMode is called, so wait for all keys to be released
		 *
		 * http://bugs.freedesktop.org/show_bug.cgi?id=1162
		 */
		int i;
		do {
			char keys[32];
			XQueryKeymap(mDisplay, keys);
	   		for (i=0; (i<32) && (keys[i]==0); i++) {}
		} while(i<32);
		XGrabKeyboard(mDisplay, DefaultRootWindow(mDisplay), True, GrabModeAsync, GrabModeAsync, CurrentTime);
		framebufferopen=1;
	}	

	if (high)
	{
		if (brokentrident)
			XDGASetMode(mDisplay, mScreen, modes[2].num);
		if (!(mDevice=XDGASetMode(mDisplay, mScreen, modes[1].num)))
		{
			fprintf(stderr, "dga: XDGASetMode failed\n");
/*			XDGACloseFramebuffer(mDisplay, mScreen);*/
			framebufferopen=0;
			return -1;
		}
		plScrMode=101;
		plScrWidth=128;
		plScrHeight=60;
		plScrLines=modes[1].viewportHeight;
		plRealBytesPerLine=plScrLineBytes=modes[1].pixmapWidth;
		plBPP=modes[1].bitsPerPixel;
		if ((plBPP!=8) || (plScrLineBytes!=1024))
		{
			plScrLineBytes=1024;
			virtual_framebuffer=calloc(1024*768|65535, 1);
			virtual_framebuffer_end=virtual_framebuffer+1024*768;
		} else
			virtual_framebuffer=0;
		plDepth=modes[1].depth;
	} else {
#ifdef DGA_DEBUG
		fprintf(stderr, "About to set mode %d\n", modes[0].num);
#endif
		if (!(mDevice=XDGASetMode(mDisplay, mScreen, modes[0].num)))
		{
			fprintf(stderr, "dga: XDGASetMode failed\n");
/*			XDGACloseFramebuffer(mDisplay, mScreen);*/
			framebufferopen=0;
			return -1;
		}
		plScrMode=100;
		plScrWidth=80;
		plScrHeight=60;
		plScrLines=modes[0].viewportHeight;
		plRealBytesPerLine=plScrLineBytes=modes[0].pixmapWidth;
		plBPP=modes[0].bitsPerPixel;
		if ((plBPP!=8) || (plScrLineBytes!=640))
		{
			plScrLineBytes=640;
			virtual_framebuffer=calloc(640*480|65535, 1);
			virtual_framebuffer_end=virtual_framebuffer+640*480;
		} else
			virtual_framebuffer=0;
		plDepth=modes[0].depth;
	}

	if (!virtual_framebuffer) /* we have both perfect pitch and 8 bpp */
		plVidMem=(char *)mDevice->data;
	else
		plVidMem=(char *)virtual_framebuffer;
quick:
	memset(mDevice->data, 0, plRealBytesPerLine * plScrLines * plDepth >> 3);
	currentpage=0;

	x11_gflushpal();
	return 0;
}

static int __plSetGraphPage(unsigned char x)
{
	int retval=0;/*65536;*/
	{
		if (virtual_framebuffer)
		{
			if (x==currentpage)
			{
			} else if (plBPP==32)
			{ 
				int bytestodo=65536;
					
				uint8_t *src=(uint8_t *)plVidMem;

				int startx = (currentpage * 0x10000) % plScrLineBytes;
				int starty = (currentpage * 0x10000) / plScrLineBytes;

				uint32_t *dst_line = ((uint32_t *)mDevice->data) + starty * plRealBytesPerLine;
				uint32_t *dst = dst_line + startx ;

				int j = startx;

				goto tight_32;

				while (1)
				{
					for (j=0;j<plScrLineBytes;j++)
					{
						tight_32:
						*dst=palette32[*src];
						dst++;
						src++;
						if (!--bytestodo)
							goto done_32;
						if (src==virtual_framebuffer_end)
							goto done_32;
					}
					dst = dst_line += plRealBytesPerLine;
				}
				
				done_32:
				plVidMem=(char *)virtual_framebuffer + x * 0x10000;
			} else if (plDepth==16)
			{ 
				int bytestodo=65536;
					
				uint8_t *src=(uint8_t *)plVidMem;

				int startx = (currentpage * 0x10000) % plScrLineBytes;
				int starty = (currentpage * 0x10000) / plScrLineBytes;

				uint16_t *dst_line = ((uint16_t *)mDevice->data) + starty * plRealBytesPerLine;
				uint16_t *dst = dst_line + startx ;

				int j = startx;

				goto tight_16;

				while (1)
				{
					for (j=0;j<plScrLineBytes;j++)
					{
						tight_16:
						*dst=palette16[*src];
						dst++;
						src++;
						if (!--bytestodo)
							goto done_16;
						if (src==virtual_framebuffer_end)
							goto done_16;
					}
					dst = dst_line += plRealBytesPerLine;
				}
				
				done_16:
				plVidMem=(char *)virtual_framebuffer + x * 0x10000;
			} else if (plDepth==15)
			{ 
				int bytestodo=65536;
					
				uint8_t *src=(uint8_t *)plVidMem;

				int startx = (currentpage * 0x10000) % plScrLineBytes;
				int starty = (currentpage * 0x10000) / plScrLineBytes;

				uint16_t *dst_line = ((uint16_t *)mDevice->data) + starty * plRealBytesPerLine;
				uint16_t *dst = dst_line + startx ;

				int j = startx;

				goto tight_15;

				while (1)
				{
					for (j=0;j<plScrLineBytes;j++)
					{
						tight_15:
						*dst=palette15[*src];
						dst++;
						src++;
						if (!--bytestodo)
							goto done_15;
						if (src==virtual_framebuffer_end)
							goto done_15;
					}
					dst = dst_line += plRealBytesPerLine;
				}
				done_15:
				plVidMem=(char *)virtual_framebuffer + x * 0x10000;
			} else if (plDepth==8)
			{ 
				int bytestodo=65536;
					
				uint8_t *src=(uint8_t *)plVidMem;

				int startx = (currentpage * 0x10000) % plScrLineBytes;
				int starty = (currentpage * 0x10000) / plScrLineBytes;

				uint8_t *dst_line = ((uint8_t *)mDevice->data) + starty * plRealBytesPerLine;
				uint8_t *dst = dst_line + startx ;

				int j = startx;

				goto tight_8;

				while (1)
				{
					for (j=0;j<plScrLineBytes;j++)
					{
						tight_8:
						*dst=*src;
						dst++;
						src++;
						if (!--bytestodo)
							goto done_8;
						if (src==virtual_framebuffer_end)
							goto done_8;
					}
					dst = dst_line += plRealBytesPerLine;
				}
				done_8:
				plVidMem=(char *)virtual_framebuffer + x * 0x10000;
			}
		} else {
			plVidMem=(char *)mDevice->data + x * 0x10000;
		}

		currentpage=x;
	}
	while (XPending(mDisplay))
	{
		int n_chars = 0;
		char buf[21];
		KeySym ks;

		uint16_t key;
		static int leftshift = 0;
		static int rightshift = 0;
		static int leftalt=0;
		static unsigned int state;
		XEvent event;

		XNextEvent(mDisplay, &event);
		switch (event.type)
		{
			default:
/*				fprintf(stderr, "Unkown event.type=%d\n", event.type);
				break;*/
			case MappingNotify:
				XRefreshKeyboardMapping( &event.xmapping );
				break;
			case KeyPress:
				if (broken_keypress_state)
					event.xkey.state=state; /* FUCKING BUGGING SHITTY XFREE86-DGA2 */
				n_chars = XLookupString(&event.xkey, buf, 20, &ks, NULL);
				key=0;
				if ((n_chars==1)&&(buf[0]>=32)/*&&(buf[0]<=127)*/)
				{
					if (state==Mod1Mask)
					{
						switch (toupper(buf[0]))
						{
							case 'G': ___push_key(KEY_ALT_G); break;
						}
					} else if ((state==ShiftMask)||!state)
						___push_key(buf[0]);
				}
				else if (ks==XK_Alt_L)
				{
					leftalt=1;
					state|=Mod1Mask;
				} else if (ks==XK_Shift_R)
				{
					rightshift=1;
					state|=ShiftMask;
				} else if (ks==XK_Shift_L)
				{
					leftshift=1;
					state|=ShiftMask;
				} else switch (ks)
				{
					case XK_Escape:    key=KEY_ESC;    break;
					case XK_F1:        key=KEY_F1;     break;
					case XK_F2:        key=KEY_F2;     break;
					case XK_F3:        key=KEY_F3;     break;
					case XK_F4:        key=KEY_F4;     break;
					case XK_F5:        key=KEY_F5;     break;
					case XK_F6:        key=KEY_F6;     break;
					case XK_F7:        key=KEY_F7;     break;
					case XK_F8:        key=KEY_F8;     break;
					case XK_F9:        key=KEY_F9;     break;
					case XK_F10:       key=KEY_F10;    break;
					case XK_F11:       key=KEY_F11;    break;
					case XK_F12:       key=KEY_F12;    break;
					case XK_Insert:    key=KEY_INSERT; break;
					case XK_Home:      key=KEY_HOME;   break;
					case XK_Page_Up:   key=KEY_NPAGE;  break;
					case XK_Delete:    key=KEY_DELETE; break;
					case XK_End:       key=KEY_END;    break;
					case XK_Page_Down: key=KEY_PPAGE;  break;
					case XK_Up:        key=KEY_UP;     break;
					case XK_Down:      key=KEY_DOWN;   break;
					case XK_Left:      key=KEY_LEFT;   break;
					case XK_Right:     key=KEY_RIGHT;  break;
					case XK_KP_Enter:
					case XK_Return:
					case XK_Linefeed:  key=_KEY_ENTER; break;
					case XK_BackSpace: key=KEY_BS;     break;
					case XK_Tab:       key=KEY_TAB;    break;
				}
				if (key)
					___push_key(key);
				break;
			case KeyRelease:
				n_chars = XLookupString(&event.xkey, buf, 20, &ks, NULL);
				switch (ks)
				{
					case XK_Alt_L:
						leftalt=0;
						state&=~Mod1Mask;
						return retval;
					case XK_Shift_R:
						rightshift=0;
						if (!leftshift)
							state&=~ShiftMask;
						return retval;
					case XK_Shift_L:
						leftshift=0;
						if (!rightshift)
							state&=~ShiftMask;
						return retval;
				}
		}
	}
	return retval;
}
int dga_init(int ignore)
{
	int MajorVersion, MinorVersion;
	int EventBase, ErrorBase;
	int dummyfd;
	int tmp;

	if ((cfGetProfileBool("dga", "disable", 0, 0)))
		return -1;
	
	sloppyreset=cfGetProfileBool("dga", "sloppyreset", 1, 0);
	if  ((brokentrident=cfGetProfileBool("dga", "brokentrident", 0, 0)))
		sloppyreset=1; /* brokentrident depends on sloppyreset */

	if (sloppyreset)
		fprintf(stderr, "[dga] sloppy reset enabled in config\n");
	if (brokentrident)
		fprintf(stderr, "[dga] broken trident enabled in config\n");
	
	if ((broken_keypress_state=cfGetProfileBool("dga", "broken_keypress_state", 1, 0)))
		fprintf(stderr, "[dga] broken_keypress_state enabled in config\n");

#ifdef XDGANeedRoot
	fprintf(stderr, "[dga] checking if we are suid root... ");
	if (geteuid()) {
		fprintf(stderr, "failed\n");
		return -1;
	}
	fprintf(stderr, "okey\n");
#endif

	if (x11_connect())
		return -1;

	if (!XDGAQueryVersion(mDisplay, &MajorVersion, &MinorVersion))
	{
		if (!XF86DGAQueryVersion(mDisplay, &MajorVersion, &MinorVersion))
		{
			fprintf(stderr, "[dga] Unable to query video extension version\n");
			x11_disconnect();
			return -1;
		} else {
			fprintf(stderr, "[dga] Old DGA extentions found :-( (%d.%d)\n", MajorVersion, MinorVersion);
			x11_disconnect();
			return -1;
		}
	}

	fprintf(stderr, "[dga] Version %d.%d found\n", MajorVersion, MinorVersion);

	if (!XF86DGAQueryExtension(mDisplay, &EventBase, &ErrorBase))
	{
		fprintf(stderr, "[dga] Unable to query video extension information\n");
		x11_disconnect();
		return -1;
	}
	
	{
		int lowres=-1, highres=-1;
		int lowresscore=0, highresscore=0;
		int defres=-1;
		int maxx=-1, maxy=-1;
		XDGAMode *mode;
		int index, i;
		if (!(mode=XDGAQueryModes(mDisplay, mScreen, &index)))
		{
			fprintf(stderr, "[dga] Unable to Query Modes\n");
			x11_disconnect();
			return -1;
		}
		for (i=0;i<index;i++)
		{
			int score;
#ifdef DGA_DEBUG
			fprintf(stderr, "[dga] mode %d - %s@%fHz "
					/*%dx%d vs %dx%d vs %dx%d with*/ 
					"bpp=%d depth=%d (%d bytes per line)\n",
					mode[i].num, mode[i].name, mode[i].verticalRefresh,
					/*mode[i].imageWidth, mode[i].imageHeight, mode[i].pixmapWidth, mode[i].pixmapHeight, mode[i].viewportWidth, mode[i].viewportHeight,*/
					mode[i].bitsPerPixel, mode[i].depth, mode[i].bytesPerScanline);
#endif
			
			score=points(mode+i, 640, 480);
			if (score>lowresscore)
			{
				lowresscore=score;
				lowres=i;
			}
			score=points(mode+i, 1024, 768);
			if (score>highresscore)
			{
				highresscore=score;
				highres=i;
			}
			if (sloppyreset)
				if ((mode[i].viewportWidth>=maxx)&&(mode[i].viewportHeight>=maxy))
				{
					maxx=mode[i].viewportWidth;
					maxy=mode[i].viewportHeight;
					defres=i;
				}
		}
		if (lowres<0)
		{
			fprintf(stderr, "[dga] Failed to find a low resolution\n");
			x11_disconnect();
			return -1;
		}
		if (highres<0)
		{
			fprintf(stderr, "[dga] Failed to find a high resolution\n");
			x11_disconnect();
			return -1;
		}
#ifdef DGA_DEBUG
		fprintf(stderr, "[dga] using lowres=%d, highres=%d (%d %d)\n", mode[lowres].num, mode[highres].num, lowresscore, highresscore);
#endif
		memcpy(&modes[0], &mode[lowres], sizeof(XDGAMode));
		memcpy(&modes[1], &mode[highres], sizeof(XDGAMode));
		if (sloppyreset)
			memcpy(&modes[2], &mode[defres], sizeof(XDGAMode));

	}

	dummyfd=open("/dev/null", O_WRONLY);
	close(dummyfd);
	if (!XDGAOpenFramebuffer(mDisplay, mScreen))
	{
		fprintf(stderr, "[dga] XDGAOpenFramebuffer failed\n");
		x11_disconnect();
		return -1;
	}

	tmp=0; /* remove valgrind warning */
	if (!fcntl(dummyfd, F_GETFD, &tmp)) /* this will fail if the dga-lib closes the filedescriptor */
	{
		if (!(tmp&FD_CLOEXEC))
		{
			fprintf(stderr, "[dga] WARNING! Your X-server DGA extension has a BIG security hole. It leaves a\n     file-descriptor to /dev/mem open across exec calls. Setting the flag by\n     hand.\n");
			if (fcntl(dummyfd, F_SETFD, tmp|FD_CLOEXEC))
				perror("fcntl(dga_fd, F_SETFD, tmp|FD_CLOEXEC)");
		}
	}

	_plSetGraphMode=__plSetGraphMode;
	_plSetGraphPage=__plSetGraphPage;
	_gdrawstr=generic_gdrawstr;
	_gdrawchar8=generic_gdrawchar8;
	_gdrawchar8p=generic_gdrawchar8p;
	_gdrawchar8t=generic_gdrawchar8t;
	_gdrawcharp=generic_gdrawcharp;
	_gdrawchar=generic_gdrawchar;
	_gupdatestr=generic_gupdatestr;
	_gupdatepal=x11_gupdatepal;
	_gflushpal=x11_gflushpal;

	plVidType=vidVESA;
	
	return 0;	
}

void dga_done(void)
{
	if (!mDisplay)
		return;
	__plSetGraphMode(-1);
	XDGACloseFramebuffer(mDisplay, mScreen);
	x11_disconnect();
}
