/* OpenCP Module Player
 * copyright (c) '94-'05 Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *
 * ITPlay auxiliary routines
 *
 * revision history: (please note changes here)
 *  -nb980510   Niklas Beisert <nbeisert@physik.tu-muenchen.de>
 *    -first release
 */

#include "config.h"
#include <stdio.h> /* FILE in itplay.h */
#include <stdlib.h>
#include <string.h>
#include "types.h"
#include "itplay.h"

void it_optimizepatlens(struct it_module *this)
{
	uint8_t *lastrows;
	int i;

	if (!(lastrows=malloc(sizeof(uint8_t)*this->npat)))
		return;
	memset(lastrows, 0, this->npat);
	for (i=0; i<this->nord; i++)
	{
		uint8_t *t, first;
		int row;
		int newpat;
		int newrow=0;
		
		if (this->orders[i]==0xFFFF)
			continue;
		t=this->patterns[this->orders[i]];
		first=0;
		row=0;
		newpat=-1;
		while (row<this->patlens[this->orders[i]])
		{
			if (!*t++)
			{
				if (newpat!=-1)
				{
					while ((newpat<this->nord)&&(this->orders[newpat]==0xFFFF))
						newpat++;
					if (newpat>=this->nord)
					{
						newpat=0;
						newrow=0;
					}
					if ((newrow>=this->patlens[this->orders[newpat]]))
					{
						newpat++;
						newrow=0;
					}
					if (newpat>=this->nord)
						newpat=0;
					if (newrow)
						lastrows[this->orders[newpat]]=this->patlens[this->orders[newpat]]-1;
					if (!first)
					{
						first=1;
						if (!lastrows[this->orders[i]])
							lastrows[this->orders[i]]=row;
					}
				}
				row++;
				newpat=-1;
			} else {
				switch (t[3])
				{
					case cmdJump:
						newpat=t[4];
						newrow=0;
						break;
					case cmdBreak:
						if (newpat==-1)
							newpat=i+1;
						newrow=t[4];
						break;
				}
				t+=5;
			}
		}
		if (!first)
			lastrows[this->orders[i]]=this->patlens[this->orders[i]]-1;
	}

	for (i=0; i<this->npat; i++)
		this->patlens[i]=lastrows[i]+1;
	free(lastrows);
}
