// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _gce_MakeCirc_HeaderFile
#define _gce_MakeCirc_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _gp_Circ_HeaderFile
#include <gp_Circ.hxx>
#endif
#ifndef _gce_Root_HeaderFile
#include <gce_Root.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class StdFail_NotDone;
class gp_Ax2;
class gp_Circ;
class gp_Pnt;
class gp_Dir;
class gp_Pln;
class gp_Ax1;


//! This class implements the following algorithms used <br>
//!           to create Circ from gp. <br>
//! <br>
//!           * Create a Circ coaxial to another and passing <br>
//!             though a point. <br>
//!           * Create a Circ coaxial to another at the distance <br>
//!             Dist. <br>
//!           * Create a Circ passing through 3 points. <br>
//!           * Create a Circ with its center and the normal of its <br>
//!             plane and its radius. <br>
//!           * Create a Circ with its center and its plane and its <br>
//!             radius. <br>
//!           * Create a Circ with its axis and radius. <br>
//!           * Create a Circ with two points giving its axis and <br>
//!             its radius. <br>
//!           * Create a Circ with is Ax2 and its Radius. <br>
class gce_MakeCirc  : public gce_Root {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  
//!  A2 locates the circle and gives its orientation in 3D space. <br>
//! Warnings : <br>
//!  It is not forbidden to create a circle with Radius = 0.0 <br>
//! The status is "NegativeRadius" if Radius < 0.0 <br>
  Standard_EXPORT   gce_MakeCirc(const gp_Ax2& A2,const Standard_Real Radius);
  //! Makes a Circ from gp <TheCirc> coaxial to another <br>
//!           Circ <Circ> at a distance <Dist>. <br>
//!           If Dist is greater than zero the result is encloses <br>
//!           the circle <Circ>, else the result is enclosed by the <br>
//!           circle <Circ>. <br>
  Standard_EXPORT   gce_MakeCirc(const gp_Circ& Circ,const Standard_Real Dist);
  //! Makes a Circ from gp <TheCirc> coaxial to another <br>
//!           Circ <Circ> and passing through a Pnt2d <Point>. <br>
  Standard_EXPORT   gce_MakeCirc(const gp_Circ& Circ,const gp_Pnt& Point);
  //! Makes a Circ from gp <TheCirc> passing through 3 <br>
//!           Pnt2d <P1>,<P2>,<P3>. <br>
  Standard_EXPORT   gce_MakeCirc(const gp_Pnt& P1,const gp_Pnt& P2,const gp_Pnt& P3);
  //! Makes a Circ from gp <TheCirc> with its center <br>
//!           <Center> and the normal of its plane <Norm> and <br>
//!           its radius <Radius>. <br>
  Standard_EXPORT   gce_MakeCirc(const gp_Pnt& Center,const gp_Dir& Norm,const Standard_Real Radius);
  //! Makes a Circ from gp <TheCirc> with its center <br>
//!           <Center> and the normal of its plane <Plane> and <br>
//!           its radius <Radius>. <br>
  Standard_EXPORT   gce_MakeCirc(const gp_Pnt& Center,const gp_Pln& Plane,const Standard_Real Radius);
  //! Makes a Circ from gp <TheCirc> with its center <br>
//!           <Center> and a point <Ptaxis> giving the normal <br>
//!           of its plane <Plane> and its radius <Radius>. <br>
  Standard_EXPORT   gce_MakeCirc(const gp_Pnt& Center,const gp_Pnt& Ptaxis,const Standard_Real Radius);
  //! Makes a Circ from gp <TheCirc> with its center <br>
//!           <Center> and its radius <Radius>. <br>
//! Warning <br>
//! The MakeCirc class does not prevent the <br>
//! construction of a circle with a null radius. <br>
//! If an error occurs (that is, when IsDone returns <br>
//! false), the Status function returns: <br>
//! -   gce_Negative Radius if: <br>
//!   -   Radius is less than 0.0, or <br>
//!   -   Dist is less than 0.0 and the absolute value of <br>
//!    Dist is greater than the radius of Circ; <br>
//! -   gce_IntersectionError if the points P1, P2 and <br>
//!   P3 are collinear, and the three are not coincident; <br>
//! -   gce_ConfusedPoints if two of the three points <br>
//!   P1, P2 and P3 are coincident; or <br>
//! -   gce_NullAxis if Center and Ptaxis are coincident. <br>
  Standard_EXPORT   gce_MakeCirc(const gp_Ax1& Axis,const Standard_Real Radius);
  //! Returns the constructed circle. <br>
//! Exceptions StdFail_NotDone if no circle is constructed. <br>
  Standard_EXPORT    const gp_Circ& Value() const;
  
  Standard_EXPORT    const gp_Circ& Operator() const;
Standard_EXPORT operator gp_Circ() const;





protected:





private:



gp_Circ TheCirc;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
