// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Intf_TangentZone_HeaderFile
#define _Intf_TangentZone_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Intf_SeqOfSectionPoint_HeaderFile
#include <Intf_SeqOfSectionPoint.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class Standard_OutOfRange;
class Intf_SectionPoint;


//! Describes   a  zone  of  tangence  between  polygons  or <br>
//!          polyhedra as a sequence of points of intersection. <br>
class Intf_TangentZone  {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  //! Returns number of SectionPoint in this TangentZone. <br>
        Standard_Integer NumberOfPoints() const;
  //! Gives   the   SectionPoint   of  address  <Index>  in  the <br>
//!          TangentZone. <br>
//! <br>
  Standard_EXPORT    const Intf_SectionPoint& GetPoint(const Standard_Integer Index) const;
  //! Compares two TangentZones. <br>
//! <br>
  Standard_EXPORT     Standard_Boolean IsEqual(const Intf_TangentZone& Other) const;
    Standard_Boolean operator ==(const Intf_TangentZone& Other) const
{
  return IsEqual(Other);
}
  //! Checks if <ThePI> is in TangentZone. <br>
  Standard_EXPORT     Standard_Boolean Contains(const Intf_SectionPoint& ThePI) const;
  //! Gives  the parameter range of the  TangentZone on the first <br>
//!          argument of the Interference. (Usable only for polygon) <br>
        void ParamOnFirst(Standard_Real& paraMin,Standard_Real& paraMax) const;
  //! Gives the parameter range of the  TangentZone on the second <br>
//!          argument of the Interference. (Usable only for polygon) <br>
        void ParamOnSecond(Standard_Real& paraMin,Standard_Real& paraMax) const;
  //! Gives information  about  the    first argument   of   the <br>
//!          Interference. (Usable only for polygon) <br>
  Standard_EXPORT     void InfoFirst(Standard_Integer& segMin,Standard_Real& paraMin,Standard_Integer& segMax,Standard_Real& paraMax) const;
  //! Gives   informations  about  the  second   argument of  the <br>
//!          Interference. (Usable only for polygon) <br>
  Standard_EXPORT     void InfoSecond(Standard_Integer& segMin,Standard_Real& paraMin,Standard_Integer& segMax,Standard_Real& paraMax) const;
  //! Returns True if  <ThePI>  is in the parameter  range of the <br>
//!          TangentZone. <br>
  Standard_EXPORT     Standard_Boolean RangeContains(const Intf_SectionPoint& ThePI) const;
  //! Returns True if the TangentZone  <Other> has  a common part <br>
//!          with <me>. <br>
  Standard_EXPORT     Standard_Boolean HasCommonRange(const Intf_TangentZone& Other) const;
  //! Builds an empty tangent zone. <br>
  Standard_EXPORT   Intf_TangentZone();
  //! Copies a Tangent zone. <br>
  Standard_EXPORT   Intf_TangentZone(const Intf_TangentZone& Other);
  //! Adds a SectionPoint to the TangentZone. <br>
  Standard_EXPORT     void Append(const Intf_SectionPoint& Pi) ;
  //! Adds the TangentZone <Tzi> to <me>. <br>
  Standard_EXPORT     void Append(const Intf_TangentZone& Tzi) ;
  //! Inserts a SectionPoint in the TangentZone. <br>
  Standard_EXPORT     Standard_Boolean Insert(const Intf_SectionPoint& Pi) ;
  //! Inserts a point in the polygonal TangentZone. <br>
  Standard_EXPORT     void PolygonInsert(const Intf_SectionPoint& Pi) ;
  //! Inserts a SectionPoint before <Index> in the TangentZone. <br>
  Standard_EXPORT     void InsertBefore(const Standard_Integer Index,const Intf_SectionPoint& Pi) ;
  //! Inserts a SectionPoint after <Index> in the TangentZone. <br>
  Standard_EXPORT     void InsertAfter(const Standard_Integer Index,const Intf_SectionPoint& Pi) ;
  
  Standard_EXPORT     void Dump(const Standard_Integer Indent) const;





protected:





private:



Intf_SeqOfSectionPoint Result;
Standard_Real ParamOnFirstMin;
Standard_Real ParamOnFirstMax;
Standard_Real ParamOnSecondMin;
Standard_Real ParamOnSecondMax;


};


#include <Intf_TangentZone.lxx>



// other Inline functions and methods (like "C++: function call" methods)


#endif
