// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _IntRes2d_Transition_HeaderFile
#define _IntRes2d_Transition_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _IntRes2d_Position_HeaderFile
#include <IntRes2d_Position.hxx>
#endif
#ifndef _IntRes2d_TypeTrans_HeaderFile
#include <IntRes2d_TypeTrans.hxx>
#endif
#ifndef _IntRes2d_Situation_HeaderFile
#include <IntRes2d_Situation.hxx>
#endif
#ifndef _Standard_Storable_HeaderFile
#include <Standard_Storable.hxx>
#endif
#ifndef _Standard_PrimitiveTypes_HeaderFile
#include <Standard_PrimitiveTypes.hxx>
#endif
class Standard_DomainError;


Standard_EXPORT const Handle(Standard_Type)& STANDARD_TYPE(IntRes2d_Transition);

//! Definition of    the  type  of   transition    near an <br>
//!          intersection point between  two curves. The transition <br>
//!          is either a "true transition", which means that one of <br>
//!          the curves goes inside or outside  the area defined by <br>
//!          the other curve  near  the intersection, or  a  "touch <br>
//!          transition" which means that the  first curve does not <br>
//!          cross  the  other one,  or an  "undecided" transition, <br>
//!          which means that the curves are superposed. <br>
class IntRes2d_Transition  {

public:
  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  //! Empty constructor. <br>
  Standard_EXPORT   IntRes2d_Transition();
  //! Creates an IN or OUT transition. <br>
      IntRes2d_Transition(const Standard_Boolean Tangent,const IntRes2d_Position Pos,const IntRes2d_TypeTrans Type);
  //! Creates a TOUCH transition. <br>
      IntRes2d_Transition(const Standard_Boolean Tangent,const IntRes2d_Position Pos,const IntRes2d_Situation Situ,const Standard_Boolean Oppos);
  //! Creates an UNDECIDED transition. <br>
      IntRes2d_Transition(const IntRes2d_Position Pos);
  //! Sets the values of an IN or OUT transition. <br>
        void SetValue(const Standard_Boolean Tangent,const IntRes2d_Position Pos,const IntRes2d_TypeTrans Type) ;
  //! Sets the values of a TOUCH transition. <br>
        void SetValue(const Standard_Boolean Tangent,const IntRes2d_Position Pos,const IntRes2d_Situation Situ,const Standard_Boolean Oppos) ;
  //! Sets the values of an UNDECIDED transition. <br>
        void SetValue(const IntRes2d_Position Pos) ;
  //! Sets the value of the position. <br>
        void SetPosition(const IntRes2d_Position Pos) ;
  //! Indicates if the  intersection is at the beginning <br>
//!          (IntRes2d_Head),  at the end (IntRes2d_End), or in <br>
//!          the middle (IntRes2d_Middle) of the curve. <br>
        IntRes2d_Position PositionOnCurve() const;
  //! Returns the type of transition at the intersection. <br>
//!          It may be IN or OUT or TOUCH, or UNDECIDED if the <br>
//!          two first derivatives are not enough to give <br>
//!          the tangent to one of the two curves. <br>
        IntRes2d_TypeTrans TransitionType() const;
  //! Returns TRUE when the 2 curves are tangent at the <br>
//!          intersection point. <br>
//!          Theexception DomainError is raised if the type of <br>
//!          transition is UNDECIDED. <br>
        Standard_Boolean IsTangent() const;
  //! returns a significant value if TransitionType returns <br>
//!          TOUCH. In this case, the function returns : <br>
//!          INSIDE when the curve remains inside the other one, <br>
//!          OUTSIDE when it remains outside the other one, <br>
//!          UNKNOWN when the calculus, based on the second derivatives <br>
//!          cannot give the result. <br>
//!          If TransitionType returns IN or OUT or UNDECIDED, the <br>
//!          exception DomainError is raised. <br>
        IntRes2d_Situation Situation() const;
  //! returns a  significant value   if   TransitionType <br>
//!          returns TOUCH. In this  case, the function returns <br>
//!          true   when  the  2   curves   locally define  two <br>
//!          different  parts of the  space.  If TransitionType <br>
//!          returns  IN or   OUT or UNDECIDED,  the  exception <br>
//!          DomainError is raised. <br>
        Standard_Boolean IsOpposite() const;
    Standard_Boolean _CSFDB_GetIntRes2d_Transitiontangent() const { return tangent; }
    void _CSFDB_SetIntRes2d_Transitiontangent(const Standard_Boolean p) { tangent = p; }
    IntRes2d_Position _CSFDB_GetIntRes2d_Transitionposit() const { return posit; }
    void _CSFDB_SetIntRes2d_Transitionposit(const IntRes2d_Position p) { posit = p; }
    IntRes2d_TypeTrans _CSFDB_GetIntRes2d_Transitiontypetra() const { return typetra; }
    void _CSFDB_SetIntRes2d_Transitiontypetra(const IntRes2d_TypeTrans p) { typetra = p; }
    IntRes2d_Situation _CSFDB_GetIntRes2d_Transitionsituat() const { return situat; }
    void _CSFDB_SetIntRes2d_Transitionsituat(const IntRes2d_Situation p) { situat = p; }
    Standard_Boolean _CSFDB_GetIntRes2d_Transitionoppos() const { return oppos; }
    void _CSFDB_SetIntRes2d_Transitionoppos(const Standard_Boolean p) { oppos = p; }



protected:




private: 


Standard_Boolean tangent;
IntRes2d_Position posit;
IntRes2d_TypeTrans typetra;
IntRes2d_Situation situat;
Standard_Boolean oppos;


};


#include <IntRes2d_Transition.lxx>



// other Inline functions and methods (like "C++: function call" methods)


#endif
