// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _HLRAlgo_Projector_HeaderFile
#define _HLRAlgo_Projector_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _gp_Trsf_HeaderFile
#include <gp_Trsf.hxx>
#endif
#ifndef _gp_Vec2d_HeaderFile
#include <gp_Vec2d.hxx>
#endif
class Standard_NoSuchObject;
class gp_Ax2;
class gp_Trsf;
class gp_Vec2d;
class gp_Vec;
class gp_Pnt;
class gp_Pnt2d;
class gp_Lin;


//! Implements a  projector object. <br>
//! This object is designed to be used in the <br>
//! removal of hidden lines and is returned by the <br>
//! Prs3d_Projector::Projector function. <br>
//! You define the projection of the selected shape <br>
//! by calling one of the following functions: <br>
//! -   HLRBRep_Algo::Projector, or <br>
//! -   HLRBRep_PolyAlgo::Projector <br>
//! The choice depends on the algorithm, which you are using. <br>
//! The parameters of the view are defined at the <br>
//! time of construction of a Prs3d_Projector object. <br>
class HLRAlgo_Projector  {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  
  Standard_EXPORT   HLRAlgo_Projector();
  //! Creates   an axonometric  projector.   <CS> is the <br>
//!          viewing coordinate system. <br>
  Standard_EXPORT   HLRAlgo_Projector(const gp_Ax2& CS);
  //! Creates  a  perspective  projector.   <CS>  is the <br>
//!          viewing coordinate system. <br>
  Standard_EXPORT   HLRAlgo_Projector(const gp_Ax2& CS,const Standard_Real Focus);
  //! build a Projector with automatic minmax directions. <br>
  Standard_EXPORT   HLRAlgo_Projector(const gp_Trsf& T,const Standard_Boolean Persp,const Standard_Real Focus);
  //! build a Projector with given minmax directions. <br>
  Standard_EXPORT   HLRAlgo_Projector(const gp_Trsf& T,const Standard_Boolean Persp,const Standard_Real Focus,const gp_Vec2d& v1,const gp_Vec2d& v2,const gp_Vec2d& v3);
  
  Standard_EXPORT     void Set(const gp_Trsf& T,const Standard_Boolean Persp,const Standard_Real Focus) ;
  
        void Directions(gp_Vec2d& D1,gp_Vec2d& D2,gp_Vec2d& D3) const;
  //! to compute with the given scale and translation. <br>
  Standard_EXPORT     void Scaled(const Standard_Boolean On = Standard_False) ;
  //! Returns True if there is a perspective transformation. <br>
        Standard_Boolean Perspective() const;
  //! Returns the active transformation. <br>
  Standard_EXPORT    const gp_Trsf& Transformation() const;
  //! Returns the active inverted transformation. <br>
       const gp_Trsf& InvertedTransformation() const;
  //! Returns the original transformation. <br>
       const gp_Trsf& FullTransformation() const;
  //! Returns the focal length. <br>
        Standard_Real Focus() const;
  
        void Transform(gp_Vec& D) const;
  
        void Transform(gp_Pnt& Pnt) const;
  //! Transform and apply perspective if needed. <br>
  Standard_EXPORT     void Project(const gp_Pnt& P,gp_Pnt2d& Pout) const;
  //! Transform and apply perspective if needed. <br>
  Standard_EXPORT     void Project(const gp_Pnt& P,Standard_Real& X,Standard_Real& Y,Standard_Real& Z) const;
  //! Transform and apply perspective if needed. <br>
  Standard_EXPORT     void Project(const gp_Pnt& P,const gp_Vec& D1,gp_Pnt2d& Pout,gp_Vec2d& D1out) const;
  //! return a line going through the eye towards the <br>
//!          2d point <X,Y>. <br>
  Standard_EXPORT     gp_Lin Shoot(const Standard_Real X,const Standard_Real Y) const;





protected:





private:

  
  Standard_EXPORT     void SetDirection() ;


Standard_Integer myType;
Standard_Boolean myPersp;
Standard_Real myFocus;
gp_Trsf myScaledTrsf;
gp_Trsf myTrsf;
gp_Trsf myInvTrsf;
gp_Vec2d myD1;
gp_Vec2d myD2;
gp_Vec2d myD3;


};


#include <HLRAlgo_Projector.lxx>



// other Inline functions and methods (like "C++: function call" methods)


#endif
