// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _BRepAdaptor_Surface_HeaderFile
#define _BRepAdaptor_Surface_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _GeomAdaptor_Surface_HeaderFile
#include <GeomAdaptor_Surface.hxx>
#endif
#ifndef _gp_Trsf_HeaderFile
#include <gp_Trsf.hxx>
#endif
#ifndef _TopoDS_Face_HeaderFile
#include <TopoDS_Face.hxx>
#endif
#ifndef _Adaptor3d_Surface_HeaderFile
#include <Adaptor3d_Surface.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _GeomAbs_Shape_HeaderFile
#include <GeomAbs_Shape.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Adaptor3d_HSurface_HeaderFile
#include <Handle_Adaptor3d_HSurface.hxx>
#endif
#ifndef _GeomAbs_SurfaceType_HeaderFile
#include <GeomAbs_SurfaceType.hxx>
#endif
#ifndef _Handle_Geom_BezierSurface_HeaderFile
#include <Handle_Geom_BezierSurface.hxx>
#endif
#ifndef _Handle_Geom_BSplineSurface_HeaderFile
#include <Handle_Geom_BSplineSurface.hxx>
#endif
#ifndef _Handle_Adaptor3d_HCurve_HeaderFile
#include <Handle_Adaptor3d_HCurve.hxx>
#endif
class Standard_OutOfRange;
class Standard_DomainError;
class Standard_NoSuchObject;
class TopoDS_Face;
class GeomAdaptor_Surface;
class gp_Trsf;
class TColStd_Array1OfReal;
class Adaptor3d_HSurface;
class gp_Pnt;
class gp_Vec;
class gp_Pln;
class gp_Cylinder;
class gp_Cone;
class gp_Sphere;
class gp_Torus;
class Geom_BezierSurface;
class Geom_BSplineSurface;
class gp_Ax1;
class gp_Dir;
class Adaptor3d_HCurve;


//! The Surface from BRepAdaptor allows to  use a Face <br>
//!          of the BRep topology look like a 3D surface. <br>
//! <br>
//!          It  has  the methods  of  the class   Surface from <br>
//!          Adaptor3d. <br>
//! <br>
//!          It is created or initialized with a Face. It takes <br>
//!          into account the local coordinates system. <br>
//! <br>
//!          The  u,v parameter range is   the minmax value for <br>
//!          the  restriction,  unless  the flag restriction is <br>
//!          set to false. <br>
class BRepAdaptor_Surface  : public Adaptor3d_Surface {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  //! Creates an undefined surface with no face loaded. <br>
  Standard_EXPORT   BRepAdaptor_Surface();
  //! Creates a surface to  access the geometry  of <F>. <br>
//!          If  <Restriction> is  true  the parameter range is <br>
//!          the  parameter  range  in   the  UV space  of  the <br>
//!          restriction. <br>
  Standard_EXPORT   BRepAdaptor_Surface(const TopoDS_Face& F,const Standard_Boolean R = Standard_True);
  //! Sets the surface to the geometry of <F>. <br>
  Standard_EXPORT     void Initialize(const TopoDS_Face& F,const Standard_Boolean Restriction = Standard_True) ;
  //! Returns the surface. <br>
//! <br>
  Standard_EXPORT    const GeomAdaptor_Surface& Surface() const;
  //! Returns the surface. <br>
//! <br>
  Standard_EXPORT     GeomAdaptor_Surface& ChangeSurface() ;
  //! Returns the surface coordinate system. <br>
//! <br>
  Standard_EXPORT    const gp_Trsf& Trsf() const;
  //! Returns the face. <br>
//! <br>
  Standard_EXPORT    const TopoDS_Face& Face() const;
  //! Returns the face tolerance. <br>
//! <br>
  Standard_EXPORT     Standard_Real Tolerance() const;
  
        Standard_Real FirstUParameter() const;
  
        Standard_Real LastUParameter() const;
  
        Standard_Real FirstVParameter() const;
  
        Standard_Real LastVParameter() const;
  
        GeomAbs_Shape UContinuity() const;
  
        GeomAbs_Shape VContinuity() const;
  //! If necessary, breaks the surface in U intervals of <br>
//!          continuity    <S>.  And   returns  the  number  of <br>
//!          intervals. <br>
        Standard_Integer NbUIntervals(const GeomAbs_Shape S) const;
  //! If necessary, breaks the surface in V intervals of <br>
//!          continuity    <S>.  And   returns  the  number  of <br>
//!          intervals. <br>
        Standard_Integer NbVIntervals(const GeomAbs_Shape S) const;
  //! Returns the  intervals with the requested continuity <br>
//!          in the U direction. <br>
  Standard_EXPORT     void UIntervals(TColStd_Array1OfReal& T,const GeomAbs_Shape S) const;
  //! Returns the  intervals with the requested continuity <br>
//!          in the V direction. <br>
  Standard_EXPORT     void VIntervals(TColStd_Array1OfReal& T,const GeomAbs_Shape S) const;
  //! Returns    a  surface trimmed in the U direction <br>
//!           equivalent   of  <me>  between <br>
//!          parameters <First>  and <Last>. <Tol>  is used  to <br>
//!          test for 3d points confusion. <br>//! If <First> >= <Last> <br>
  Standard_EXPORT     Handle_Adaptor3d_HSurface UTrim(const Standard_Real First,const Standard_Real Last,const Standard_Real Tol) const;
  //! Returns    a  surface trimmed in the V direction  between <br>
//!          parameters <First>  and <Last>. <Tol>  is used  to <br>
//!          test for 3d points confusion. <br>//! If <First> >= <Last> <br>
  Standard_EXPORT     Handle_Adaptor3d_HSurface VTrim(const Standard_Real First,const Standard_Real Last,const Standard_Real Tol) const;
  
        Standard_Boolean IsUClosed() const;
  
        Standard_Boolean IsVClosed() const;
  
        Standard_Boolean IsUPeriodic() const;
  
        Standard_Real UPeriod() const;
  
        Standard_Boolean IsVPeriodic() const;
  
        Standard_Real VPeriod() const;
  //! Computes the point of parameters U,V on the surface. <br>
  Standard_EXPORT     gp_Pnt Value(const Standard_Real U,const Standard_Real V) const;
  //! Computes the point of parameters U,V on the surface. <br>
  Standard_EXPORT     void D0(const Standard_Real U,const Standard_Real V,gp_Pnt& P) const;
  //! Computes the point  and the first derivatives on <br>
//!  the surface. <br>//! Raised   if  the continuity  of   the  current <br>
//!  intervals is not C1. <br>
  Standard_EXPORT     void D1(const Standard_Real U,const Standard_Real V,gp_Pnt& P,gp_Vec& D1U,gp_Vec& D1V) const;
  //!  Computes   the point,  the  first  and  second <br>
//!  derivatives on the surface. <br>//! Raised  if   the   continuity   of the current <br>
//!  intervals is not C2. <br>
  Standard_EXPORT     void D2(const Standard_Real U,const Standard_Real V,gp_Pnt& P,gp_Vec& D1U,gp_Vec& D1V,gp_Vec& D2U,gp_Vec& D2V,gp_Vec& D2UV) const;
  //! Computes the point,  the first, second and third <br>
//!  derivatives on the surface. <br>//! Raised  if   the   continuity   of the current <br>
//!  intervals is not C3. <br>
  Standard_EXPORT     void D3(const Standard_Real U,const Standard_Real V,gp_Pnt& P,gp_Vec& D1U,gp_Vec& D1V,gp_Vec& D2U,gp_Vec& D2V,gp_Vec& D2UV,gp_Vec& D3U,gp_Vec& D3V,gp_Vec& D3UUV,gp_Vec& D3UVV) const;
  //!  Computes the derivative of order Nu in the direction <br>
//!  U and Nv in the direction V at the point P(U, V). <br>//! Raised if the current U  interval is not not CNu <br>
//!  and the current V interval is not CNv. <br>//! Raised if Nu + Nv < 1 or Nu < 0 or Nv < 0. <br>
  Standard_EXPORT     gp_Vec DN(const Standard_Real U,const Standard_Real V,const Standard_Integer Nu,const Standard_Integer Nv) const;
  //!  Returns the parametric U  resolution corresponding <br>
//!         to the real space resolution <R3d>. <br>
//! <br>
        Standard_Real UResolution(const Standard_Real R3d) const;
  //!  Returns the parametric V  resolution corresponding <br>
//!         to the real space resolution <R3d>. <br>
//! <br>
        Standard_Real VResolution(const Standard_Real R3d) const;
  //! Returns the type of the surface : Plane, Cylinder, <br>
//!          Cone,      Sphere,        Torus,    BezierSurface, <br>
//!          BSplineSurface,               SurfaceOfRevolution, <br>
//!          SurfaceOfExtrusion, OtherSurface <br>
        GeomAbs_SurfaceType GetType() const;
  
  Standard_EXPORT     gp_Pln Plane() const;
  
  Standard_EXPORT     gp_Cylinder Cylinder() const;
  
  Standard_EXPORT     gp_Cone Cone() const;
  
  Standard_EXPORT     gp_Sphere Sphere() const;
  
  Standard_EXPORT     gp_Torus Torus() const;
  
        Standard_Integer UDegree() const;
  
        Standard_Integer NbUPoles() const;
  
        Standard_Integer VDegree() const;
  
        Standard_Integer NbVPoles() const;
  
        Standard_Integer NbUKnots() const;
  
        Standard_Integer NbVKnots() const;
  
        Standard_Boolean IsURational() const;
  
        Standard_Boolean IsVRational() const;
  
  Standard_EXPORT     Handle_Geom_BezierSurface Bezier() const;
  
//!  Warning : this will make a copy of the <br>
//!           BSpline Surface since it applies <br>
//!           to it the myTsrf transformation <br>
//!           Be Carefull when using this method <br>
  Standard_EXPORT     Handle_Geom_BSplineSurface BSpline() const;
  
  Standard_EXPORT     gp_Ax1 AxeOfRevolution() const;
  
  Standard_EXPORT     gp_Dir Direction() const;
  //! only for SurfaceOfExtrusion and SurfaceOfRevolution <br>
//!  Warning: this will make a copy of the underlying curve <br>
//!          since it applies to it the transformation <br>
//!          myTrsf. Be carefull when using this method. <br>
  Standard_EXPORT     Handle_Adaptor3d_HCurve BasisCurve() const;
  
  Standard_EXPORT     Handle_Adaptor3d_HSurface BasisSurface() const;
  
  Standard_EXPORT     Standard_Real OffsetValue() const;





protected:





private:



GeomAdaptor_Surface mySurf;
gp_Trsf myTrsf;
TopoDS_Face myFace;


};


#include <BRepAdaptor_Surface.lxx>



// other Inline functions and methods (like "C++: function call" methods)


#endif
